/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.io.ConverterConfiguration;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DdlUtilsXMLException;
import org.apache.ddlutils.io.converters.SqlTypeConverter;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.xml.sax.InputSource;

public class DataReader {
    private final Log _log = LogFactory.getLog(DataReader.class);
    private Database _model;
    private DataSink _sink;
    private ConverterConfiguration _converterConf = new ConverterConfiguration();
    private boolean _caseSensitive = false;

    public ConverterConfiguration getConverterConfiguration() {
        return this._converterConf;
    }

    public Database getModel() {
        return this._model;
    }

    public void setModel(Database model) {
        this._model = model;
    }

    public DataSink getSink() {
        return this._sink;
    }

    public void setSink(DataSink sink) {
        this._sink = sink;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean beCaseSensitive) {
        this._caseSensitive = beCaseSensitive;
    }

    private XMLInputFactory getXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        return factory;
    }

    public void read(String filename) throws DdlUtilsXMLException {
        this.read(new File(filename));
    }

    public void read(File file) throws DdlUtilsXMLException {
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(file);
                this.read(input);
            }
            catch (IOException ex) {
                throw new DdlUtilsXMLException(ex);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    this._log.warn((Object)("Error while trying to close the input stream for " + file), (Throwable)ex);
                }
            }
        }
    }

    public void read(Reader reader) throws DdlUtilsXMLException {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            this.read(this.getXMLInputFactory().createXMLStreamReader(bufferedReader));
        }
        catch (XMLStreamException ex) {
            throw new DdlUtilsXMLException(ex);
        }
    }

    public void read(InputStream input) throws DdlUtilsXMLException {
        BufferedInputStream bufferedInput = input instanceof BufferedInputStream ? (BufferedInputStream)input : new BufferedInputStream(input);
        try {
            this.read(this.getXMLInputFactory().createXMLStreamReader(bufferedInput));
        }
        catch (XMLStreamException ex) {
            throw new DdlUtilsXMLException(ex);
        }
    }

    public void read(InputSource source) throws DdlUtilsXMLException {
        this.read(source.getCharacterStream());
    }

    private void read(XMLStreamReader xmlReader) throws DdlUtilsXMLException {
        try {
            while (xmlReader.getEventType() != 1) {
                if (xmlReader.next() != 8) continue;
                return;
            }
            this.readDocument(xmlReader);
        }
        catch (XMLStreamException ex) {
            throw new DdlUtilsXMLException(ex);
        }
    }

    private void readDocument(XMLStreamReader xmlReader) throws XMLStreamException, DdlUtilsXMLException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            this.readBean(xmlReader);
        }
    }

    private void readBean(XMLStreamReader xmlReader) throws XMLStreamException, DdlUtilsXMLException {
        QName elemQName = xmlReader.getName();
        Location location = xmlReader.getLocation();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String tableName = null;
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            attributes.put(this.isCaseSensitive() ? attrQName.getLocalPart() : attrQName.getLocalPart().toLowerCase(), xmlReader.getAttributeValue(idx));
            ++idx;
        }
        this.readColumnSubElements(xmlReader, attributes);
        tableName = "table".equals(elemQName.getLocalPart()) ? (String)attributes.get("table-name") : elemQName.getLocalPart();
        Table table = this._model.findTable(tableName, this.isCaseSensitive());
        if (table == null) {
            this._log.warn((Object)("Data XML contains an element " + elemQName + " at location " + location + " but there is no table defined with this name. This element will be ignored."));
        } else {
            DynaBean bean = this._model.createDynaBeanFor(table);
            int idx2 = 0;
            while (idx2 < table.getColumnCount()) {
                Column column = table.getColumn(idx2);
                String value = (String)attributes.get(this.isCaseSensitive() ? column.getName() : column.getName().toLowerCase());
                if (value != null) {
                    this.setColumnValue(bean, table, column, value);
                }
                ++idx2;
            }
            this.getSink().addBean(bean);
            this.consumeRestOfElement(xmlReader);
        }
    }

    private void readColumnSubElements(XMLStreamReader xmlReader, Map data) throws XMLStreamException, DdlUtilsXMLException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            this.readColumnSubElement(xmlReader, data);
        }
    }

    private void readColumnSubElement(XMLStreamReader xmlReader, Map data) throws XMLStreamException, DdlUtilsXMLException {
        String name;
        String value;
        QName elemQName = xmlReader.getName();
        HashMap<String, String> attributes = new HashMap<String, String>();
        boolean usesBase64 = false;
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            value = xmlReader.getAttributeValue(idx);
            if ("base64".equals(attrQName.getLocalPart())) {
                if ("true".equalsIgnoreCase(value)) {
                    usesBase64 = true;
                }
            } else {
                attributes.put(attrQName.getLocalPart(), value);
            }
            ++idx;
        }
        int eventType = 1;
        StringBuffer content = new StringBuffer();
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType == 1) {
                this.readColumnDataSubElement(xmlReader, attributes);
                continue;
            }
            if (eventType != 4 && eventType != 12 && eventType != 6 && eventType != 9) continue;
            content.append(xmlReader.getText());
        }
        value = content.toString().trim();
        if (usesBase64) {
            value = new String(Base64.decodeBase64((byte[])value.getBytes()));
        }
        if ("table-name".equals(name = elemQName.getLocalPart())) {
            data.put("table-name", value);
        } else {
            if ("column".equals(name)) {
                name = (String)attributes.get("column-name");
            }
            if (attributes.containsKey("column-value")) {
                value = (String)attributes.get("column-value");
            }
            data.put(name, value);
        }
        this.consumeRestOfElement(xmlReader);
    }

    private void readColumnDataSubElement(XMLStreamReader xmlReader, Map data) throws XMLStreamException, DdlUtilsXMLException {
        String name;
        String value;
        QName elemQName = xmlReader.getName();
        boolean usesBase64 = false;
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            String value2 = xmlReader.getAttributeValue(idx);
            if ("base64".equals(attrQName.getLocalPart())) {
                if (!"true".equalsIgnoreCase(value2)) break;
                usesBase64 = true;
                break;
            }
            ++idx;
        }
        if ((value = xmlReader.getElementText()) != null) {
            value = value.toString().trim();
            if (usesBase64) {
                value = new String(Base64.decodeBase64((byte[])value.getBytes()));
            }
        }
        if ("column-name".equals(name = elemQName.getLocalPart())) {
            data.put("column-name", value);
        } else if ("column-value".equals(name)) {
            data.put("column-value", value);
        }
        this.consumeRestOfElement(xmlReader);
    }

    private void setColumnValue(DynaBean bean, Table table, Column column, String value) throws DdlUtilsXMLException {
        SqlTypeConverter converter = this._converterConf.getRegisteredConverter(table, column);
        String propValue = converter != null ? converter.convertFromString(value, column.getTypeCode()) : value;
        try {
            PropertyUtils.setProperty((Object)bean, (String)column.getName(), (Object)propValue);
        }
        catch (NoSuchMethodException ex) {
            throw new DdlUtilsXMLException("Undefined column " + column.getName());
        }
        catch (IllegalAccessException ex) {
            throw new DdlUtilsXMLException("Could not set bean property for column " + column.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new DdlUtilsXMLException("Could not set bean property for column " + column.getName(), ex);
        }
    }

    private void consumeRestOfElement(XMLStreamReader reader) throws XMLStreamException {
        int eventType = reader.getEventType();
        while (eventType != 2 && eventType != 8) {
            eventType = reader.next();
        }
    }
}

