/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.hsqldb;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;

public class HsqlDbBuilder
extends SqlBuilder {
    public HsqlDbBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    @Override
    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" IF EXISTS");
        this.printEndOfStatement();
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "CALL IDENTITY()";
    }

    public void insertColumn(Table table, Column newColumn, Column nextColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(table, newColumn);
        if (nextColumn != null) {
            this.print(" BEFORE ");
            this.printIdentifier(this.getColumnName(nextColumn));
        }
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    @Override
    protected void writeColumn(Table table, Column column) throws IOException {
        this.printIdentifier(this.getColumnName(column));
        this.print(" ");
        this.print(this.getSqlType(column));
        if (column.isAutoIncrement()) {
            if (!column.isPrimaryKey()) {
                throw new ModelException("Column " + column.getName() + " in table " + table.getName() + " is auto-incrementing but not a primary key column, which is not supported by the platform");
            }
            this.print(" ");
            this.writeColumnAutoIncrementStmt(table, column);
        } else {
            this.writeColumnDefaultValueStmt(table, column);
        }
        if (column.isRequired()) {
            this.print(" ");
            this.writeColumnNotNullableStmt();
        } else if (this.getPlatformInfo().isNullAsDefaultValueRequired() && this.getPlatformInfo().hasNullDefault(column.getTypeCode())) {
            this.print(" ");
            this.writeColumnNullableStmt();
        }
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("GENERATED BY DEFAULT AS IDENTITY(START WITH 1)");
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged = ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        boolean typeChanged = ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        if (sizeChanged || typeChanged) {
            boolean needSubstr;
            boolean bl = needSubstr = TypeMap.isTextType(targetColumn.getTypeCode()) && sizeChanged && sourceColumn.getSizeAsInt() > targetColumn.getSizeAsInt();
            if (needSubstr) {
                this.print("SUBSTR(");
            }
            this.print("CAST(");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" AS ");
            if (needSubstr) {
                this.print(this.getNativeType(targetColumn));
            } else {
                this.print(this.getSqlType(targetColumn));
            }
            this.print(")");
            if (needSubstr) {
                this.print(",1,");
                this.print(targetColumn.getSize());
                this.print(")");
            }
        } else {
            super.writeCastExpression(sourceColumn, targetColumn);
        }
    }
}

