/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import siena.Column;
import siena.Generator;
import siena.Id;
import siena.Join;
import siena.Json;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Table;
import siena.core.InheritFilter;
import siena.core.lifecycle.LifeCyclePhase;
import siena.core.lifecycle.LifeCycleUtils;
import siena.embed.Embedded;

public class ClassInfo {
    protected static Map<Class<?>, ClassInfo> infoClasses = new ConcurrentHashMap();
    public Class<?> clazz;
    public String tableName;
    public List<Field> keys = new ArrayList<Field>();
    public List<Field> insertFields = new ArrayList<Field>();
    public List<Field> updateFields = new ArrayList<Field>();
    public List<Field> generatedKeys = new ArrayList<Field>();
    public List<Field> allFields = new ArrayList<Field>();
    public List<Field> joinFields = new ArrayList<Field>();
    public List<Field> queryAndAllFields = new ArrayList<Field>();
    public Map<LifeCyclePhase, List<Method>> lifecycleMethods = new HashMap<LifeCyclePhase, List<Method>>();

    protected ClassInfo(Class<?> clazz) {
        int n;
        int n2;
        Object[] objectArray;
        this.clazz = clazz;
        this.tableName = this.getTableName(clazz);
        ArrayList classH = new ArrayList();
        Class<?> cl = clazz;
        HashSet<Object> removedFields = new HashSet<Object>();
        while (cl != null) {
            classH.add(0, cl);
            InheritFilter inheritFilter = cl.getAnnotation(InheritFilter.class);
            if (inheritFilter != null) {
                String[] efs = inheritFilter.removedFields();
                objectArray = efs;
                n2 = efs.length;
                n = 0;
                while (n < n2) {
                    Object ef = objectArray[n];
                    removedFields.add(ef);
                    ++n;
                }
            }
            cl = cl.getSuperclass();
        }
        for (Class clazz2 : classH) {
            objectArray = clazz2.getDeclaredFields();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object field = objectArray[n];
                if (!removedFields.contains(((Field)field).getName())) {
                    Class<?> type = ((Field)field).getType();
                    if ((((Field)field).getModifiers() & 0x80) != 128 && (((Field)field).getModifiers() & 8) != 8 && !((Field)field).isSynthetic()) {
                        if (type == Class.class || type == Query.class) {
                            this.queryAndAllFields.add((Field)field);
                        } else {
                            Id id = ((Field)field).getAnnotation(Id.class);
                            if (id != null) {
                                if (id.value() == Generator.AUTO_INCREMENT && (Long.TYPE == type || Long.class.isAssignableFrom(type))) {
                                    this.generatedKeys.add((Field)field);
                                } else {
                                    this.insertFields.add((Field)field);
                                }
                                this.keys.add((Field)field);
                            } else {
                                this.updateFields.add((Field)field);
                                this.insertFields.add((Field)field);
                            }
                            if (((Field)field).getAnnotation(Join.class) != null) {
                                if (!ClassInfo.isModel(((Field)field).getType())) {
                                    throw new SienaException("Join not possible: Field " + ((Field)field).getName() + " is not a relation field");
                                }
                                this.joinFields.add((Field)field);
                            }
                            this.allFields.add((Field)field);
                            this.queryAndAllFields.add((Field)field);
                        }
                    }
                }
                ++n;
            }
            objectArray = clazz2.getDeclaredMethods();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object m = objectArray[n];
                List<LifeCyclePhase> lcps = LifeCycleUtils.getMethodLifeCycles((Method)m);
                for (LifeCyclePhase lcp : lcps) {
                    List<Method> methods = this.lifecycleMethods.get((Object)lcp);
                    if (methods == null) {
                        methods = new ArrayList<Method>();
                        this.lifecycleMethods.put(lcp, methods);
                    }
                    methods.add((Method)m);
                }
                ++n;
            }
        }
    }

    private String getTableName(Class<?> clazz) {
        Table t = clazz.getAnnotation(Table.class);
        if (t == null) {
            return clazz.getSimpleName();
        }
        return t.value();
    }

    public List<String> getUpdateFieldsColumnNames() {
        ArrayList<String> strs = new ArrayList<String>(this.updateFields.size());
        for (Field field : this.updateFields) {
            Column c = field.getAnnotation(Column.class);
            if (c != null && c.value().length > 0) {
                strs.add(c.value()[0]);
                continue;
            }
            if (ClassInfo.isModel(field.getType())) {
                ClassInfo ci = ClassInfo.getClassInfo(field.getType());
                for (Field key : ci.keys) {
                    Collections.addAll(strs, ClassInfo.getColumnNames(key));
                }
                continue;
            }
            strs.add(field.getName());
        }
        return strs;
    }

    public static String[] getColumnNames(Field field) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(field.getName()) + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{field.getName()};
    }

    public static String[] getColumnNamesWithPrefix(Field field, String prefix) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            String[] cols = c.value();
            int i = 0;
            while (i < cols.length) {
                cols[i] = String.valueOf(prefix) + cols[i];
                ++i;
            }
            return cols;
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(prefix) + field.getName() + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{String.valueOf(prefix) + field.getName()};
    }

    public static String[] getColumnNames(Field field, String tableName) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            if (tableName != null && !"".equals(tableName)) {
                String[] cols = c.value();
                int i = 0;
                while (i < cols.length) {
                    cols[i] = String.valueOf(tableName) + "." + cols[i];
                    ++i;
                }
                return cols;
            }
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(field.getName()) + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        if (tableName != null && !"".equals(tableName)) {
            return new String[]{String.valueOf(tableName) + "." + field.getName()};
        }
        return new String[]{field.getName()};
    }

    public static boolean isModel(Class<?> type) {
        if (Model.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.getName().startsWith("java.")) {
            return false;
        }
        if (Json.class.isAssignableFrom(type)) {
            return false;
        }
        return !ClassInfo.getClassInfo(type).keys.isEmpty();
    }

    public static boolean isId(Field field) {
        return field.isAnnotationPresent(Id.class);
    }

    public static boolean isEmbedded(Field field) {
        return field.isAnnotationPresent(Embedded.class);
    }

    public static boolean isGenerated(Field field) {
        Id id = field.getAnnotation(Id.class);
        if (id != null) {
            Class<?> type = field.getType();
            if (id.value() == Generator.AUTO_INCREMENT && (Long.TYPE == type || Long.class.isAssignableFrom(type))) {
                return true;
            }
            if (id.value() == Generator.UUID && (String.class.isAssignableFrom(type) || UUID.class.isAssignableFrom(type))) {
                return true;
            }
        }
        return false;
    }

    public static Field getIdField(Class<?> clazz) {
        List<Field> keys = ClassInfo.getClassInfo(clazz).keys;
        if (keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + clazz.getName());
        }
        if (keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + clazz.getName());
        }
        return keys.get(0);
    }

    public Field getIdField() {
        if (this.keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + this.tableName);
        }
        if (this.keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + this.tableName);
        }
        return this.keys.get(0);
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        ClassInfo ci = infoClasses.get(clazz);
        if (ci == null) {
            ci = new ClassInfo(clazz);
            infoClasses.put(clazz, ci);
        }
        return ci;
    }

    public List<Method> getLifeCycleMethod(LifeCyclePhase lcp) {
        return this.lifecycleMethods.get((Object)lcp);
    }
}

