/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.PreparedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import siena.core.options.QueryOption;
import siena.embed.EmbeddedMap;

@EmbeddedMap
public class QueryOptionGaeContext
extends QueryOption {
    public static final int ID = 8193;
    public List<String> cursors = new ArrayList<String>();
    public int cursorIdx = -1;
    public boolean useCursor = true;
    public boolean noMoreDataBefore = false;
    public boolean noMoreDataAfter = false;
    public int realOffset = 0;
    public int realPageSize = 0;

    public QueryOptionGaeContext() {
        super(8193);
    }

    public QueryOptionGaeContext(PreparedQuery query) {
        super(8193);
    }

    public QueryOptionGaeContext(QueryOptionGaeContext option) {
        super(option);
        Collections.copy(this.cursors, option.cursors);
        this.cursorIdx = option.cursorIdx;
        this.useCursor = option.useCursor;
        this.noMoreDataBefore = option.noMoreDataBefore;
        this.noMoreDataAfter = option.noMoreDataAfter;
        this.realOffset = option.realOffset;
        this.realPageSize = option.realPageSize;
    }

    public void addCursor(String cursor) {
        if (this.cursorIdx < this.cursors.size() - 1 && this.cursorIdx >= 0) {
            this.cursors.set(this.cursorIdx + 1, cursor);
        } else {
            this.cursors.add(this.cursorIdx + 1, cursor);
        }
    }

    public void addAndMoveCursor(String cursor) {
        if (this.cursorIdx < this.cursors.size() - 1 && this.cursorIdx >= 0) {
            this.cursors.set(++this.cursorIdx, cursor);
        } else {
            this.cursors.add(++this.cursorIdx, cursor);
        }
    }

    public void setCurrentCursor(String cursor) {
        if (this.cursorIdx != -1) {
            this.cursors.set(this.cursorIdx, cursor);
        } else {
            this.addAndMoveCursor(cursor);
        }
    }

    public String currentCursor() {
        if (this.cursorIdx != -1) {
            return this.cursors.get(this.cursorIdx);
        }
        return null;
    }

    public String nextCursor() {
        int sz = this.cursors.size();
        if (sz == 0) {
            return null;
        }
        if (this.cursorIdx < sz - 1) {
            return this.cursors.get(++this.cursorIdx);
        }
        return this.cursors.get(this.cursorIdx);
    }

    public boolean hasNextCursor() {
        int sz = this.cursors.size();
        return sz != 0;
    }

    public String previousCursor() {
        int sz = this.cursors.size();
        if (sz == 0) {
            return null;
        }
        if (this.cursorIdx > 0) {
            return this.cursors.get(--this.cursorIdx);
        }
        if (this.cursorIdx == 0) {
            this.cursorIdx = -1;
            return null;
        }
        return null;
    }

    @Override
    public QueryOption clone() {
        return new QueryOptionGaeContext(this);
    }

    @Override
    public String toString() {
        return "type:GAE_CONTEXT - state:" + (Object)((Object)this.state) + " - realOffset:" + this.realOffset + " - realPageSize:" + this.realPageSize + " - useCursor:" + this.useCursor + " - cursorIdx:" + this.cursorIdx + " - cursors:" + this.cursors;
    }
}

