/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import siena.ClassInfo;
import siena.Query;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.SienaException;
import siena.Util;
import siena.jdbc.JdbcMappingUtils;
import siena.jdbc.JdbcPersistenceManager;
import siena.jdbc.QueryOptionJdbcContext;

public class JdbcDBUtils {
    public static final String WHERE = " WHERE ";
    public static final String AND = " AND ";
    public static final String IS_NULL = " IS NULL";
    public static final String IS_NOT_NULL = " IS NOT NULL";

    public static void closeStatement(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    public static <T> StringBuilder buildSqlSelect(Query<T> query) {
        Class clazz = query.getQueriedClass();
        JdbcPersistenceManager.JdbcClassInfo info = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz);
        ArrayList<String> cols = new ArrayList<String>();
        List<Field> joinFields = JdbcMappingUtils.getJoinFields(query, info);
        if (joinFields == null) {
            JdbcPersistenceManager.JdbcClassInfo.calculateColumnsAliases(info.allFields, cols, info.tableName, "");
            StringBuilder sql = new StringBuilder("SELECT " + Util.join(cols, ", ") + " FROM " + info.tableName);
            return sql;
        }
        JdbcPersistenceManager.JdbcClassInfo.calculateColumnsAliases(info.allFields, cols, info.tableName, "");
        StringBuilder sql = new StringBuilder(" FROM " + info.tableName);
        int i = 0;
        for (Field field : joinFields) {
            JdbcPersistenceManager.JdbcClassInfo fieldInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(field.getType());
            if (!ClassInfo.isModel(field.getType())) {
                throw new SienaException("Join not possible: Field " + field.getName() + " is not a relation field");
            }
            String alias = String.valueOf(fieldInfo.tableName) + i++;
            fieldInfo.joinFieldAliases.put(field.getName(), alias);
            JdbcPersistenceManager.JdbcClassInfo.calculateColumnsAliases(fieldInfo.allFields, cols, alias, "");
            String[] columns = ClassInfo.getColumnNames(field, info.tableName);
            if (columns.length > 1 || fieldInfo.keys.size() > 1) {
                throw new SienaException("Join not possible: join field " + field.getName() + " has multiple keys");
            }
            sql.append(" LEFT JOIN " + fieldInfo.tableName + " AS " + alias + " ON " + columns[0] + " = " + alias + "." + fieldInfo.keys.get(0).getName());
        }
        sql.insert(0, "SELECT " + Util.join(cols, ", "));
        return sql;
    }

    public static <T> void appendSqlOrder(Query<T> query, StringBuilder sql) {
        Class clazz = query.getQueriedClass();
        JdbcPersistenceManager.JdbcClassInfo info = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz);
        List<QueryOrder> orders = query.getOrders();
        List<QueryJoin> joins = query.getJoins();
        if (orders.isEmpty() && joins.isEmpty()) {
            return;
        }
        sql.append(" ORDER BY ");
        boolean first = true;
        for (QueryOrder order : orders) {
            if (!first) {
                sql.append(", ");
            }
            first = false;
            if (order.parentField == null) {
                String[] columns;
                String[] stringArray = columns = ClassInfo.getColumnNames(order.field, info.tableName);
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    sql.append(String.valueOf(column) + (order.ascending ? "" : " DESC"));
                    ++n2;
                }
                continue;
            }
            try {
                String[] columns;
                JdbcPersistenceManager.JdbcClassInfo parentCi = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(order.parentField.getType());
                Field subField = order.parentField.getType().getField(order.field.getName());
                String[] stringArray = columns = ClassInfo.getColumnNames(subField, parentCi.joinFieldAliases.get(order.parentField.getName()));
                int n = columns.length;
                int n3 = 0;
                while (n3 < n) {
                    String column = stringArray[n3];
                    sql.append(String.valueOf(column) + (order.ascending ? "" : " DESC"));
                    ++n3;
                }
            }
            catch (NoSuchFieldException ex) {
                throw new SienaException("Order not possible: join sort field " + order.field.getName() + " is not a known field of " + order.parentField.getName(), ex);
            }
        }
    }

    public static <T> void appendSqlLimitOffset(Query<T> query, StringBuilder sql, List<Object> parameters) {
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        sql.append(" LIMIT ?");
        parameters.add(jdbcCtx.realPageSize);
        sql.append(" OFFSET ?");
        parameters.add(jdbcCtx.realOffset);
    }
}

