/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import siena.ClassInfo;
import siena.Json;
import siena.Query;
import siena.QueryJoin;
import siena.SienaException;
import siena.Util;
import siena.core.DecimalPrecision;
import siena.core.Polymorphic;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.jdbc.JdbcPersistenceManager;

public class JdbcMappingUtils {
    public static <T> List<Field> getJoinFields(Query<T> query) {
        ArrayList<Field> joinFields = null;
        if (query.getJoins().size() > 0) {
            joinFields = new ArrayList<Field>();
            for (QueryJoin join : query.getJoins()) {
                joinFields.add(join.field);
            }
        }
        ClassInfo ci = ClassInfo.getClassInfo(query.getQueriedClass());
        if (ci.joinFields.size() > 0) {
            if (joinFields == null) {
                joinFields = new ArrayList();
            }
            for (Field f : ci.joinFields) {
                if (joinFields.contains(f)) continue;
                joinFields.add(f);
            }
        }
        return joinFields;
    }

    public static <T> List<Field> getJoinFields(Query<T> query, JdbcPersistenceManager.JdbcClassInfo info) {
        ArrayList<Field> joinFields = null;
        if (query.getJoins() != null && query.getJoins().size() > 0) {
            joinFields = new ArrayList<Field>();
            for (QueryJoin join : query.getJoins()) {
                joinFields.add(join.field);
            }
        }
        if (info.joinFields != null && info.joinFields.size() > 0) {
            if (joinFields == null) {
                joinFields = new ArrayList();
            }
            for (Field f : info.joinFields) {
                if (joinFields.contains(f)) continue;
                joinFields.add(f);
            }
        }
        return joinFields;
    }

    public static <T> T mapObject(Class<T> clazz, ResultSet rs, String tableName, List<Field> joinFields) {
        try {
            T obj = Util.createObjectInstance(clazz);
            JdbcMappingUtils.mapObject(obj, rs, tableName, joinFields);
            return obj;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static void mapObject(Object obj, ResultSet rs, String tableName, List<Field> joinFields) {
        Class<?> clazz = obj.getClass();
        for (Field field : JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz).allFields) {
            JdbcMappingUtils.mapField(obj, field, rs, tableName, joinFields);
        }
    }

    public static <T> List<T> mapList(Class<T> clazz, ResultSet rs, String tableName, List<Field> joinFields, int pageSize) {
        try {
            ArrayList<T> objects = new ArrayList<T>();
            if (pageSize == 0) {
                while (rs.next()) {
                    objects.add(JdbcMappingUtils.mapObject(clazz, rs, tableName, joinFields));
                }
            } else {
                int i = 0;
                while (i < pageSize && rs.next()) {
                    objects.add(JdbcMappingUtils.mapObject(clazz, rs, tableName, joinFields));
                    ++i;
                }
            }
            return objects;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static <T> T mapObjectKeys(Class<T> clazz, ResultSet rs, String tableName, List<Field> joinFields) {
        try {
            T obj = Util.createObjectInstance(clazz);
            JdbcMappingUtils.mapObjectKeys(obj, rs, tableName, joinFields);
            return obj;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static void mapObjectKeys(Object obj, ResultSet rs, String tableName, List<Field> joinFields) {
        Class<?> clazz = obj.getClass();
        for (Field field : JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz).keys) {
            JdbcMappingUtils.mapField(obj, field, rs, tableName, joinFields);
        }
    }

    public static <T> List<T> mapListKeys(Class<T> clazz, ResultSet rs, String tableName, List<Field> joinFields, int pageSize) {
        try {
            ArrayList<T> objects = new ArrayList<T>();
            if (pageSize == 0) {
                while (rs.next()) {
                    objects.add(JdbcMappingUtils.mapObjectKeys(clazz, rs, tableName, joinFields));
                }
            } else {
                int i = 0;
                while (i < pageSize && rs.next()) {
                    objects.add(JdbcMappingUtils.mapObjectKeys(clazz, rs, tableName, joinFields));
                    ++i;
                }
            }
            return objects;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static void mapField(Object obj, Field field, ResultSet rs, String tableName, List<Field> joinFields) {
        Class<?> type = field.getType();
        try {
            if (ClassInfo.isModel(type) && !ClassInfo.isEmbedded(field)) {
                JdbcPersistenceManager.JdbcClassInfo fieldClassInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(type);
                if (joinFields == null || joinFields.size() == 0 || !joinFields.contains(field)) {
                    String[] fks = ClassInfo.getColumnNames(field, tableName);
                    Object rel = Util.createObjectInstance(type);
                    boolean none = false;
                    int i = 0;
                    JdbcMappingUtils.checkForeignKeyMapping(fieldClassInfo.keys, fks, obj.getClass(), field);
                    for (Field f : fieldClassInfo.keys) {
                        Object o;
                        if ((o = rs.getObject(JdbcPersistenceManager.JdbcClassInfo.aliasFromCol(fks[i++]))) == null) {
                            none = true;
                            break;
                        }
                        JdbcMappingUtils.setFromObject(rel, f, o);
                    }
                    if (!none) {
                        Util.setField(obj, field, rel);
                    }
                } else {
                    Object val = rs.getObject(JdbcPersistenceManager.JdbcClassInfo.aliasFromCol(ClassInfo.getColumnNames(field, tableName)[0]));
                    if (val == null) {
                        Util.setField(obj, field, null);
                        return;
                    }
                    Object rel = JdbcMappingUtils.mapObject(type, rs, fieldClassInfo.joinFieldAliases.get(field.getName()), null);
                    Util.setField(obj, field, rel);
                }
            } else {
                Object val = rs.getObject(ClassInfo.getColumnNames(field, tableName)[0].replace('.', '_'));
                JdbcMappingUtils.setFromObject(obj, field, val);
            }
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static void checkForeignKeyMapping(List<Field> keys, String[] columns, Class<?> clazz, Field field) {
        if (keys.size() != columns.length) {
            throw new SienaException("Bad mapping for field '" + field.getName() + "'. " + "Related class " + field.getType().getName() + " has " + keys.size() + " primary keys, " + "but '" + clazz.getName() + "' only has mappings for " + columns.length + " foreign keys");
        }
    }

    public static void setFromObject(Object object, Field f, Object value) throws IllegalArgumentException, IllegalAccessException {
        Util.setField(object, f, JdbcMappingUtils.fromObject(f, value));
    }

    public static Object fromObject(Field field, Object value) {
        Class<?> type = field.getType();
        if (Json.class.isAssignableFrom(type) && value != null && Clob.class.isAssignableFrom(value.getClass())) {
            Clob clob = (Clob)value;
            try {
                return Json.load(new BufferedReader(clob.getCharacterStream()));
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        if (field.getAnnotation(Embedded.class) != null && value != null && Clob.class.isAssignableFrom(value.getClass())) {
            Clob clob = (Clob)value;
            try {
                Json data = Json.load(new BufferedReader(clob.getCharacterStream()));
                return JsonSerializer.deserialize(field, data);
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        if (field.isAnnotationPresent(Polymorphic.class)) {
            try {
                if (Blob.class.isAssignableFrom(value.getClass())) {
                    Blob blob = (Blob)value;
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(blob.getBytes(0L, (int)blob.length())));
                    return in.readObject();
                }
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
                return in.readObject();
            }
            catch (IOException e) {
                throw new SienaException(e);
            }
            catch (ClassNotFoundException e) {
                throw new SienaException(e);
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        if (byte[].class == type && value != null && Blob.class.isAssignableFrom(value.getClass())) {
            Blob blob = (Blob)value;
            try {
                return blob.getBytes(0L, (int)blob.length());
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        if (BigDecimal.class == type) {
            DecimalPrecision ann = field.getAnnotation(DecimalPrecision.class);
            if (ann == null) {
                return (BigDecimal)value;
            }
            switch (ann.storateType()) {
                case DOUBLE: {
                    return BigDecimal.valueOf((Double)value);
                }
                case STRING: {
                    return new BigDecimal((String)value);
                }
                case NATIVE: {
                    return (BigDecimal)value;
                }
            }
        }
        return Util.fromObject(field, value);
    }
}

