/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import siena.ClassInfo;
import siena.Query;
import siena.SienaException;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.jdbc.JdbcDBUtils;
import siena.jdbc.JdbcMappingUtils;
import siena.jdbc.QueryOptionJdbcContext;

public class JdbcSienaIterable<T>
implements Iterable<T> {
    private final Statement st;
    private final ResultSet rs;
    private Query<T> query;

    JdbcSienaIterable(Statement st, ResultSet rs, Query<T> query) {
        this.st = st;
        this.rs = rs;
        this.query = query;
    }

    @Override
    public Iterator<T> iterator() {
        return new SienaJdbcIterator<T>(this.query);
    }

    protected void finalize() throws Throwable {
        JdbcDBUtils.closeResultSet(this.rs);
        JdbcDBUtils.closeStatement(this.st);
        super.finalize();
    }

    public class SienaJdbcIterator<V>
    implements Iterator<V> {
        private Query<V> query;
        private int idx = 0;
        private QueryOptionPage pag;
        private QueryOptionJdbcContext jdbcCtx;
        private QueryOptionState state;
        private boolean hasNext = true;

        SienaJdbcIterator(Query<V> query) {
            this.query = query;
            this.pag = (QueryOptionPage)query.option(1);
            this.jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
            this.state = (QueryOptionState)query.option(3);
            try {
                if (this.pag.isPaginating()) {
                    this.jdbcCtx.noMoreDataAfter = JdbcSienaIterable.this.rs.isLast();
                }
            }
            catch (SQLException ex) {
                throw new SienaException(ex);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.hasNext = false;
                if (JdbcSienaIterable.this.rs.next()) {
                    if (this.pag.isPaginating()) {
                        if (this.idx < this.pag.pageSize) {
                            this.hasNext = true;
                        }
                    } else {
                        this.hasNext = true;
                    }
                }
                return this.hasNext;
            }
            catch (SQLException ex) {
                throw new SienaException(ex);
            }
        }

        @Override
        public V next() {
            try {
                if (this.hasNext || JdbcSienaIterable.this.rs.next()) {
                    Class clazz = this.query.getQueriedClass();
                    if (this.pag.isPaginating() && this.idx < Integer.valueOf(this.pag.pageSize)) {
                        ++this.idx;
                        return (V)JdbcMappingUtils.mapObject(clazz, JdbcSienaIterable.this.rs, ClassInfo.getClassInfo(clazz).tableName, JdbcMappingUtils.getJoinFields(this.query));
                    }
                    if (this.state.isStateful()) {
                        ++this.jdbcCtx.realOffset;
                    }
                    return (V)JdbcMappingUtils.mapObject(clazz, JdbcSienaIterable.this.rs, ClassInfo.getClassInfo(clazz).tableName, JdbcMappingUtils.getJoinFields(this.query));
                }
                throw new NoSuchElementException();
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }

        @Override
        public void remove() {
        }

        protected void finalize() throws Throwable {
            JdbcDBUtils.closeResultSet(JdbcSienaIterable.this.rs);
            JdbcDBUtils.closeStatement(JdbcSienaIterable.this.st);
            super.finalize();
        }
    }
}

