/*
 * Decompiled with CFR 0.152.
 */
package siena.remote;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.NotImplementedException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Model;
import siena.Query;
import siena.QueryFilter;
import siena.QueryFilterSimple;
import siena.QueryOrder;
import siena.SienaException;
import siena.Util;
import siena.core.async.PersistenceManagerAsync;
import siena.remote.Common;
import siena.remote.Connector;
import siena.remote.Serializer;
import siena.remote.URLConnector;
import siena.remote.XmlSerializer;

public class RemotePersistenceManager
extends AbstractPersistenceManager {
    private Connector connector;
    private Serializer serializer;
    private String key;

    @Override
    public void init(Properties p) {
        String connectorImpl = p.getProperty("connector");
        if (connectorImpl != null) {
            try {
                this.connector = (Connector)Class.forName(connectorImpl).newInstance();
            }
            catch (Exception e) {
                throw new SienaException("Error while instantiating connector: " + connectorImpl, e);
            }
        } else {
            this.connector = new URLConnector();
        }
        String serializerImpl = p.getProperty("serializer");
        if (serializerImpl != null) {
            try {
                this.serializer = (Serializer)Class.forName(serializerImpl).newInstance();
            }
            catch (Exception e) {
                throw new SienaException("Error while instantiating serializer: " + serializerImpl, e);
            }
        } else {
            this.serializer = new XmlSerializer();
        }
        this.key = p.getProperty("key");
        this.connector.configure(p);
    }

    @Override
    public void delete(Object obj) {
        this.simpleRequest("delete", obj, true);
    }

    @Override
    public void get(Object obj) {
        this.simpleRequest("get", obj, true);
    }

    @Override
    public void insert(Object obj) {
        this.simpleRequest("insert", obj, false);
    }

    @Override
    public void update(Object obj) {
        this.simpleRequest("update", obj, false);
    }

    protected Document createRequest(String name) {
        Document d = DocumentHelper.createDocument();
        Element root = d.addElement(name);
        if (this.key != null) {
            String time = Long.toString(System.currentTimeMillis());
            root.addAttribute("time", time);
            root.addAttribute("hash", Util.sha1(String.valueOf(time) + this.key));
        }
        return d;
    }

    private Document createRequest(String name, Object entity, boolean ids) {
        Document d = this.createRequest(name);
        Common.fillRequestElement(entity, d.getRootElement(), ids);
        return d;
    }

    private void simpleRequest(String name, Object entity, boolean ids) {
        Document request = this.createRequest(name, entity, ids);
        Document response = this.send(request);
        Element root = response.getRootElement();
        String rootName = root.getName();
        if ("error".equals(rootName)) {
            throw new SienaException(String.valueOf(root.attributeValue("class")) + " " + root.getText());
        }
        if ("object".equals(rootName)) {
            Common.parseEntity(entity, root, entity.getClass().getClassLoader());
        }
    }

    protected Document send(Document request) {
        try {
            this.connector.connect();
            this.serializer.serialize(request, this.connector.getOutputStream());
            Document response = this.serializer.deserialize(this.connector.getInputStream());
            this.connector.close();
            return response;
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    private <T> Document createRequest(Query<T> query) {
        Field field;
        Class clazz = query.getQueriedClass();
        Document request = this.createRequest("query");
        request.getRootElement().addAttribute("class", clazz.getName());
        List<QueryFilter> filters = query.getFilters();
        for (QueryFilter filter : filters) {
            if (!QueryFilterSimple.class.isAssignableFrom(filter.getClass())) continue;
            QueryFilterSimple qf = (QueryFilterSimple)filter;
            field = qf.field;
            Object value = qf.value;
            Element filtr = request.getRootElement().addElement("filter");
            filtr.addAttribute("field", field.getName());
            filtr.addAttribute("operator", qf.operator);
            if (ClassInfo.isModel(value.getClass())) {
                Common.fillRequestElement((Model)value, filtr, true);
                continue;
            }
            filtr.setText(Util.toString(field, value));
        }
        List<QueryOrder> orders = query.getOrders();
        for (QueryOrder order : orders) {
            field = order.field;
            request.getRootElement().addElement("order").addAttribute("field", field.getName()).addAttribute("ascending", Boolean.toString(order.ascending));
        }
        return request;
    }

    private <T> List<T> sendAndParse(Document request) {
        Document response = this.send(request);
        Element root = response.getRootElement();
        if ("error".equals(root.getName())) {
            throw new SienaException(String.valueOf(root.attributeValue("class")) + " " + root.getText());
        }
        List result = response.getRootElement().elements("object");
        ArrayList<Model> list = new ArrayList<Model>(result.size());
        for (Element element : result) {
            list.add(Common.parseEntity(element, null));
        }
        return list;
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        Document request = this.createRequest(query);
        return this.sendAndParse(request);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        Document request = this.createRequest(query);
        request.getRootElement().addAttribute("limit", Integer.toString(limit));
        return this.sendAndParse(request);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        Document request = this.createRequest(query);
        request.getRootElement().addAttribute("limit", Integer.toString(limit));
        request.getRootElement().addAttribute("offset", offset.toString());
        return this.sendAndParse(request);
    }

    @Override
    public <T> int count(Query<T> query) {
        return this.fetch(query).size();
    }

    @Override
    public <T> int delete(Query<T> query) {
        throw new NotImplementedException();
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        throw new NotImplementedException();
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        throw new NotImplementedException();
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        throw new NotImplementedException();
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        throw new NotImplementedException();
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        throw new NotImplementedException();
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        throw new NotImplementedException();
    }

    @Override
    public String[] supportedOperators() {
        return null;
    }

    @Override
    public <T> void release(Query<T> query) {
    }

    @Override
    public int insert(Object ... objects) {
        return 0;
    }

    @Override
    public int insert(Iterable<?> objects) {
        return 0;
    }

    @Override
    public int delete(Object ... models) {
        return 0;
    }

    @Override
    public int delete(Iterable<?> models) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        return 0;
    }

    @Override
    public int get(Object ... models) {
        return 0;
    }

    @Override
    public <T> int get(Iterable<T> models) {
        return 0;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        return null;
    }

    @Override
    public <T> int update(Object ... models) {
        return 0;
    }

    @Override
    public <T> int update(Iterable<T> models) {
        return 0;
    }

    @Override
    public <T> void nextPage(Query<T> query) {
    }

    @Override
    public <T> void previousPage(Query<T> query) {
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        return null;
    }

    @Override
    public <T> void paginate(Query<T> query) {
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        return null;
    }

    @Override
    public void save(Object obj) {
    }

    @Override
    public int save(Object ... objects) {
        return 0;
    }

    @Override
    public int save(Iterable<?> objects) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        return 0;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        return null;
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        return 0;
    }
}

