/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Query;
import siena.QueryFilter;
import siena.QueryFilterSimple;
import siena.QueryOrder;
import siena.SienaException;
import siena.Util;
import siena.core.async.PersistenceManagerAsync;
import siena.sdb.ws.Item;
import siena.sdb.ws.SelectResponse;
import siena.sdb.ws.SimpleDB;

public class SdbPersistenceManager
extends AbstractPersistenceManager {
    private static final String[] supportedOperators = new String[]{"<", ">", ">=", "<=", "="};
    private static long ioffset = Math.abs(Integer.MIN_VALUE);
    private SimpleDB ws;
    private String prefix;
    private List<String> domains;

    @Override
    public void init(Properties p) {
        String awsAccessKeyId = p.getProperty("awsAccessKeyId");
        String awsSecretAccessKey = p.getProperty("awsSecretAccessKey");
        if (awsAccessKeyId == null || awsSecretAccessKey == null) {
            throw new SienaException("Both awsAccessKeyId and awsSecretAccessKey properties must be set");
        }
        this.prefix = p.getProperty("prefix");
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.ws = new SimpleDB(awsAccessKeyId, awsSecretAccessKey);
    }

    @Override
    public void delete(Object obj) {
        this.ws.deleteAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    @Override
    public void get(Object obj) {
        Item item = this.ws.getAttributes((String)this.getDomainName(obj.getClass()), (String)this.getIdValue((Object)obj)).item;
        this.fillModel(item, obj);
    }

    @Override
    public void insert(Object obj) {
        this.ws.putAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    @Override
    public void update(Object obj) {
        this.ws.putAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    public String getIdValue(Object obj) {
        try {
            return (String)ClassInfo.getIdField(obj.getClass()).get(obj);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected String getDomainName(Class<?> clazz) {
        String domain = String.valueOf(this.prefix) + ClassInfo.getClassInfo(clazz).tableName;
        if (this.domains == null) {
            this.domains = this.ws.listDomains(null, null).domains;
        }
        if (!this.domains.contains(domain)) {
            this.ws.createDomain(domain);
        }
        return domain;
    }

    private String getAttributeName(Field field) {
        return ClassInfo.getColumnNames(field)[0];
    }

    private Object readField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private Item toItem(Object obj) {
        Item item = new Item();
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            try {
                String value = SdbPersistenceManager.toString(field, field.get(obj));
                if (value == null) continue;
                item.add(this.getAttributeName(field), value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Field id = ClassInfo.getIdField(clazz);
        String name = (String)this.readField(obj, id);
        if (name == null) {
            try {
                name = UUID.randomUUID().toString();
                id.set(obj, name);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        item.name = name;
        return item;
    }

    private static String toString(Field field, Object object) {
        if (object == null) {
            return null;
        }
        Class<?> type = field.getType();
        if (type == Integer.class || type == Integer.TYPE) {
            return SdbPersistenceManager.toString((Integer)object);
        }
        if (ClassInfo.isModel(type)) {
            try {
                return ClassInfo.getIdField(type).get(object).toString();
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return Util.toString(field, object);
    }

    private void fillModel(Item item, Object obj) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            List<String> values = item.attributes.get(this.getAttributeName(field));
            if (values == null || values.isEmpty()) continue;
            try {
                String value = values.get(0);
                if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                    field.set(obj, SdbPersistenceManager.fromString(value));
                    continue;
                }
                Class<?> type = field.getType();
                if (ClassInfo.isModel(type)) {
                    Object rel = type.newInstance();
                    Field id = ClassInfo.getIdField(type);
                    id.set(rel, value);
                    field.set(obj, rel);
                    continue;
                }
                Util.setFromString(obj, field, value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Field id = ClassInfo.getIdField(clazz);
        try {
            id.set(obj, item.name);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private static String toString(int i) {
        return String.format("%010d", (long)i + ioffset);
    }

    private static int fromString(String s) {
        long l = Long.parseLong(s);
        return (int)(l - ioffset);
    }

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public void rollbackTransaction() {
    }

    private <T> List<T> query(Query<T> query, String suffix, String nextToken) {
        Class clazz = query.getQueriedClass();
        String domain = this.getDomainName(clazz);
        String q = String.valueOf(this.buildQuery(query, "select * from " + domain)) + suffix;
        SelectResponse response = this.ws.select(q, nextToken);
        query.setNextOffset(response.nextToken);
        List<Item> items = response.items;
        ArrayList result = new ArrayList(items.size());
        for (Item item : items) {
            try {
                Object object = clazz.newInstance();
                this.fillModel(item, object);
                result.add(object);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return result;
    }

    private <T> String buildQuery(Query<T> query, String prefix) {
        List<QueryOrder> orders;
        StringBuilder q = new StringBuilder(prefix);
        List<QueryFilter> filters = query.getFilters();
        if (!filters.isEmpty()) {
            q.append(" where ");
            boolean first = true;
            for (QueryFilter filter : filters) {
                if (!QueryFilterSimple.class.isAssignableFrom(filter.getClass())) continue;
                QueryFilterSimple qf = (QueryFilterSimple)filter;
                Field f = qf.field;
                Object value = qf.value;
                String op = qf.operator;
                if (!first) {
                    q.append(" and ");
                }
                first = false;
                String column = null;
                column = ClassInfo.isId(f) ? "itemName()" : ClassInfo.getColumnNames(f)[0];
                if (value == null && op.equals("=")) {
                    q.append(String.valueOf(column) + " is null");
                    continue;
                }
                String s = SdbPersistenceManager.toString(f, value);
                q.append(String.valueOf(column) + op + SimpleDB.quote(s));
            }
        }
        if (!(orders = query.getOrders()).isEmpty()) {
            QueryOrder last = orders.get(orders.size() - 1);
            Field field = last.field;
            if (ClassInfo.isId(field)) {
                q.append("order by itemName()");
            } else {
                q.append("order by ");
                q.append(ClassInfo.getColumnNames(field)[0]);
            }
            if (!last.ascending) {
                q.append(" desc");
            }
        }
        return q.toString();
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        return this.query(query, "", null);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        return this.query(query, " limit " + limit, null);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        return this.query(query, " limit " + limit, offset.toString());
    }

    @Override
    public <T> int count(Query<T> query) {
        Class clazz = query.getQueriedClass();
        String domain = this.getDomainName(clazz);
        String q = this.buildQuery(query, "select count(*) from " + domain);
        SelectResponse response = this.ws.select(q, null);
        query.setNextOffset(response.nextToken);
        return Integer.parseInt(response.items.get((int)0).attributes.get("Count").get(0));
    }

    @Override
    public <T> int delete(Query<T> query) {
        return 0;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        return null;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        return null;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        return null;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        return null;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        return null;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        return null;
    }

    @Override
    public <T> void release(Query<T> query) {
    }

    @Override
    public String[] supportedOperators() {
        return supportedOperators;
    }

    @Override
    public int insert(Object ... objects) {
        return 0;
    }

    @Override
    public int insert(Iterable<?> objects) {
        return 0;
    }

    @Override
    public int delete(Object ... models) {
        return 0;
    }

    @Override
    public int delete(Iterable<?> models) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        return 0;
    }

    @Override
    public int get(Object ... models) {
        return 0;
    }

    @Override
    public <T> int get(Iterable<T> models) {
        return 0;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        return null;
    }

    @Override
    public <T> int update(Object ... models) {
        return 0;
    }

    @Override
    public <T> int update(Iterable<T> models) {
        return 0;
    }

    @Override
    public <T> void nextPage(Query<T> query) {
    }

    @Override
    public <T> void previousPage(Query<T> query) {
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        return null;
    }

    @Override
    public <T> void paginate(Query<T> query) {
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        return null;
    }

    @Override
    public void save(Object obj) {
    }

    @Override
    public int save(Object ... objects) {
        return 0;
    }

    @Override
    public int save(Iterable<?> objects) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        return 0;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        return null;
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        return 0;
    }
}

