/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.oracle;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.util.StringUtilsExt;

public class Oracle8Builder
extends SqlBuilder {
    private Pattern _isoDatePattern;
    private Pattern _isoTimePattern;
    private Pattern _isoTimestampPattern;

    public Oracle8Builder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
        try {
            this._isoDatePattern = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}");
            this._isoTimePattern = Pattern.compile("\\d{2}:\\d{2}:\\d{2}");
            this._isoTimestampPattern = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}[\\.\\d{1,8}]?");
        }
        catch (PatternSyntaxException ex) {
            throw new DdlUtilsException(ex);
        }
    }

    @Override
    public void createTable(Database database, Table table, Map parameters) throws IOException {
        Column[] columns = table.getAutoIncrementColumns();
        int idx = 0;
        while (idx < columns.length) {
            this.createAutoIncrementSequence(table, columns[idx]);
            ++idx;
        }
        super.createTable(database, table, parameters);
        idx = 0;
        while (idx < columns.length) {
            this.createAutoIncrementTrigger(table, columns[idx]);
            ++idx;
        }
    }

    @Override
    public void dropTable(Table table) throws IOException {
        Column[] columns = table.getAutoIncrementColumns();
        int idx = 0;
        while (idx < columns.length) {
            this.dropAutoIncrementTrigger(table, columns[idx]);
            this.dropAutoIncrementSequence(table, columns[idx]);
            ++idx;
        }
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" CASCADE CONSTRAINTS");
        this.printEndOfStatement();
    }

    protected void createAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("CREATE SEQUENCE ");
        this.printIdentifier(this.getConstraintName("seq", table, column.getName(), null));
        this.printEndOfStatement();
    }

    protected void createAutoIncrementTrigger(Table table, Column column) throws IOException {
        String columnName = this.getColumnName(column);
        String triggerName = this.getConstraintName("trg", table, column.getName(), null);
        if (this.getPlatform().isScriptModeOn()) {
            this.print("CREATE OR REPLACE TRIGGER ");
            this.printlnIdentifier(triggerName);
            this.print("BEFORE INSERT ON ");
            this.printlnIdentifier(this.getTableName(table));
            this.print("FOR EACH ROW WHEN (new.");
            this.printIdentifier(columnName);
            this.println(" IS NULL)");
            this.println("BEGIN");
            this.print("  SELECT ");
            this.printIdentifier(this.getConstraintName("seq", table, column.getName(), null));
            this.print(".nextval INTO :new.");
            this.printIdentifier(columnName);
            this.print(" FROM dual");
            this.println(this.getPlatformInfo().getSqlCommandDelimiter());
            this.print("END");
            this.println(this.getPlatformInfo().getSqlCommandDelimiter());
            this.println("/");
            this.println();
        } else {
            this.print("CREATE OR REPLACE TRIGGER ");
            this.printIdentifier(triggerName);
            this.print(" BEFORE INSERT ON ");
            this.printIdentifier(this.getTableName(table));
            this.print(" FOR EACH ROW WHEN (new.");
            this.printIdentifier(columnName);
            this.println(" IS NULL)");
            this.print("BEGIN SELECT ");
            this.printIdentifier(this.getConstraintName("seq", table, column.getName(), null));
            this.print(".nextval INTO :new.");
            this.printIdentifier(columnName);
            this.print(" FROM dual");
            this.print(this.getPlatformInfo().getSqlCommandDelimiter());
            this.print(" END");
            this.print(this.getPlatformInfo().getSqlCommandDelimiter());
            this.printEndOfStatement();
        }
    }

    protected void dropAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("DROP SEQUENCE ");
        this.printIdentifier(this.getConstraintName("seq", table, column.getName(), null));
        this.printEndOfStatement();
    }

    protected void dropAutoIncrementTrigger(Table table, Column column) throws IOException {
        this.print("DROP TRIGGER ");
        this.printIdentifier(this.getConstraintName("trg", table, column.getName(), null));
        this.printEndOfStatement();
    }

    @Override
    protected void createTemporaryTable(Database database, Table table, Map parameters) throws IOException {
        this.createTable(database, table, parameters);
    }

    @Override
    protected void dropTemporaryTable(Database database, Table table) throws IOException {
        this.dropTable(table);
    }

    @Override
    public void dropForeignKeys(Table table) throws IOException {
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    @Override
    protected void printDefaultValue(Object defaultValue, int typeCode) throws IOException {
        if (defaultValue != null) {
            boolean shouldUseQuotes;
            String defaultValueStr = defaultValue.toString();
            boolean bl = shouldUseQuotes = !TypeMap.isNumericType(typeCode) && !defaultValueStr.startsWith("TO_DATE(");
            if (shouldUseQuotes) {
                this.print(this.getPlatformInfo().getValueQuoteToken());
                this.print(this.escapeStringValue(defaultValueStr));
                this.print(this.getPlatformInfo().getValueQuoteToken());
            } else {
                this.print(defaultValueStr);
            }
        }
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        if (column.getTypeCode() == 91) {
            if (this._isoDatePattern.matcher(column.getDefaultValue()).matches()) {
                return "TO_DATE('" + column.getDefaultValue() + "', 'YYYY-MM-DD')";
            }
        } else if (column.getTypeCode() == 92) {
            if (this._isoTimePattern.matcher(column.getDefaultValue()).matches()) {
                return "TO_DATE('" + column.getDefaultValue() + "', 'HH24:MI:SS')";
            }
        } else if (column.getTypeCode() == 93 && this._isoTimestampPattern.matcher(column.getDefaultValue()).matches()) {
            return "TO_DATE('" + column.getDefaultValue() + "', 'YYYY-MM-DD HH24:MI:SS')";
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length > 0) {
            StringBuffer result = new StringBuffer();
            result.append("SELECT ");
            int idx = 0;
            while (idx < columns.length) {
                if (idx > 0) {
                    result.append(",");
                }
                result.append(this.getDelimitedIdentifier(this.getConstraintName("seq", table, columns[idx].getName(), null)));
                result.append(".currval");
                ++idx;
            }
            result.append(" FROM dual");
            return result.toString();
        }
        return null;
    }

    @Override
    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
        if (newColumn.isAutoIncrement()) {
            this.createAutoIncrementSequence(table, newColumn);
            this.createAutoIncrementTrigger(table, newColumn);
        }
    }

    public void dropColumn(Table table, Column column) throws IOException {
        if (column.isAutoIncrement()) {
            this.dropAutoIncrementTrigger(table, column);
            this.dropAutoIncrementSequence(table, column);
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    public void dropPrimaryKey(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP PRIMARY KEY");
        this.printEndOfStatement();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged;
        boolean bl = sizeChanged = TypeMap.isTextType(targetColumn.getTypeCode()) && ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn) && !StringUtilsExt.isEmpty((String)targetColumn.getSize());
        if (sizeChanged) {
            this.print("SUBSTR(");
        }
        if (ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn)) {
            this.print("CAST (");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" AS ");
            this.print(this.getSqlType(targetColumn));
            this.print(")");
        } else {
            this.printIdentifier(this.getColumnName(sourceColumn));
        }
        if (sizeChanged) {
            this.print(",0,");
            this.print(targetColumn.getSize());
            this.print(")");
        }
    }
}

