/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.io.ColumnXmlWriter;
import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.io.ModelXmlWriter;
import org.apache.ddlutils.io.XMLUtils;
import org.apache.ddlutils.model.Table;

public class TableXmlWriter
extends ModelXmlWriter {
    private static final int AS_TAG_NAME = 0;
    private static final int AS_ATTRIBUTE = 1;
    private static final int AS_SUB_TAG = 2;
    private final String tableName;
    private final int formattingMethod;
    private final boolean base64Encoded;

    public TableXmlWriter(Table table) {
        if (XMLUtils.hasIllegalXMLCharacters(table.getName())) {
            this.tableName = XMLUtils.base64Encode(table.getName());
            this.formattingMethod = 2;
            this.base64Encoded = true;
        } else {
            this.tableName = table.getName();
            this.base64Encoded = false;
            this.formattingMethod = this.tableName.length() > 255 ? 2 : ("table".equals(this.tableName) || !XMLUtils.isWellFormedXMLName(this.tableName) ? 1 : 0);
        }
    }

    public void write(List columnXmlWriters, DataWriter writer) {
        writer.indentIfPrettyPrinting(1);
        if (this.formattingMethod == 0) {
            writer.writeElementStart(null, this.tableName);
        } else {
            writer.writeElementStart(null, "table");
        }
        if (this.formattingMethod == 1) {
            writer.writeAttribute(null, "table-name", this.tableName);
        }
        Iterator it = columnXmlWriters.iterator();
        while (it.hasNext()) {
            ((ColumnXmlWriter)it.next()).writeAttribute(writer);
        }
        boolean hasSubTags = false;
        if (this.formattingMethod == 2) {
            writer.printlnIfPrettyPrinting();
            writer.indentIfPrettyPrinting(2);
            writer.writeElementStart(null, "table-name");
            this.writeText(writer, this.tableName, this.base64Encoded);
            writer.writeElementEnd();
            hasSubTags = true;
        }
        Iterator it2 = columnXmlWriters.iterator();
        while (it2.hasNext()) {
            boolean bl = hasSubTags = ((ColumnXmlWriter)it2.next()).writeSubElement(writer) || hasSubTags;
        }
        if (hasSubTags) {
            writer.printlnIfPrettyPrinting();
            writer.indentIfPrettyPrinting(1);
        }
        writer.writeElementEnd();
        writer.printlnIfPrettyPrinting();
    }
}

