/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.io.PrettyPrintingXmlWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DumpMetadataTask
extends Task {
    private static final String[] IGNORED_PROPERTY_METHODS = new String[]{"getConnection", "getCatalogs", "getSchemas"};
    private BasicDataSource _dataSource;
    private File _outputFile = null;
    private String _outputEncoding = "UTF-8";
    private String _catalogPattern = "%";
    private String _schemaPattern = "%";
    private String _tablePattern = "%";
    private String _procedurePattern = "%";
    private String _columnPattern = "%";
    private String[] _tableTypes = null;
    private boolean _dumpTables = true;
    private boolean _dumpProcedures = true;

    public void addConfiguredDatabase(BasicDataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void setOutputEncoding(String encoding) {
        this._outputEncoding = encoding;
    }

    public void setCatalogPattern(String catalogPattern) {
        this._catalogPattern = catalogPattern == null || catalogPattern.length() == 0 ? null : catalogPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this._schemaPattern = schemaPattern == null || schemaPattern.length() == 0 ? null : schemaPattern;
    }

    public void setTablePattern(String tablePattern) {
        this._tablePattern = tablePattern == null || tablePattern.length() == 0 ? null : tablePattern;
    }

    public void setProcedurePattern(String procedurePattern) {
        this._procedurePattern = procedurePattern == null || procedurePattern.length() == 0 ? null : procedurePattern;
    }

    public void setColumnPattern(String columnPattern) {
        this._columnPattern = columnPattern == null || columnPattern.length() == 0 ? null : columnPattern;
    }

    public void setTableTypes(String tableTypes) {
        ArrayList<String> types = new ArrayList<String>();
        if (tableTypes != null) {
            StringTokenizer tokenizer = new StringTokenizer(tableTypes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() <= 0) continue;
                types.add(token);
            }
        }
        this._tableTypes = types.toArray(new String[types.size()]);
    }

    public void setDumpProcedures(boolean readProcedures) {
        this._dumpProcedures = readProcedures;
    }

    public void setDumpTables(boolean readTables) {
        this._dumpTables = readTables;
    }

    public void execute() throws BuildException {
        if (this._dataSource == null) {
            this.log("No data source specified, so there is nothing to do.", 2);
            return;
        }
        Connection connection = null;
        OutputStream output = null;
        try {
            try {
                connection = this._dataSource.getConnection();
                output = this._outputFile == null ? System.out : new FileOutputStream(this._outputFile);
                PrettyPrintingXmlWriter xmlWriter = new PrettyPrintingXmlWriter(output, this._outputEncoding);
                xmlWriter.writeDocumentStart();
                xmlWriter.writeElementStart(null, "metadata");
                xmlWriter.writeAttribute(null, "driverClassName", this._dataSource.getDriverClassName());
                this.dumpMetaData(xmlWriter, connection.getMetaData());
                xmlWriter.writeDocumentEnd();
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this._outputFile != null && output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void dumpMetaData(PrettyPrintingXmlWriter xmlWriter, DatabaseMetaData metaData) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, SQLException {
        Method[] methods = metaData.getClass().getMethods();
        HashSet<String> filtered = new HashSet<String>(Arrays.asList(IGNORED_PROPERTY_METHODS));
        int idx = 0;
        while (idx < methods.length) {
            if (methods[idx].getParameterTypes().length == 0 && methods[idx].getReturnType() != null && Object.class != methods[idx].getDeclaringClass() && !filtered.contains(methods[idx].getName())) {
                this.dumpProperty(xmlWriter, metaData, methods[idx]);
            }
            ++idx;
        }
        this.dumpCatalogsAndSchemas(xmlWriter, metaData);
        if (this._dumpTables) {
            this.dumpTables(xmlWriter, metaData);
        }
        if (this._dumpProcedures) {
            this.dumpProcedures(xmlWriter, metaData);
        }
    }

    private void dumpProperty(PrettyPrintingXmlWriter xmlWriter, Object obj, Method propGetter) {
        try {
            this.addProperty(xmlWriter, this.getPropertyName(propGetter.getName()), propGetter.invoke(obj, null));
        }
        catch (Throwable ex) {
            this.log("Could not dump property " + propGetter.getName() + ": " + ex.getStackTrace(), 0);
        }
    }

    private void addProperty(PrettyPrintingXmlWriter xmlWriter, String name, Object value) {
        if (value != null) {
            if (value.getClass().isArray()) {
                this.addArrayProperty(xmlWriter, name, (Object[])value);
            } else if (value.getClass().isPrimitive() || value instanceof String) {
                xmlWriter.writeAttribute(null, name, value.toString());
            } else if (value instanceof ResultSet) {
                this.addResultSetProperty(xmlWriter, name, (ResultSet)value);
            }
        }
    }

    private void addArrayProperty(PrettyPrintingXmlWriter xmlWriter, String name, Object[] values) {
        String propName = name;
        if (propName.endsWith("s")) {
            propName = propName.substring(0, propName.length() - 1);
        }
        xmlWriter.writeElementStart(null, String.valueOf(propName) + "s");
        int idx = 0;
        while (idx < values.length) {
            this.addProperty(xmlWriter, "value", values[idx]);
            ++idx;
        }
        xmlWriter.writeElementEnd();
    }

    private void addResultSetProperty(PrettyPrintingXmlWriter xmlWriter, String name, ResultSet result) {
        String propName = name;
        if (propName.endsWith("s")) {
            propName = propName.substring(0, propName.length() - 1);
        }
        try {
            ResultSetMetaData metaData = result.getMetaData();
            xmlWriter.writeElementStart(null, String.valueOf(propName) + "s");
            try {
                while (result.next()) {
                    xmlWriter.writeElementStart(null, propName);
                    try {
                        int idx = 1;
                        while (idx <= metaData.getColumnCount()) {
                            Object value = result.getObject(idx);
                            this.addProperty(xmlWriter, metaData.getColumnLabel(idx), value);
                            ++idx;
                        }
                    }
                    finally {
                        xmlWriter.writeElementEnd();
                    }
                }
            }
            finally {
                xmlWriter.writeElementEnd();
            }
        }
        catch (SQLException ex) {
            this.log("Could not read the result set metadata: " + ex.getStackTrace(), 0);
        }
    }

    private String getPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            if (Character.isLowerCase(methodName.charAt(4))) {
                return String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
            }
            return methodName.substring(3);
        }
        if (methodName.startsWith("is")) {
            if (Character.isLowerCase(methodName.charAt(3))) {
                return String.valueOf(Character.toLowerCase(methodName.charAt(2))) + methodName.substring(3);
            }
            return methodName.substring(2);
        }
        return methodName;
    }

    private void performResultSetXmlOperation(PrettyPrintingXmlWriter xmlWriter, String name, ResultSetXmlOperation op) {
        block18: {
            ResultSet result = null;
            try {
                try {
                    result = op.getResultSet();
                    if (name != null) {
                        xmlWriter.writeElementStart(null, name);
                    }
                    try {
                        while (result.next()) {
                            op.handleRow(xmlWriter, result);
                        }
                    }
                    finally {
                        if (name != null) {
                            xmlWriter.writeElementEnd();
                        }
                    }
                }
                catch (SQLException ex) {
                    op.handleError(ex);
                    if (result == null) break block18;
                    try {
                        result.close();
                    }
                    catch (SQLException ex2) {
                        this.log("Could not close a result set: " + ex2.getStackTrace(), 0);
                    }
                }
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException ex) {
                        this.log("Could not close a result set: " + ex.getStackTrace(), 0);
                    }
                }
            }
        }
    }

    private void dumpCatalogsAndSchemas(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData) {
        this.performResultSetXmlOperation(xmlWriter, "catalogs", new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getCatalogs();
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                String catalogName = result.getString("TABLE_CAT");
                if (catalogName != null && catalogName.length() > 0) {
                    xmlWriter.writeElementStart(null, "catalog");
                    xmlWriter.writeAttribute(null, "name", catalogName);
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the catalogs from the result set: " + ex.getStackTrace(), 0);
            }
        });
        this.performResultSetXmlOperation(xmlWriter, "schemas", new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getSchemas();
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                String schemaName = result.getString("TABLE_SCHEM");
                if (schemaName != null && schemaName.length() > 0) {
                    xmlWriter.writeElementStart(null, "schema");
                    xmlWriter.writeAttribute(null, "name", schemaName);
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the schemas from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpTables(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData) {
        final ArrayList tableTypeList = new ArrayList();
        this.performResultSetXmlOperation(xmlWriter, "tableTypes", new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getTableTypes();
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                String tableType = result.getString("TABLE_TYPE");
                tableTypeList.add(tableType);
                xmlWriter.writeElementStart(null, "tableType");
                xmlWriter.writeAttribute(null, "name", tableType);
                xmlWriter.writeElementEnd();
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the table types from the result set: " + ex.getStackTrace(), 0);
            }
        });
        final String[] tableTypesToRead = this._tableTypes == null || this._tableTypes.length == 0 ? tableTypeList.toArray(new String[tableTypeList.size()]) : this._tableTypes;
        this.performResultSetXmlOperation(xmlWriter, "tables", new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getTables(DumpMetadataTask.this._catalogPattern, DumpMetadataTask.this._schemaPattern, DumpMetadataTask.this._tablePattern, tableTypesToRead);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                String tableName = result.getString("TABLE_NAME");
                if (tableName != null && tableName.length() > 0) {
                    String catalog = result.getString("TABLE_CAT");
                    String schema = result.getString("TABLE_SCHEM");
                    DumpMetadataTask.this.log("Reading table " + (schema != null && schema.length() > 0 ? String.valueOf(schema) + "." : "") + tableName, 2);
                    xmlWriter.writeElementStart(null, "table");
                    xmlWriter.writeAttribute(null, "name", tableName);
                    if (catalog != null) {
                        xmlWriter.writeAttribute(null, "catalog", catalog);
                    }
                    if (schema != null) {
                        xmlWriter.writeAttribute(null, "schema", schema);
                    }
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "type", result, columns, "TABLE_TYPE");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "remarks", result, columns, "REMARKS");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "typeName", result, columns, "TYPE_NAME");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "typeCatalog", result, columns, "TYPE_CAT");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "typeSchema", result, columns, "TYPE_SCHEM");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "identifierColumn", result, columns, "SELF_REFERENCING_COL_NAME");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "identifierGeneration", result, columns, "REF_GENERATION");
                    DumpMetadataTask.this.dumpColumns(xmlWriter, metaData, catalog, schema, tableName);
                    DumpMetadataTask.this.dumpPKs(xmlWriter, metaData, catalog, schema, tableName);
                    DumpMetadataTask.this.dumpVersionColumns(xmlWriter, metaData, catalog, schema, tableName);
                    DumpMetadataTask.this.dumpFKs(xmlWriter, metaData, catalog, schema, tableName);
                    DumpMetadataTask.this.dumpIndexes(xmlWriter, metaData, catalog, schema, tableName);
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the tables from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpColumns(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData, final String catalogName, final String schemaName, final String tableName) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, null, new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getColumns(catalogName, schemaName, tableName, DumpMetadataTask.this._columnPattern);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                String columnName = result.getString("COLUMN_NAME");
                if (columnName != null && columnName.length() > 0) {
                    xmlWriter.writeElementStart(null, "column");
                    xmlWriter.writeAttribute(null, "name", columnName);
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "typeCode", result, columns, "DATA_TYPE");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "type", result, columns, "TYPE_NAME");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "size", result, columns, "COLUMN_SIZE");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "digits", result, columns, "DECIMAL_DIGITS");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "precision", result, columns, "NUM_PREC_RADIX");
                    if (columns.contains("NULLABLE")) {
                        try {
                            switch (result.getInt("NULLABLE")) {
                                case 0: {
                                    xmlWriter.writeAttribute(null, "nullable", "false");
                                    break;
                                }
                                case 1: {
                                    xmlWriter.writeAttribute(null, "nullable", "true");
                                    break;
                                }
                                default: {
                                    xmlWriter.writeAttribute(null, "nullable", "unknown");
                                    break;
                                }
                            }
                        }
                        catch (SQLException ex) {
                            DumpMetadataTask.this.log("Could not read the NULLABLE value for colum '" + columnName + "' of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                        }
                    }
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "remarks", result, columns, "REMARKS");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "defaultValue", result, columns, "COLUMN_DEF");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "maxByteLength", result, columns, "CHAR_OCTET_LENGTH");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "index", result, columns, "ORDINAL_POSITION");
                    if (columns.contains("IS_NULLABLE")) {
                        try {
                            String value = result.getString("IS_NULLABLE");
                            if ("no".equalsIgnoreCase(value)) {
                                xmlWriter.writeAttribute(null, "isNullable", "false");
                            } else if ("yes".equalsIgnoreCase(value)) {
                                xmlWriter.writeAttribute(null, "isNullable", "true");
                            } else {
                                xmlWriter.writeAttribute(null, "isNullable", "unknown");
                            }
                        }
                        catch (SQLException ex) {
                            DumpMetadataTask.this.log("Could not read the IS_NULLABLE value for colum '" + columnName + "' of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                        }
                    }
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "refCatalog", result, columns, "SCOPE_CATLOG");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "refSchema", result, columns, "SCOPE_SCHEMA");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "refTable", result, columns, "SCOPE_TABLE");
                    DumpMetadataTask.this.addShortAttribute(xmlWriter, "sourceTypeCode", result, columns, "SOURCE_DATA_TYPE");
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the colums for table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpPKs(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData, final String catalogName, final String schemaName, final String tableName) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, null, new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getPrimaryKeys(catalogName, schemaName, tableName);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                String columnName = result.getString("COLUMN_NAME");
                if (columnName != null && columnName.length() > 0) {
                    xmlWriter.writeElementStart(null, "primaryKey");
                    xmlWriter.writeAttribute(null, "column", columnName);
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "name", result, columns, "PK_NAME");
                    DumpMetadataTask.this.addShortAttribute(xmlWriter, "sequenceNumberInPK", result, columns, "KEY_SEQ");
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the primary keys for table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpVersionColumns(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData, final String catalogName, final String schemaName, final String tableName) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, null, new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getVersionColumns(catalogName, schemaName, tableName);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                String columnName = result.getString("COLUMN_NAME");
                if (columnName != null && columnName.length() > 0) {
                    xmlWriter.writeElementStart(null, "versionedColumn");
                    xmlWriter.writeAttribute(null, "column", columnName);
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "typeCode", result, columns, "DATA_TYPE");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "type", result, columns, "TYPE_NAME");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "size", result, columns, "BUFFER_LENGTH");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "precision", result, columns, "COLUMN_SIZE");
                    DumpMetadataTask.this.addShortAttribute(xmlWriter, "scale", result, columns, "DECIMAL_DIGITS");
                    if (columns.contains("PSEUDO_COLUMN")) {
                        try {
                            switch (result.getShort("PSEUDO_COLUMN")) {
                                case 2: {
                                    xmlWriter.writeAttribute(null, "columnType", "pseudo column");
                                    break;
                                }
                                case 1: {
                                    xmlWriter.writeAttribute(null, "columnType", "real column");
                                    break;
                                }
                                default: {
                                    xmlWriter.writeAttribute(null, "columnType", "unknown");
                                    break;
                                }
                            }
                        }
                        catch (SQLException ex) {
                            DumpMetadataTask.this.log("Could not read the PSEUDO_COLUMN value for versioned colum '" + columnName + "' of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                        }
                    }
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the versioned columns for table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpFKs(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData, final String catalogName, final String schemaName, final String tableName) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, null, new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getImportedKeys(catalogName, schemaName, tableName);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                xmlWriter.writeElementStart(null, "foreignKey");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "name", result, columns, "FK_NAME");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "primaryKeyName", result, columns, "PK_NAME");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "column", result, columns, "PKCOLUMN_NAME");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "foreignCatalog", result, columns, "FKTABLE_CAT");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "foreignSchema", result, columns, "FKTABLE_SCHEM");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "foreignTable", result, columns, "FKTABLE_NAME");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "foreignColumn", result, columns, "FKCOLUMN_NAME");
                DumpMetadataTask.this.addShortAttribute(xmlWriter, "sequenceNumberInFK", result, columns, "KEY_SEQ");
                if (columns.contains("UPDATE_RULE")) {
                    try {
                        switch (result.getShort("UPDATE_RULE")) {
                            case 3: {
                                xmlWriter.writeAttribute(null, "updateRule", "no action");
                                break;
                            }
                            case 0: {
                                xmlWriter.writeAttribute(null, "updateRule", "cascade PK change");
                                break;
                            }
                            case 2: {
                                xmlWriter.writeAttribute(null, "updateRule", "set FK to NULL");
                                break;
                            }
                            case 4: {
                                xmlWriter.writeAttribute(null, "updateRule", "set FK to default");
                                break;
                            }
                            default: {
                                xmlWriter.writeAttribute(null, "updateRule", "unknown");
                                break;
                            }
                        }
                    }
                    catch (SQLException ex) {
                        DumpMetadataTask.this.log("Could not read the UPDATE_RULE value for a foreign key of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                    }
                }
                if (columns.contains("DELETE_RULE")) {
                    try {
                        switch (result.getShort("DELETE_RULE")) {
                            case 1: 
                            case 3: {
                                xmlWriter.writeAttribute(null, "deleteRule", "no action");
                                break;
                            }
                            case 0: {
                                xmlWriter.writeAttribute(null, "deleteRule", "cascade PK change");
                                break;
                            }
                            case 2: {
                                xmlWriter.writeAttribute(null, "deleteRule", "set FK to NULL");
                                break;
                            }
                            case 4: {
                                xmlWriter.writeAttribute(null, "deleteRule", "set FK to default");
                                break;
                            }
                            default: {
                                xmlWriter.writeAttribute(null, "deleteRule", "unknown");
                                break;
                            }
                        }
                    }
                    catch (SQLException ex) {
                        DumpMetadataTask.this.log("Could not read the DELETE_RULE value for a foreign key of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                    }
                }
                if (columns.contains("DEFERRABILITY")) {
                    try {
                        switch (result.getShort("DEFERRABILITY")) {
                            case 5: {
                                xmlWriter.writeAttribute(null, "deferrability", "initially deferred");
                                break;
                            }
                            case 6: {
                                xmlWriter.writeAttribute(null, "deferrability", "immediately deferred");
                                break;
                            }
                            case 7: {
                                xmlWriter.writeAttribute(null, "deferrability", "not deferred");
                                break;
                            }
                            default: {
                                xmlWriter.writeAttribute(null, "deferrability", "unknown");
                                break;
                            }
                        }
                    }
                    catch (SQLException ex) {
                        DumpMetadataTask.this.log("Could not read the DEFERRABILITY value for a foreign key of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                    }
                }
                xmlWriter.writeElementEnd();
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not determine the foreign keys for table '" + tableName + "': " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpIndexes(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData, final String catalogName, final String schemaName, final String tableName) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, null, new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getIndexInfo(catalogName, schemaName, tableName, false, false);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                xmlWriter.writeElementStart(null, "index");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "name", result, columns, "INDEX_NAME");
                DumpMetadataTask.this.addBooleanAttribute(xmlWriter, "nonUnique", result, columns, "NON_UNIQUE");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "indexCatalog", result, columns, "INDEX_QUALIFIER");
                if (columns.contains("TYPE")) {
                    try {
                        switch (result.getShort("TYPE")) {
                            case 0: {
                                xmlWriter.writeAttribute(null, "type", "table statistics");
                                break;
                            }
                            case 1: {
                                xmlWriter.writeAttribute(null, "type", "clustered");
                                break;
                            }
                            case 2: {
                                xmlWriter.writeAttribute(null, "type", "hashed");
                                break;
                            }
                            case 3: {
                                xmlWriter.writeAttribute(null, "type", "other");
                                break;
                            }
                            default: {
                                xmlWriter.writeAttribute(null, "type", "unknown");
                                break;
                            }
                        }
                    }
                    catch (SQLException ex) {
                        DumpMetadataTask.this.log("Could not read the TYPE value for an index of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                    }
                }
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "column", result, columns, "COLUMN_NAME");
                DumpMetadataTask.this.addShortAttribute(xmlWriter, "sequenceNumberInIndex", result, columns, "ORDINAL_POSITION");
                if (columns.contains("ASC_OR_DESC")) {
                    try {
                        String value = result.getString("ASC_OR_DESC");
                        if ("A".equalsIgnoreCase(value)) {
                            xmlWriter.writeAttribute(null, "sortOrder", "ascending");
                        } else if ("D".equalsIgnoreCase(value)) {
                            xmlWriter.writeAttribute(null, "sortOrder", "descending");
                        } else {
                            xmlWriter.writeAttribute(null, "sortOrder", "unknown");
                        }
                    }
                    catch (SQLException ex) {
                        DumpMetadataTask.this.log("Could not read the ASC_OR_DESC value for an index of table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
                    }
                }
                DumpMetadataTask.this.addIntAttribute(xmlWriter, "cardinality", result, columns, "CARDINALITY");
                DumpMetadataTask.this.addIntAttribute(xmlWriter, "pages", result, columns, "PAGES");
                DumpMetadataTask.this.addStringAttribute(xmlWriter, "filter", result, columns, "FILTER_CONDITION");
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the indexes for table '" + tableName + "' from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpProcedures(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, "procedures", new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getProcedures(DumpMetadataTask.this._catalogPattern, DumpMetadataTask.this._schemaPattern, DumpMetadataTask.this._procedurePattern);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                String procedureName = result.getString("PROCEDURE_NAME");
                if (procedureName != null && procedureName.length() > 0) {
                    String catalog = result.getString("PROCEDURE_CAT");
                    String schema = result.getString("PROCEDURE_SCHEM");
                    DumpMetadataTask.this.log("Reading procedure " + (schema != null && schema.length() > 0 ? String.valueOf(schema) + "." : "") + procedureName, 2);
                    xmlWriter.writeElementStart(null, "procedure");
                    xmlWriter.writeAttribute(null, "name", procedureName);
                    if (catalog != null) {
                        xmlWriter.writeAttribute(null, "catalog", catalog);
                    }
                    if (schema != null) {
                        xmlWriter.writeAttribute(null, "schema", schema);
                    }
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "remarks", result, columns, "REMARKS");
                    if (columns.contains("PROCEDURE_TYPE")) {
                        try {
                            switch (result.getShort("PROCEDURE_TYPE")) {
                                case 2: {
                                    xmlWriter.writeAttribute(null, "type", "returns result");
                                    break;
                                }
                                case 1: {
                                    xmlWriter.writeAttribute(null, "type", "doesn't return result");
                                    break;
                                }
                                case 0: {
                                    xmlWriter.writeAttribute(null, "type", "may return result");
                                    break;
                                }
                                default: {
                                    xmlWriter.writeAttribute(null, "type", "unknown");
                                    break;
                                }
                            }
                        }
                        catch (SQLException ex) {
                            DumpMetadataTask.this.log("Could not read the PROCEDURE_TYPE value for the procedure '" + procedureName + "' from the result set: " + ex.getStackTrace(), 0);
                        }
                    }
                    DumpMetadataTask.this.dumpProcedure(xmlWriter, metaData, "%", "%", procedureName);
                    xmlWriter.writeElementEnd();
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the procedures from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void dumpProcedure(PrettyPrintingXmlWriter xmlWriter, final DatabaseMetaData metaData, final String catalogName, final String schemaName, final String procedureName) throws SQLException {
        this.performResultSetXmlOperation(xmlWriter, null, new ResultSetXmlOperation(){

            @Override
            public ResultSet getResultSet() throws SQLException {
                return metaData.getProcedureColumns(catalogName, schemaName, procedureName, DumpMetadataTask.this._columnPattern);
            }

            @Override
            public void handleRow(PrettyPrintingXmlWriter xmlWriter, ResultSet result) throws SQLException {
                Set columns = DumpMetadataTask.this.getColumnsInResultSet(result);
                String columnName = result.getString("COLUMN_NAME");
                if (columnName != null && columnName.length() > 0) {
                    xmlWriter.writeElementStart(null, "column");
                    xmlWriter.writeAttribute(null, "name", columnName);
                    if (columns.contains("COLUMN_TYPE")) {
                        try {
                            switch (result.getShort("COLUMN_TYPE")) {
                                case 1: {
                                    xmlWriter.writeAttribute(null, "type", "in parameter");
                                    break;
                                }
                                case 2: {
                                    xmlWriter.writeAttribute(null, "type", "in/out parameter");
                                    break;
                                }
                                case 4: {
                                    xmlWriter.writeAttribute(null, "type", "out parameter");
                                    break;
                                }
                                case 5: {
                                    xmlWriter.writeAttribute(null, "type", "return value");
                                    break;
                                }
                                case 3: {
                                    xmlWriter.writeAttribute(null, "type", "result column in ResultSet");
                                    break;
                                }
                                default: {
                                    xmlWriter.writeAttribute(null, "type", "unknown");
                                    break;
                                }
                            }
                        }
                        catch (SQLException ex) {
                            DumpMetadataTask.this.log("Could not read the COLUMN_TYPE value for the column '" + columnName + "' of procedure '" + procedureName + "' from the result set: " + ex.getStackTrace(), 0);
                        }
                    }
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "typeCode", result, columns, "DATA_TYPE");
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "type", result, columns, "TYPE_NAME");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "length", result, columns, "LENGTH");
                    DumpMetadataTask.this.addIntAttribute(xmlWriter, "precision", result, columns, "PRECISION");
                    DumpMetadataTask.this.addShortAttribute(xmlWriter, "short", result, columns, "SCALE");
                    DumpMetadataTask.this.addShortAttribute(xmlWriter, "radix", result, columns, "RADIX");
                    if (columns.contains("NULLABLE")) {
                        try {
                            switch (result.getInt("NULLABLE")) {
                                case 0: {
                                    xmlWriter.writeAttribute(null, "nullable", "false");
                                    break;
                                }
                                case 1: {
                                    xmlWriter.writeAttribute(null, "nullable", "true");
                                    break;
                                }
                                default: {
                                    xmlWriter.writeAttribute(null, "nullable", "unknown");
                                    break;
                                }
                            }
                        }
                        catch (SQLException ex) {
                            DumpMetadataTask.this.log("Could not read the NULLABLE value for the column '" + columnName + "' of procedure '" + procedureName + "' from the result set: " + ex.getStackTrace(), 0);
                        }
                    }
                    DumpMetadataTask.this.addStringAttribute(xmlWriter, "remarks", result, columns, "REMARKS");
                }
            }

            @Override
            public void handleError(SQLException ex) {
                DumpMetadataTask.this.log("Could not read the columns for procedure '" + procedureName + "' from the result set: " + ex.getStackTrace(), 0);
            }
        });
    }

    private void addStringAttribute(PrettyPrintingXmlWriter xmlWriter, String attrName, ResultSet result, Set columns, String columnName) throws SQLException {
        if (columns.contains(columnName)) {
            try {
                xmlWriter.writeAttribute(null, attrName, result.getString(columnName));
            }
            catch (SQLException ex) {
                this.log("Could not read the value from result set column " + columnName + ":" + ex.getStackTrace(), 0);
            }
        }
    }

    private void addIntAttribute(PrettyPrintingXmlWriter xmlWriter, String attrName, ResultSet result, Set columns, String columnName) throws SQLException {
        block5: {
            if (columns.contains(columnName)) {
                try {
                    xmlWriter.writeAttribute(null, attrName, String.valueOf(result.getInt(columnName)));
                }
                catch (SQLException ex) {
                    String value = result.getString(columnName);
                    if (value == null) break block5;
                    try {
                        xmlWriter.writeAttribute(null, attrName, new Integer(value).toString());
                    }
                    catch (NumberFormatException parseEx) {
                        this.log("Could not parse the value from result set column " + columnName + ":" + ex.getStackTrace(), 0);
                    }
                }
            }
        }
    }

    private void addShortAttribute(PrettyPrintingXmlWriter xmlWriter, String attrName, ResultSet result, Set columns, String columnName) throws SQLException {
        block5: {
            if (columns.contains(columnName)) {
                try {
                    xmlWriter.writeAttribute(null, attrName, String.valueOf(result.getShort(columnName)));
                }
                catch (SQLException ex) {
                    String value = result.getString(columnName);
                    if (value == null) break block5;
                    try {
                        xmlWriter.writeAttribute(null, attrName, new Short(value).toString());
                    }
                    catch (NumberFormatException parseEx) {
                        this.log("Could not parse the value from result set column " + columnName + ":" + ex.getStackTrace(), 0);
                    }
                }
            }
        }
    }

    private void addBooleanAttribute(PrettyPrintingXmlWriter xmlWriter, String attrName, ResultSet result, Set columns, String columnName) throws SQLException {
        block5: {
            if (columns.contains(columnName)) {
                try {
                    xmlWriter.writeAttribute(null, attrName, String.valueOf(result.getBoolean(columnName)));
                }
                catch (SQLException ex) {
                    String value = result.getString(columnName);
                    if (value == null) break block5;
                    try {
                        xmlWriter.writeAttribute(null, attrName, new Boolean(value).toString());
                    }
                    catch (NumberFormatException parseEx) {
                        this.log("Could not parse the value from result set column " + columnName + ":" + ex.getStackTrace(), 0);
                    }
                }
            }
        }
    }

    private Set getColumnsInResultSet(ResultSet resultSet) throws SQLException {
        ListOrderedSet result = new ListOrderedSet();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int idx = 1;
        while (idx <= metaData.getColumnCount()) {
            result.add((Object)metaData.getColumnName(idx).toUpperCase());
            ++idx;
        }
        return result;
    }

    private static interface ResultSetXmlOperation {
        public ResultSet getResultSet() throws SQLException;

        public void handleRow(PrettyPrintingXmlWriter var1, ResultSet var2) throws SQLException;

        public void handleError(SQLException var1);
    }
}

