/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import siena.QueryData;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryFilterSimple;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.SienaException;
import siena.Util;
import siena.core.options.QueryOption;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.embed.EmbeddedMap;

@EmbeddedMap
public class BaseQueryData<T>
implements QueryData<T> {
    private static final long serialVersionUID = -5112648712321740542L;
    protected Class<T> clazz;
    protected List<QueryFilter> filters;
    protected List<QueryOrder> orders;
    protected List<QueryFilterSearch> searches;
    protected List<QueryJoin> joins;
    protected Map<Integer, QueryOption> options = BaseQueryData.defaultOptions();

    public static Map<Integer, QueryOption> defaultOptions() {
        return new HashMap<Integer, QueryOption>(){
            private static final long serialVersionUID = -7438657296637379900L;
            {
                this.put(1, new QueryOptionPage(0));
                this.put(2, new QueryOptionOffset(0));
                this.put(3, new QueryOptionState());
                this.put(4, new QueryOptionFetchType().activate());
            }
        };
    }

    public BaseQueryData() {
        this.filters = new ArrayList<QueryFilter>();
        this.orders = new ArrayList<QueryOrder>();
        this.searches = new ArrayList<QueryFilterSearch>();
        this.joins = new ArrayList<QueryJoin>();
    }

    public BaseQueryData(Class<T> clazz) {
        this.clazz = clazz;
        this.filters = new ArrayList<QueryFilter>();
        this.orders = new ArrayList<QueryOrder>();
        this.searches = new ArrayList<QueryFilterSearch>();
        this.joins = new ArrayList<QueryJoin>();
    }

    public BaseQueryData(BaseQueryData<T> data) {
        this.clazz = data.clazz;
        this.filters = data.filters;
        this.orders = data.orders;
        this.searches = data.searches;
        this.joins = data.joins;
        for (Integer key : data.options.keySet()) {
            this.options.put(key, data.options.get(key));
        }
    }

    @Override
    public Class<T> getQueriedClass() {
        return this.clazz;
    }

    @Override
    public List<QueryFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<QueryOrder> getOrders() {
        return this.orders;
    }

    @Override
    public List<QueryFilterSearch> getSearches() {
        return this.searches;
    }

    @Override
    public List<QueryJoin> getJoins() {
        return this.joins;
    }

    @Override
    public QueryOption option(int option) {
        return this.options.get(option);
    }

    @Override
    public Map<Integer, QueryOption> options() {
        return this.options;
    }

    protected void addFilter(String fieldName, Object value, String[] supportedOperators) {
        String op = "=";
        String[] stringArray = supportedOperators;
        int n = supportedOperators.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (fieldName.endsWith(s)) {
                op = s;
                fieldName = fieldName.substring(0, fieldName.length() - op.length());
                break;
            }
            ++n2;
        }
        fieldName = fieldName.trim();
        try {
            Field field = Util.getField(this.clazz, fieldName);
            this.filters.add(new QueryFilterSimple(field, op, value));
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected void addOrder(String fieldName) {
        boolean ascending = true;
        if (fieldName.startsWith("-")) {
            fieldName = fieldName.substring(1);
            ascending = false;
        }
        try {
            Field field = Util.getField(this.clazz, fieldName);
            this.orders.add(new QueryOrder(field, ascending));
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected void addSearch(String match, String ... fields) {
        QueryFilterSearch q = new QueryFilterSearch(match, fields);
        this.filters.add(q);
        this.searches.add(q);
    }

    protected void addSearch(String match, QueryOption opt, String ... fields) {
        QueryFilterSearch q = new QueryFilterSearch(match, opt, fields);
        this.filters.add(q);
        this.searches.add(q);
    }

    protected void addJoin(String fieldName, String ... sortFields) {
        try {
            Field field = Util.getField(this.clazz, fieldName);
            this.joins.add(new QueryJoin(field, sortFields));
            String[] stringArray = sortFields;
            int n = sortFields.length;
            int n2 = 0;
            while (n2 < n) {
                String sortFieldName = stringArray[n2];
                boolean ascending = true;
                if (sortFieldName.startsWith("-")) {
                    sortFieldName = sortFieldName.substring(1);
                    ascending = false;
                }
                try {
                    Field sortField = field.getType().getField(sortFieldName);
                    this.orders.add(new QueryOrder(sortField, ascending, field));
                }
                catch (NoSuchFieldException ex) {
                    throw new SienaException("Join not possible: join sort field " + sortFieldName + " is not a known field of " + fieldName, ex);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected void optionPaginate(int pageSize) {
        QueryOptionPage opt = (QueryOptionPage)this.options.get(1);
        QueryOptionOffset offOpt = (QueryOptionOffset)this.options.get(2);
        opt.activate();
        opt.pageSize = pageSize;
        opt.pageType = QueryOptionPage.PageType.PAGINATING;
        offOpt.offsetType = QueryOptionOffset.OffsetType.PAGINATING;
    }

    protected void optionLimit(int limit) {
        QueryOptionPage pagOpt = (QueryOptionPage)this.options.get(1);
        pagOpt.activate();
        pagOpt.pageSize = limit;
        pagOpt.pageType = QueryOptionPage.PageType.MANUAL;
    }

    protected void optionOffset(int offset) {
        QueryOptionPage pagOpt = (QueryOptionPage)this.options.get(1);
        QueryOptionOffset offOpt = (QueryOptionOffset)this.options.get(2);
        offOpt.activate();
        offOpt.offsetType = QueryOptionOffset.OffsetType.MANUAL;
        offOpt.offset = offset;
        pagOpt.pageType = QueryOptionPage.PageType.MANUAL;
    }

    protected void optionStateful() {
        QueryOptionState opt = (QueryOptionState)this.options.get(3).activate();
        opt.lifeCycle = QueryOptionState.LifeCycle.STATEFUL;
    }

    protected void optionStateless() {
        QueryOptionState opt = (QueryOptionState)this.options.get(3).activate();
        opt.lifeCycle = QueryOptionState.LifeCycle.STATELESS;
    }

    protected void addOptions(QueryOption ... options) {
        QueryOption[] queryOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            QueryOption option = queryOptionArray[n2];
            this.options.put(option.type, option);
            ++n2;
        }
    }

    protected void reset() {
        this.options.clear();
        this.filters.clear();
        this.orders.clear();
        this.searches.clear();
        this.joins.clear();
        this.options = BaseQueryData.defaultOptions();
    }

    protected void resetOptions() {
        this.options = BaseQueryData.defaultOptions();
    }
}

