/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import siena.ClassInfo;
import siena.Filter;
import siena.PersistenceManager;
import siena.PersistenceManagerFactory;
import siena.Query;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.SienaException;
import siena.Util;
import siena.core.InheritFilter;
import siena.core.async.ModelAsync;
import siena.core.async.QueryAsync;
import siena.core.batch.Batch;
import siena.core.options.QueryOption;

public abstract class Model {
    private transient PersistenceManager persistenceManager;

    public Model() {
        this.init();
    }

    public void get() {
        this.getPersistenceManager().get((Object)this);
    }

    public void delete() {
        this.getPersistenceManager().delete((Object)this);
    }

    public void insert() {
        this.getPersistenceManager().insert((Object)this);
    }

    public void update() {
        this.getPersistenceManager().update((Object)this);
    }

    public void save() {
        this.getPersistenceManager().save((Object)this);
    }

    public final PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = PersistenceManagerFactory.getPersistenceManager(this.getClass());
        }
        return this.persistenceManager;
    }

    public static <R> Query<R> all(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createQuery(clazz);
    }

    public static <R> Batch<R> batch(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createBatch(clazz);
    }

    public static <R> R getByKey(Class<R> clazz, Object key) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).getByKey(clazz, key);
    }

    public ModelAsync async() {
        return new ModelAsync(this);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        List<Field> keys = ClassInfo.getClassInfo(this.getClass()).keys;
        for (Field field : keys) {
            field.setAccessible(true);
            try {
                Object a = field.get(this);
                Object b = field.get(that);
                if (!(a == null ? b != null : !a.equals(b))) continue;
                return false;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        List<Field> keys = ClassInfo.getClassInfo(this.getClass()).keys;
        for (Field field : keys) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                result = 31 * result + (value == null ? 0 : value.hashCode());
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return result;
    }

    private void init() {
        int n;
        int n2;
        Object[] objectArray;
        Class clazz = this.getClass();
        ArrayList<Class> classH = new ArrayList<Class>();
        Class cl = clazz;
        HashSet<Object> removedFields = new HashSet<Object>();
        while (cl != null) {
            classH.add(0, cl);
            InheritFilter iFilter = cl.getAnnotation(InheritFilter.class);
            if (iFilter != null) {
                String[] efs = iFilter.removedFields();
                objectArray = efs;
                n2 = efs.length;
                n = 0;
                while (n < n2) {
                    Object ef = objectArray[n];
                    removedFields.add(ef);
                    ++n;
                }
            }
            cl = cl.getSuperclass();
        }
        for (Class c : classH) {
            objectArray = c.getDeclaredFields();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object field = objectArray[n];
                if (((Field)field).getType() == Query.class && !removedFields.contains(((Field)field).getName())) {
                    Filter filter = ((Field)field).getAnnotation(Filter.class);
                    if (filter == null) {
                        throw new SienaException("Found Query<T> field without @Filter annotation at " + c.getName() + "." + ((Field)field).getName());
                    }
                    ParameterizedType pt = (ParameterizedType)((Field)field).getGenericType();
                    cl = (Class)pt.getActualTypeArguments()[0];
                    try {
                        Util.setField(this, (Field)field, new ProxyQuery(cl, filter.value(), this));
                    }
                    catch (Exception e) {
                        throw new SienaException(e);
                    }
                }
                ++n;
            }
        }
    }

    class ProxyQuery<T>
    implements Query<T> {
        private static final long serialVersionUID = -7726081283511624780L;
        private String filter;
        private Class<T> clazz;
        private Model obj;

        public ProxyQuery(Class<T> clazz, String filter, Model obj) {
            this.filter = filter;
            this.clazz = clazz;
            this.obj = obj;
        }

        private Query<T> createQuery() {
            return this.getPersistenceManager().createQuery(this.clazz).filter(this.filter, this.obj);
        }

        @Override
        public int count() {
            return this.createQuery().count();
        }

        @Override
        @Deprecated
        public int count(int limit) {
            return this.createQuery().count(limit);
        }

        @Override
        @Deprecated
        public int count(int limit, Object offset) {
            return this.createQuery().count(limit, offset);
        }

        @Override
        public List<T> fetch() {
            return this.createQuery().fetch();
        }

        @Override
        public List<T> fetch(int limit) {
            return this.createQuery().fetch(limit);
        }

        @Override
        public List<T> fetch(int limit, Object offset) {
            return this.createQuery().fetch(limit, offset);
        }

        @Override
        public Query<T> filter(String fieldName, Object value) {
            return this.createQuery().filter(fieldName, value);
        }

        @Override
        public Query<T> order(String fieldName) {
            return this.createQuery().order(fieldName);
        }

        @Override
        @Deprecated
        public Query<T> search(String match, boolean inBooleanMode, String index) {
            return this.createQuery().search(match, inBooleanMode, index);
        }

        @Override
        public Query<T> join(String field, String ... sortFields) {
            return this.createQuery().join(field, sortFields);
        }

        @Override
        public T get() {
            return this.createQuery().get();
        }

        @Override
        public Iterable<T> iter() {
            return this.createQuery().iter();
        }

        @Override
        public Iterable<T> iter(int limit) {
            return this.createQuery().iter(limit);
        }

        @Override
        public Iterable<T> iter(int limit, Object offset) {
            return this.createQuery().iter(limit, offset);
        }

        @Override
        public Iterable<T> iterPerPage(int limit) {
            return this.createQuery().iterPerPage(limit);
        }

        @Override
        public ProxyQuery<T> clone() {
            return new ProxyQuery<T>(this.clazz, this.filter, this.obj);
        }

        @Override
        @Deprecated
        public Object nextOffset() {
            return this.createQuery().nextOffset();
        }

        @Override
        public int delete() {
            return this.createQuery().delete();
        }

        @Override
        public List<T> fetchKeys() {
            return this.createQuery().fetchKeys();
        }

        @Override
        public List<T> fetchKeys(int limit) {
            return this.createQuery().fetchKeys(limit);
        }

        @Override
        public List<T> fetchKeys(int limit, Object offset) {
            return this.createQuery().fetchKeys(limit, offset);
        }

        @Override
        public List<QueryFilter> getFilters() {
            return this.createQuery().getFilters();
        }

        @Override
        public List<QueryOrder> getOrders() {
            return this.createQuery().getOrders();
        }

        @Override
        public List<QueryFilterSearch> getSearches() {
            return this.createQuery().getSearches();
        }

        @Override
        public List<QueryJoin> getJoins() {
            return this.createQuery().getJoins();
        }

        @Override
        @Deprecated
        public void setNextOffset(Object nextOffset) {
            this.createQuery().setNextOffset(nextOffset);
        }

        @Override
        public Class<T> getQueriedClass() {
            return this.clazz;
        }

        @Override
        public Query<T> paginate(int limit) {
            return this.createQuery().paginate(limit);
        }

        @Override
        public Query<T> limit(int limit) {
            return this.createQuery().limit(limit);
        }

        @Override
        public Query<T> offset(Object offset) {
            return this.createQuery().offset(offset);
        }

        @Override
        public Query<T> customize(QueryOption ... options) {
            return this.createQuery().customize(options);
        }

        @Override
        public QueryOption option(int option) {
            return this.createQuery().option(option);
        }

        @Override
        public Map<Integer, QueryOption> options() {
            return this.createQuery().options();
        }

        @Override
        public Query<T> stateful() {
            return this.createQuery().stateful();
        }

        @Override
        public Query<T> stateless() {
            return this.createQuery().stateless();
        }

        @Override
        public Query<T> release() {
            return this.createQuery().release();
        }

        @Override
        public Query<T> resetData() {
            return this.createQuery().resetData();
        }

        @Override
        public Query<T> search(String match, String ... fields) {
            return this.createQuery().search(match, fields);
        }

        @Override
        public Query<T> search(String match, QueryOption opt, String ... fields) {
            return this.createQuery().search(match, opt, fields);
        }

        @Override
        public int update(Map<String, ?> fieldValues) {
            return this.createQuery().update(fieldValues);
        }

        @Override
        public Query<T> nextPage() {
            return this.createQuery().nextPage();
        }

        @Override
        public Query<T> previousPage() {
            return this.createQuery().previousPage();
        }

        public String dump() {
            return this.createQuery().dump(new QueryOption[0]);
        }

        public Query<T> restore(String dump) {
            return this.createQuery().restore(dump, new QueryOption[0]);
        }

        @Override
        public QueryAsync<T> async() {
            return this.createQuery().async();
        }

        @Override
        public T getByKey(Object key) {
            return this.createQuery().getByKey(key);
        }

        @Override
        public PersistenceManager getPersistenceManager() {
            return this.obj.getPersistenceManager();
        }

        @Override
        public String dump(QueryOption ... options) {
            return this.createQuery().dump(options);
        }

        @Override
        public void dump(OutputStream os, QueryOption ... options) {
            this.createQuery().dump(os, options);
        }

        @Override
        public Query<T> restore(String dump, QueryOption ... options) {
            return this.createQuery().restore(dump, options);
        }

        @Override
        public Query<T> restore(InputStream dump, QueryOption ... options) {
            return this.createQuery().restore(dump, options);
        }
    }
}

