/*
 * Decompiled with CFR 0.152.
 */
package siena.core;

import java.util.Iterator;
import siena.Query;

public class SienaIterablePerPage<T>
implements Iterable<T> {
    private Query<T> query;
    private int pageSize;
    Iterable<T> iterable;

    public SienaIterablePerPage(Query<T> query, int pageSize) {
        this.query = query;
        this.pageSize = pageSize;
        this.iterable = query.paginate(this.pageSize).iter();
    }

    @Override
    public Iterator<T> iterator() {
        return new SienaIteratorPerPage(this.iterable.iterator());
    }

    protected void finalize() throws Throwable {
        this.query.release();
        super.finalize();
    }

    public class SienaIteratorPerPage
    implements Iterator<T> {
        private Iterator<T> iterator;
        private boolean hasNext = false;

        SienaIteratorPerPage(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                this.hasNext = true;
            } else {
                SienaIterablePerPage.this.iterable = SienaIterablePerPage.this.query.nextPage().iter();
                this.iterator = SienaIterablePerPage.this.iterable.iterator();
                this.hasNext = this.iterator.hasNext();
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (this.hasNext || this.iterator.hasNext()) {
                return this.iterator.next();
            }
            SienaIterablePerPage.this.iterable = SienaIterablePerPage.this.query.nextPage().iter();
            this.iterator = SienaIterablePerPage.this.iterable.iterator();
            return this.iterator.next();
        }

        @Override
        public void remove() {
        }

        protected void finalize() throws Throwable {
            SienaIterablePerPage.this.query.release();
            super.finalize();
        }
    }
}

