/*
 * Decompiled with CFR 0.152.
 */
package siena.core.async;

import java.util.List;
import java.util.Map;
import siena.Model;
import siena.PersistenceManagerFactory;
import siena.Query;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.core.async.PersistenceManagerAsync;
import siena.core.async.QueryAsync;
import siena.core.async.SienaFuture;
import siena.core.batch.BatchAsync;
import siena.core.options.QueryOption;

public class ModelAsync {
    private transient PersistenceManagerAsync persistenceManagerAsync;
    private transient Model model;

    public ModelAsync(Model model) {
        this.model = model;
        this.persistenceManagerAsync = model.getPersistenceManager().async();
    }

    public SienaFuture<Void> get() {
        return this.getPersistenceManager().get((Object)this.model);
    }

    public SienaFuture<Void> delete() {
        return this.getPersistenceManager().delete((Object)this.model);
    }

    public SienaFuture<Void> insert() {
        return this.getPersistenceManager().insert((Object)this.model);
    }

    public SienaFuture<Void> update() {
        return this.getPersistenceManager().update((Object)this.model);
    }

    public final PersistenceManagerAsync getPersistenceManager() {
        if (this.persistenceManagerAsync == null) {
            this.persistenceManagerAsync = PersistenceManagerFactory.getPersistenceManager(this.model.getClass()).async();
        }
        return this.persistenceManagerAsync;
    }

    public static <R> QueryAsync<R> all(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createQuery(clazz).async();
    }

    public static <R> BatchAsync<R> batch(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createBatch(clazz).async();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        ModelAsync masync = (ModelAsync)that;
        return this.model.equals(masync.model);
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    class ProxyQueryAsync<T>
    implements QueryAsync<T> {
        private String filter;
        private Class<T> clazz;
        private ModelAsync obj;

        public ProxyQueryAsync(Class<T> clazz, String filter, ModelAsync obj) {
            this.filter = filter;
            this.clazz = clazz;
            this.obj = obj;
        }

        private QueryAsync<T> createQuery() {
            return this.getPersistenceManager().createQuery(this.clazz).filter(this.filter, this.obj);
        }

        @Override
        public QueryAsync<T> filter(String fieldName, Object value) {
            return this.createQuery().filter(fieldName, value);
        }

        @Override
        public QueryAsync<T> order(String fieldName) {
            return this.createQuery().order(fieldName);
        }

        @Override
        public QueryAsync<T> join(String field, String ... sortFields) {
            return this.createQuery().join(field, sortFields);
        }

        @Override
        public QueryAsync<T> search(String match, String ... fields) {
            return this.createQuery().search(match, fields);
        }

        @Override
        public QueryAsync<T> search(String match, QueryOption opt, String ... fields) {
            return this.createQuery().search(match, opt, fields);
        }

        @Override
        public SienaFuture<T> get() {
            return this.createQuery().get();
        }

        @Override
        public SienaFuture<T> getByKey(Object key) {
            return this.createQuery().getByKey(key);
        }

        @Override
        public SienaFuture<Integer> delete() {
            return this.createQuery().delete();
        }

        @Override
        public SienaFuture<Integer> update(Map<String, ?> fieldValues) {
            return this.createQuery().update(fieldValues);
        }

        @Override
        public SienaFuture<Integer> count() {
            return this.createQuery().count();
        }

        @Override
        public SienaFuture<List<T>> fetch() {
            return this.createQuery().fetch();
        }

        @Override
        public SienaFuture<List<T>> fetch(int limit) {
            return this.createQuery().fetch();
        }

        @Override
        public SienaFuture<List<T>> fetch(int limit, Object offset) {
            return this.createQuery().fetch(limit, offset);
        }

        @Override
        public SienaFuture<List<T>> fetchKeys() {
            return this.createQuery().fetchKeys();
        }

        @Override
        public SienaFuture<List<T>> fetchKeys(int limit) {
            return this.createQuery().fetchKeys(limit);
        }

        @Override
        public SienaFuture<List<T>> fetchKeys(int limit, Object offset) {
            return this.createQuery().fetchKeys(limit, offset);
        }

        @Override
        public SienaFuture<Iterable<T>> iter() {
            return this.createQuery().iter();
        }

        @Override
        public SienaFuture<Iterable<T>> iter(int limit) {
            return this.createQuery().iter(limit);
        }

        @Override
        public SienaFuture<Iterable<T>> iter(int limit, Object offset) {
            return this.createQuery().iter(limit, offset);
        }

        @Override
        public SienaFuture<Iterable<T>> iterPerPage(int limit) {
            return this.createQuery().iterPerPage(limit);
        }

        @Override
        public Class<T> getQueriedClass() {
            return this.clazz;
        }

        @Override
        public SienaFuture<Object> raw(String request) {
            return this.createQuery().raw(request);
        }

        @Override
        public QueryAsync<T> paginate(int size) {
            return this.createQuery().paginate(size);
        }

        @Override
        public QueryAsync<T> nextPage() {
            return this.createQuery().nextPage();
        }

        @Override
        public QueryAsync<T> previousPage() {
            return this.createQuery().previousPage();
        }

        @Override
        public QueryAsync<T> customize(QueryOption ... options) {
            return this.createQuery().customize(options);
        }

        @Override
        public QueryOption option(int option) {
            return this.createQuery().option(option);
        }

        @Override
        public Map<Integer, QueryOption> options() {
            return this.createQuery().options();
        }

        @Override
        public QueryAsync<T> stateful() {
            return this.createQuery().stateful();
        }

        @Override
        public QueryAsync<T> stateless() {
            return this.createQuery().stateless();
        }

        @Override
        public QueryAsync<T> release() {
            return this.createQuery().release();
        }

        @Override
        public QueryAsync<T> resetData() {
            return this.createQuery().resetData();
        }

        @Override
        public String dump() {
            return this.createQuery().dump();
        }

        @Override
        public QueryAsync<T> restore(String dump) {
            return this.createQuery().restore(dump);
        }

        @Override
        public Query<T> sync() {
            return this.createQuery().sync();
        }

        @Override
        public List<QueryFilter> getFilters() {
            return this.createQuery().getFilters();
        }

        @Override
        public List<QueryOrder> getOrders() {
            return this.createQuery().getOrders();
        }

        @Override
        public List<QueryFilterSearch> getSearches() {
            return this.createQuery().getSearches();
        }

        @Override
        public List<QueryJoin> getJoins() {
            return this.createQuery().getJoins();
        }

        @Override
        public QueryAsync<T> clone() {
            return this.createQuery().clone();
        }

        @Override
        public PersistenceManagerAsync getPersistenceManager() {
            return this.obj.getPersistenceManager();
        }

        @Override
        public QueryAsync<T> limit(int limit) {
            return this.createQuery().limit(limit);
        }

        @Override
        public QueryAsync<T> offset(Object offset) {
            return this.createQuery().offset(offset);
        }
    }
}

