/*
 * Decompiled with CFR 0.152.
 */
package siena.embed;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import siena.Json;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.embed.At;
import siena.embed.EmbedIgnore;
import siena.embed.EmbeddedList;
import siena.embed.EmbeddedMap;
import siena.embed.Format;
import siena.embed.JsonDeserializeAs;
import siena.embed.JsonDumpable;
import siena.embed.JsonRestorable;
import siena.embed.Key;

public class JsonSerializer {
    public static Json serialize(Object obj) {
        return JsonSerializer.serialize(obj, null);
    }

    public static Json serialize(Object obj, Field f) {
        Format format;
        if (obj == null) {
            return new Json(null);
        }
        Class<?> clazz = obj.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)obj;
            Json result = Json.map();
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey().toString();
                Json value = JsonSerializer.serialize(entry.getValue(), null);
                result.put(key, value);
            }
            return result;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Json result = Json.list(new Object[0]);
            Collection col = (Collection)obj;
            for (Object object : col) {
                result.add(JsonSerializer.serialize(object));
            }
            return result;
        }
        if (Json.class.isAssignableFrom(clazz)) {
            return new Json(obj);
        }
        if (Field.class.isAssignableFrom(clazz)) {
            return new Json(obj);
        }
        if (clazz.isArray()) {
            return new Json(obj);
        }
        if (clazz == Class.class) {
            return new Json(obj);
        }
        if (JsonDumpable.class.isAssignableFrom(obj.getClass())) {
            return ((JsonDumpable)obj).dump();
        }
        try {
            EmbeddedList list = obj.getClass().getAnnotation(EmbeddedList.class);
            if (list != null) {
                return JsonSerializer.serializeList(obj);
            }
            EmbeddedMap map = obj.getClass().getAnnotation(EmbeddedMap.class);
            if (map != null) {
                return JsonSerializer.serializeMap(obj);
            }
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        if (f != null && (format = f.getAnnotation(Format.class)) != null && obj.getClass() == Date.class) {
            Date date = (Date)obj;
            SimpleDateFormat sdf = new SimpleDateFormat(format.value());
            return new Json(sdf.format(date));
        }
        return new Json(obj);
    }

    public static Json serializeMap(Object obj) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        Json result = Json.map();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!JsonSerializer.mustIgnore(f)) {
                Key k = f.getAnnotation(Key.class);
                if (k != null) {
                    result.put(k.value(), JsonSerializer.serialize(f.get(obj), f));
                } else {
                    result.put(f.getName(), JsonSerializer.serialize(f.get(obj), f));
                }
            }
            ++n2;
        }
        Class<?> clazz = obj.getClass().getSuperclass();
        while (clazz != null) {
            Field[] fieldArray2 = fields = clazz.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field f = fieldArray2[n];
                if (!JsonSerializer.mustIgnore(f)) {
                    Key k = f.getAnnotation(Key.class);
                    if (k != null) {
                        result.put(k.value(), JsonSerializer.serialize(Util.readField(obj, f), f));
                    } else {
                        result.put(f.getName(), JsonSerializer.serialize(Util.readField(obj, f), f));
                    }
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Json serializeList(Object obj) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        Json result = Json.list(new Object[0]);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!JsonSerializer.mustIgnore(f)) {
                At at = f.getAnnotation(At.class);
                if (at == null) {
                    throw new SienaException("Field " + obj.getClass() + "." + f.getName() + " must be annotated with @At(n)");
                }
                result.addAt(at.value(), JsonSerializer.serialize(f.get(obj), f));
            }
            ++n2;
        }
        Class<?> clazz = obj.getClass().getSuperclass();
        while (clazz != null) {
            Field[] fieldArray2 = fields = clazz.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field f = fieldArray2[n];
                if (!JsonSerializer.mustIgnore(f)) {
                    At at = f.getAnnotation(At.class);
                    if (at == null) {
                        throw new SienaException("Field " + obj.getClass() + "." + f.getName() + " must be annotated with @At(n)");
                    }
                    result.addAt(at.value(), JsonSerializer.serialize(f.get(obj), f));
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private static Class<?> getGenericClass(Field f, int n) {
        Type genericFieldType = f.getGenericType();
        if (genericFieldType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            return (Class)fieldArgTypes[n];
        }
        return null;
    }

    public static Object deserializeMap(Class<?> clazz, Json data) {
        Field[] fields;
        if (!data.isMap()) {
            throw new SienaException("Error while deserializating class " + clazz + ". A Json map is needed but found: " + data);
        }
        Object obj = Util.createObjectInstance(clazz);
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!JsonSerializer.mustIgnore(f)) {
                Key key = f.getAnnotation(Key.class);
                if (key != null) {
                    Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(key.value())));
                } else {
                    Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(f.getName())));
                }
            }
            ++n2;
        }
        Class<?> superclazz = obj.getClass().getSuperclass();
        while (superclazz != null) {
            Field[] fieldArray2 = fields = superclazz.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field f = fieldArray2[n];
                if (!JsonSerializer.mustIgnore(f)) {
                    Key key = f.getAnnotation(Key.class);
                    if (key != null) {
                        Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(key.value())));
                    } else {
                        Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(f.getName())));
                    }
                }
                ++n;
            }
            superclazz = superclazz.getSuperclass();
        }
        return obj;
    }

    public static Object deserialize(Class<?> clazz, Json data) {
        try {
            EmbeddedMap map = clazz.getAnnotation(EmbeddedMap.class);
            if (map != null) {
                Field[] fields;
                if (!data.isMap()) {
                    throw new SienaException("Error while deserializating class " + clazz + ". A Json map is needed but found: " + data);
                }
                Object obj = Util.createObjectInstance(clazz);
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (!JsonSerializer.mustIgnore(f)) {
                        Key key = f.getAnnotation(Key.class);
                        if (key != null) {
                            Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(key.value())));
                        } else {
                            Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(f.getName())));
                        }
                    }
                    ++n2;
                }
                Class<?> superclazz = obj.getClass().getSuperclass();
                while (superclazz != null) {
                    Field[] fieldArray2 = fields = superclazz.getDeclaredFields();
                    int n3 = fields.length;
                    n = 0;
                    while (n < n3) {
                        Field f = fieldArray2[n];
                        if (!JsonSerializer.mustIgnore(f)) {
                            Key key = f.getAnnotation(Key.class);
                            if (key != null) {
                                Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(key.value())));
                            } else {
                                Util.setField(obj, f, JsonSerializer.deserialize(f, data.get(f.getName())));
                            }
                        }
                        ++n;
                    }
                    superclazz = superclazz.getSuperclass();
                }
                return obj;
            }
            EmbeddedList list = clazz.getAnnotation(EmbeddedList.class);
            if (list != null) {
                Field[] fields;
                if (!data.isList()) {
                    throw new SienaException("Error while deserializating class " + clazz + ". A Json list is needed but found: " + data);
                }
                Object obj = Util.createObjectInstance(clazz);
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n4 = 0;
                while (n4 < n) {
                    Field f = fieldArray[n4];
                    if (!JsonSerializer.mustIgnore(f)) {
                        At at = f.getAnnotation(At.class);
                        if (at == null) {
                            throw new SienaException("Field " + obj.getClass() + "." + f.getName() + " must be annotated with @At(n)");
                        }
                        Json value = data.at(at.value());
                        Util.setField(obj, f, JsonSerializer.deserialize(f, value));
                    }
                    ++n4;
                }
                Class<?> superclazz = obj.getClass().getSuperclass();
                while (superclazz != null) {
                    Field[] fieldArray3 = fields = superclazz.getDeclaredFields();
                    int n5 = fields.length;
                    n = 0;
                    while (n < n5) {
                        Field f = fieldArray3[n];
                        if (!JsonSerializer.mustIgnore(f)) {
                            At at = f.getAnnotation(At.class);
                            if (at == null) {
                                throw new SienaException("Field " + obj.getClass() + "." + f.getName() + " must be annotated with @At(n)");
                            }
                            Json value = data.at(at.value());
                            Util.setField(obj, f, JsonSerializer.deserialize(f, value));
                        }
                        ++n;
                    }
                    superclazz = superclazz.getSuperclass();
                }
                return obj;
            }
            if (Json.class.isAssignableFrom(clazz)) {
                return data;
            }
            JsonDeserializeAs as = clazz.getAnnotation(JsonDeserializeAs.class);
            if (as != null) {
                if (as.value() == String.class) {
                    return data.asString();
                }
                Class<?> asClazz = as.value();
                Object ret = JsonSerializer.deserialize(as.value(), data);
                if (JsonRestorable.class.isAssignableFrom(asClazz)) {
                    return ((JsonRestorable)ret).restore();
                }
                return ret;
            }
            return JsonSerializer.deserializePlain(clazz, data);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private static boolean mustIgnore(Field field) {
        boolean b;
        if (Query.class.isAssignableFrom(field.getType())) {
            return true;
        }
        if (field.isAnnotationPresent(EmbedIgnore.class)) {
            return true;
        }
        boolean bl = b = (field.getModifiers() & 0x80) == 128 || (field.getModifiers() & 8) == 8 || field.isSynthetic();
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return b;
    }

    public static Object deserialize(Field f, Json data) {
        if (data == null || data.isNull()) {
            return JsonSerializer.deserializePlain(f.getType(), data);
        }
        Class<?> clazz = f.getType();
        if (Map.class.isAssignableFrom(clazz)) {
            if (!data.isMap()) {
                throw new SienaException("Error while deserializating field " + f.getDeclaringClass() + "." + f.getName() + " of type " + clazz + ". A Json map is needed but found: " + data);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : data.keys()) {
                map.put(key, JsonSerializer.deserialize(JsonSerializer.getGenericClass(f, 1), data.get(key)));
            }
            return map;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (!data.isList()) {
                throw new SienaException("Error while deserializating field " + f.getDeclaringClass() + "." + f.getName() + " of type " + clazz + ". A Json list is needed but found: " + data);
            }
            AbstractCollection collection = null;
            collection = clazz == List.class ? new ArrayList(data.size()) : new HashSet();
            for (Json value : data) {
                collection.add(JsonSerializer.deserialize(JsonSerializer.getGenericClass(f, 0), value));
            }
            return collection;
        }
        if (Json.class.isAssignableFrom(clazz)) {
            return data;
        }
        if (Field.class.isAssignableFrom(clazz)) {
            String fieldName = data.get("fieldName").asString();
            String parentClass = data.get("parentClass").asString();
            try {
                Class<?> cl = Class.forName(parentClass);
                Field fi = cl.getField(fieldName);
                return fi;
            }
            catch (ClassNotFoundException ex) {
                throw new SienaException(ex);
            }
            catch (NoSuchFieldException ex) {
                throw new SienaException(ex);
            }
        }
        if (clazz.isArray()) {
            Class<?> arrClazz = clazz.getComponentType();
            Object arr = Array.newInstance(arrClazz, data.size());
            int i = 0;
            for (Json value : data) {
                Array.set(arr, i++, JsonSerializer.deserialize(arrClazz, value));
            }
            return arr;
        }
        if (clazz == Class.class) {
            String className = data.get("className").asString();
            try {
                Class<?> cl = Class.forName(className);
                return cl;
            }
            catch (ClassNotFoundException ex) {
                throw new SienaException(ex);
            }
        }
        Format format = f.getAnnotation(Format.class);
        if (format != null && f.getType() == Date.class) {
            SimpleDateFormat sdf = new SimpleDateFormat(format.value());
            try {
                return sdf.parse(data.str());
            }
            catch (ParseException e) {
                throw new SienaException(e);
            }
        }
        JsonDeserializeAs as = f.getAnnotation(JsonDeserializeAs.class);
        if (as != null) {
            if (as.value() == String.class) {
                return data.asString();
            }
            return JsonSerializer.deserialize(as.value(), data);
        }
        return JsonSerializer.deserialize(clazz, data);
    }

    private static Object deserializePlain(Class<?> type, Json data) {
        if (Boolean.class == type || Boolean.TYPE == type) {
            return data != null ? (Comparable<Boolean>)Boolean.valueOf(data.asBoolean()) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return data != null ? (Comparable<Boolean>)Boolean.valueOf(data.asBoolean()) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        if (type == Short.class || type == Short.TYPE) {
            return data != null ? data.asShort() : (short)0;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return data != null ? data.asInt() : 0;
        }
        if (type == Long.class || type == Long.TYPE) {
            return data != null ? data.asLong() : 0L;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(data != null ? data.asFloat() : 0.0f);
        }
        if (type == Double.class || type == Double.TYPE) {
            return data != null ? data.asDouble() : 0.0;
        }
        if (type == String.class) {
            return data != null ? data.str() : null;
        }
        if (type.isEnum()) {
            String str;
            if (data != null && (str = data.str()) != null) {
                return Enum.valueOf(type, data.str());
            }
            return null;
        }
        if (type == Date.class) {
            return data != null ? data.asDate() : null;
        }
        return null;
    }
}

