/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Text;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import siena.ClassInfo;
import siena.Id;
import siena.Json;
import siena.SienaException;
import siena.SienaRestrictedApiException;
import siena.Util;
import siena.core.DecimalPrecision;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.gae.Unindexed;

public class GaeMappingUtils {
    public static Entity createEntityInstance(Field idField, ClassInfo info, Object obj) {
        Entity entity;
        block10: {
            block9: {
                entity = null;
                Id id = idField.getAnnotation(Id.class);
                Class<?> type = idField.getType();
                if (id == null) break block9;
                switch (id.value()) {
                    case NONE: {
                        Object idVal = null;
                        idVal = Util.readField(obj, idField);
                        if (idVal == null) {
                            throw new SienaException("Id Field " + idField.getName() + " value null");
                        }
                        String keyVal = Util.toString(idField, idVal);
                        entity = new Entity(info.tableName, keyVal);
                        break block10;
                    }
                    case AUTO_INCREMENT: {
                        if (Long.TYPE == type || Long.class.isAssignableFrom(type)) {
                            entity = new Entity(info.tableName);
                        } else {
                            Object idStringVal = null;
                            idStringVal = Util.readField(obj, idField);
                            if (idStringVal == null) {
                                throw new SienaException("Id Field " + idField.getName() + " value null");
                            }
                            String keyStringVal = Util.toString(idField, idStringVal);
                            entity = new Entity(info.tableName, keyStringVal);
                        }
                        break block10;
                    }
                    case UUID: {
                        entity = new Entity(info.tableName, UUID.randomUUID().toString());
                        break block10;
                    }
                    default: {
                        throw new SienaRestrictedApiException("DB", "createEntityInstance", "Id Generator " + (Object)((Object)id.value()) + " not supported");
                    }
                }
            }
            throw new SienaException("Field " + idField.getName() + " is not an @Id field");
        }
        return entity;
    }

    public static Entity createEntityInstanceForUpdate(Field idField, ClassInfo info, Object obj) {
        Key key = GaeMappingUtils.makeKey(idField, info, obj);
        Entity entity = new Entity(key);
        return entity;
    }

    public static void setIdFromKey(Field idField, Object obj, Key key) {
        block16: {
            block15: {
                Id id = idField.getAnnotation(Id.class);
                Class<?> type = idField.getType();
                if (id == null) break block15;
                switch (id.value()) {
                    case NONE: {
                        Object val = null;
                        if (Long.TYPE == type || Long.class.isAssignableFrom(type)) {
                            val = Long.parseLong(key.getName());
                        } else if (String.class.isAssignableFrom(type)) {
                            val = key.getName();
                        } else {
                            throw new SienaRestrictedApiException("DB", "setKey", "Id Type " + idField.getType() + " not supported");
                        }
                        Util.setField(obj, idField, val);
                        break block16;
                    }
                    case AUTO_INCREMENT: {
                        if (Long.TYPE == type || Long.class.isAssignableFrom(idField.getType())) {
                            Util.setField(obj, idField, key.getId());
                        } else {
                            idField.setAccessible(true);
                            Object val2 = null;
                            if (Long.TYPE == type || Long.class.isAssignableFrom(idField.getType())) {
                                Long val = Long.parseLong(key.getName());
                            } else if (String.class.isAssignableFrom(idField.getType())) {
                                String val = key.getName();
                            } else {
                                throw new SienaRestrictedApiException("DB", "setKey", "Id Type " + idField.getType() + " not supported");
                            }
                            Util.setField(obj, idField, val2);
                        }
                        break block16;
                    }
                    case UUID: {
                        Util.setField(obj, idField, key.getName());
                        break block16;
                    }
                    default: {
                        throw new SienaException("Id Generator " + (Object)((Object)id.value()) + " not supported");
                    }
                }
            }
            throw new SienaException("Field " + idField.getName() + " is not an @Id field");
        }
    }

    protected static Key getKey(Object obj) {
        Object value;
        Field idField;
        Class<?> clazz;
        block10: {
            clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            try {
                idField = info.getIdField();
                value = Util.readField(obj, idField);
                if (value != null) break block10;
                return null;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Class<?> type = idField.getType();
        if (idField.isAnnotationPresent(Id.class)) {
            Id id = idField.getAnnotation(Id.class);
            switch (id.value()) {
                case NONE: {
                    return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                }
                case AUTO_INCREMENT: {
                    if (Long.TYPE == type || Long.class.isAssignableFrom(type)) {
                        return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (long)((Long)value));
                    }
                    return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                }
                case UUID: {
                    return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                }
            }
            throw new SienaException("Id Generator " + (Object)((Object)id.value()) + " not supported");
        }
        throw new SienaException("Field " + idField.getName() + " is not an @Id field");
    }

    protected static Key getKeyFromParent(Object obj, Entity parentEntity) {
        Object value;
        Field idField;
        Class<?> clazz;
        block10: {
            clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            try {
                idField = info.getIdField();
                value = Util.readField(obj, idField);
                if (value != null) break block10;
                return null;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Class<?> type = idField.getType();
        if (idField.isAnnotationPresent(Id.class)) {
            Id id = idField.getAnnotation(Id.class);
            switch (id.value()) {
                case NONE: {
                    return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                }
                case AUTO_INCREMENT: {
                    if (Long.TYPE == type || Long.class.isAssignableFrom(type)) {
                        return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (long)((Long)value));
                    }
                    return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                }
                case UUID: {
                    return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                }
            }
            throw new SienaException("Id Generator " + (Object)((Object)id.value()) + " not supported");
        }
        throw new SienaException("Field " + idField.getName() + " is not an @Id field");
    }

    protected static Key makeKey(Class<?> clazz, Object value) {
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        try {
            Field idField = info.getIdField();
            if (idField.isAnnotationPresent(Id.class)) {
                Id id = idField.getAnnotation(Id.class);
                switch (id.value()) {
                    case NONE: {
                        return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                    }
                    case AUTO_INCREMENT: {
                        Class<?> type = idField.getType();
                        if (Long.TYPE == type || Long.class.isAssignableFrom(type)) {
                            return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (long)((Long)value));
                        }
                        return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                    }
                    case UUID: {
                        return KeyFactory.createKey((String)ClassInfo.getClassInfo(clazz).tableName, (String)value.toString());
                    }
                }
                throw new SienaException("Id Generator " + (Object)((Object)id.value()) + " not supported");
            }
            throw new SienaException("Field " + idField.getName() + " is not an @Id field");
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected static Key makeKey(Field field, ClassInfo info, Object object) {
        try {
            Field idField = info.getIdField();
            Object idVal = Util.readField(object, idField);
            if (idVal == null) {
                throw new SienaException("Id Field " + idField.getName() + " value null");
            }
            if (idField.isAnnotationPresent(Id.class)) {
                Id id = idField.getAnnotation(Id.class);
                switch (id.value()) {
                    case NONE: {
                        return KeyFactory.createKey((String)info.tableName, (String)idVal.toString());
                    }
                    case AUTO_INCREMENT: {
                        Class<?> type = idField.getType();
                        if (Long.TYPE == type || Long.class.isAssignableFrom(type)) {
                            return KeyFactory.createKey((String)info.tableName, (long)((Long)idVal));
                        }
                        return KeyFactory.createKey((String)info.tableName, (String)idVal.toString());
                    }
                    case UUID: {
                        return KeyFactory.createKey((String)info.tableName, (String)idVal.toString());
                    }
                }
                throw new SienaException("Id Generator " + (Object)((Object)id.value()) + " not supported");
            }
            throw new SienaException("Field " + idField.getName() + " is not an @Id field");
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static void fillEntity(Object obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            Unindexed ui;
            String property = ClassInfo.getColumnNames(field)[0];
            Object value = Util.readField(obj, field);
            Class<?> fieldClass = field.getType();
            if (ClassInfo.isModel(fieldClass) && !ClassInfo.isEmbedded(field)) {
                if (value == null) {
                    entity.setProperty(property, null);
                    continue;
                }
                Key key = GaeMappingUtils.getKey(value);
                entity.setProperty(property, (Object)key);
                continue;
            }
            if (value != null) {
                String s;
                if (fieldClass == Json.class) {
                    value = value.toString();
                } else if (value instanceof String) {
                    s = (String)value;
                    if (s.length() > 500) {
                        value = new Text(s);
                    }
                } else if (value instanceof byte[]) {
                    byte[] arr = (byte[])value;
                    value = arr.length < 1000000 ? new Blob(arr) : new Blob(Arrays.copyOf(arr, 1000000));
                } else if (field.getAnnotation(Embedded.class) != null) {
                    s = (String)(value = JsonSerializer.serialize(value).toString());
                    if (s.length() > 500) {
                        value = new Text(s);
                    }
                } else if (fieldClass == BigDecimal.class) {
                    DecimalPrecision ann = field.getAnnotation(DecimalPrecision.class);
                    if (ann == null) {
                        value = ((BigDecimal)value).toPlainString();
                    } else {
                        switch (ann.storateType()) {
                            case DOUBLE: {
                                value = ((BigDecimal)value).doubleValue();
                                break;
                            }
                            case NATIVE: 
                            case STRING: {
                                value = ((BigDecimal)value).toPlainString();
                            }
                        }
                    }
                } else if (Enum.class.isAssignableFrom(field.getType())) {
                    value = value.toString();
                }
            }
            if ((ui = field.getAnnotation(Unindexed.class)) == null) {
                entity.setProperty(property, value);
                continue;
            }
            entity.setUnindexedProperty(property, value);
        }
    }

    public static void fillModel(Object obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            String property = ClassInfo.getColumnNames(field)[0];
            try {
                Class<?> fieldClass = field.getType();
                if (ClassInfo.isModel(fieldClass) && !ClassInfo.isEmbedded(field)) {
                    Key key = (Key)entity.getProperty(property);
                    if (key == null) continue;
                    Object value = Util.createObjectInstance(fieldClass);
                    Field id = ClassInfo.getIdField(fieldClass);
                    GaeMappingUtils.setIdFromKey(id, value, key);
                    Util.setField(obj, field, value);
                    continue;
                }
                GaeMappingUtils.setFromObject(obj, field, entity.getProperty(property));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
    }

    public static void fillModelAndKey(Object obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field id = info.getIdField();
        Class<?> fieldClass = id.getType();
        Key key = entity.getKey();
        if (key != null) {
            GaeMappingUtils.setIdFromKey(id, obj, key);
        }
        for (Field field : info.updateFields) {
            String property = ClassInfo.getColumnNames(field)[0];
            try {
                fieldClass = field.getType();
                if (ClassInfo.isModel(fieldClass) && !ClassInfo.isEmbedded(field)) {
                    key = (Key)entity.getProperty(property);
                    if (key == null) continue;
                    Object value = Util.createObjectInstance(fieldClass);
                    id = ClassInfo.getIdField(fieldClass);
                    GaeMappingUtils.setIdFromKey(id, value, key);
                    Util.setField(obj, field, value);
                    continue;
                }
                GaeMappingUtils.setFromObject(obj, field, entity.getProperty(property));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
    }

    public static void setFromObject(Object object, Field f, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (value instanceof Text) {
            value = ((Text)value).getValue();
        } else if (value instanceof Blob && f.getType() == byte[].class) {
            value = ((Blob)value).getBytes();
        } else if (f.getType() == BigDecimal.class) {
            DecimalPrecision ann = f.getAnnotation(DecimalPrecision.class);
            if (ann == null) {
                value = new BigDecimal((String)value);
            } else {
                switch (ann.storateType()) {
                    case DOUBLE: {
                        value = BigDecimal.valueOf((Double)value);
                        break;
                    }
                    case NATIVE: 
                    case STRING: {
                        value = new BigDecimal((String)value);
                    }
                }
            }
        }
        Util.setFromObject(object, f, value);
    }

    public static <T> T mapEntityKeysOnly(Entity entity, Class<T> clazz) {
        T obj;
        Field id = ClassInfo.getIdField(clazz);
        try {
            obj = Util.createObjectInstance(clazz);
            GaeMappingUtils.setIdFromKey(id, obj, entity.getKey());
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return obj;
    }

    public static <T> List<T> mapEntitiesKeysOnly(List<Entity> entities, Class<T> clazz) {
        Field id = ClassInfo.getIdField(clazz);
        ArrayList<T> list = new ArrayList<T>(entities.size());
        for (Entity entity : entities) {
            try {
                T obj = Util.createObjectInstance(clazz);
                list.add(obj);
                GaeMappingUtils.setIdFromKey(id, obj, entity.getKey());
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return list;
    }

    public static <T> List<T> mapEntitiesKeysOnly(Iterable<Entity> entities, Class<T> clazz) {
        Field id = ClassInfo.getIdField(clazz);
        ArrayList<T> list = new ArrayList<T>();
        for (Entity entity : entities) {
            try {
                T obj = Util.createObjectInstance(clazz);
                list.add(obj);
                GaeMappingUtils.setIdFromKey(id, obj, entity.getKey());
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return list;
    }

    public static <T> T mapEntity(Entity entity, Class<T> clazz) {
        T obj;
        Field id = ClassInfo.getIdField(clazz);
        try {
            obj = Util.createObjectInstance(clazz);
            GaeMappingUtils.fillModel(obj, entity);
            GaeMappingUtils.setIdFromKey(id, obj, entity.getKey());
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return obj;
    }

    public static <T> List<T> mapEntities(List<Entity> entities, Class<T> clazz) {
        Field id = ClassInfo.getIdField(clazz);
        ArrayList<T> list = new ArrayList<T>(entities.size());
        for (Entity entity : entities) {
            try {
                T obj = Util.createObjectInstance(clazz);
                GaeMappingUtils.fillModel(obj, entity);
                list.add(obj);
                GaeMappingUtils.setIdFromKey(id, obj, entity.getKey());
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return list;
    }

    public static <T> List<T> mapEntities(Iterable<Entity> entities, Class<T> clazz) {
        Field id = ClassInfo.getIdField(clazz);
        ArrayList<T> list = new ArrayList<T>();
        for (Entity entity : entities) {
            try {
                T obj = Util.createObjectInstance(clazz);
                GaeMappingUtils.fillModel(obj, entity);
                list.add(obj);
                GaeMappingUtils.setIdFromKey(id, obj, entity.getKey());
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return list;
    }
}

