/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.Transaction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.commons.lang.NotImplementedException;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.SienaException;
import siena.Util;
import siena.core.async.AbstractPersistenceManagerAsync;
import siena.core.async.QueryAsync;
import siena.core.async.SienaFuture;
import siena.core.async.SienaFutureContainer;
import siena.core.async.SienaFutureMock;
import siena.core.async.SienaFutureWrapper;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.gae.GaeMappingUtils;
import siena.gae.GaePersistenceManager;
import siena.gae.GaeQueryUtils;
import siena.gae.GaeSienaFutureIterableMapper;
import siena.gae.GaeSienaFutureIterableMapperWithCursor;
import siena.gae.GaeSienaFutureListMapper;
import siena.gae.QueryOptionGaeContext;
import siena.gae.SienaIterableAsyncPerPageWrapper;

public class GaePersistenceManagerAsync
extends AbstractPersistenceManagerAsync {
    private AsyncDatastoreService ds;
    private PersistenceManager syncPm;
    private Properties props;
    public static final String DB = "GAE_ASYNC";
    private static String[] supportedOperators = GaeQueryUtils.operators.keySet().toArray(new String[0]);

    @Override
    public void init(Properties p) {
        this.ds = DatastoreServiceFactory.getAsyncDatastoreService();
        this.props = p;
    }

    public void init(Properties p, PersistenceManager syncPm) {
        this.syncPm = syncPm;
        this.ds = DatastoreServiceFactory.getAsyncDatastoreService();
        this.props = p;
    }

    @Override
    public PersistenceManager sync() {
        if (this.syncPm == null) {
            this.syncPm = new GaePersistenceManager();
            this.syncPm.init(this.props);
        }
        return this.syncPm;
    }

    @Override
    public SienaFuture<Void> insert(final Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        final Field idField = info.getIdField();
        Entity entity = GaeMappingUtils.createEntityInstance(idField, info, obj);
        GaeMappingUtils.fillEntity(obj, entity);
        Future future = this.ds.put(entity);
        SienaFutureWrapper<Key, Void> wrapped = new SienaFutureWrapper<Key, Void>(future){

            protected Void wrap(Key generatedKey) throws Exception {
                GaeMappingUtils.setIdFromKey(idField, obj, generatedKey);
                return null;
            }
        };
        return new SienaFutureContainer<Void>((Future<Void>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Void> delete(Object obj) {
        return new SienaFutureContainer<Void>(this.ds.delete(new Key[]{GaeMappingUtils.getKey(obj)}));
    }

    @Override
    public SienaFuture<Void> get(final Object obj) {
        Key key = GaeMappingUtils.getKey(obj);
        Future future = this.ds.get(key);
        SienaFutureWrapper<Entity, Void> wrapped = new SienaFutureWrapper<Entity, Void>(future){

            protected Void wrap(Entity entity) throws Exception {
                GaeMappingUtils.fillModel(obj, entity);
                return null;
            }
        };
        return new SienaFutureContainer<Void>((Future<Void>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Void> beginTransaction(int isolationLevel) {
        Future future = this.ds.beginTransaction();
        SienaFutureWrapper<Transaction, Void> wrapped = new SienaFutureWrapper<Transaction, Void>(future){

            protected Void wrap(Transaction transaction) throws Exception {
                return null;
            }
        };
        return new SienaFutureContainer<Void>((Future<Void>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Void> beginTransaction() {
        Future future = this.ds.beginTransaction();
        SienaFutureWrapper<Transaction, Void> wrapped = new SienaFutureWrapper<Transaction, Void>(future){

            protected Void wrap(Transaction transaction) throws Exception {
                return null;
            }
        };
        return new SienaFutureContainer<Void>((Future<Void>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Void> closeConnection() {
        return null;
    }

    @Override
    public SienaFuture<Void> commitTransaction() {
        Transaction txn = this.ds.getCurrentTransaction();
        return new SienaFutureContainer<Void>(txn.commitAsync());
    }

    @Override
    public SienaFuture<Void> rollbackTransaction() {
        Transaction txn = this.ds.getCurrentTransaction();
        return new SienaFutureContainer<Void>(txn.rollbackAsync());
    }

    @Override
    public SienaFuture<Void> update(Object obj) {
        Entity entity = new Entity(GaeMappingUtils.getKey(obj));
        GaeMappingUtils.fillEntity(obj, entity);
        Future future = this.ds.put(entity);
        SienaFutureWrapper<Key, Void> wrapped = new SienaFutureWrapper<Key, Void>(future){

            protected Void wrap(Key key) throws Exception {
                return null;
            }
        };
        return new SienaFutureContainer<Void>((Future<Void>)((Object)wrapped));
    }

    protected AsyncDatastoreService getDatastoreService() {
        return this.ds;
    }

    private <T> PreparedQuery prepare(QueryAsync<T> query) {
        Class clazz = query.getQueriedClass();
        Query q = new Query(ClassInfo.getClassInfo(clazz).tableName);
        return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q));
    }

    private <T> PreparedQuery prepareKeysOnly(QueryAsync<T> query) {
        Class clazz = query.getQueriedClass();
        Query q = new Query(ClassInfo.getClassInfo(clazz).tableName);
        return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q).setKeysOnly());
    }

    protected <T> T mapJoins(QueryAsync<T> query, T model) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(query);
            for (Field field : fieldMap.keySet()) {
                Key key = GaeMappingUtils.getKey(field.get(model));
                List keys = fieldMap.get(field);
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Future entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, (Map)entities.get());
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap linkedModels = new HashMap();
            for (Field field : fieldMap.keySet()) {
                Object objVal = field.get(model);
                Key key = GaeMappingUtils.getKey(objVal);
                Object linkedObj = linkedModels.get(key);
                if (linkedObj == null) {
                    Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                    linkedObj = objVal;
                    GaeMappingUtils.fillModel(linkedObj, entity);
                    linkedModels.put(key, linkedObj);
                }
                field.set(model, linkedObj);
            }
            return model;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected <T> List<T> mapJoins(QueryAsync<T> query, List<T> models) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(query);
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    List keys = fieldMap.get(field);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Future entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, (Map)entities.get());
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap<Key, Object> linkedModels = new HashMap<Key, Object>();
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    void var6_13;
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    Object v = linkedModels.get(key);
                    if (v == null) {
                        Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                        Object object = objVal;
                        GaeMappingUtils.fillModel(object, entity);
                        linkedModels.put(key, object);
                    }
                    field.set(model, var6_13);
                }
            }
            return models;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    protected <T> T map(QueryAsync<T> query, Entity entity) {
        Class clazz = query.getQueriedClass();
        Object result = GaeMappingUtils.mapEntity(entity, clazz);
        if (!query.getJoins().isEmpty() || ClassInfo.getClassInfo(clazz).joinFields.size() != 0) {
            return this.mapJoins(query, result);
        }
        return result;
    }

    protected <T> List<T> map(QueryAsync<T> query, Iterable<Entity> entities) {
        Class clazz = query.getQueriedClass();
        List result = GaeMappingUtils.mapEntities(entities, clazz);
        if (!query.getJoins().isEmpty() || ClassInfo.getClassInfo(clazz).joinFields.size() != 0) {
            return this.mapJoins(query, result);
        }
        return result;
    }

    protected <T> List<T> map(QueryAsync<T> query, QueryResultList<Entity> entities) {
        Class clazz = query.getQueriedClass();
        List result = GaeMappingUtils.mapEntities(entities, clazz);
        if (!query.getJoins().isEmpty() || ClassInfo.getClassInfo(clazz).joinFields.size() != 0) {
            return this.mapJoins(query, result);
        }
        return result;
    }

    private <T> SienaFuture<List<T>> doFetchList(QueryAsync<T> query, int limit, int offset) {
        String cursor;
        QueryResultList entities;
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.customize(gaeCtx);
        }
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (!pag.isPaginating()) {
            if (pag.isActive()) {
                if (limit != Integer.MAX_VALUE) {
                    gaeCtx.realPageSize = limit;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    pag.passivate();
                } else {
                    gaeCtx.realPageSize = pag.pageSize;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    if (state.isStateless()) {
                        pag.passivate();
                    }
                }
            } else if (limit != Integer.MAX_VALUE) {
                gaeCtx.realPageSize = limit;
                fetchOptions.limit(gaeCtx.realPageSize);
            }
        } else {
            gaeCtx.realPageSize = pag.pageSize;
            fetchOptions.limit(gaeCtx.realPageSize);
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
        if (gaeCtx.noMoreDataBefore) {
            return new SienaFutureMock<List<T>>(new ArrayList());
        }
        if (state.isStateless()) {
            if (pag.isPaginating()) {
                if (off.isActive()) {
                    gaeCtx.realOffset += off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                } else {
                    fetchOptions.offset(gaeCtx.realOffset);
                }
            } else {
                gaeCtx.realOffset = 0;
                if (off.isActive()) {
                    gaeCtx.realOffset = off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                }
            }
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    Iterable entities2 = this.prepareKeysOnly(query).asIterable(fetchOptions);
                    return new GaeSienaFutureListMapper<T>(this, entities2, query, GaeSienaFutureListMapper.MapType.KEYS_ONLY);
                }
            }
            Iterable entities3 = this.prepare(query).asIterable(fetchOptions);
            return new GaeSienaFutureListMapper<T>(this, entities3, query);
        }
        if (off.isActive()) {
            fetchOptions.offset(off.offset);
            gaeCtx.realOffset += off.offset;
            off.passivate();
        }
        if (!gaeCtx.isActive()) {
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    PreparedQuery pq = this.prepareKeysOnly(query);
                    if (!gaeCtx.useCursor) {
                        fetchOptions.offset(gaeCtx.realOffset);
                    }
                    QueryResultList entities4 = pq.asQueryResultList(fetchOptions);
                    gaeCtx.activate();
                    if (pag.isPaginating()) {
                        Cursor cursor2 = entities4.getCursor();
                        if (cursor2 != null) {
                            gaeCtx.addCursor(cursor2.toWebSafeString());
                        }
                    } else {
                        Cursor cursor3 = entities4.getCursor();
                        if (cursor3 != null) {
                            gaeCtx.addAndMoveCursor(entities4.getCursor().toWebSafeString());
                        }
                        gaeCtx.realOffset += entities4.size();
                    }
                    return new GaeSienaFutureListMapper<T>(this, (Iterable<Entity>)entities4, query, GaeSienaFutureListMapper.MapType.KEYS_ONLY);
                }
            }
            PreparedQuery pq = this.prepare(query);
            if (!gaeCtx.useCursor) {
                fetchOptions.offset(gaeCtx.realOffset);
            }
            QueryResultList entities5 = pq.asQueryResultList(fetchOptions);
            gaeCtx.activate();
            if (pag.isPaginating()) {
                Cursor cursor4 = entities5.getCursor();
                if (cursor4 != null) {
                    gaeCtx.addCursor(cursor4.toWebSafeString());
                }
            } else {
                Cursor cursor5 = entities5.getCursor();
                if (cursor5 != null) {
                    gaeCtx.addAndMoveCursor(entities5.getCursor().toWebSafeString());
                }
                gaeCtx.realOffset += entities5.size();
            }
            return new GaeSienaFutureListMapper<T>(this, (Iterable<Entity>)entities5, query);
        }
        switch (fetchType.fetchType) {
            case KEYS_ONLY: {
                String cursor6;
                QueryResultList entities6;
                PreparedQuery pq = this.prepareKeysOnly(query);
                if (!gaeCtx.useCursor) {
                    fetchOptions.offset(gaeCtx.realOffset);
                    entities6 = pq.asQueryResultList(fetchOptions);
                } else {
                    cursor6 = gaeCtx.currentCursor();
                    entities6 = cursor6 != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor6))) : pq.asQueryResultList(fetchOptions);
                }
                if (pag.isPaginating()) {
                    cursor6 = entities6.getCursor();
                    if (cursor6 != null) {
                        gaeCtx.addCursor(cursor6.toWebSafeString());
                    }
                } else {
                    cursor6 = entities6.getCursor();
                    if (cursor6 != null) {
                        gaeCtx.addAndMoveCursor(entities6.getCursor().toWebSafeString());
                    }
                    gaeCtx.realOffset += entities6.size();
                }
                return new GaeSienaFutureListMapper<T>(this, (Iterable<Entity>)entities6, query, GaeSienaFutureListMapper.MapType.KEYS_ONLY);
            }
        }
        PreparedQuery pq = this.prepare(query);
        if (!gaeCtx.useCursor) {
            fetchOptions.offset(gaeCtx.realOffset);
            entities = pq.asQueryResultList(fetchOptions);
        } else {
            cursor = gaeCtx.currentCursor();
            entities = cursor != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)gaeCtx.currentCursor()))) : pq.asQueryResultList(fetchOptions);
        }
        if (pag.isPaginating()) {
            cursor = entities.getCursor();
            if (cursor != null) {
                gaeCtx.addCursor(cursor.toWebSafeString());
            }
        } else {
            cursor = entities.getCursor();
            if (cursor != null) {
                gaeCtx.addAndMoveCursor(entities.getCursor().toWebSafeString());
            }
            gaeCtx.realOffset += entities.size();
        }
        return new GaeSienaFutureListMapper<T>(this, (Iterable<Entity>)entities, query);
    }

    private <T> SienaFuture<Iterable<T>> doFetchIterable(QueryAsync<T> query, int limit, int offset) {
        QueryResultIterable entities;
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.customize(gaeCtx);
        }
        FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (!pag.isPaginating()) {
            if (pag.isActive()) {
                if (limit != Integer.MAX_VALUE) {
                    gaeCtx.realPageSize = limit;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    pag.passivate();
                } else {
                    gaeCtx.realPageSize = pag.pageSize;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    if (state.isStateless()) {
                        pag.passivate();
                    }
                }
            } else if (limit != Integer.MAX_VALUE) {
                gaeCtx.realPageSize = limit;
                fetchOptions.limit(gaeCtx.realPageSize);
            }
        } else {
            gaeCtx.realPageSize = pag.pageSize;
            fetchOptions.limit(gaeCtx.realPageSize);
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
        if (gaeCtx.noMoreDataBefore) {
            return new SienaFutureMock<Iterable<T>>(new ArrayList());
        }
        if (state.isStateless()) {
            if (pag.isPaginating()) {
                if (off.isActive()) {
                    gaeCtx.realOffset += off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                } else {
                    fetchOptions.offset(gaeCtx.realOffset);
                }
            } else {
                gaeCtx.realOffset = off.offset;
                if (off.isActive()) {
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                }
            }
            switch (fetchType.fetchType) {
                default: 
            }
            Iterable entities2 = this.prepare(query).asIterable(fetchOptions);
            return new GaeSienaFutureIterableMapper<T>(this, entities2, query);
        }
        if (off.isActive()) {
            fetchOptions.offset(off.offset);
            gaeCtx.realOffset += off.offset;
            off.passivate();
        }
        if (!gaeCtx.isActive()) {
            switch (fetchType.fetchType) {
                default: 
            }
            PreparedQuery pq = this.prepare(query);
            if (pag.isPaginating()) {
                QueryResultList entities3 = pq.asQueryResultList(fetchOptions);
                gaeCtx.activate();
                Cursor cursor = entities3.getCursor();
                if (cursor != null) {
                    gaeCtx.addCursor(cursor.toWebSafeString());
                }
                return new GaeSienaFutureIterableMapper<T>(this, (Iterable<Entity>)entities3, query);
            }
            QueryResultIterable entities4 = pq.asQueryResultIterable(fetchOptions);
            gaeCtx.activate();
            return new GaeSienaFutureIterableMapperWithCursor<T>(this, (QueryResultIterable<Entity>)entities4, query);
        }
        switch (fetchType.fetchType) {
            default: 
        }
        PreparedQuery pq = this.prepare(query);
        if (pag.isPaginating()) {
            QueryResultList entities5;
            if (!gaeCtx.useCursor) {
                fetchOptions.offset(gaeCtx.realOffset);
                entities5 = pq.asQueryResultList(fetchOptions);
            } else {
                String cursor = gaeCtx.currentCursor();
                entities5 = cursor != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor))) : pq.asQueryResultList(fetchOptions);
                gaeCtx.addCursor(entities5.getCursor().toWebSafeString());
            }
            return new GaeSienaFutureIterableMapper<T>(this, (Iterable<Entity>)entities5, query);
        }
        if (!gaeCtx.useCursor) {
            fetchOptions.offset(gaeCtx.realOffset);
            entities = pq.asQueryResultIterable(fetchOptions);
        } else {
            String cursor = gaeCtx.currentCursor();
            entities = cursor != null ? pq.asQueryResultIterable(fetchOptions.startCursor(Cursor.fromWebSafeString((String)gaeCtx.currentCursor()))) : pq.asQueryResultIterable(fetchOptions);
        }
        return new GaeSienaFutureIterableMapperWithCursor<T>(this, (QueryResultIterable<Entity>)entities, query);
    }

    @Override
    public <T> SienaFuture<Integer> count(QueryAsync<T> query) {
        int nb = this.prepare(query).countEntities(FetchOptions.Builder.withDefaults());
        return new SienaFutureMock<Integer>(nb);
    }

    @Override
    public <T> SienaFuture<Integer> delete(QueryAsync<T> query) {
        final ArrayList<Key> keys = new ArrayList<Key>();
        for (Entity entity : this.prepareKeysOnly(query).asIterable(FetchOptions.Builder.withDefaults())) {
            keys.add(entity.getKey());
        }
        Future future = this.ds.delete(keys);
        SienaFutureWrapper<Void, Integer> wrapped = new SienaFutureWrapper<Void, Integer>(future){

            protected Integer wrap(Void v) throws Exception {
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<List<T>> fetch(QueryAsync<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> SienaFuture<List<T>> fetch(QueryAsync<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, limit, 0);
    }

    @Override
    public <T> SienaFuture<List<T>> fetch(QueryAsync<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, limit, (Integer)offset);
    }

    @Override
    public <T> SienaFuture<List<T>> fetchKeys(QueryAsync<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> SienaFuture<List<T>> fetchKeys(QueryAsync<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, limit, 0);
    }

    @Override
    public <T> SienaFuture<List<T>> fetchKeys(QueryAsync<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, limit, (Integer)offset);
    }

    @Override
    public <T> SienaFuture<Iterable<T>> iter(QueryAsync<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> SienaFuture<Iterable<T>> iter(QueryAsync<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, 0);
    }

    @Override
    public <T> SienaFuture<Iterable<T>> iter(QueryAsync<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, (Integer)offset);
    }

    @Override
    public <T> SienaFuture<Iterable<T>> iterPerPage(QueryAsync<T> query, int pageSize) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER_PER_PAGE;
        return new SienaIterableAsyncPerPageWrapper<T>(query, pageSize);
    }

    @Override
    public <T> void release(QueryAsync<T> query) {
        super.release(query);
        GaeQueryUtils.release(query);
    }

    @Override
    public <T> void paginate(QueryAsync<T> query) {
        GaeQueryUtils.paginate(query);
    }

    @Override
    public <T> void nextPage(QueryAsync<T> query) {
        GaeQueryUtils.nextPage(query);
    }

    @Override
    public <T> void previousPage(QueryAsync<T> query) {
        GaeQueryUtils.previousPage(query);
    }

    @Override
    public SienaFuture<Integer> insert(final Object ... objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Class<?> clazz = objects[i].getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstance(idField, info, objects[i]);
            GaeMappingUtils.fillEntity(objects[i], entity);
            entities.add(entity);
            ++i;
        }
        Future future = this.ds.put(entities);
        SienaFutureWrapper<List<Key>, Integer> wrapped = new SienaFutureWrapper<List<Key>, Integer>(future){

            protected Integer wrap(List<Key> generatedKeys) throws Exception {
                int i = 0;
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    Class<?> clazz = obj.getClass();
                    ClassInfo info = ClassInfo.getClassInfo(clazz);
                    Field idField = info.getIdField();
                    GaeMappingUtils.setIdFromKey(idField, obj, generatedKeys.get(i++));
                    ++n2;
                }
                return generatedKeys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Integer> insert(final Iterable<?> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstance(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
        Future future = this.ds.put(entities);
        SienaFutureWrapper<List<Key>, Integer> wrapped = new SienaFutureWrapper<List<Key>, Integer>(future){

            protected Integer wrap(List<Key> generatedKeys) throws Exception {
                int i = 0;
                for (Object obj : objects) {
                    Class<?> clazz = obj.getClass();
                    ClassInfo info = ClassInfo.getClassInfo(clazz);
                    Field idField = info.getIdField();
                    GaeMappingUtils.setIdFromKey(idField, obj, generatedKeys.get(i++));
                }
                return generatedKeys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Integer> delete(Object ... models) {
        final ArrayList<Key> keys = new ArrayList<Key>();
        Object[] objectArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            keys.add(GaeMappingUtils.getKey(obj));
            ++n2;
        }
        Future future = this.ds.delete(keys);
        SienaFutureWrapper<Void, Integer> wrapped = new SienaFutureWrapper<Void, Integer>(future){

            protected Integer wrap(Void v) throws Exception {
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Integer> delete(Iterable<?> models) {
        final ArrayList<Key> keys = new ArrayList<Key>();
        for (Object obj : models) {
            keys.add(GaeMappingUtils.getKey(obj));
        }
        Future future = this.ds.delete(keys);
        SienaFutureWrapper<Void, Integer> wrapped = new SienaFutureWrapper<Void, Integer>(future){

            protected Integer wrap(Void v) throws Exception {
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<Integer> deleteByKeys(Class<T> clazz, Object ... keys) {
        final ArrayList<Key> gaeKeys = new ArrayList<Key>();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
            ++n2;
        }
        Future future = this.ds.delete(gaeKeys);
        SienaFutureWrapper<Void, Integer> wrapped = new SienaFutureWrapper<Void, Integer>(future){

            protected Integer wrap(Void v) throws Exception {
                return gaeKeys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<Integer> deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        final ArrayList<Key> gaeKeys = new ArrayList<Key>();
        for (Object key : keys) {
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
        }
        Future future = this.ds.delete(gaeKeys);
        SienaFutureWrapper<Void, Integer> wrapped = new SienaFutureWrapper<Void, Integer>(future){

            protected Integer wrap(Void v) throws Exception {
                return gaeKeys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Integer> get(final Object ... objects) {
        ArrayList<Key> keys = new ArrayList<Key>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            keys.add(GaeMappingUtils.getKey(obj));
            ++n2;
        }
        Future future = this.ds.get(keys);
        SienaFutureWrapper<Map<Key, Entity>, Integer> wrapped = new SienaFutureWrapper<Map<Key, Entity>, Integer>(future){

            protected Integer wrap(Map<Key, Entity> entityMap) throws Exception {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    GaeMappingUtils.fillModel(obj, entityMap.get(GaeMappingUtils.getKey(obj)));
                    ++n2;
                }
                return entityMap.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<Integer> get(final Iterable<T> objects) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (T obj : objects) {
            keys.add(GaeMappingUtils.getKey(obj));
        }
        Future future = this.ds.get(keys);
        SienaFutureWrapper<Map<Key, Entity>, Integer> wrapped = new SienaFutureWrapper<Map<Key, Entity>, Integer>(future){

            protected Integer wrap(Map<Key, Entity> entityMap) throws Exception {
                for (Object obj : objects) {
                    GaeMappingUtils.fillModel(obj, entityMap.get(GaeMappingUtils.getKey(obj)));
                }
                return entityMap.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<T> getByKey(final Class<T> clazz, Object key) {
        Key gkey = GaeMappingUtils.makeKey(clazz, key);
        try {
            Future future = this.ds.get(gkey);
            SienaFutureWrapper wrapped = new SienaFutureWrapper<Entity, T>(future){

                protected T wrap(Entity entity) throws Exception {
                    Object obj = Util.createObjectInstance(clazz);
                    GaeMappingUtils.fillModelAndKey(obj, entity);
                    return obj;
                }
            };
            return new SienaFutureContainer(wrapped);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public <T> SienaFuture<List<T>> getByKeys(final Class<T> clazz, final Object ... keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
            ++n2;
        }
        Future future = this.ds.get(gaeKeys);
        SienaFutureWrapper wrapped = new SienaFutureWrapper<Map<Key, Entity>, List<T>>(future){

            protected List<T> wrap(Map<Key, Entity> entityMap) throws Exception {
                ArrayList models = new ArrayList(entityMap.size());
                Object[] objectArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    models.add(GaeMappingUtils.mapEntity(entityMap.get(GaeMappingUtils.makeKey(clazz, key)), clazz));
                    ++n2;
                }
                return models;
            }
        };
        return new SienaFutureContainer<List<T>>(wrapped);
    }

    @Override
    public <T> SienaFuture<List<T>> getByKeys(final Class<T> clazz, final Iterable<?> keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        for (Object key : keys) {
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
        }
        Future future = this.ds.get(gaeKeys);
        SienaFutureWrapper wrapped = new SienaFutureWrapper<Map<Key, Entity>, List<T>>(future){

            protected List<T> wrap(Map<Key, Entity> entityMap) throws Exception {
                ArrayList models = new ArrayList(entityMap.size());
                for (Object key : keys) {
                    models.add(GaeMappingUtils.mapEntity(entityMap.get(GaeMappingUtils.makeKey(clazz, key)), clazz));
                }
                return models;
            }
        };
        return new SienaFutureContainer<List<T>>(wrapped);
    }

    @Override
    public SienaFuture<Integer> update(Object ... objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
            ++n2;
        }
        Future future = this.ds.put(entities);
        SienaFutureWrapper<List<Key>, Integer> wrapped = new SienaFutureWrapper<List<Key>, Integer>(future){

            protected Integer wrap(List<Key> keys) throws Exception {
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<Integer> update(Iterable<T> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (T obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
        Future future = this.ds.put(entities);
        SienaFutureWrapper<List<Key>, Integer> wrapped = new SienaFutureWrapper<List<Key>, Integer>(future){

            protected Integer wrap(List<Key> keys) throws Exception {
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public <T> SienaFuture<Integer> update(QueryAsync<T> query, Map<String, ?> fieldValues) {
        throw new NotImplementedException("update not implemented for GAE yet");
    }

    @Override
    public SienaFuture<Void> save(final Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        final Field idField = info.getIdField();
        final Object idVal = Util.readField(obj, idField);
        final Entity entity = idVal == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
        GaeMappingUtils.fillEntity(obj, entity);
        Future future = this.ds.put(entity);
        SienaFutureWrapper<Key, Void> wrapped = new SienaFutureWrapper<Key, Void>(future){

            protected Void wrap(Key generatedKey) throws Exception {
                if (idVal == null) {
                    GaeMappingUtils.setIdFromKey(idField, obj, entity.getKey());
                }
                return null;
            }
        };
        return new SienaFutureContainer<Void>((Future<Void>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Integer> save(final Object ... objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Object idVal = Util.readField(obj, idField);
            Entity entity = idVal == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
            ++n2;
        }
        Future future = this.ds.put(entities);
        SienaFutureWrapper<List<Key>, Integer> wrapped = new SienaFutureWrapper<List<Key>, Integer>(future){

            protected Integer wrap(List<Key> keys) throws Exception {
                int i = 0;
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    Class<?> clazz = obj.getClass();
                    ClassInfo info = ClassInfo.getClassInfo(clazz);
                    Field idField = info.getIdField();
                    Object idVal = Util.readField(obj, idField);
                    if (idVal == null) {
                        GaeMappingUtils.setIdFromKey(idField, obj, keys.get(i++));
                    }
                    ++n2;
                }
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public SienaFuture<Integer> save(final Iterable<?> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object obj : objects) {
            Class<?> clazz;
            ClassInfo info;
            Field idField;
            Object idVal = Util.readField(obj, idField = (info = ClassInfo.getClassInfo(clazz = obj.getClass())).getIdField());
            Entity entity = idVal == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
        Future future = this.ds.put(entities);
        SienaFutureWrapper<List<Key>, Integer> wrapped = new SienaFutureWrapper<List<Key>, Integer>(future){

            protected Integer wrap(List<Key> keys) throws Exception {
                int i = 0;
                for (Object obj : objects) {
                    Class<?> clazz;
                    ClassInfo info;
                    Field idField;
                    Object idVal = Util.readField(obj, idField = (info = ClassInfo.getClassInfo(clazz = obj.getClass())).getIdField());
                    if (idVal != null) continue;
                    GaeMappingUtils.setIdFromKey(idField, obj, keys.get(i++));
                }
                return keys.size();
            }
        };
        return new SienaFutureContainer<Integer>((Future<Integer>)((Object)wrapped));
    }

    @Override
    public String[] supportedOperators() {
        return supportedOperators;
    }
}

