/*
 * Decompiled with CFR 0.152.
 */
package siena.hbase;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import siena.BaseQueryData;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.Query;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.SienaException;
import siena.core.async.PersistenceManagerAsync;
import siena.core.async.QueryAsync;
import siena.core.batch.Batch;
import siena.core.options.QueryOption;

public class HBasePersistenceManager
implements PersistenceManager {
    private Configuration config = HBaseConfiguration.create();

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return new HBaseQuery<T>(clazz);
    }

    @Override
    public void delete(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        try {
            HTable table = new HTable(this.config, info.tableName);
            Field id = ClassInfo.getIdField(clazz);
            id.setAccessible(true);
            Delete d = new Delete(Bytes.toBytes((String)id.get(obj).toString()));
            table.delete(d);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void get(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        try {
            HTable table = new HTable(this.config, info.tableName);
            Field id = ClassInfo.getIdField(clazz);
            id.setAccessible(true);
            Get g = new Get(Bytes.toBytes((String)id.get(obj).toString()));
            Result rowResult = table.get(g);
            if (rowResult.isEmpty()) {
                throw new SienaException("No such object");
            }
            this.mapObject(clazz, obj, rowResult);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void init(Properties p) {
    }

    @Override
    public void insert(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        try {
            HTable table = new HTable(this.config, info.tableName);
            Field id = ClassInfo.getIdField(clazz);
            id.setAccessible(true);
            Put p = new Put(Bytes.toBytes((String)id.get(obj).toString()));
            List<Field> fields = info.insertFields;
            for (Field field : fields) {
                p.add(Bytes.toBytes((String)"string"), Bytes.toBytes((String)ClassInfo.getColumnNames(field)[0]), Bytes.toBytes((String)field.get(obj).toString()));
            }
            table.put(p);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public void update(Object obj) {
        this.insert(obj);
    }

    private <T> void mapObject(Class<T> clazz, Object obj, Result result) {
        try {
            String id = Bytes.toString((byte[])result.getRow());
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            for (Field field : info.insertFields) {
                String column = "string:" + ClassInfo.getColumnNames(field)[0];
                String value = Bytes.toString((byte[])result.getValue(Bytes.toBytes((String)"string"), Bytes.toBytes((String)ClassInfo.getColumnNames(field)[0])));
                field.setAccessible(true);
                field.set(obj, value);
            }
            ClassInfo.getIdField(clazz).set(obj, id);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private <T> T mapObject(Class<T> clazz, Result rowResult) {
        try {
            T obj = clazz.newInstance();
            this.mapObject(clazz, obj, rowResult);
            return obj;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public <T> T get(Query<T> query) {
        return null;
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        return null;
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        return null;
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        return null;
    }

    @Override
    public <T> int count(Query<T> query) {
        return 0;
    }

    @Override
    public <T> int count(Query<T> query, int limit) {
        return 0;
    }

    @Override
    public <T> int count(Query<T> query, int limit, Object offset) {
        return 0;
    }

    @Override
    public <T> int delete(Query<T> query) {
        return 0;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        return null;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        return null;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        return null;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        return null;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        return null;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        return null;
    }

    @Override
    public String[] supportedOperators() {
        return null;
    }

    @Override
    public <T> void release(Query<T> query) {
    }

    @Override
    public <T> Query<T> createQuery(BaseQueryData<T> query) {
        return null;
    }

    @Override
    public <T> Batch<T> createBatch(Class<T> clazz) {
        return null;
    }

    @Override
    public int get(Object ... models) {
        return 0;
    }

    @Override
    public <T> int get(Iterable<T> models) {
        return 0;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        return null;
    }

    @Override
    public <T> int update(Object ... models) {
        return 0;
    }

    @Override
    public <T> int update(Iterable<T> models) {
        return 0;
    }

    @Override
    public <T> void nextPage(Query<T> query) {
    }

    @Override
    public <T> void previousPage(Query<T> query) {
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        return null;
    }

    @Override
    public int insert(Object ... objects) {
        return 0;
    }

    @Override
    public int insert(Iterable<?> objects) {
        return 0;
    }

    @Override
    public int delete(Object ... models) {
        return 0;
    }

    @Override
    public int delete(Iterable<?> models) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        return 0;
    }

    @Override
    public <T> void paginate(Query<T> query) {
    }

    @Override
    public <T> Iterable<T> iterPerPage(Query<T> query, int pageSize) {
        return null;
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        return null;
    }

    @Override
    public void save(Object obj) {
    }

    @Override
    public int save(Object ... objects) {
        return 0;
    }

    @Override
    public int save(Iterable<?> objects) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        return 0;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        return null;
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        return 0;
    }

    class HBaseQuery<T>
    implements Query<T> {
        private Class<T> clazz;
        private ClassInfo info;

        public HBaseQuery(Class<T> clazz) {
            this.clazz = clazz;
            this.info = ClassInfo.getClassInfo(clazz);
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public int count(int limit) {
            return 0;
        }

        @Override
        public int count(int limit, Object offset) {
            return 0;
        }

        @Override
        public List<T> fetch() {
            ResultScanner scanner = null;
            try {
                HTable table = new HTable(HBasePersistenceManager.this.config, this.info.tableName);
                List<Field> fields = this.info.insertFields;
                ArrayList names = new ArrayList();
                Scan s = new Scan();
                for (Field field : fields) {
                    s.addColumn(Bytes.toBytes((String)"string"), Bytes.toBytes((String)ClassInfo.getColumnNames(field)[0]));
                }
                scanner = table.getScanner(s);
                ArrayList<Object> results = new ArrayList<Object>();
                Result rr = scanner.next();
                while (rr != null) {
                    results.add(HBasePersistenceManager.this.mapObject(this.clazz, rr));
                    rr = scanner.next();
                }
                ArrayList<Object> arrayList = results;
                return arrayList;
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
            finally {
                scanner.close();
            }
        }

        @Override
        public List<T> fetch(int limit) {
            return null;
        }

        @Override
        public List<T> fetch(int limit, Object offset) {
            return null;
        }

        @Override
        public Query<T> filter(String fieldName, Object value) {
            return null;
        }

        @Override
        public T get() {
            List<T> list = this.fetch();
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }

        @Override
        public Iterable<T> iter() {
            return null;
        }

        @Override
        public Iterable<T> iter(int limit) {
            return null;
        }

        @Override
        public Iterable<T> iter(int limit, Object offset) {
            return null;
        }

        @Override
        public Query<T> order(String fieldName) {
            return null;
        }

        @Override
        public Query<T> search(String match, boolean inBooleanMode, String index) {
            return null;
        }

        @Override
        public HBaseQuery<T> clone() {
            return null;
        }

        @Override
        public Object nextOffset() {
            return null;
        }

        @Override
        public int delete() {
            return 0;
        }

        @Override
        public List<T> fetchKeys() {
            return null;
        }

        @Override
        public List<T> fetchKeys(int limit) {
            return null;
        }

        @Override
        public List<T> fetchKeys(int limit, Object offset) {
            return null;
        }

        @Override
        public List<QueryFilter> getFilters() {
            return null;
        }

        @Override
        public List<QueryOrder> getOrders() {
            return null;
        }

        @Override
        public List<QueryFilterSearch> getSearches() {
            return null;
        }

        @Override
        public void setNextOffset(Object nextOffset) {
        }

        @Override
        public Class<T> getQueriedClass() {
            return null;
        }

        @Override
        public List<QueryJoin> getJoins() {
            return null;
        }

        @Override
        public Query<T> join(String field, String ... sortFields) {
            return null;
        }

        @Override
        public Query<T> paginate(int size) {
            return null;
        }

        @Override
        public Query<T> customize(QueryOption ... options) {
            return null;
        }

        @Override
        public Map<Integer, QueryOption> options() {
            return null;
        }

        @Override
        public Query<T> search(String match, String ... fields) {
            return null;
        }

        @Override
        public Query<T> search(String match, QueryOption opt, String ... fields) {
            return null;
        }

        @Override
        public QueryOption option(int option) {
            return null;
        }

        @Override
        public Query<T> stateful() {
            return null;
        }

        @Override
        public Query<T> release() {
            return null;
        }

        @Override
        public int update(Map<String, ?> fieldValues) {
            return 0;
        }

        @Override
        public Query<T> nextPage() {
            return null;
        }

        @Override
        public Query<T> previousPage() {
            return null;
        }

        @Override
        public Query<T> stateless() {
            return null;
        }

        @Override
        public Query<T> resetData() {
            return null;
        }

        @Override
        public String dump(QueryOption ... options) {
            return null;
        }

        @Override
        public void dump(OutputStream os, QueryOption ... options) {
        }

        @Override
        public Query<T> restore(String dump, QueryOption ... options) {
            return null;
        }

        @Override
        public Query<T> restore(InputStream dump, QueryOption ... options) {
            return null;
        }

        @Override
        public QueryAsync<T> async() {
            return null;
        }

        @Override
        public PersistenceManager getPersistenceManager() {
            return null;
        }

        @Override
        public Query<T> limit(int limit) {
            return null;
        }

        @Override
        public Query<T> offset(Object offset) {
            return null;
        }

        @Override
        public Iterable<T> iterPerPage(int limit) {
            return null;
        }

        @Override
        public T getByKey(Object key) {
            return null;
        }
    }
}

