/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import siena.BaseQueryData;
import siena.Json;
import siena.PersistenceManager;
import siena.Query;
import siena.SienaException;
import siena.core.async.QueryAsync;
import siena.core.options.QueryOption;
import siena.embed.JsonSerializer;

public class BaseQuery<T>
extends BaseQueryData<T>
implements Query<T> {
    private static final long serialVersionUID = 3533080111146350262L;
    protected transient PersistenceManager pm;
    @Deprecated
    protected transient Object nextOffset;

    public BaseQuery() {
    }

    public BaseQuery(PersistenceManager pm, Class<T> clazz) {
        super(clazz);
        this.pm = pm;
    }

    public BaseQuery(BaseQuery<T> query) {
        super(query);
        this.pm = query.pm;
    }

    public BaseQuery(PersistenceManager pm, BaseQueryData<T> data) {
        super(data);
        this.pm = pm;
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    @Override
    public Query<T> filter(String fieldName, Object value) {
        this.addFilter(fieldName, value, this.pm.supportedOperators());
        return this;
    }

    @Override
    public Query<T> order(String fieldName) {
        this.addOrder(fieldName);
        return this;
    }

    @Override
    public Query<T> search(String match, String ... fields) {
        this.addSearch(match, fields);
        return this;
    }

    @Override
    public Query<T> search(String match, QueryOption opt, String ... fields) {
        this.addSearch(match, opt, fields);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> search(String match, boolean inBooleanMode, String index) {
        return this;
    }

    @Override
    public Query<T> join(String fieldName, String ... sortFields) {
        this.addJoin(fieldName, sortFields);
        return this;
    }

    @Override
    public Query<T> aggregated(Object aggregator, String fieldName) {
        this.addAggregated(aggregator, fieldName);
        return this;
    }

    public Query<T> aggregated(Object aggregator, Field field) {
        this.addAggregated(aggregator, field);
        return this;
    }

    @Override
    public Query<T> owned(Object owner, String fieldName) {
        this.addOwned(owner, fieldName);
        return this;
    }

    public Query<T> owned(Object owner, Field field) {
        this.addOwned(owner, field);
        return this;
    }

    @Override
    public T get() {
        return this.pm.get(this);
    }

    @Override
    public List<T> fetch() {
        return this.pm.fetch(this);
    }

    @Override
    public List<T> fetch(int limit) {
        return this.pm.fetch(this, limit);
    }

    @Override
    public List<T> fetch(int limit, Object offset) {
        return this.pm.fetch(this, limit, offset);
    }

    @Override
    public int count() {
        return this.pm.count(this);
    }

    @Override
    @Deprecated
    public int count(int limit) {
        return this.pm.count(this, limit);
    }

    @Override
    @Deprecated
    public int count(int limit, Object offset) {
        return this.pm.count(this, limit, offset);
    }

    @Override
    public int delete() {
        return this.pm.delete(this);
    }

    @Override
    public List<T> fetchKeys() {
        return this.pm.fetchKeys(this);
    }

    @Override
    public List<T> fetchKeys(int limit) {
        return this.pm.fetchKeys(this, limit);
    }

    @Override
    public List<T> fetchKeys(int limit, Object offset) {
        return this.pm.fetchKeys(this, limit, offset);
    }

    @Override
    public Iterable<T> iter() {
        return this.pm.iter(this);
    }

    @Override
    public Iterable<T> iter(int limit) {
        return this.pm.iter(this, limit);
    }

    @Override
    public Iterable<T> iter(int limit, Object offset) {
        return this.pm.iter(this, limit, offset);
    }

    @Override
    public Iterable<T> iterPerPage(int pageSize) {
        return this.pm.iterPerPage(this, pageSize);
    }

    @Override
    public Query<T> copy() {
        return new BaseQuery<T>(this);
    }

    @Override
    public Class<T> getQueriedClass() {
        return this.clazz;
    }

    @Override
    @Deprecated
    public Object nextOffset() {
        return this.nextOffset;
    }

    @Override
    @Deprecated
    public void setNextOffset(Object nextOffset) {
        this.nextOffset = nextOffset;
    }

    @Override
    public Query<T> paginate(int pageSize) {
        this.optionPaginate(pageSize);
        this.pm.paginate(this);
        return this;
    }

    @Override
    public Query<T> limit(int limit) {
        this.optionLimit(limit);
        return this;
    }

    @Override
    public Query<T> offset(Object offset) {
        this.optionOffset((Integer)offset);
        return this;
    }

    @Override
    public Query<T> nextPage() {
        this.pm.nextPage(this);
        return this;
    }

    @Override
    public Query<T> previousPage() {
        this.pm.previousPage(this);
        return this;
    }

    @Override
    public Query<T> customize(QueryOption ... options) {
        this.addOptions(options);
        return this;
    }

    @Override
    public Query<T> stateful() {
        this.optionStateful();
        return this;
    }

    @Override
    public Query<T> stateless() {
        this.resetOptions();
        this.optionStateless();
        return this;
    }

    @Override
    public Query<T> release() {
        super.reset();
        this.pm.release(this);
        return this;
    }

    @Override
    public Query<T> resetData() {
        super.reset();
        return this;
    }

    @Override
    public int update(Map<String, ?> fieldValues) {
        return this.pm.update(this, fieldValues);
    }

    @Override
    public QueryAsync<T> async() {
        return this.pm.async().createQuery(this);
    }

    @Override
    public T getByKey(Object key) {
        return this.pm.getByKey(this.clazz, key);
    }

    @Override
    public String dump(QueryOption ... options) {
        return JsonSerializer.serialize(this).toString();
    }

    @Override
    public void dump(OutputStream os, QueryOption ... options) {
        OutputStreamWriter st = new OutputStreamWriter(os);
        try {
            st.write(JsonSerializer.serialize(this).toString());
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
    }

    @Override
    public Query<T> restore(String dump, QueryOption ... options) {
        return (Query)JsonSerializer.deserialize(BaseQuery.class, Json.loads(dump));
    }

    @Override
    public Query<T> restore(InputStream is, QueryOption ... options) {
        InputStreamReader st = new InputStreamReader(is);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            while (st.read(buffer) != -1) {
                sb.append(buffer);
            }
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
        return (Query)JsonSerializer.deserialize(BaseQuery.class, Json.loads(sb.toString()));
    }
}

