/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.PersistenceManagerFactory;
import siena.Query;
import siena.QueryAggregated;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.QueryOwned;
import siena.SienaException;
import siena.Util;
import siena.core.Aggregator;
import siena.core.Many4PM;
import siena.core.One;
import siena.core.One4PM;
import siena.core.Relation;
import siena.core.RelationMode;
import siena.core.SyncList;
import siena.core.async.ModelAsync;
import siena.core.async.QueryAsync;
import siena.core.batch.Batch;
import siena.core.options.QueryOption;
import siena.core.options.QueryOptionState;

public abstract class Model {
    private transient PersistenceManager persistenceManager;
    @Aggregator
    private Relation relation;

    public Model() {
        this.init();
    }

    public void get() {
        this.getPersistenceManager().get((Object)this);
    }

    public void delete() {
        this.getPersistenceManager().delete((Object)this);
    }

    public void insert() {
        this.getPersistenceManager().insert((Object)this);
    }

    public void update() {
        this.getPersistenceManager().update((Object)this);
    }

    public void save() {
        this.getPersistenceManager().save((Object)this);
    }

    public final PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = PersistenceManagerFactory.getPersistenceManager(this.getClass());
        }
        return this.persistenceManager;
    }

    public static <R> Query<R> all(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createQuery(clazz);
    }

    public static <R> Batch<R> batch(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createBatch(clazz);
    }

    public static <R> R getByKey(Class<R> clazz, Object key) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).getByKey(clazz, key);
    }

    public ModelAsync async() {
        return new ModelAsync(this);
    }

    public boolean hasRelation(RelationMode mode) {
        if (mode == RelationMode.AGGREGATION) {
            return Util.readField(this, ClassInfo.getClassInfo(this.getClass()).aggregator) != null;
        }
        return false;
    }

    public Model setRelation(Relation relation) {
        Util.setField(this, ClassInfo.getClassInfo(this.getClass()).aggregator, relation);
        return this;
    }

    public Relation getRelation() {
        return (Relation)Util.readField(this, ClassInfo.getClassInfo(this.getClass()).aggregator);
    }

    public Model aggregate(Object aggregator, String fieldName) {
        return this.setRelation(new Relation(RelationMode.AGGREGATION, aggregator, Util.getField(aggregator.getClass(), fieldName)));
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        List<Field> keys = ClassInfo.getClassInfo(this.getClass()).keys;
        for (Field field : keys) {
            field.setAccessible(true);
            try {
                Object a = field.get(this);
                Object b = field.get(that);
                if (!(a == null ? b != null : !a.equals(b))) continue;
                return false;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        List<Field> keys = ClassInfo.getClassInfo(this.getClass()).keys;
        for (Field field : keys) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                result = 31 * result + (value == null ? 0 : value.hashCode());
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return result;
    }

    private void init() {
        RelationMode mode;
        Map<ClassInfo.FieldMapKeys, Object> map;
        Class<?> clazz = this.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Field field : info.queryFieldMap.keySet()) {
            try {
                map = info.queryFieldMap.get(field);
                Util.setField(this, field, new ProxyQuery((Class)map.get((Object)ClassInfo.FieldMapKeys.CLASS), (String)map.get((Object)ClassInfo.FieldMapKeys.FILTER), this));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        for (Field field : info.manyFieldMap.keySet()) {
            try {
                map = info.manyFieldMap.get(field);
                mode = (RelationMode)((Object)map.get((Object)ClassInfo.FieldMapKeys.MODE));
                switch (mode) {
                    case AGGREGATION: {
                        Util.setField(this, field, new ProxyMany((Class)map.get((Object)ClassInfo.FieldMapKeys.CLASS), this, (RelationMode)((Object)map.get((Object)ClassInfo.FieldMapKeys.MODE)), field));
                        break;
                    }
                    case RELATION: {
                        Util.setField(this, field, new ProxyMany((Class)map.get((Object)ClassInfo.FieldMapKeys.CLASS), this, (RelationMode)((Object)map.get((Object)ClassInfo.FieldMapKeys.MODE)), (Field)map.get((Object)ClassInfo.FieldMapKeys.FIELD)));
                    }
                }
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        for (Field field : info.oneFieldMap.keySet()) {
            try {
                map = info.oneFieldMap.get(field);
                mode = (RelationMode)((Object)map.get((Object)ClassInfo.FieldMapKeys.MODE));
                switch (mode) {
                    case AGGREGATION: {
                        Util.setField(this, field, new ProxyOne((Class)map.get((Object)ClassInfo.FieldMapKeys.CLASS), this, (RelationMode)((Object)map.get((Object)ClassInfo.FieldMapKeys.MODE)), field));
                        break;
                    }
                    case RELATION: {
                        Util.setField(this, field, new ProxyOne((Class)map.get((Object)ClassInfo.FieldMapKeys.CLASS), this, (RelationMode)((Object)map.get((Object)ClassInfo.FieldMapKeys.MODE)), (Field)map.get((Object)ClassInfo.FieldMapKeys.FIELD)));
                    }
                }
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
    }

    class ProxyMany<T>
    implements Many4PM<T> {
        private static final long serialVersionUID = -4540064249546783019L;
        private Class<T> clazz;
        private Model obj;
        private Many4PM<T> many;
        private RelationMode mode;
        private Field field;

        public ProxyMany(Class<T> clazz, Model obj, RelationMode mode, Field field) {
            this.clazz = clazz;
            this.obj = obj;
            this.mode = mode;
            this.field = field;
        }

        private Many4PM<T> createMany() {
            if (this.many == null) {
                this.many = this.obj.getPersistenceManager().createMany(this.clazz);
            }
            switch (this.mode) {
                case AGGREGATION: {
                    this.aggregationMode(this.obj, this.field);
                    break;
                }
                case RELATION: {
                    this.relationMode(this.obj, this.field);
                }
            }
            return this.many;
        }

        @Override
        public SyncList<T> asList() {
            return this.createMany().asList();
        }

        @Override
        public Query<T> asQuery() {
            return this.createMany().asQuery();
        }

        @Override
        public List<T> asList2Remove() {
            return this.createMany().asList2Remove();
        }

        @Override
        public List<T> asList2Add() {
            return this.createMany().asList2Add();
        }

        @Override
        public Many4PM<T> aggregationMode(Object aggregator, Field field) {
            return this.many.aggregationMode(aggregator, field);
        }

        @Override
        public Many4PM<T> relationMode(Object owner, Field field) {
            return this.many.relationMode(owner, field);
        }

        @Override
        public Many4PM<T> setSync(boolean isSync) {
            return this.createMany().setSync(isSync);
        }
    }

    class ProxyOne<T>
    implements One4PM<T> {
        private Class<T> clazz;
        private Model ancestor;
        private One4PM<T> one;
        private RelationMode mode;
        private Field field;

        public ProxyOne(Class<T> clazz, Model ancestor, RelationMode mode, Field field) {
            this.clazz = clazz;
            this.ancestor = ancestor;
            this.mode = mode;
            this.field = field;
        }

        private One4PM<T> createOne() {
            if (this.one == null) {
                this.one = this.ancestor.getPersistenceManager().createOne(this.clazz);
                switch (this.mode) {
                    case AGGREGATION: {
                        this.aggregationMode(this.ancestor, this.field);
                        break;
                    }
                    case RELATION: {
                        this.relationMode(this.ancestor, this.field);
                    }
                }
            }
            return this.one;
        }

        @Override
        public One4PM<T> aggregationMode(Object aggregator, Field field) {
            return this.one.aggregationMode(aggregator, field);
        }

        @Override
        public One4PM<T> relationMode(Object owner, Field field) {
            return this.one.relationMode(owner, field);
        }

        @Override
        public T get() {
            return this.createOne().get();
        }

        @Override
        public void set(T obj) {
            this.createOne().set(obj);
        }

        @Override
        public One<T> sync() {
            return this.createOne().sync();
        }

        @Override
        public One<T> forceSync() {
            return this.createOne().forceSync();
        }

        @Override
        public boolean isModified() {
            return this.createOne().isModified();
        }

        @Override
        public One4PM<T> setModified(boolean isModified) {
            return this.createOne().setModified(isModified);
        }

        @Override
        public T getPrev() {
            return this.createOne().getPrev();
        }

        @Override
        public One4PM<T> setSync(boolean isSync) {
            return this.createOne().setSync(isSync);
        }
    }

    class ProxyQuery<T>
    implements Query<T> {
        private static final long serialVersionUID = -7726081283511624780L;
        private String filter;
        private Class<T> clazz;
        private Model obj;
        private Query<T> query;

        public ProxyQuery(Class<T> clazz, String filter, Model obj) {
            this.filter = filter;
            this.clazz = clazz;
            this.obj = obj;
        }

        private Query<T> createQuery() {
            if (this.query == null) {
                this.query = this.obj.getPersistenceManager().createQuery(this.clazz);
            } else if (((QueryOptionState)this.query.option(3)).isStateless()) {
                this.query.release();
            }
            return this.query.filter(this.filter, this.obj);
        }

        @Override
        public int count() {
            return this.createQuery().count();
        }

        @Override
        @Deprecated
        public int count(int limit) {
            return this.createQuery().count(limit);
        }

        @Override
        @Deprecated
        public int count(int limit, Object offset) {
            return this.createQuery().count(limit, offset);
        }

        @Override
        public List<T> fetch() {
            return this.createQuery().fetch();
        }

        @Override
        public List<T> fetch(int limit) {
            return this.createQuery().fetch(limit);
        }

        @Override
        public List<T> fetch(int limit, Object offset) {
            return this.createQuery().fetch(limit, offset);
        }

        @Override
        public Query<T> filter(String fieldName, Object value) {
            return this.createQuery().filter(fieldName, value);
        }

        @Override
        public Query<T> order(String fieldName) {
            return this.createQuery().order(fieldName);
        }

        @Override
        @Deprecated
        public Query<T> search(String match, boolean inBooleanMode, String index) {
            return this.createQuery().search(match, inBooleanMode, index);
        }

        @Override
        public Query<T> join(String field, String ... sortFields) {
            return this.createQuery().join(field, sortFields);
        }

        @Override
        public Query<T> aggregated(Object aggregator, String fieldName) {
            return this.createQuery().aggregated(aggregator, fieldName);
        }

        @Override
        public Query<T> owned(Object owner, String fieldName) {
            return this.createQuery().owned(owner, fieldName);
        }

        @Override
        public T get() {
            return this.createQuery().get();
        }

        @Override
        public Iterable<T> iter() {
            return this.createQuery().iter();
        }

        @Override
        public Iterable<T> iter(int limit) {
            return this.createQuery().iter(limit);
        }

        @Override
        public Iterable<T> iter(int limit, Object offset) {
            return this.createQuery().iter(limit, offset);
        }

        @Override
        public Iterable<T> iterPerPage(int limit) {
            return this.createQuery().iterPerPage(limit);
        }

        @Override
        public ProxyQuery<T> copy() {
            return new ProxyQuery<T>(this.clazz, this.filter, this.obj);
        }

        @Override
        @Deprecated
        public Object nextOffset() {
            return this.createQuery().nextOffset();
        }

        @Override
        public int delete() {
            return this.createQuery().delete();
        }

        @Override
        public List<T> fetchKeys() {
            return this.createQuery().fetchKeys();
        }

        @Override
        public List<T> fetchKeys(int limit) {
            return this.createQuery().fetchKeys(limit);
        }

        @Override
        public List<T> fetchKeys(int limit, Object offset) {
            return this.createQuery().fetchKeys(limit, offset);
        }

        @Override
        public List<QueryFilter> getFilters() {
            return this.createQuery().getFilters();
        }

        @Override
        public List<QueryOrder> getOrders() {
            return this.createQuery().getOrders();
        }

        @Override
        public List<QueryFilterSearch> getSearches() {
            return this.createQuery().getSearches();
        }

        @Override
        public List<QueryJoin> getJoins() {
            return this.createQuery().getJoins();
        }

        @Override
        public List<QueryAggregated> getAggregatees() {
            return this.createQuery().getAggregatees();
        }

        @Override
        public List<QueryOwned> getOwnees() {
            return this.createQuery().getOwnees();
        }

        @Override
        @Deprecated
        public void setNextOffset(Object nextOffset) {
            this.createQuery().setNextOffset(nextOffset);
        }

        @Override
        public Class<T> getQueriedClass() {
            return this.clazz;
        }

        @Override
        public Query<T> paginate(int limit) {
            return this.createQuery().paginate(limit);
        }

        @Override
        public Query<T> limit(int limit) {
            return this.createQuery().limit(limit);
        }

        @Override
        public Query<T> offset(Object offset) {
            return this.createQuery().offset(offset);
        }

        @Override
        public Query<T> customize(QueryOption ... options) {
            return this.createQuery().customize(options);
        }

        @Override
        public QueryOption option(int option) {
            return this.createQuery().option(option);
        }

        @Override
        public Map<Integer, QueryOption> options() {
            return this.createQuery().options();
        }

        @Override
        public Query<T> stateful() {
            return this.createQuery().stateful();
        }

        @Override
        public Query<T> stateless() {
            return this.createQuery().stateless();
        }

        @Override
        public Query<T> release() {
            return this.createQuery().release();
        }

        @Override
        public Query<T> resetData() {
            return this.createQuery().resetData();
        }

        @Override
        public Query<T> search(String match, String ... fields) {
            return this.createQuery().search(match, fields);
        }

        @Override
        public Query<T> search(String match, QueryOption opt, String ... fields) {
            return this.createQuery().search(match, opt, fields);
        }

        @Override
        public int update(Map<String, ?> fieldValues) {
            return this.createQuery().update(fieldValues);
        }

        @Override
        public Query<T> nextPage() {
            return this.createQuery().nextPage();
        }

        @Override
        public Query<T> previousPage() {
            return this.createQuery().previousPage();
        }

        public String dump() {
            return this.createQuery().dump(new QueryOption[0]);
        }

        public Query<T> restore(String dump) {
            return this.createQuery().restore(dump, new QueryOption[0]);
        }

        @Override
        public QueryAsync<T> async() {
            return this.createQuery().async();
        }

        @Override
        public T getByKey(Object key) {
            return this.createQuery().getByKey(key);
        }

        @Override
        public PersistenceManager getPersistenceManager() {
            return this.obj.getPersistenceManager();
        }

        @Override
        public String dump(QueryOption ... options) {
            return this.createQuery().dump(options);
        }

        @Override
        public void dump(OutputStream os, QueryOption ... options) {
            this.createQuery().dump(os, options);
        }

        @Override
        public Query<T> restore(String dump, QueryOption ... options) {
            return this.createQuery().restore(dump, options);
        }

        @Override
        public Query<T> restore(InputStream dump, QueryOption ... options) {
            return this.createQuery().restore(dump, options);
        }
    }
}

