/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import siena.Json;
import siena.SienaException;

class Parser {
    private int n;
    private Reader s;
    private char last;
    private boolean more;

    public Parser(String s) {
        this.s = new StringReader(s);
    }

    public Parser(BufferedReader reader) {
        this.s = reader;
    }

    public Json parse() {
        try {
            this.get();
            return this.next();
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
    }

    private Json next() throws IOException {
        char c = this.last;
        if (c == '\"') {
            String s = "";
            block11: while (true) {
                if ((c = this.getc()) == '\\') {
                    c = this.getc();
                    switch (c) {
                        case 'b': {
                            s = String.valueOf(s) + '\b';
                            continue block11;
                        }
                        case 'f': {
                            s = String.valueOf(s) + '\f';
                            continue block11;
                        }
                        case 'n': {
                            s = String.valueOf(s) + '\n';
                            continue block11;
                        }
                        case 'r': {
                            s = String.valueOf(s) + '\r';
                            continue block11;
                        }
                        case 't': {
                            s = String.valueOf(s) + '\t';
                            continue block11;
                        }
                        case '\"': {
                            s = String.valueOf(s) + '\"';
                            continue block11;
                        }
                        case '\\': {
                            s = String.valueOf(s) + '\\';
                            continue block11;
                        }
                        case '/': {
                            s = String.valueOf(s) + '/';
                            continue block11;
                        }
                        case 'u': {
                            char u = (char)Integer.parseInt(new String(new char[]{this.getc(), this.getc(), this.getc(), this.getc()}), 16);
                            s = String.valueOf(s) + u;
                            continue block11;
                        }
                    }
                    throw new SienaException("Invalid escape character: \\" + c + " at position " + this.n);
                }
                if (c == '\"') {
                    if (this.more()) {
                        this.get();
                    }
                    return new Json(s);
                }
                s = String.valueOf(s) + c;
            }
        }
        if (c == '[') {
            Json result = Json.list(new Object[0]);
            this.get();
            c = this.ignoreWS();
            if (c == ']') {
                if (this.more()) {
                    this.get();
                }
                return result;
            }
            while (true) {
                result.add(this.next());
                c = this.ignoreWS();
                if (c == ']') {
                    if (this.more()) {
                        this.get();
                    }
                    return result;
                }
                if (c != ',') {
                    throw new SienaException("expected ',' or ']' at character " + this.n);
                }
                this.get();
                c = this.ignoreWS();
            }
        }
        if (c == '{') {
            Json result = Json.map();
            this.get();
            c = this.ignoreWS();
            if (c == '}') {
                if (this.more()) {
                    this.get();
                }
                return result;
            }
            while (true) {
                Json k;
                if (!(k = this.next()).isString()) {
                    throw new SienaException("find non-string key at character " + this.n);
                }
                String key = k.str();
                c = this.ignoreWS();
                if (c != ':') {
                    throw new SienaException("expected ':' at character " + this.n);
                }
                this.get();
                c = this.ignoreWS();
                Json value = this.next();
                result.put(key, value);
                c = this.ignoreWS();
                if (c == '}') {
                    if (this.more()) {
                        this.get();
                    }
                    return result;
                }
                if (c != ',') {
                    throw new SienaException("expected: ',' or '}'' at character " + this.n);
                }
                this.get();
                c = this.ignoreWS();
            }
        }
        if (c == 't') {
            if (this.getc() != 'r' || this.getc() != 'u' || this.getc() != 'e') {
                throw new SienaException("expected 'true' at character " + this.n);
            }
            if (this.more()) {
                this.get();
            }
            return new Json(Boolean.TRUE);
        }
        if (c == 'f') {
            if (this.getc() != 'a' || this.getc() != 'l' || this.getc() != 's' || this.getc() != 'e') {
                throw new SienaException("expected 'false' at character " + this.n);
            }
            if (this.more()) {
                this.get();
            }
            return new Json(Boolean.FALSE);
        }
        if (c == 'n') {
            if (this.getc() != 'u' || this.getc() != 'l' || this.getc() != 'l') {
                throw new SienaException("expected 'true' at character " + this.n);
            }
            if (this.more()) {
                this.get();
            }
            return new Json(null);
        }
        if (c == '-' || c >= '0' && c <= '9') {
            String s = "";
            boolean d = false;
            do {
                s = String.valueOf(s) + c;
                if (!this.more()) break;
                c = this.getc();
                if (c != '.' && c != 'e' && c != 'E') continue;
                d = true;
            } while (c >= '0' && c <= '9' || c == 'e' || c == 'E' || c == '.' || c == '+' || c == '-');
            if (d) {
                return new Json(Double.parseDouble(s));
            }
            return new Json(Long.parseLong(s));
        }
        throw new SienaException("expected: '{', '[', '\"', true, false, null, or a number at " + this.n);
    }

    private char ignoreWS() throws IOException {
        char c = this.last;
        while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
            c = this.getc();
        }
        return c;
    }

    private void get() throws IOException {
        int r = this.s.read();
        ++this.n;
        this.more = r != -1;
        this.last = (char)r;
    }

    private boolean more() {
        return this.more;
    }

    private char getc() throws IOException {
        this.get();
        return this.last;
    }
}

