/*
 * Decompiled with CFR 0.152.
 */
package play.modules.siena;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.scanner.ScannerException;
import play.Logger;
import play.Play;
import play.data.binding.Binder;
import play.db.DB;
import play.db.DBPlugin;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.exceptions.YAMLException;
import play.libs.IO;
import play.modules.siena.SienaModelUtils;
import play.modules.siena.SienaPlugin;
import play.templates.TemplateLoader;
import play.vfs.VirtualFile;
import siena.ClassInfo;
import siena.Filter;
import siena.Json;
import siena.Query;
import siena.Util;
import siena.embed.Embedded;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SienaFixtures {
    static Pattern keyPattern = Pattern.compile("([^(]+)\\(([^)]+)\\)");
    static Map<String, Object> idCache = new HashMap<String, Object>();
    static String[] dontDeleteTheseTables = new String[]{"play_evolutions"};

    public static void executeSQL(String sqlScript) {
        for (String sql : sqlScript.split(";")) {
            if (sql.trim().length() <= 0) continue;
            DB.execute((String)sql);
        }
    }

    public static void executeSQL(File sqlScript) {
        SienaFixtures.executeSQL(IO.readContentAsString((File)sqlScript));
    }

    public static void delete(Class<?> ... types) {
        idCache.clear();
        SienaFixtures.disableForeignKeyConstraints();
        for (Class<?> type : types) {
            try {
                if (!ClassInfo.isModel(type)) continue;
                SienaPlugin.pm().createQuery(type).delete();
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)("While deleting " + type + " instances"), (Object[])new Object[0]);
            }
        }
        SienaFixtures.enableForeignKeyConstraints();
        Play.pluginCollection.afterFixtureLoad();
    }

    public static void delete(List<Class> classes) {
        SienaFixtures.delete(classes.toArray(new Class[classes.size()]));
    }

    public static void deleteAllModels() {
        SienaFixtures.delete(SienaModelUtils.getSienaClasses());
    }

    @Deprecated
    public static void deleteAll() {
        SienaFixtures.deleteDatabase();
    }

    public static void deleteDatabase() {
        String dbType = SienaPlugin.dbType();
        if (dbType.startsWith("sql")) {
            try {
                idCache.clear();
                ArrayList<String> names = new ArrayList<String>();
                for (Class c : SienaModelUtils.getSienaClasses()) {
                    ClassInfo ci = ClassInfo.getClassInfo((Class)c);
                    names.add(ci.tableName);
                }
                SienaFixtures.disableForeignKeyConstraints();
                for (String name : names) {
                    if (Arrays.binarySearch(dontDeleteTheseTables, name) >= 0) continue;
                    if (Logger.isTraceEnabled()) {
                        Logger.trace((String)"Dropping content of table %s", (Object[])new Object[]{name});
                    }
                    DB.execute((String)(SienaFixtures.getDeleteTableStmt(name) + ";"));
                }
                SienaFixtures.enableForeignKeyConstraints();
                Play.pluginCollection.afterFixtureLoad();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot delete all table data : " + e.getMessage(), e);
            }
        } else {
            SienaFixtures.deleteAllModels();
        }
    }

    @Deprecated
    public static void load(String name) {
        SienaFixtures.loadModels(name);
    }

    public static void loadModels(String name) {
        VirtualFile yamlFile = null;
        try {
            VirtualFile vf;
            Iterator i$ = Play.javaPath.iterator();
            while (i$.hasNext() && ((yamlFile = (vf = (VirtualFile)i$.next()).child(name)) == null || !yamlFile.exists())) {
            }
            if (yamlFile == null) {
                throw new RuntimeException("Cannot load fixture " + name + ", the file was not found");
            }
            Yaml yaml = new Yaml();
            String renderedYaml = TemplateLoader.load(yamlFile).render();
            Object o = yaml.load(renderedYaml);
            if (o instanceof LinkedHashMap) {
                LinkedHashMap objects = (LinkedHashMap)o;
                for (Object key : objects.keySet()) {
                    Matcher matcher = keyPattern.matcher(key.toString().trim());
                    if (!matcher.matches()) continue;
                    String type = matcher.group(1);
                    String id = matcher.group(2);
                    if (!type.startsWith("models.")) {
                        type = "models." + type;
                    }
                    if (idCache.containsKey(type + "-" + id)) {
                        throw new RuntimeException("Cannot load fixture " + name + ", duplicate id '" + id + "' for type " + type);
                    }
                    HashMap<String, String[]> params = new HashMap<String, String[]>();
                    if (objects.get(key) == null) {
                        objects.put(key, new HashMap());
                    }
                    SienaFixtures.serialize((Map)objects.get(key), "object", params);
                    Class cType = Play.classloader.loadClass(type);
                    SienaFixtures.resolveDependencies(cType, params);
                    Object model = Binder.bind((String)"object", (Class)cType, (Type)cType, null, params);
                    ArrayList<Object> queryObj = new ArrayList<Object>();
                    for (Field f : model.getClass().getFields()) {
                        Object obj;
                        if (f.getType().isAssignableFrom(Map.class)) {
                            f.set(model, ((Map)objects.get(key)).get(f.getName()));
                            continue;
                        }
                        if (f.getType().equals(byte[].class)) {
                            f.set(model, ((Map)objects.get(key)).get(f.getName()));
                            continue;
                        }
                        if (Json.class.isAssignableFrom(f.getType())) {
                            obj = ((Map)objects.get(key)).get(f.getName());
                            Json json = new Json(obj);
                            if (json == null) continue;
                            f.set(model, json);
                            continue;
                        }
                        if (f.isAnnotationPresent(Embedded.class) && List.class.isAssignableFrom(f.getType())) {
                            obj = ((Map)objects.get(key)).get(f.getName());
                            f.set(model, obj);
                            continue;
                        }
                        if (!Query.class.isAssignableFrom(f.getType())) continue;
                        Class fieldType = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        String ownerFieldName = f.getAnnotation(Filter.class).value();
                        ArrayList linkedKeys = (ArrayList)((Map)objects.get(key)).get(f.getName());
                        if (linkedKeys == null) continue;
                        for (String linkedKey : linkedKeys) {
                            Object linkedId = idCache.get(fieldType.getName() + "-" + linkedKey);
                            if (linkedId == null) {
                                throw new RuntimeException("YAML AutoQuery mapping: linkedObj of type:" + fieldType.getName() + " and id:" + linkedKey + " was not found");
                            }
                            Object linkedObj = SienaPlugin.pm().getByKey(fieldType, linkedId);
                            if (linkedObj != null) {
                                Util.setField((Object)linkedObj, (Field)fieldType.getField(ownerFieldName), (Object)model);
                                queryObj.add(linkedObj);
                                continue;
                            }
                            throw new RuntimeException("YAML AutoQuery mapping: linkedObj of type:" + fieldType.getName() + " and id:" + linkedKey + " was not found");
                        }
                    }
                    SienaPlugin.pm().save(model);
                    if (!queryObj.isEmpty()) {
                        SienaPlugin.pm().save(queryObj);
                    }
                    Class tType = cType;
                    while (!tType.equals(Object.class)) {
                        idCache.put(tType.getName() + "-" + id, SienaModelUtils.keyValue(model));
                        tType = tType.getSuperclass();
                    }
                }
            }
            Play.pluginCollection.afterFixtureLoad();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + e.getMessage() + " was not found", e);
        }
        catch (ScannerException e) {
            throw new YAMLException(e, yamlFile);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load fixture " + name + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static void load(String ... names) {
        for (String name : names) {
            SienaFixtures.loadModels(name);
        }
    }

    public static void loadModels(String ... names) {
        for (String name : names) {
            SienaFixtures.loadModels(name);
        }
    }

    public static void load(List<String> names) {
        SienaFixtures.loadModels(names);
    }

    public static void loadModels(List<String> names) {
        String[] tNames = new String[names.size()];
        for (int i = 0; i < tNames.length; ++i) {
            tNames[i] = names.get(i);
        }
        SienaFixtures.load(tNames);
    }

    public static Object loadYaml(String name) {
        return SienaFixtures.loadYaml(name, Object.class);
    }

    public static List<?> loadYamlAsList(String name) {
        return (List)SienaFixtures.loadYaml(name);
    }

    public static Map<?, ?> loadYamlAsMap(String name) {
        return (Map)SienaFixtures.loadYaml(name);
    }

    public static <T> T loadYaml(String name, Class<T> clazz) {
        Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(clazz, (ClassLoader)Play.classloader));
        yaml.setBeanAccess(BeanAccess.FIELD);
        return SienaFixtures.loadYaml(name, yaml);
    }

    public static <T> T loadYaml(String name, Yaml yaml) {
        VirtualFile yamlFile = null;
        try {
            VirtualFile vf;
            Iterator i$ = Play.javaPath.iterator();
            while (i$.hasNext() && ((yamlFile = (vf = (VirtualFile)i$.next()).child(name)) == null || !yamlFile.exists())) {
            }
            InputStream is = Play.classloader.getResourceAsStream(name);
            if (is == null) {
                throw new RuntimeException("Cannot load fixture " + name + ", the file was not found");
            }
            Object o = yaml.load(is);
            return (T)o;
        }
        catch (ScannerException e) {
            throw new YAMLException(e, yamlFile);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load fixture " + name + ": " + e.getMessage(), e);
        }
    }

    public static void deleteDirectory(String path) {
        try {
            FileUtils.deleteDirectory((File)Play.getFile((String)path));
        }
        catch (IOException ex) {
            throw new UnexpectedException((Throwable)ex);
        }
    }

    static void serialize(Map<?, ?> values, String prefix, Map<String, String[]> serialized) {
        for (Object key : values.keySet()) {
            Object value = values.get(key);
            if (value == null) continue;
            if (value instanceof Map) {
                SienaFixtures.serialize((Map)value, prefix + "." + key, serialized);
                continue;
            }
            if (value instanceof Date) {
                serialized.put(prefix + "." + key.toString(), new String[]{new SimpleDateFormat("'ISO8601:'yyyy-MM-dd'T'HH:mm:ssZ").format((Date)value)});
                continue;
            }
            if (value instanceof List) {
                List l = (List)value;
                String[] r = new String[l.size()];
                int i = 0;
                for (Object el : l) {
                    r[i++] = el.toString();
                }
                serialized.put(prefix + "." + key.toString(), r);
                continue;
            }
            if (value instanceof String && value.toString().matches("<<<\\s*\\{[^}]+}\\s*")) {
                Matcher m = Pattern.compile("<<<\\s*\\{([^}]+)}\\s*").matcher(value.toString());
                m.find();
                String file = m.group(1);
                VirtualFile f = Play.getVirtualFile((String)file);
                if (f == null || !f.exists()) continue;
                serialized.put(prefix + "." + key.toString(), new String[]{f.contentAsString()});
                continue;
            }
            serialized.put(prefix + "." + key.toString(), new String[]{value.toString()});
        }
    }

    static void resolveDependencies(Class<?> type, Map<String, String[]> serialized) {
        for (Model.Property field : SienaModelUtils.listProperties(SienaPlugin.pm(), type)) {
            if (!field.isRelation || field.field.isAnnotationPresent(Embedded.class) && !ClassInfo.isModel(field.field.getType())) continue;
            String[] ids = serialized.get("object." + field.name);
            if (ids != null) {
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    id = field.relationType.getName() + "-" + id;
                    if (!idCache.containsKey(id)) {
                        throw new RuntimeException("No previous reference found for object of type " + field.name + " with key " + ids[i]);
                    }
                    ids[i] = idCache.get(id).toString();
                }
            }
            serialized.remove("object." + field.name);
            serialized.put("object." + field.name + "." + SienaModelUtils.keyName(field.relationType), ids);
        }
    }

    private static void disableForeignKeyConstraints() {
        if (DBPlugin.url.startsWith("jdbc:oracle:")) {
            DB.execute((String)"begin\nfor i in (select constraint_name, table_name from user_constraints where constraint_type ='R'\nand status = 'ENABLED') LOOP\nexecute immediate 'alter table '||i.table_name||' disable constraint '||i.constraint_name||'';\nend loop;\nend;");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:hsqldb:")) {
            DB.execute((String)"SET REFERENTIAL_INTEGRITY FALSE");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:h2:")) {
            DB.execute((String)"SET REFERENTIAL_INTEGRITY FALSE");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:mysql:")) {
            DB.execute((String)"SET foreign_key_checks = 0;");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:postgresql:")) {
            DB.execute((String)"SET CONSTRAINTS ALL DEFERRED");
            return;
        }
        Logger.warn((String)("Fixtures : unable to disable constraints, unsupported database : " + DBPlugin.url), (Object[])new Object[0]);
    }

    private static void enableForeignKeyConstraints() {
        if (DBPlugin.url.startsWith("jdbc:oracle:")) {
            DB.execute((String)"begin\nfor i in (select constraint_name, table_name from user_constraints where constraint_type ='R'\nand status = 'DISABLED') LOOP\nexecute immediate 'alter table '||i.table_name||' enable constraint '||i.constraint_name||'';\nend loop;\nend;");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:hsqldb:")) {
            DB.execute((String)"SET REFERENTIAL_INTEGRITY TRUE");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:h2:")) {
            DB.execute((String)"SET REFERENTIAL_INTEGRITY TRUE");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:mysql:")) {
            DB.execute((String)"SET foreign_key_checks = 1;");
            return;
        }
        if (DBPlugin.url.startsWith("jdbc:postgresql:")) {
            return;
        }
        Logger.warn((String)("Fixtures : unable to enable constraints, unsupported database : " + DBPlugin.url), (Object[])new Object[0]);
    }

    static String getDeleteTableStmt(String name) {
        if (DBPlugin.url.startsWith("jdbc:mysql:")) {
            return "TRUNCATE TABLE " + name;
        }
        if (DBPlugin.url.startsWith("jdbc:postgresql:")) {
            return "TRUNCATE TABLE " + name + " cascade";
        }
        if (DBPlugin.url.startsWith("jdbc:oracle:")) {
            return "TRUNCATE TABLE " + name;
        }
        return "DELETE FROM " + name;
    }
}

