/*
 * Decompiled with CFR 0.152.
 */
package play.modules.siena;

import com.google.gson.JsonParseException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import play.Logger;
import play.Play;
import play.data.binding.BeanWrapper;
import play.data.binding.Binder;
import play.data.validation.Validation;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.siena.SienaPlugin;
import siena.ClassInfo;
import siena.Entity;
import siena.Filter;
import siena.Json;
import siena.Model;
import siena.PersistenceManager;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.embed.Embedded;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SienaModelUtils {
    private static final long serialVersionUID = 949918995355310821L;

    public static <T> T create(Class<T> type, String name, Map<String, String[]> params) {
        return SienaModelUtils.create(type, name, params, new Annotation[0]);
    }

    public static <T> T create(Class<T> type, String name, Map<String, String[]> params, Annotation[] annotations) {
        Object model = Util.createObjectInstance(type);
        return (T)SienaModelUtils.edit(model, name, params, annotations);
    }

    public static Field keyField(Class<?> clazz) {
        return ClassInfo.getClassInfo(clazz).getIdField();
    }

    public static Class<?> keyType(Class<?> clazz) {
        Field f = SienaModelUtils.keyField(clazz);
        return f == null ? null : f.getType();
    }

    public static String keyName(Class<?> clazz) {
        Field f = SienaModelUtils.keyField(clazz);
        return f == null ? null : f.getName();
    }

    public static Object keyValue(Object obj) {
        if (obj == null) {
            return null;
        }
        Field k = SienaModelUtils.keyField(obj.getClass());
        try {
            return null != k ? k.get(obj) : null;
        }
        catch (Exception ex) {
            throw new UnexpectedException((Throwable)ex);
        }
    }

    public static <T> T edit(T o, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            BeanWrapper bw = new BeanWrapper(o.getClass());
            Class<?> spClazz = o.getClass();
            for (Field field : ClassInfo.getClassInfo(spClazz).allExtendedFields) {
                String[] jsonStr;
                boolean isEntity = false;
                boolean isJson = false;
                String relation = null;
                boolean multiple = false;
                String owner = null;
                Class<?> clazz = field.getType();
                if (ClassInfo.isModel(clazz)) {
                    isEntity = true;
                    relation = clazz.getName();
                } else if (Query.class.isAssignableFrom(clazz)) {
                    isEntity = true;
                    multiple = true;
                    Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    relation = fieldType.getName();
                    owner = field.getAnnotation(Filter.class).value();
                    if (owner == null || "".equals(owner)) {
                        owner = o.getClass().getName().toLowerCase();
                    }
                } else if (Json.class.isAssignableFrom(clazz)) {
                    isJson = true;
                } else if (field.isAnnotationPresent(Embedded.class)) {
                    multiple = List.class.isAssignableFrom(clazz) ? true : Map.class.isAssignableFrom(clazz);
                } else if (byte[].class.isAssignableFrom(clazz)) {
                    String[] posted = params.get(name + "." + field.getName());
                    Object val = field.get(o);
                }
                if (isEntity) {
                    String[] ids;
                    String idName;
                    Class relClass;
                    if (multiple) {
                        relClass = Play.classloader.loadClass(relation);
                        idName = ClassInfo.getSimplestColumnName((Field)SienaModelUtils.keyField(relClass));
                        ids = params.get(name + "." + field.getName() + "@" + idName);
                        if (ids == null) {
                            ids = params.get(name + "." + field.getName() + "." + idName);
                        }
                        if (ids == null) continue;
                        params.remove(name + "." + field.getName() + "." + idName);
                        params.remove(name + "." + field.getName() + "@" + idName);
                        for (String _id : ids) {
                            if (_id.equals("")) continue;
                            Model res = (Model)Model.all((Class)relClass).filter(idName, Binder.directBind((String)_id, SienaModelUtils.keyType(relClass))).get();
                            if (res != null) {
                                Field ownerField = Util.getField((Class)relClass, (String)owner);
                                if (ownerField == null) {
                                    throw new UnexpectedException("In related Model " + relClass.getName() + " owner field '" + owner + "' not found");
                                }
                                Util.setField((Object)res, (Field)ownerField, o);
                                res.save();
                                continue;
                            }
                            Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{_id});
                        }
                        continue;
                    }
                    relClass = Play.classloader.loadClass(relation);
                    idName = ClassInfo.getSimplestColumnName((Field)SienaModelUtils.keyField(relClass));
                    ids = params.get(name + "." + field.getName() + "@" + idName);
                    if (ids == null) {
                        ids = params.get(name + "." + field.getName() + "." + idName);
                    }
                    if (ids != null && ids.length > 0 && !ids[0].equals("")) {
                        params.remove(name + "." + field.getName() + "." + idName);
                        params.remove(name + "." + field.getName() + "@" + idName);
                        Model res = (Model)Model.all((Class)relClass).filter(idName, Binder.directBind((String)ids[0], SienaModelUtils.keyType(relClass))).get();
                        if (res != null) {
                            bw.set(field.getName(), o, (Object)res);
                            continue;
                        }
                        Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{ids[0]});
                        continue;
                    }
                    if (ids == null || ids.length <= 0 || !ids[0].equals("")) continue;
                    bw.set(field.getName(), o, null);
                    params.remove(name + "." + field.getName() + "." + idName);
                    params.remove(name + "." + field.getName() + "@" + idName);
                    continue;
                }
                if (!isJson || (jsonStr = params.get(name + "." + field.getName())) == null || jsonStr.length <= 0 || jsonStr[0].equals("")) continue;
                try {
                    Json json = Json.loads((String)jsonStr[0]);
                    if (json != null) {
                        bw.set(field.getName(), o, (Object)json);
                        params.remove(name + "." + field.getName());
                        continue;
                    }
                    Validation.addError((String)(name + "." + field.getName()), (String)"validation.notParsable", (String[])new String[0]);
                }
                catch (JsonParseException ex) {
                    ex.printStackTrace();
                    Logger.error((String)"json parserdelete exception:%s", (Object[])new Object[]{ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()});
                    Validation.addError((String)(name + "." + field.getName()), (String)"validation.notParsable", (String[])new String[]{ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()});
                }
                catch (SienaException ex) {
                    ex.printStackTrace();
                    Logger.error((String)"json parserdelete exception:%s", (Object[])new Object[]{ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()});
                    Validation.addError((String)(name + "." + field.getName()), (String)"validation.notParsable", (String[])new String[]{ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()});
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                    Logger.error((String)"json parser exception:%s", (Object[])new Object[]{ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()});
                    Validation.addError((String)(name + "." + field.getName()), (String)"validation.notParsable", (String[])new String[]{ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()});
                }
            }
            bw.bind(name, o.getClass(), params, "", o, o.getClass().getAnnotations());
            return o;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static List<Class> getSienaClasses() {
        List classes = Play.classloader.getAssignableClasses(Model.class);
        List entityClasses = Play.classloader.getAnnotatedClasses(Entity.class);
        for (Class cl : entityClasses) {
            if (classes.contains(cl)) continue;
            classes.add(cl);
        }
        return classes;
    }

    public static List<Model.Property> listProperties(PersistenceManager pm, Class<?> clazz) {
        ArrayList<Model.Property> properties = new ArrayList<Model.Property>();
        LinkedHashSet fields = new LinkedHashSet();
        for (Field f : ClassInfo.getClassInfo(clazz).allExtendedFields) {
            Model.Property mp = SienaModelUtils.buildProperty(f, pm);
            if (mp == null) continue;
            properties.add(mp);
        }
        return properties;
    }

    public static Model.Property buildProperty(Field field, final PersistenceManager pm) {
        Class fieldType;
        Class<?> clazz;
        Model.Property modelProperty = new Model.Property();
        modelProperty.type = clazz = field.getType();
        modelProperty.field = field;
        if (ClassInfo.isModel(clazz)) {
            modelProperty.isRelation = true;
            modelProperty.relationType = clazz;
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return pm.createQuery(clazz).fetch();
                }
            };
        }
        if (Query.class.isAssignableFrom(clazz)) {
            fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            modelProperty.isRelation = true;
            modelProperty.isMultiple = true;
            modelProperty.relationType = fieldType;
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return pm.createQuery(fieldType).fetch();
                }
            };
        }
        if (clazz.isEnum()) {
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return Arrays.asList(clazz.getEnumConstants());
                }
            };
        }
        if (Json.class.isAssignableFrom(clazz)) {
            modelProperty.type = String.class;
        }
        if (field.isAnnotationPresent(Embedded.class)) {
            if (List.class.isAssignableFrom(clazz)) {
                fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                modelProperty.isRelation = true;
                modelProperty.isMultiple = true;
                modelProperty.relationType = fieldType;
            } else if (Map.class.isAssignableFrom(clazz)) {
                fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                modelProperty.isRelation = true;
                modelProperty.isMultiple = true;
                modelProperty.relationType = fieldType;
            } else {
                modelProperty.isRelation = true;
                modelProperty.isMultiple = false;
                modelProperty.relationType = clazz;
            }
        }
        modelProperty.name = field.getName();
        if (clazz.equals(String.class)) {
            modelProperty.isSearchable = true;
        }
        if (ClassInfo.isGenerated((Field)field)) {
            modelProperty.isGenerated = true;
        }
        return modelProperty;
    }

    public static <T> T findById(Class<T> clazz, Object id) {
        if (id == null) {
            return null;
        }
        try {
            return (T)SienaPlugin.pm().getByKey(clazz, Binder.directBind((String)id.toString(), SienaModelUtils.keyType(clazz)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> void processWhere(Query<T> q, String where) {
        String[] propValPairs;
        if ("".equals(where = null != where ? where.trim() : "") || "null".equalsIgnoreCase(where)) {
            return;
        }
        for (String propVal : propValPairs = where.split("(and|&&)")) {
            String prop;
            String[] sa;
            if (propVal.contains("=")) {
                sa = propVal.split("=");
                if (sa.length != 2) {
                    throw new IllegalArgumentException("invalid where clause: " + where);
                }
                prop = sa[0];
                String val = sa[1];
                Logger.trace((String)"where prop val pair found: %1$s = %2$s", (Object[])new Object[]{prop, val});
                prop = prop.replaceAll("[\"' ]", "");
                if (val.matches("[\"'].*[\"']")) {
                    val = val.replaceAll("[\"' ]", "");
                    q.filter(prop, (Object)val);
                    continue;
                }
                if (val.matches("[-+]?\\d+\\.\\d+")) {
                    q.filter(prop, (Object)Float.valueOf(Float.parseFloat(val)));
                    continue;
                }
                if (val.matches("[-+]?\\d+")) {
                    q.filter(prop, (Object)Integer.parseInt(val));
                    continue;
                }
                if (val.matches("(false|true|FALSE|TRUE|False|True)")) {
                    q.filter(prop, (Object)Boolean.parseBoolean(val));
                    continue;
                }
                q.filter(prop, (Object)val);
                continue;
            }
            if (propVal.contains(" in ")) {
                sa = propVal.split(" in ");
                if (sa.length != 2) {
                    throw new IllegalArgumentException("invalid where clause: " + where);
                }
                prop = sa[0].trim();
                String val0 = sa[1].trim();
                if (!val0.matches("\\(.*\\)")) {
                    throw new IllegalArgumentException("invalid where clause: " + where);
                }
                val0 = val0.replaceAll("[\\(\\)]", "");
                String[] vals = val0.split(",");
                ArrayList<Object> l = new ArrayList<Object>();
                for (String val : vals) {
                    if (val.matches("[-+]?\\d+\\.\\d+")) {
                        l.add(Float.valueOf(Float.parseFloat(val)));
                        continue;
                    }
                    if (val.matches("[-+]?\\d+")) {
                        l.add(Integer.parseInt(val));
                        continue;
                    }
                    if (val.matches("(false|true|FALSE|TRUE|False|True)")) {
                        l.add(Boolean.parseBoolean(val));
                        continue;
                    }
                    l.add(val);
                }
                q.filter(prop + " IN ", l);
                continue;
            }
            throw new IllegalArgumentException("invalid where clause: " + where);
        }
    }

    public static <T> List<T> fetch(PersistenceManager pm, Class<T> clazz, int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
        Query q = pm.createQuery(clazz);
        Field keyField = SienaModelUtils.keyField(clazz);
        if (orderBy == null) {
            if (order == null) {
                q.order(keyField.getName());
            } else if (order.equals("+")) {
                q.order(keyField.getName());
            } else if (order.equals("-")) {
                q.order(order + keyField.getName());
            } else if (order.equals("ASC")) {
                q.order(keyField.getName());
            } else if (order.equals("DESC")) {
                q.order("-" + keyField.getName());
            } else {
                q.order(keyField.getName());
            }
        } else if (order == null) {
            q.order(orderBy);
        } else if (order.equals("+")) {
            q.order(orderBy);
        } else if (order.equals("-")) {
            q.order(order + orderBy);
        } else if (order.equals("ASC")) {
            q.order(orderBy);
        } else if (order.equals("DESC")) {
            q.order("-" + orderBy);
        } else {
            q.order(orderBy);
        }
        if (keywords != null) {
            if (searchFields != null && searchFields.size() != 0) {
                q.search(keywords, (String[])searchFields.toArray());
            } else {
                ClassInfo ci = ClassInfo.getClassInfo(clazz);
                String[] strs = new String[ci.allFields.size()];
                int i = 0;
                for (Field f : ClassInfo.getClassInfo(clazz).allFields) {
                    strs[i++] = f.getName();
                }
                q.search(keywords, strs);
            }
        }
        SienaModelUtils.processWhere(q, where);
        return q.fetch(size, (Object)offset);
    }

    public static <T> Long count(PersistenceManager pm, Class<T> clazz, List<String> searchFields, String keywords, String where) {
        Query q = pm.createQuery(clazz);
        if (keywords != null) {
            if (searchFields != null && searchFields.size() != 0) {
                q.search(keywords, (String[])searchFields.toArray());
            } else {
                ClassInfo ci = ClassInfo.getClassInfo(clazz);
                String[] strs = new String[ci.allFields.size()];
                int i = 0;
                for (Field f : ClassInfo.getClassInfo(clazz).allFields) {
                    strs[i++] = f.getName();
                }
                q.search(keywords, strs);
            }
        }
        SienaModelUtils.processWhere(q, where);
        return new Long(q.count());
    }

    public static <T> void deleteAll(PersistenceManager pm, Class<T> clazz) {
        pm.createQuery(clazz).delete();
    }
}

