/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.List;
import org.apache.ddlutils.alteration.ForeignKeyChange;
import org.apache.ddlutils.alteration.Pair;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;

public abstract class ForeignKeyChangeImplBase
extends TableChangeImplBase
implements ForeignKeyChange {
    private List _referenceColumnNames = new ArrayList();

    public ForeignKeyChangeImplBase(String tableName, ForeignKey foreignKey) {
        super(tableName);
        int refIdx = 0;
        while (refIdx < foreignKey.getReferenceCount()) {
            Reference ref = foreignKey.getReference(refIdx);
            this._referenceColumnNames.add(new Pair(ref.getLocalColumnName(), ref.getForeignColumnName()));
            ++refIdx;
        }
    }

    @Override
    public ForeignKey findChangedForeignKey(Database model, boolean caseSensitive) {
        Table table = this.findChangedTable(model, caseSensitive);
        if (table != null) {
            int fkIdx = 0;
            while (fkIdx < table.getForeignKeyCount()) {
                ForeignKey curFk = table.getForeignKey(fkIdx);
                if (curFk.getReferenceCount() == this._referenceColumnNames.size()) {
                    int refIdx = 0;
                    while (refIdx < curFk.getReferenceCount()) {
                        Reference ref = curFk.getReference(refIdx);
                        Pair colNames = (Pair)this._referenceColumnNames.get(refIdx);
                        if (caseSensitive ? ref.getLocalColumnName().equals((String)colNames.getFirst()) && ref.getForeignColumnName().equals((String)colNames.getSecond()) : ref.getLocalColumnName().equalsIgnoreCase((String)colNames.getFirst()) && ref.getForeignColumnName().equalsIgnoreCase((String)colNames.getSecond())) {
                            return curFk;
                        }
                        ++refIdx;
                    }
                }
                ++fkIdx;
            }
        }
        return null;
    }
}

