/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.io.DdlUtilsXMLException;
import org.apache.ddlutils.io.ModelValidator;
import org.apache.ddlutils.io.PrettyPrintingXmlWriter;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.xml.sax.InputSource;

public class DatabaseIO {
    public static final String BASE64_ATTR_NAME = "base64";
    public static final String DDLUTILS_NAMESPACE = "http://db.apache.org/ddlutils/schema/1.1";
    public static final QName QNAME_ELEMENT_COLUMN = new QName("http://db.apache.org/ddlutils/schema/1.1", "column");
    public static final QName QNAME_ELEMENT_DATABASE = new QName("http://db.apache.org/ddlutils/schema/1.1", "database");
    public static final QName QNAME_ELEMENT_FOREIGN_KEY = new QName("http://db.apache.org/ddlutils/schema/1.1", "foreign-key");
    public static final QName QNAME_ELEMENT_INDEX = new QName("http://db.apache.org/ddlutils/schema/1.1", "index");
    public static final QName QNAME_ELEMENT_INDEX_COLUMN = new QName("http://db.apache.org/ddlutils/schema/1.1", "index-column");
    public static final QName QNAME_ELEMENT_REFERENCE = new QName("http://db.apache.org/ddlutils/schema/1.1", "reference");
    public static final QName QNAME_ELEMENT_TABLE = new QName("http://db.apache.org/ddlutils/schema/1.1", "table");
    public static final QName QNAME_ELEMENT_UNIQUE = new QName("http://db.apache.org/ddlutils/schema/1.1", "unique");
    public static final QName QNAME_ELEMENT_UNIQUE_COLUMN = new QName("http://db.apache.org/ddlutils/schema/1.1", "unique-column");
    public static final QName QNAME_ATTRIBUTE_AUTO_INCREMENT = new QName("http://db.apache.org/ddlutils/schema/1.1", "autoIncrement");
    public static final QName QNAME_ATTRIBUTE_DEFAULT = new QName("http://db.apache.org/ddlutils/schema/1.1", "default");
    public static final QName QNAME_ATTRIBUTE_DEFAULT_ID_METHOD = new QName("http://db.apache.org/ddlutils/schema/1.1", "defaultIdMethod");
    public static final QName QNAME_ATTRIBUTE_DESCRIPTION = new QName("http://db.apache.org/ddlutils/schema/1.1", "description");
    public static final QName QNAME_ATTRIBUTE_FOREIGN = new QName("http://db.apache.org/ddlutils/schema/1.1", "foreign");
    public static final QName QNAME_ATTRIBUTE_FOREIGN_TABLE = new QName("http://db.apache.org/ddlutils/schema/1.1", "foreignTable");
    public static final QName QNAME_ATTRIBUTE_JAVA_NAME = new QName("http://db.apache.org/ddlutils/schema/1.1", "javaName");
    public static final QName QNAME_ATTRIBUTE_LOCAL = new QName("http://db.apache.org/ddlutils/schema/1.1", "local");
    public static final QName QNAME_ATTRIBUTE_NAME = new QName("http://db.apache.org/ddlutils/schema/1.1", "name");
    public static final QName QNAME_ATTRIBUTE_ON_DELETE = new QName("http://db.apache.org/ddlutils/schema/1.1", "onDelete");
    public static final QName QNAME_ATTRIBUTE_ON_UPDATE = new QName("http://db.apache.org/ddlutils/schema/1.1", "onUpdate");
    public static final QName QNAME_ATTRIBUTE_PRIMARY_KEY = new QName("http://db.apache.org/ddlutils/schema/1.1", "primaryKey");
    public static final QName QNAME_ATTRIBUTE_REQUIRED = new QName("http://db.apache.org/ddlutils/schema/1.1", "required");
    public static final QName QNAME_ATTRIBUTE_SIZE = new QName("http://db.apache.org/ddlutils/schema/1.1", "size");
    public static final QName QNAME_ATTRIBUTE_TYPE = new QName("http://db.apache.org/ddlutils/schema/1.1", "type");
    public static final QName QNAME_ATTRIBUTE_VERSION = new QName("http://db.apache.org/ddlutils/schema/1.1", "version");
    private final Log _log = LogFactory.getLog(DatabaseIO.class);
    private boolean _validateXml = true;
    private boolean _useInternalDtd = true;

    public boolean isValidateXml() {
        return this._validateXml;
    }

    public void setValidateXml(boolean validateXml) {
        this._validateXml = validateXml;
    }

    public boolean isUseInternalDtd() {
        return this._useInternalDtd;
    }

    public void setUseInternalDtd(boolean useInternalDtd) {
        this._useInternalDtd = useInternalDtd;
    }

    public Database read(String filename) throws DdlUtilsXMLException {
        return this.read(new File(filename));
    }

    public Database read(File file) throws DdlUtilsXMLException {
        FileReader reader = null;
        if (this._validateXml) {
            try {
                try {
                    reader = new FileReader(file);
                    new ModelValidator().validate(new StreamSource(reader));
                }
                catch (IOException ex) {
                    throw new DdlUtilsXMLException(ex);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        this._log.warn((Object)("Could not close reader for file " + file.getAbsolutePath()));
                    }
                    reader = null;
                }
            }
        }
        try {
            reader = new FileReader(file);
            Database database = this.read(this.getXMLInputFactory().createXMLStreamReader(reader));
            return database;
        }
        catch (XMLStreamException ex) {
            throw new DdlUtilsXMLException(ex);
        }
        catch (IOException ex) {
            throw new DdlUtilsXMLException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    this._log.warn((Object)("Could not close reader for file " + file.getAbsolutePath()));
                }
            }
        }
    }

    public Database read(Reader reader) throws DdlUtilsXMLException {
        try {
            if (this._validateXml) {
                int len;
                StringBuffer tmpXml = new StringBuffer();
                char[] buf = new char[4096];
                while ((len = reader.read(buf)) >= 0) {
                    tmpXml.append(buf, 0, len);
                }
                new ModelValidator().validate(new StreamSource(new StringReader(tmpXml.toString())));
                return this.read(this.getXMLInputFactory().createXMLStreamReader(new StringReader(tmpXml.toString())));
            }
            return this.read(this.getXMLInputFactory().createXMLStreamReader(reader));
        }
        catch (XMLStreamException ex) {
            throw new DdlUtilsXMLException(ex);
        }
        catch (IOException ex) {
            throw new DdlUtilsXMLException(ex);
        }
    }

    public Database read(InputSource source) throws DdlUtilsXMLException {
        return this.read(source.getCharacterStream());
    }

    private XMLInputFactory getXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        return factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Database read(XMLStreamReader xmlReader) throws DdlUtilsXMLException {
        Database model;
        block6: {
            model = null;
            try {
                do {
                    if (xmlReader.getEventType() != 1) continue;
                    if (this.isSameAs(xmlReader.getName(), QNAME_ELEMENT_DATABASE)) {
                        model = this.readDatabaseElement(xmlReader);
                    }
                    break block6;
                } while (xmlReader.next() != 8);
                return null;
            }
            catch (IOException ex) {
                throw new DdlUtilsXMLException(ex);
            }
            catch (XMLStreamException ex) {
                throw new DdlUtilsXMLException(ex);
            }
        }
        if (model != null) {
            model.initialize();
        }
        return model;
    }

    private Database readDatabaseElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        Database model = new Database();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                model.setName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_DEFAULT_ID_METHOD)) {
                model.setIdMethod(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_VERSION)) {
                model.setVersion(xmlReader.getAttributeValue(idx));
            }
            ++idx;
        }
        this.readTableElements(xmlReader, model);
        this.consumeRestOfElement(xmlReader);
        return model;
    }

    private void readTableElements(XMLStreamReader xmlReader, Database model) throws XMLStreamException, IOException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            if (this.isSameAs(xmlReader.getName(), QNAME_ELEMENT_TABLE)) {
                model.addTable(this.readTableElement(xmlReader));
                continue;
            }
            this.readOverElement(xmlReader);
        }
    }

    private Table readTableElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        Table table = new Table();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                table.setName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_DESCRIPTION)) {
                table.setDescription(xmlReader.getAttributeValue(idx));
            }
            ++idx;
        }
        this.readTableSubElements(xmlReader, table);
        this.consumeRestOfElement(xmlReader);
        return table;
    }

    private void readTableSubElements(XMLStreamReader xmlReader, Table table) throws XMLStreamException, IOException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            QName elemQName = xmlReader.getName();
            if (this.isSameAs(elemQName, QNAME_ELEMENT_COLUMN)) {
                table.addColumn(this.readColumnElement(xmlReader));
                continue;
            }
            if (this.isSameAs(elemQName, QNAME_ELEMENT_FOREIGN_KEY)) {
                table.addForeignKey(this.readForeignKeyElement(xmlReader));
                continue;
            }
            if (this.isSameAs(elemQName, QNAME_ELEMENT_INDEX)) {
                table.addIndex(this.readIndexElement(xmlReader));
                continue;
            }
            if (this.isSameAs(elemQName, QNAME_ELEMENT_UNIQUE)) {
                table.addIndex(this.readUniqueElement(xmlReader));
                continue;
            }
            this.readOverElement(xmlReader);
        }
    }

    private Column readColumnElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        Column column = new Column();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                column.setName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_PRIMARY_KEY)) {
                column.setPrimaryKey(this.getAttributeValueAsBoolean(xmlReader, idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_REQUIRED)) {
                column.setRequired(this.getAttributeValueAsBoolean(xmlReader, idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_TYPE)) {
                column.setType(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_SIZE)) {
                column.setSize(this.getAttributeValueBeingNullAware(xmlReader, idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_DEFAULT)) {
                column.setDefaultValue(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_AUTO_INCREMENT)) {
                column.setAutoIncrement(this.getAttributeValueAsBoolean(xmlReader, idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_DESCRIPTION)) {
                column.setDescription(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_JAVA_NAME)) {
                column.setJavaName(xmlReader.getAttributeValue(idx));
            }
            ++idx;
        }
        this.consumeRestOfElement(xmlReader);
        return column;
    }

    private ForeignKey readForeignKeyElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        ForeignKey foreignKey = new ForeignKey();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_FOREIGN_TABLE)) {
                foreignKey.setForeignTableName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                foreignKey.setName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_ON_UPDATE)) {
                foreignKey.setOnUpdate(this.getAttributeValueAsCascadeEnum(xmlReader, idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_ON_DELETE)) {
                foreignKey.setOnDelete(this.getAttributeValueAsCascadeEnum(xmlReader, idx));
            }
            ++idx;
        }
        this.readReferenceElements(xmlReader, foreignKey);
        this.consumeRestOfElement(xmlReader);
        return foreignKey;
    }

    private void readReferenceElements(XMLStreamReader xmlReader, ForeignKey foreignKey) throws XMLStreamException, IOException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            QName elemQName = xmlReader.getName();
            if (this.isSameAs(elemQName, QNAME_ELEMENT_REFERENCE)) {
                foreignKey.addReference(this.readReferenceElement(xmlReader));
                continue;
            }
            this.readOverElement(xmlReader);
        }
    }

    private Reference readReferenceElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        Reference reference = new Reference();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_LOCAL)) {
                reference.setLocalColumnName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_FOREIGN)) {
                reference.setForeignColumnName(xmlReader.getAttributeValue(idx));
            }
            ++idx;
        }
        this.consumeRestOfElement(xmlReader);
        return reference;
    }

    private Index readIndexElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        NonUniqueIndex index = new NonUniqueIndex();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                index.setName(xmlReader.getAttributeValue(idx));
            }
            ++idx;
        }
        this.readIndexColumnElements(xmlReader, index);
        this.consumeRestOfElement(xmlReader);
        return index;
    }

    private Index readUniqueElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        UniqueIndex index = new UniqueIndex();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                index.setName(xmlReader.getAttributeValue(idx));
            }
            ++idx;
        }
        this.readUniqueColumnElements(xmlReader, index);
        this.consumeRestOfElement(xmlReader);
        return index;
    }

    private void readIndexColumnElements(XMLStreamReader xmlReader, Index index) throws XMLStreamException, IOException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            QName elemQName = xmlReader.getName();
            if (this.isSameAs(elemQName, QNAME_ELEMENT_INDEX_COLUMN)) {
                index.addColumn(this.readIndexColumnElement(xmlReader));
                continue;
            }
            this.readOverElement(xmlReader);
        }
    }

    private void readUniqueColumnElements(XMLStreamReader xmlReader, Index index) throws XMLStreamException, IOException {
        int eventType = 1;
        while (eventType != 2) {
            eventType = xmlReader.next();
            if (eventType != 1) continue;
            QName elemQName = xmlReader.getName();
            if (this.isSameAs(elemQName, QNAME_ELEMENT_UNIQUE_COLUMN)) {
                index.addColumn(this.readIndexColumnElement(xmlReader));
                continue;
            }
            this.readOverElement(xmlReader);
        }
    }

    private IndexColumn readIndexColumnElement(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        IndexColumn indexColumn = new IndexColumn();
        int idx = 0;
        while (idx < xmlReader.getAttributeCount()) {
            QName attrQName = xmlReader.getAttributeName(idx);
            if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_NAME)) {
                indexColumn.setName(xmlReader.getAttributeValue(idx));
            } else if (this.isSameAs(attrQName, QNAME_ATTRIBUTE_SIZE)) {
                indexColumn.setSize(this.getAttributeValueBeingNullAware(xmlReader, idx));
            }
            ++idx;
        }
        this.consumeRestOfElement(xmlReader);
        return indexColumn;
    }

    private boolean isSameAs(QName curElemQName, QName qName) {
        if (StringUtils.isEmpty((String)curElemQName.getNamespaceURI())) {
            return qName.getLocalPart().equals(curElemQName.getLocalPart());
        }
        return qName.equals(curElemQName);
    }

    private String getAttributeValueBeingNullAware(XMLStreamReader xmlReader, int attributeIdx) throws DdlUtilsXMLException {
        String value = xmlReader.getAttributeValue(attributeIdx);
        return "null".equalsIgnoreCase(value) ? null : value;
    }

    private boolean getAttributeValueAsBoolean(XMLStreamReader xmlReader, int attributeIdx) throws DdlUtilsXMLException {
        String value = xmlReader.getAttributeValue(attributeIdx);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new DdlUtilsXMLException("Illegal boolean value '" + value + "' for attribute " + xmlReader.getAttributeLocalName(attributeIdx));
    }

    private CascadeActionEnum getAttributeValueAsCascadeEnum(XMLStreamReader xmlReader, int attributeIdx) throws DdlUtilsXMLException {
        CascadeActionEnum enumValue;
        String value = xmlReader.getAttributeValue(attributeIdx);
        CascadeActionEnum cascadeActionEnum = enumValue = value == null ? null : CascadeActionEnum.getEnum(value.toLowerCase());
        if (enumValue == null) {
            throw new DdlUtilsXMLException("Illegal boolean value '" + value + "' for attribute " + xmlReader.getAttributeLocalName(attributeIdx));
        }
        return enumValue;
    }

    private void consumeRestOfElement(XMLStreamReader reader) throws XMLStreamException {
        int eventType = reader.getEventType();
        while (eventType != 2 && eventType != 8) {
            eventType = reader.next();
        }
    }

    private void readOverElement(XMLStreamReader reader) throws XMLStreamException {
        int depth = 1;
        while (depth > 0) {
            int eventType = reader.next();
            if (eventType == 1) {
                ++depth;
                continue;
            }
            if (eventType != 2) continue;
            --depth;
        }
    }

    public void write(Database model, String filename) throws DdlUtilsXMLException {
        try {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(filename));
                this.write(model, writer);
                writer.flush();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception ex) {
            throw new DdlUtilsXMLException(ex);
        }
    }

    public void write(Database model, OutputStream output) throws DdlUtilsXMLException {
        PrettyPrintingXmlWriter xmlWriter = new PrettyPrintingXmlWriter(output, "UTF-8");
        xmlWriter.setDefaultNamespace(DDLUTILS_NAMESPACE);
        xmlWriter.writeDocumentStart();
        this.writeDatabaseElement(model, xmlWriter);
        xmlWriter.writeDocumentEnd();
    }

    public void write(Database model, Writer output) throws DdlUtilsXMLException {
        PrettyPrintingXmlWriter xmlWriter = new PrettyPrintingXmlWriter(output, "UTF-8");
        xmlWriter.setDefaultNamespace(DDLUTILS_NAMESPACE);
        xmlWriter.writeDocumentStart();
        this.writeDatabaseElement(model, xmlWriter);
        xmlWriter.writeDocumentEnd();
    }

    private void writeDatabaseElement(Database model, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        this.writeElementStart(xmlWriter, QNAME_ELEMENT_DATABASE);
        xmlWriter.writeNamespace(null, DDLUTILS_NAMESPACE);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_NAME, model.getName());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_DEFAULT_ID_METHOD, model.getIdMethod());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_VERSION, model.getVersion());
        if (model.getTableCount() > 0) {
            xmlWriter.printlnIfPrettyPrinting();
            int idx = 0;
            while (idx < model.getTableCount()) {
                this.writeTableElement(model.getTable(idx), xmlWriter);
                ++idx;
            }
        }
        this.writeElementEnd(xmlWriter);
    }

    private void writeTableElement(Table table, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.indentIfPrettyPrinting(1);
        this.writeElementStart(xmlWriter, QNAME_ELEMENT_TABLE);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_NAME, table.getName());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_DESCRIPTION, table.getDescription());
        if (table.getColumnCount() > 0 || table.getForeignKeyCount() > 0 || table.getIndexCount() > 0) {
            xmlWriter.printlnIfPrettyPrinting();
            int idx = 0;
            while (idx < table.getColumnCount()) {
                this.writeColumnElement(table.getColumn(idx), xmlWriter);
                ++idx;
            }
            idx = 0;
            while (idx < table.getForeignKeyCount()) {
                this.writeForeignKeyElement(table.getForeignKey(idx), xmlWriter);
                ++idx;
            }
            idx = 0;
            while (idx < table.getIndexCount()) {
                this.writeIndexElement(table.getIndex(idx), xmlWriter);
                ++idx;
            }
            xmlWriter.indentIfPrettyPrinting(1);
        }
        this.writeElementEnd(xmlWriter);
    }

    private void writeColumnElement(Column column, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.indentIfPrettyPrinting(2);
        this.writeElementStart(xmlWriter, QNAME_ELEMENT_COLUMN);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_NAME, column.getName());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_PRIMARY_KEY, String.valueOf(column.isPrimaryKey()));
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_REQUIRED, String.valueOf(column.isRequired()));
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_TYPE, column.getType());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_SIZE, column.getSize());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_DEFAULT, column.getDefaultValue());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_AUTO_INCREMENT, String.valueOf(column.isAutoIncrement()));
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_DESCRIPTION, column.getDescription());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_JAVA_NAME, column.getJavaName());
        this.writeElementEnd(xmlWriter);
    }

    private void writeForeignKeyElement(ForeignKey foreignKey, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.indentIfPrettyPrinting(2);
        this.writeElementStart(xmlWriter, QNAME_ELEMENT_FOREIGN_KEY);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_FOREIGN_TABLE, foreignKey.getForeignTableName());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_NAME, foreignKey.getName());
        if (foreignKey.getOnUpdate() != CascadeActionEnum.NONE) {
            this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_ON_UPDATE, foreignKey.getOnUpdate().getName());
        }
        if (foreignKey.getOnDelete() != CascadeActionEnum.NONE) {
            this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_ON_DELETE, foreignKey.getOnDelete().getName());
        }
        if (foreignKey.getReferenceCount() > 0) {
            xmlWriter.printlnIfPrettyPrinting();
            int idx = 0;
            while (idx < foreignKey.getReferenceCount()) {
                this.writeReferenceElement(foreignKey.getReference(idx), xmlWriter);
                ++idx;
            }
            xmlWriter.indentIfPrettyPrinting(2);
        }
        this.writeElementEnd(xmlWriter);
    }

    private void writeReferenceElement(Reference reference, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.indentIfPrettyPrinting(3);
        this.writeElementStart(xmlWriter, QNAME_ELEMENT_REFERENCE);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_LOCAL, reference.getLocalColumnName());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_FOREIGN, reference.getForeignColumnName());
        this.writeElementEnd(xmlWriter);
    }

    private void writeIndexElement(Index index, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.indentIfPrettyPrinting(2);
        this.writeElementStart(xmlWriter, index.isUnique() ? QNAME_ELEMENT_UNIQUE : QNAME_ELEMENT_INDEX);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_NAME, index.getName());
        if (index.getColumnCount() > 0) {
            xmlWriter.printlnIfPrettyPrinting();
            int idx = 0;
            while (idx < index.getColumnCount()) {
                this.writeIndexColumnElement(index.getColumn(idx), index.isUnique(), xmlWriter);
                ++idx;
            }
            xmlWriter.indentIfPrettyPrinting(2);
        }
        this.writeElementEnd(xmlWriter);
    }

    private void writeIndexColumnElement(IndexColumn indexColumn, boolean isUnique, PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.indentIfPrettyPrinting(3);
        this.writeElementStart(xmlWriter, isUnique ? QNAME_ELEMENT_UNIQUE_COLUMN : QNAME_ELEMENT_INDEX_COLUMN);
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_NAME, indexColumn.getName());
        this.writeAttribute(xmlWriter, QNAME_ATTRIBUTE_SIZE, indexColumn.getSize());
        this.writeElementEnd(xmlWriter);
    }

    private void writeElementStart(PrettyPrintingXmlWriter xmlWriter, QName qName) throws DdlUtilsXMLException {
        xmlWriter.writeElementStart(qName.getNamespaceURI(), qName.getLocalPart());
    }

    private void writeAttribute(PrettyPrintingXmlWriter xmlWriter, QName qName, String value) throws DdlUtilsXMLException {
        if (value != null) {
            xmlWriter.writeAttribute(null, qName.getLocalPart(), value);
        }
    }

    private void writeElementEnd(PrettyPrintingXmlWriter xmlWriter) throws DdlUtilsXMLException {
        xmlWriter.writeElementEnd();
        xmlWriter.printlnIfPrettyPrinting();
    }
}

