/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import siena.Column;
import siena.Filter;
import siena.Generator;
import siena.Id;
import siena.Join;
import siena.Json;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Table;
import siena.core.Aggregated;
import siena.core.Aggregator;
import siena.core.InheritFilter;
import siena.core.Many;
import siena.core.One;
import siena.core.Owned;
import siena.core.Owner;
import siena.core.Relation;
import siena.core.RelationMode;
import siena.core.lifecycle.LifeCyclePhase;
import siena.core.lifecycle.LifeCycleUtils;
import siena.embed.Embedded;

public class ClassInfo {
    protected static Map<Class<?>, ClassInfo> infoClasses = new ConcurrentHashMap();
    public Class<?> clazz;
    public String tableName;
    public List<Field> keys = new ArrayList<Field>();
    public List<Field> insertFields = new ArrayList<Field>();
    public List<Field> updateFields = new ArrayList<Field>();
    public List<Field> generatedKeys = new ArrayList<Field>();
    public List<Field> allFields = new ArrayList<Field>();
    public List<Field> joinFields = new ArrayList<Field>();
    public List<Field> allExtendedFields = new ArrayList<Field>();
    public List<Field> aggregatedFields = new ArrayList<Field>();
    public boolean hasAggregatedFields = false;
    public List<Field> ownedFields = new ArrayList<Field>();
    public boolean hasOwnedFields = false;
    public Map<LifeCyclePhase, List<Method>> lifecycleMethods = new HashMap<LifeCyclePhase, List<Method>>();
    public Map<Field, Map<FieldMapKeys, Object>> queryFieldMap = new HashMap<Field, Map<FieldMapKeys, Object>>();
    public Map<Field, Map<FieldMapKeys, Object>> manyFieldMap = new HashMap<Field, Map<FieldMapKeys, Object>>();
    public Map<Field, Map<FieldMapKeys, Object>> oneFieldMap = new HashMap<Field, Map<FieldMapKeys, Object>>();
    public Field aggregator = null;
    public boolean hasAggregator = false;

    protected ClassInfo(Class<?> clazz) {
        this.clazz = clazz;
        this.tableName = this.getTableName(clazz);
        ArrayList classH = new ArrayList();
        Class<?> cl = clazz;
        HashSet<String> removedFields = new HashSet<String>();
        ClassInfo.scanClassHierarchy(cl, classH, removedFields);
        for (Class clazz2 : classH) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!removedFields.contains(field.getName())) {
                    Class<?> type = field.getType();
                    if (!ClassInfo.shouldSkip(field)) {
                        if (ClassInfo.isId(field)) {
                            this.buildId(field);
                        } else if (type == Query.class) {
                            this.buildQuery(field, clazz2);
                        } else if (type == Many.class) {
                            this.buildMany(field, clazz2);
                        } else if (type == One.class) {
                            this.buildOne(field, clazz2);
                        } else if (ClassInfo.isAggregator(field)) {
                            if (this.aggregator != null) {
                                if (clazz2 != Model.class) {
                                    throw new SienaException("Found 2 @Aggregator fields in your model which is forbidden");
                                }
                            } else {
                                if (type != Relation.class) {
                                    throw new SienaException("Found @Aggregator field not with type siena.core.Relation which is forbidden");
                                }
                                this.aggregator = field;
                                this.hasAggregator = true;
                            }
                        } else {
                            this.validateAnnotations(field, type);
                            this.updateFields.add(field);
                            this.insertFields.add(field);
                            this.allFields.add(field);
                            this.allExtendedFields.add(field);
                        }
                    }
                }
                ++n2;
            }
            this.buildLifecycleMethods(clazz2);
        }
    }

    private void buildId(Field field) {
        Class<?> type = field.getType();
        Id id = field.getAnnotation(Id.class);
        if (id != null) {
            if (id.value() == Generator.AUTO_INCREMENT && (Long.TYPE == type || Long.class.isAssignableFrom(type))) {
                this.generatedKeys.add(field);
            } else {
                this.insertFields.add(field);
            }
            this.keys.add(field);
            this.allFields.add(field);
            this.allExtendedFields.add(field);
        }
    }

    private void buildQuery(Field field, Class<?> c) {
        Class<?> type = field.getType();
        Filter filter = field.getAnnotation(Filter.class);
        Owned related = field.getAnnotation(Owned.class);
        if (filter == null && related == null) {
            throw new SienaException("Found Query<T> field without @Filter or @Owned annotation at " + c.getName() + "." + field.getName());
        }
        ParameterizedType pt = (ParameterizedType)field.getGenericType();
        Class cl = (Class)pt.getActualTypeArguments()[0];
        if (filter != null) {
            try {
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.FILTER, filter.value());
                this.queryFieldMap.put(field, fieldMap);
                this.ownedFields.add(field);
                this.hasOwnedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (related != null) {
            String as = related.mappedBy();
            if ("".equals(as) || as == null) {
                ClassInfo fieldInfo = ClassInfo.getClassInfo(cl);
                Field f = fieldInfo.getFirstFieldFromType(this.clazz);
                if (f == null) {
                    throw new SienaException("@Owned without 'as' attribute and no field of type " + this.clazz.getName() + "found in class " + type.getName());
                }
                as = ClassInfo.getSimplestColumnName(f);
            }
            try {
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.FILTER, as);
                this.queryFieldMap.put(field, fieldMap);
                this.ownedFields.add(field);
                this.hasOwnedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        this.allExtendedFields.add(field);
    }

    private void buildMany(Field field, Class<?> c) {
        Class<?> type = field.getType();
        ParameterizedType pt = (ParameterizedType)field.getGenericType();
        Class cl = (Class)pt.getActualTypeArguments()[0];
        Aggregated agg = field.getAnnotation(Aggregated.class);
        Filter filter = field.getAnnotation(Filter.class);
        Owned related = field.getAnnotation(Owned.class);
        if (agg != null && filter != null || agg != null && related != null) {
            throw new SienaException("Found Many<T> field " + c.getName() + "." + field.getName() + "with @Filter+@Owned or @Filter+@Owned: this is not authorized");
        }
        if (agg != null) {
            try {
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.MODE, (Object)RelationMode.AGGREGATION);
                this.manyFieldMap.put(field, fieldMap);
                this.aggregatedFields.add(field);
                this.hasAggregatedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (filter != null) {
            try {
                Field filterField = cl.getField(filter.value());
                if (filterField == null) {
                    throw new SienaException("@Filter error: Couldn't find field " + filter.value() + "in class " + cl.getName());
                }
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.MODE, (Object)RelationMode.RELATION);
                fieldMap.put(FieldMapKeys.FIELD, filterField);
                fieldMap.put(FieldMapKeys.FILTER, filter.value());
                this.manyFieldMap.put(field, fieldMap);
                this.ownedFields.add(field);
                this.hasOwnedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (related != null) {
            String as = related.mappedBy();
            if ("".equals(as) || as == null) {
                ClassInfo fieldInfo = ClassInfo.getClassInfo(cl);
                Field f = fieldInfo.getFirstFieldFromType(this.clazz);
                if (f == null) {
                    throw new SienaException("@Owned without 'as' attribute and no field of type " + this.clazz.getName() + "found in class " + type.getName());
                }
                as = ClassInfo.getSimplestColumnName(f);
            }
            try {
                Field asField = cl.getField(as);
                if (asField == null) {
                    throw new SienaException("@Filter error: Couldn't find field " + as + "in class " + cl.getName());
                }
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.MODE, (Object)RelationMode.RELATION);
                fieldMap.put(FieldMapKeys.FIELD, asField);
                fieldMap.put(FieldMapKeys.FILTER, as);
                this.manyFieldMap.put(field, fieldMap);
                this.ownedFields.add(field);
                this.hasOwnedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        this.allExtendedFields.add(field);
    }

    private void buildOne(Field field, Class<?> c) {
        Class<?> type = field.getType();
        ParameterizedType pt = (ParameterizedType)field.getGenericType();
        Class cl = (Class)pt.getActualTypeArguments()[0];
        Aggregated agg = field.getAnnotation(Aggregated.class);
        Filter filter = field.getAnnotation(Filter.class);
        Owned related = field.getAnnotation(Owned.class);
        if (agg != null && filter != null || agg != null && related != null) {
            throw new SienaException("Found One<T> field " + c.getName() + "." + field.getName() + "with @Filter+@Aggregated or @Filter+@Owned: this is not authorized");
        }
        if (agg != null) {
            try {
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.MODE, (Object)RelationMode.AGGREGATION);
                this.oneFieldMap.put(field, fieldMap);
                this.aggregatedFields.add(field);
                this.hasAggregatedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (filter != null) {
            try {
                Field filterField = cl.getField(filter.value());
                if (filterField == null) {
                    throw new SienaException("@Filter error: Couldn't find field " + filter.value() + "in class " + cl.getName());
                }
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.MODE, (Object)RelationMode.RELATION);
                fieldMap.put(FieldMapKeys.FIELD, filterField);
                fieldMap.put(FieldMapKeys.FILTER, filter.value());
                this.oneFieldMap.put(field, fieldMap);
                this.ownedFields.add(field);
                this.hasOwnedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (related != null) {
            String as = related.mappedBy();
            if ("".equals(as) || as == null) {
                ClassInfo fieldInfo = ClassInfo.getClassInfo(cl);
                Field f = fieldInfo.getFirstFieldFromType(this.clazz);
                if (f == null) {
                    throw new SienaException("@Owned without 'as' attribute and no field of type " + this.clazz.getName() + "found in class " + type.getName());
                }
                as = ClassInfo.getSimplestColumnName(f);
            }
            try {
                Field asField = cl.getField(as);
                if (asField == null) {
                    throw new SienaException("@Filter error: Couldn't find field " + as + "in class " + cl.getName());
                }
                HashMap<FieldMapKeys, Object> fieldMap = new HashMap<FieldMapKeys, Object>();
                fieldMap.put(FieldMapKeys.CLASS, cl);
                fieldMap.put(FieldMapKeys.MODE, (Object)RelationMode.RELATION);
                fieldMap.put(FieldMapKeys.FIELD, asField);
                fieldMap.put(FieldMapKeys.FILTER, as);
                this.oneFieldMap.put(field, fieldMap);
                this.ownedFields.add(field);
                this.hasOwnedFields = true;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        this.allExtendedFields.add(field);
    }

    private void buildLifecycleMethods(Class<?> c) {
        Method[] methodArray = c.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            List<LifeCyclePhase> lcps = LifeCycleUtils.getMethodLifeCycles(m);
            for (LifeCyclePhase lcp : lcps) {
                List<Method> methods = this.lifecycleMethods.get((Object)lcp);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    this.lifecycleMethods.put(lcp, methods);
                }
                methods.add(m);
            }
            ++n2;
        }
    }

    private static void scanClassHierarchy(Class<?> cl, List<Class<?>> classH, Set<String> removedFields) {
        while (cl != null) {
            classH.add(0, cl);
            InheritFilter iFilter = cl.getAnnotation(InheritFilter.class);
            if (iFilter != null) {
                String[] efs;
                String[] stringArray = efs = iFilter.removedFields();
                int n = efs.length;
                int n2 = 0;
                while (n2 < n) {
                    String ef = stringArray[n2];
                    removedFields.add(ef);
                    ++n2;
                }
            }
            cl = cl.getSuperclass();
        }
    }

    private static boolean scanIdInHierarchy(Class<?> clazz) {
        ArrayList classH = new ArrayList();
        Class<?> cl = clazz;
        HashSet<String> removedFields = new HashSet<String>();
        ClassInfo.scanClassHierarchy(cl, classH, removedFields);
        for (Class clazz2 : classH) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!removedFields.contains(field.getName()) && !ClassInfo.shouldSkip(field) && ClassInfo.isId(field)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void validateAnnotations(Field field, Class<?> type) {
        if (ClassInfo.isModel(type)) {
            if (ClassInfo.isJoined(field)) {
                this.joinFields.add(field);
            } else {
                if (ClassInfo.isOwned(field)) {
                    throw new SienaException("@Owned not possible on Field '" + field.getName() + "' without @One/@Many");
                }
                if (ClassInfo.isAggregated(field)) {
                    throw new SienaException("@Aggregated not possible on Field '" + field.getName() + "' without @One/@Many");
                }
            }
        } else {
            if (ClassInfo.isJoined(field)) {
                throw new SienaException("@Join not possible: Field " + field.getName() + " is not a relation field");
            }
            if (ClassInfo.isOwned(field)) {
                throw new SienaException("@Owned not possible: Field " + field.getName() + " is not a relation field");
            }
            if (ClassInfo.isAggregated(field)) {
                throw new SienaException("@Aggregated not possible: Field " + field.getName() + " is not a relation field");
            }
        }
    }

    private static boolean shouldSkip(Field field) {
        int modifiers = field.getModifiers();
        return (modifiers & 0x80) == 128 || (modifiers & 8) == 8 || field.isSynthetic() || field.getType() == Class.class;
    }

    private String getTableName(Class<?> clazz) {
        Table t = clazz.getAnnotation(Table.class);
        if (t == null) {
            return clazz.getSimpleName();
        }
        return t.value();
    }

    public List<String> getUpdateFieldsColumnNames() {
        ArrayList<String> strs = new ArrayList<String>(this.updateFields.size());
        for (Field field : this.updateFields) {
            Column c = field.getAnnotation(Column.class);
            if (c != null && c.value().length > 0) {
                strs.add(c.value()[0]);
                continue;
            }
            if (ClassInfo.isModel(field.getType())) {
                ClassInfo ci = ClassInfo.getClassInfo(field.getType());
                for (Field key : ci.keys) {
                    Collections.addAll(strs, ClassInfo.getColumnNames(key));
                }
                continue;
            }
            strs.add(field.getName());
        }
        return strs;
    }

    public static String[] getColumnNames(Field field) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(field.getName()) + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{field.getName()};
    }

    public static String getSingleColumnName(Field field) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            return c.value()[0];
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            String keys = "";
            if (ci.keys.size() == 1) {
                return field.getName();
            }
            int i = 0;
            int sz = ci.keys.size();
            for (Field key : ci.keys) {
                keys = String.valueOf(keys) + field.getName() + "_" + ClassInfo.getSingleColumnName(key);
                if (i < sz) {
                    keys = String.valueOf(keys) + ":";
                }
                ++i;
            }
            return keys;
        }
        return field.getName();
    }

    public static String getSimplestColumnName(Field field) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            return c.value()[0];
        }
        return field.getName();
    }

    public static String[] getColumnNamesWithPrefix(Field field, String prefix) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            String[] cols = c.value();
            int i = 0;
            while (i < cols.length) {
                cols[i] = String.valueOf(prefix) + cols[i];
                ++i;
            }
            return cols;
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{String.valueOf(prefix) + field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(prefix) + field.getName() + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{String.valueOf(prefix) + field.getName()};
    }

    public static String[] getColumnNames(Field field, String tableName) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            if (tableName != null && !"".equals(tableName)) {
                String[] cols = c.value();
                int i = 0;
                while (i < cols.length) {
                    cols[i] = String.valueOf(tableName) + "." + cols[i];
                    ++i;
                }
                return cols;
            }
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                if (tableName != null && !"".equals(tableName)) {
                    return new String[]{String.valueOf(tableName) + "." + field.getName()};
                }
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                if (tableName != null && !"".equals(tableName)) {
                    keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(tableName) + "." + field.getName() + "_")));
                    continue;
                }
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(field.getName()) + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        if (tableName != null && !"".equals(tableName)) {
            return new String[]{String.valueOf(tableName) + "." + field.getName()};
        }
        return new String[]{field.getName()};
    }

    public static boolean isModel(Class<?> type) {
        if (Model.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.getName().startsWith("java.")) {
            return false;
        }
        if (Json.class.isAssignableFrom(type)) {
            return false;
        }
        ClassInfo info = ClassInfo.findClassInfo(type);
        if (info != null) {
            return !info.keys.isEmpty();
        }
        return ClassInfo.scanIdInHierarchy(type);
    }

    public static boolean isId(Field field) {
        return field.isAnnotationPresent(Id.class);
    }

    public static boolean isEmbedded(Field field) {
        return field.isAnnotationPresent(Embedded.class);
    }

    public static boolean isAggregated(Field field) {
        return field.isAnnotationPresent(Aggregated.class);
    }

    public static boolean isAggregator(Field field) {
        return field.isAnnotationPresent(Aggregator.class);
    }

    public static boolean isJoined(Field field) {
        return field.isAnnotationPresent(Join.class);
    }

    public static boolean isMany(Field field) {
        return Many.class.isAssignableFrom(field.getType());
    }

    public static boolean isOne(Field field) {
        return One.class.isAssignableFrom(field.getType());
    }

    public static boolean isOwned(Field field) {
        return field.isAnnotationPresent(Owned.class);
    }

    public static boolean isOwner(Field field) {
        return field.isAnnotationPresent(Owner.class);
    }

    public static boolean isGenerated(Field field) {
        Id id = field.getAnnotation(Id.class);
        if (id != null) {
            Class<?> type = field.getType();
            if (id.value() == Generator.AUTO_INCREMENT && (Long.TYPE == type || Long.class.isAssignableFrom(type))) {
                return true;
            }
            if (id.value() == Generator.UUID && (String.class.isAssignableFrom(type) || UUID.class.isAssignableFrom(type))) {
                return true;
            }
        }
        return false;
    }

    public static Field getIdField(Class<?> clazz) {
        List<Field> keys = ClassInfo.getClassInfo(clazz).keys;
        if (keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + clazz.getName());
        }
        if (keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + clazz.getName());
        }
        return keys.get(0);
    }

    public Field getIdField() {
        if (this.keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + this.tableName);
        }
        if (this.keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + this.tableName);
        }
        return this.keys.get(0);
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        ClassInfo ci = infoClasses.get(clazz);
        if (ci == null) {
            ci = new ClassInfo(clazz);
            infoClasses.put(clazz, ci);
        }
        return ci;
    }

    public static ClassInfo findClassInfo(Class<?> clazz) {
        return infoClasses.get(clazz);
    }

    public List<Method> getLifeCycleMethod(LifeCyclePhase lcp) {
        return this.lifecycleMethods.get((Object)lcp);
    }

    public Field getFirstFieldFromType(Class<?> fieldType) {
        for (Field f : this.updateFields) {
            if (!f.getType().isAssignableFrom(fieldType)) continue;
            return f;
        }
        return null;
    }

    public static enum FieldMapKeys {
        CLASS,
        MODE,
        FIELD,
        FILTER;

    }
}

