/*
 * Decompiled with CFR 0.152.
 */
package siena.core;

import java.lang.reflect.Field;
import siena.BaseQuery;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.Query;
import siena.Util;
import siena.core.One;
import siena.core.One4PM;
import siena.core.Relation;
import siena.core.RelationMode;

public class BaseOne<T>
implements One4PM<T> {
    protected transient PersistenceManager pm;
    protected transient Class<T> clazz;
    protected Relation relation;
    protected transient Query<T> query;
    protected transient T target;
    protected transient boolean isSync = true;
    protected transient boolean isModified = false;
    protected transient T prevTarget;

    public BaseOne(PersistenceManager pm, Class<T> clazz) {
        this.pm = pm;
        this.clazz = clazz;
        this.query = pm.createQuery(clazz);
    }

    public BaseOne(PersistenceManager pm, Class<T> clazz, RelationMode mode, Object obj, String fieldName) {
        this.pm = pm;
        this.clazz = clazz;
        switch (mode) {
            case AGGREGATION: {
                this.relation = new Relation(mode, obj, fieldName);
                this.query = pm.createQuery(clazz).aggregated(obj, fieldName);
                break;
            }
            case RELATION: {
                this.query = pm.createQuery(clazz).owned(obj, fieldName);
            }
        }
        this.query = pm.createQuery(clazz);
    }

    @Override
    public T get() {
        this.sync();
        return this.target;
    }

    @Override
    public void set(T obj) {
        this.prevTarget = this.target;
        this.target = obj;
        if (this.relation != null && this.relation.mode == RelationMode.AGGREGATION) {
            if (this.target != null) {
                Util.setField(this.target, ClassInfo.getClassInfo(this.clazz).aggregator, this.relation);
            }
            if (this.prevTarget != null) {
                Util.setField(this.prevTarget, ClassInfo.getClassInfo(this.clazz).aggregator, null);
            }
        }
        this.isModified = true;
    }

    @Override
    public One<T> sync() {
        if (!this.isSync) {
            return this.forceSync();
        }
        return this;
    }

    @Override
    public One<T> forceSync() {
        this.target = this.query.get();
        this.isSync = true;
        this.isModified = false;
        return this;
    }

    @Override
    public One4PM<T> setSync(boolean isSync) {
        this.isSync = isSync;
        return this;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public One4PM<T> setModified(boolean isModified) {
        this.isModified = isModified;
        return this;
    }

    @Override
    public T getPrev() {
        return this.prevTarget;
    }

    @Override
    public One4PM<T> aggregationMode(Object aggregator, Field field) {
        if (this.relation == null) {
            this.relation = new Relation(RelationMode.AGGREGATION, aggregator, field);
        } else {
            this.relation.mode = RelationMode.AGGREGATION;
            this.relation.target = aggregator;
            this.relation.discriminator = field;
        }
        ((BaseQuery)this.query).aggregated(aggregator, field);
        return this;
    }

    @Override
    public One4PM<T> relationMode(Object owner, Field field) {
        ((BaseQuery)this.query).owned(owner, field);
        return this;
    }
}

