/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Text;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import siena.ClassInfo;
import siena.Json;
import siena.SienaException;
import siena.Util;
import siena.core.DecimalPrecision;
import siena.embed.Embedded;
import siena.embed.JavaSerializer;
import siena.embed.JsonSerializer;
import siena.gae.GaeMappingUtils;
import siena.gae.Unindexed;

public class GaeNativeSerializer {
    public static void embed(Entity entity, String embeddingColumnName, Object embeddedObj) {
        Class<?> clazz = embeddedObj.getClass();
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        block11: for (Field f : ClassInfo.getClassInfo(clazz).updateFields) {
            Unindexed ui;
            Object propValue;
            String propName;
            block22: {
                Class<?> fieldClass;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                fieldClass = f.getType();
                                propName = String.valueOf(embeddingColumnName) + "." + ClassInfo.getSingleColumnName(f);
                                propValue = Util.readField(embeddedObj, f);
                                if (propValue == null) break block22;
                                if (fieldClass != Json.class) break block23;
                                propValue = propValue.toString();
                                break block22;
                            }
                            if (!(propValue instanceof String)) break block24;
                            String s = (String)propValue;
                            if (s.length() > 500) {
                                propValue = new Text(s);
                            }
                            break block22;
                        }
                        if (!(propValue instanceof byte[])) break block25;
                        byte[] arr = (byte[])propValue;
                        propValue = arr.length < 1000000 ? new Blob(arr) : new Blob(Arrays.copyOf(arr, 1000000));
                        break block22;
                    }
                    if (!ClassInfo.isEmbedded(f)) break block26;
                    Embedded embed = f.getAnnotation(Embedded.class);
                    switch (embed.mode()) {
                        case SERIALIZE_JSON: {
                            propValue = JsonSerializer.serialize(propValue).toString();
                            String s = (String)propValue;
                            if (s.length() > 500) {
                                propValue = new Text(s);
                                break;
                            }
                            break block22;
                        }
                        case SERIALIZE_JAVA: {
                            try {
                                byte[] b = JavaSerializer.serialize(propValue);
                                if (b.length > 1000000) {
                                    throw new SienaException("object can be java serialized because it's too large >1mb");
                                }
                                propValue = new Blob(b);
                                break block22;
                            }
                            catch (IOException ex) {
                                throw new SienaException(ex);
                            }
                        }
                        case NATIVE: {
                            GaeNativeSerializer.embed(entity, String.valueOf(embeddingColumnName) + "." + ClassInfo.getSingleColumnName(f), propValue);
                            continue block11;
                        }
                    }
                    break block22;
                }
                if (fieldClass == BigDecimal.class) {
                    DecimalPrecision ann = f.getAnnotation(DecimalPrecision.class);
                    if (ann == null) {
                        propValue = ((BigDecimal)propValue).toPlainString();
                    } else {
                        switch (ann.storageType()) {
                            case DOUBLE: {
                                propValue = ((BigDecimal)propValue).doubleValue();
                                break;
                            }
                            case NATIVE: 
                            case STRING: {
                                propValue = ((BigDecimal)propValue).toPlainString();
                            }
                        }
                    }
                } else if (Enum.class.isAssignableFrom(fieldClass)) {
                    propValue = propValue.toString();
                }
            }
            if ((ui = f.getAnnotation(Unindexed.class)) == null) {
                entity.setProperty(propName, propValue);
                continue;
            }
            entity.setUnindexedProperty(propName, propValue);
        }
    }

    public static <T> T unembed(Class<T> clazz, String embeddingFieldName, Entity entity) {
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        T obj = Util.createObjectInstance(clazz);
        try {
            for (Field f : ClassInfo.getClassInfo(clazz).updateFields) {
                String propName = String.valueOf(embeddingFieldName) + "." + ClassInfo.getSingleColumnName(f);
                Object propValue = entity.getProperty(propName);
                if (ClassInfo.isEmbedded(f) && f.getAnnotation(Embedded.class).mode() == Embedded.Mode.NATIVE) {
                    Object value = GaeNativeSerializer.unembed(f.getType(), String.valueOf(embeddingFieldName) + "." + ClassInfo.getSingleColumnName(f), entity);
                    Util.setField(obj, f, value);
                    continue;
                }
                GaeMappingUtils.setFromObject(obj, f, propValue);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }
}

