/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import siena.core.options.QueryOption;
import siena.embed.EmbeddedMap;

@EmbeddedMap
public class QueryOptionJdbcContext
extends QueryOption {
    public static final int ID = 4097;
    public PreparedStatement statement;
    public int limitParamIdx;
    public int offsetParamIdx;
    public boolean noMoreDataBefore = false;
    public boolean noMoreDataAfter = false;
    public int realOffset = 0;
    public int realPageSize = 0;

    public QueryOptionJdbcContext() {
        super(4097);
    }

    public QueryOptionJdbcContext(PreparedStatement statement, int limitParamIdx, int offsetParamIdx) {
        super(4097);
        this.statement = statement;
        this.limitParamIdx = limitParamIdx;
        this.offsetParamIdx = offsetParamIdx;
    }

    public QueryOptionJdbcContext(QueryOptionJdbcContext option) {
        super(option);
        this.statement = option.statement;
        this.limitParamIdx = option.limitParamIdx;
        this.offsetParamIdx = option.offsetParamIdx;
        this.noMoreDataAfter = option.noMoreDataAfter;
        this.noMoreDataBefore = option.noMoreDataBefore;
        this.realOffset = option.realOffset;
        this.realPageSize = option.realPageSize;
    }

    public boolean isClosed() {
        block5: {
            if (this.statement == null) {
                return true;
            }
            if (!this.statement.isClosed()) break block5;
            return true;
        }
        try {
            return this.statement.getConnection() == null;
        }
        catch (SQLException sQLException) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return true;
    }

    @Override
    public QueryOption clone() {
        return new QueryOptionJdbcContext(this);
    }

    @Override
    public String toString() {
        return "type:JDBC_CONTEXT - state:" + (Object)((Object)this.state) + " - limitParamIdx:" + this.limitParamIdx + " - offsetParamIdx:" + this.offsetParamIdx + " - noMoreDataAfter:" + this.noMoreDataAfter + " - noMoreDataBefore:" + this.noMoreDataBefore + " - realOffset:" + this.realOffset + " - realPageSize:" + this.realPageSize;
    }
}

