/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb.ws;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import siena.sdb.ws.Base64;
import siena.sdb.ws.BasicHandler;
import siena.sdb.ws.DomainMetadataHandler;
import siena.sdb.ws.DomainMetadataResponse;
import siena.sdb.ws.GetAttributesHandler;
import siena.sdb.ws.GetAttributesResponse;
import siena.sdb.ws.Item;
import siena.sdb.ws.ListDomainsHandler;
import siena.sdb.ws.ListDomainsResponse;
import siena.sdb.ws.PlainHandler;
import siena.sdb.ws.Response;
import siena.sdb.ws.SelectHandler;
import siena.sdb.ws.SelectResponse;

public class SimpleDB {
    private static final String VERSION = "2009-04-15";
    private static final String SIGNATURE_METHOD = "HmacSHA256";
    private static final String SIGNATURE_VERSION = "2";
    private static final String ENCODING = "UTF-8";
    private static final String HOST = "sdb.amazonaws.com";
    private static final String PROTOCOL = "http";
    private static final String PATH = "/";
    private static final String METHOD = "POST";
    private String awsAccessKeyId = null;
    private String awsSecretAccessKey = null;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"){
        private static final long serialVersionUID = 1L;
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };

    public SimpleDB(String awsAccessKeyId, String awsSecretAccessKey) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    private String sign(String data, String key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(ENCODING), SIGNATURE_METHOD);
            Mac mac = Mac.getInstance(SIGNATURE_METHOD);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(ENCODING));
            return Base64.encodeBytes(rawHmac);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void signParams(String httpverb, String host, String uri, String secretAccessKey, TreeMap<String, String> parameters) {
        parameters.put("AWSAccessKeyId", this.awsAccessKeyId);
        parameters.put("SignatureVersion", SIGNATURE_VERSION);
        parameters.put("SignatureMethod", SIGNATURE_METHOD);
        parameters.put("Timestamp", SimpleDB.timestamp());
        parameters.put("Version", VERSION);
        String signature = this.signature(httpverb, host, uri, parameters);
        parameters.put("Signature", this.sign(signature, secretAccessKey));
    }

    private String query(TreeMap<String, String> parameters) {
        if (parameters.isEmpty()) {
            return "";
        }
        StringBuilder params = new StringBuilder();
        for (String key : parameters.keySet()) {
            params.append("&");
            params.append(this.urlEncode(key));
            params.append("=");
            params.append(this.urlEncode(parameters.get(key)));
        }
        return params.toString().substring(1);
    }

    private String signature(String httpverb, String host, String uri, TreeMap<String, String> parameters) {
        return String.valueOf(httpverb) + "\n" + host + "\n" + uri + "\n" + this.query(parameters);
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Response createDomain(String domain) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "CreateDomain");
        parameters.put("DomainName", domain);
        return this.request(parameters, new PlainHandler());
    }

    public Response putAttributes(String domain, Item item) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "PutAttributes");
        parameters.put("DomainName", domain);
        parameters.put("ItemName", item.name);
        int i = 0;
        for (Map.Entry<String, List<String>> entry : item.attributes.entrySet()) {
            List<String> values = entry.getValue();
            for (String value : values) {
                parameters.put("Attribute." + i + ".Name", entry.getKey());
                parameters.put("Attribute." + i + ".Value", value);
                parameters.put("Attribute." + i + ".Replace", "true");
                ++i;
            }
        }
        return this.request(parameters, new PlainHandler());
    }

    public GetAttributesResponse getAttributes(String domain, String itemName) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetAttributes");
        parameters.put("DomainName", domain);
        parameters.put("ItemName", itemName);
        return this.request(parameters, new GetAttributesHandler(itemName));
    }

    public ListDomainsResponse listDomains(String maxNumberOfDomains, String nextToken) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ListDomains");
        if (maxNumberOfDomains != null) {
            parameters.put("MaxNumberOfDomains", maxNumberOfDomains);
        }
        if (nextToken != null) {
            parameters.put("NextToken", nextToken);
        }
        return this.request(parameters, new ListDomainsHandler());
    }

    public Response deleteDomain(String domain) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "DeleteDomain");
        parameters.put("DomainName", domain);
        return this.request(parameters, new PlainHandler());
    }

    public DomainMetadataResponse domainMetadata(String domain) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "DomainMetadata");
        parameters.put("DomainName", domain);
        return this.request(parameters, new DomainMetadataHandler());
    }

    public Response deleteAttributes(String domain, Item item) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "DeleteAttributes");
        parameters.put("DomainName", domain);
        parameters.put("ItemName", item.name);
        int i = 0;
        for (Map.Entry<String, List<String>> entry : item.attributes.entrySet()) {
            List<String> values = entry.getValue();
            for (String value : values) {
                parameters.put("Attribute." + i + ".Name", entry.getKey());
                parameters.put("Attribute." + i + ".Value", value);
                ++i;
            }
        }
        return this.request(parameters, new PlainHandler());
    }

    public SelectResponse select(String selectExpression, String nextToken) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "Select");
        if (selectExpression != null) {
            parameters.put("SelectExpression", selectExpression);
        }
        if (nextToken != null) {
            parameters.put("NextToken", nextToken);
        }
        return this.request(parameters, new SelectHandler());
    }

    private static String timestamp() {
        return DATE_FORMAT.format(new Date());
    }

    private <T extends Response> T request(TreeMap<String, String> parameters, BasicHandler<T> handler) {
        this.signParams(METHOD, HOST, PATH, this.awsSecretAccessKey, parameters);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            URL url = new URL("http://sdb.amazonaws.com/");
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream os = connection.getOutputStream();
            os.write(this.query(parameters).getBytes(ENCODING));
            os.close();
            parser.parse(connection.getInputStream(), handler);
            return handler.response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String quote(String s) {
        return "\"" + s.replace("'", "''") + "\"";
    }
}

