/*
 * Decompiled with CFR 0.152.
 */
package play.modules.siena;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.model.Database;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.data.binding.Binder;
import play.db.DB;
import play.db.Model;
import play.db.jpa.JPA;
import play.db.jpa.JPAPlugin;
import play.exceptions.UnexpectedException;
import play.modules.siena.ModelWrapper;
import play.modules.siena.PlayConnectionManager;
import play.modules.siena.SienaEnhancer;
import play.modules.siena.SienaModelUtils;
import siena.ClassInfo;
import siena.Generator;
import siena.Id;
import siena.PersistenceManager;
import siena.PersistenceManagerFactory;
import siena.Query;
import siena.core.PersistenceManagerLifeCycleWrapper;
import siena.core.options.PmOption;
import siena.gae.GaePersistenceManager;
import siena.jdbc.ConnectionManager;
import siena.jdbc.H2PersistenceManager;
import siena.jdbc.JdbcPersistenceManager;
import siena.jdbc.PostgresqlPersistenceManager;
import siena.jdbc.ddl.DdlGenerator;
import siena.sdb.SdbPersistenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SienaPlugin
extends PlayPlugin {
    private static PersistenceManager persistenceManager;
    private static DdlGenerator generator;
    private SienaEnhancer enhancer = new SienaEnhancer();

    public static PersistenceManager pm() {
        return persistenceManager;
    }

    public static String dbType() {
        for (PlayPlugin plugin : Play.pluginCollection.getEnabledPlugins()) {
            if (!plugin.getClass().getSimpleName().equals("GAEPlugin")) continue;
            return "nosql:gae";
        }
        String db = Play.configuration.getProperty("db");
        if (db != null && db.toLowerCase().equals("sdb")) {
            return "nosql:sdb";
        }
        String dbUrl = Play.configuration.getProperty("db.url");
        if (!(db != null && db != "" || dbUrl != null && dbUrl != "")) {
            throw new UnexpectedException("SienaPlugin : not using GAE requires at least a db=xxx config");
        }
        if (db != null && db.contains("postgresql") || dbUrl != null && dbUrl.contains("postgresql")) {
            return "sql:postgresql";
        }
        if (db != null && ("mem".equals(db) || "fs".equals(db) || db.contains("h2")) || dbUrl != null && dbUrl.contains("h2")) {
            return "sql:h2:mysql";
        }
        return "sql:mysql";
    }

    public boolean useLifecycle() {
        String lc = Play.configuration.getProperty("siena.lifecycle");
        if (lc == null) {
            return false;
        }
        return "true".equals(lc) || "yes".equals(lc);
    }

    public void onApplicationStart() {
        if (JPA.isEnabled()) {
            Play.pluginCollection.disablePlugin(JPAPlugin.class);
        }
        List<Class> classes = SienaModelUtils.getSienaClasses();
        String dbType = SienaPlugin.dbType();
        if (dbType.startsWith("sql")) {
            Database currentDatabase;
            String ddl;
            String ddlType = "mysql";
            Connection connection = new PlayConnectionManager().getConnection();
            Logger.debug((String)"Siena DB Type: %s", (Object[])new Object[]{dbType});
            String db = Play.configuration.getProperty("db");
            String dbUrl = Play.configuration.getProperty("db.url");
            if (!(db != null && db != "" || dbUrl != null && dbUrl != "")) {
                throw new UnexpectedException("SienaPlugin : not using GAE requires at least a db config");
            }
            if (dbType.contains("postgresql")) {
                persistenceManager = new PostgresqlPersistenceManager((ConnectionManager)new PlayConnectionManager(), null);
                ddlType = "postgresql";
                generator = new DdlGenerator("postgresql");
            } else if (dbType.contains("h2")) {
                persistenceManager = new H2PersistenceManager((ConnectionManager)new PlayConnectionManager(), null, "mysql");
                ddlType = "mysql";
                generator = new DdlGenerator("h2");
            } else {
                persistenceManager = new JdbcPersistenceManager((ConnectionManager)new PlayConnectionManager(), null);
                generator = new DdlGenerator("mysql");
            }
            Logger.debug((String)"Siena DDL Type: %s", (Object[])new Object[]{ddlType});
            for (Class c : classes) {
                generator.addTable(c);
            }
            Database database = generator.getDatabase();
            Platform platform = PlatformFactory.createNewPlatformInstance((String)ddlType);
            platform.setDataSource(DB.datasource);
            if (Play.mode.isDev()) {
                ddl = Play.configuration.getProperty("siena.ddl", "update");
                Logger.debug((String)"Siena DDL dev mode: %s", (Object[])new Object[]{ddl});
                if ("create".equals(ddl)) {
                    Logger.debug((String)"Siena DDL Generator SQL: %s", (Object[])new Object[]{platform.getCreateModelSql(database, false, false)});
                    try {
                        platform.createModel(connection, database, false, false);
                    }
                    catch (DatabaseOperationException ex) {
                        Logger.warn((String)"Siena DDL createTables generated exception:%s", (Object[])new Object[]{ex.getCause() != null ? ex.getCause() : ex.getMessage()});
                    }
                } else if ("update".equals(ddl)) {
                    currentDatabase = platform.readModelFromDatabase(connection, ddlType);
                    Logger.debug((String)"Siena DDL Generator SQL: %s", (Object[])new Object[]{platform.getAlterModelSql(currentDatabase, database)});
                    platform.alterModel(currentDatabase, database, true);
                }
            } else if (Play.mode.isProd()) {
                ddl = Play.configuration.getProperty("siena.ddl", "none");
                Logger.debug((String)"Siena DDL prod mode: %s", (Object[])new Object[]{ddl});
                if ("create".equals(ddl)) {
                    Logger.debug((String)"Siena DDL Generator SQL: %s", (Object[])new Object[]{platform.getCreateModelSql(database, false, false)});
                    try {
                        platform.createModel(connection, database, false, false);
                    }
                    catch (DatabaseOperationException ex) {
                        Logger.warn((String)"Siena DDL createTables generated exception:%s", (Object[])new Object[]{ex.getCause() != null ? ex.getCause() : ex.getMessage()});
                    }
                } else if ("update".equals(ddl)) {
                    currentDatabase = platform.readModelFromDatabase(connection, null);
                    Logger.debug((String)"Siena DDL Generator SQL: %s", (Object[])new Object[]{platform.getAlterModelSql(currentDatabase, database)});
                    platform.alterModel(currentDatabase, database, true);
                }
            }
            if (this.useLifecycle()) {
                Logger.debug((String)"Siena activating lifecycle management", (Object[])new Object[0]);
                persistenceManager = new PersistenceManagerLifeCycleWrapper(persistenceManager);
            }
            persistenceManager.init(null);
        } else if (dbType.equals("nosql:gae")) {
            Logger.debug((String)"Siena DB Type: GAE", (Object[])new Object[0]);
            persistenceManager = new GaePersistenceManager();
            if (this.useLifecycle()) {
                Logger.debug((String)"Siena activating lifecycle management", (Object[])new Object[0]);
                persistenceManager = new PersistenceManagerLifeCycleWrapper(persistenceManager);
            }
            persistenceManager.init(null);
        } else if (dbType.equals("nosql:sdb")) {
            Logger.debug((String)"Siena DB Type: SDB", (Object[])new Object[0]);
            persistenceManager = new SdbPersistenceManager();
            String awsAccessKeyId = Play.configuration.getProperty("siena.aws.accesskeyid");
            String awsSecretAccessKey = Play.configuration.getProperty("siena.aws.secretaccesskey");
            String prefix = Play.configuration.getProperty("siena.aws.prefix", "siena_devel_");
            String consistentread = Play.configuration.getProperty("siena.aws.consistentread", "true");
            if (awsAccessKeyId == null || awsSecretAccessKey == null) {
                throw new UnexpectedException("siena.aws.accesskeyid & siena.aws.secretaccesskey required in conf");
            }
            Properties p = new Properties();
            p.setProperty("implementation", "siena.sdb.SdbPersistenceManager");
            p.setProperty("awsAccessKeyId", awsAccessKeyId);
            p.setProperty("awsSecretAccessKey", awsSecretAccessKey);
            p.setProperty("prefix", prefix);
            if (this.useLifecycle()) {
                Logger.debug((String)"Siena activating lifecycle management", (Object[])new Object[0]);
                persistenceManager = new PersistenceManagerLifeCycleWrapper(persistenceManager);
            }
            persistenceManager.init(p);
            if (consistentread.toLowerCase().equals("true")) {
                persistenceManager.option((PmOption)SdbPersistenceManager.CONSISTENT_READ);
            }
        }
        for (Class c : classes) {
            PersistenceManagerFactory.install((PersistenceManager)persistenceManager, (Class)c);
        }
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (ClassInfo.isModel((Class)clazz)) {
            Field idField;
            Id idAnn;
            String keyName = SienaModelUtils.keyName(clazz);
            String idKey = name + "." + keyName;
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0 && (idAnn = (idField = SienaModelUtils.keyField(clazz)).getAnnotation(Id.class)) != null && idAnn.value() == Generator.AUTO_INCREMENT) {
                String id = params.get(idKey)[0];
                try {
                    Query query = SienaPlugin.pm().createQuery(clazz).filter(keyName, Binder.directBind((String)name, (Annotation[])annotations, (String)(id + ""), SienaModelUtils.keyType(clazz)));
                    Object o = query.get();
                    return SienaModelUtils.edit(o, name, params, annotations);
                }
                catch (Exception e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
            return SienaModelUtils.create(clazz, name, params, annotations);
        }
        return super.bind(name, clazz, type, annotations, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (ClassInfo.isModel(o.getClass())) {
            return SienaModelUtils.edit(o, name, params, null);
        }
        return null;
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.enhancer.enhanceThisClass(applicationClass);
    }

    public Model.Factory modelFactory(Class<? extends Model> modelClass) {
        if (ClassInfo.isModel(modelClass)) {
            return new SienaModelLoader(modelClass);
        }
        return null;
    }

    public static SienaModelLoader sienaModelFactory(Class<?> modelClass) {
        if (ClassInfo.isModel(modelClass)) {
            return new SienaModelLoader(modelClass);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SienaModelLoader
    implements Model.Factory {
        private Class<?> clazz;
        private ClassInfo sienaInfo;

        public SienaModelLoader(Class<?> clazz) {
            this.clazz = clazz;
            this.sienaInfo = ClassInfo.getClassInfo(clazz);
        }

        public Model findById(Object id) {
            if (id == null) {
                return null;
            }
            try {
                return new ModelWrapper(SienaPlugin.pm().getByKey(this.clazz, Binder.directBind((String)id.toString(), this.keyType())));
            }
            catch (Exception e) {
                return null;
            }
        }

        public String keyName() {
            Field f = this.keyField();
            return f == null ? null : f.getName();
        }

        public Class<?> keyType() {
            return this.keyField().getType();
        }

        public Object keyValue(Model m) {
            return SienaModelUtils.keyValue(m);
        }

        Field keyField() {
            return this.sienaInfo.getIdField();
        }

        public List<Model> fetch(int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
            ArrayList<Model> playModels = new ArrayList<Model>();
            for (Object obj : SienaModelUtils.fetch(SienaPlugin.pm(), this.clazz, offset, size, orderBy, order, searchFields, keywords, where)) {
                playModels.add(new ModelWrapper(obj));
            }
            return playModels;
        }

        public Long count(List<String> searchFields, String keywords, String where) {
            return SienaModelUtils.count(SienaPlugin.pm(), this.clazz, searchFields, keywords, where);
        }

        public void deleteAll() {
            SienaModelUtils.deleteAll(SienaPlugin.pm(), this.clazz);
        }

        public List<Model.Property> listProperties() {
            return SienaModelUtils.listProperties(SienaPlugin.pm(), this.clazz);
        }
    }
}

