/*
 * Decompiled with CFR 0.152.
 */
package siena.core.async;

import java.util.List;
import java.util.Map;
import siena.BaseQueryData;
import siena.Query;
import siena.core.async.PersistenceManagerAsync;
import siena.core.async.QueryAsync;
import siena.core.async.SienaFuture;
import siena.core.options.QueryOption;

public class BaseQueryAsync<T>
extends BaseQueryData<T>
implements QueryAsync<T> {
    private static final long serialVersionUID = -7039977099068819124L;
    private PersistenceManagerAsync pm;

    public BaseQueryAsync(PersistenceManagerAsync pm, Class<T> clazz) {
        super(clazz);
        this.pm = pm;
    }

    public BaseQueryAsync(BaseQueryAsync<T> query) {
        super(query);
        this.pm = query.pm;
    }

    public BaseQueryAsync(PersistenceManagerAsync pm, BaseQueryData<T> data) {
        super(data);
        this.pm = pm;
    }

    @Override
    public PersistenceManagerAsync getPersistenceManager() {
        return this.pm;
    }

    @Override
    public QueryAsync<T> filter(String fieldName, Object value) {
        this.addFilter(fieldName, value, this.pm.supportedOperators());
        return this;
    }

    @Override
    public QueryAsync<T> order(String fieldName) {
        this.addOrder(fieldName);
        return this;
    }

    @Override
    public QueryAsync<T> join(String fieldName, String ... sortFields) {
        this.addJoin(fieldName, sortFields);
        return this;
    }

    @Override
    public QueryAsync<T> aggregated(Object aggregator, String fieldName) {
        this.addAggregated(aggregator, fieldName);
        return this;
    }

    @Override
    public QueryAsync<T> owned(Object owner, String fieldName) {
        this.addOwned(owner, fieldName);
        return this;
    }

    @Override
    public QueryAsync<T> search(String match, String ... fields) {
        this.addSearch(match, fields);
        return this;
    }

    @Override
    public QueryAsync<T> search(String match, QueryOption opt, String ... fields) {
        this.addSearch(match, opt, fields);
        return this;
    }

    @Override
    public SienaFuture<T> get() {
        return this.pm.get(this);
    }

    @Override
    public SienaFuture<T> getByKey(Object key) {
        return this.pm.getByKey(this.clazz, key);
    }

    @Override
    public SienaFuture<Integer> delete() {
        return this.pm.delete(this);
    }

    @Override
    public SienaFuture<Integer> update(Map<String, ?> fieldValues) {
        return this.pm.update(this, fieldValues);
    }

    @Override
    public SienaFuture<Integer> count() {
        return this.pm.count(this);
    }

    @Override
    public SienaFuture<List<T>> fetch() {
        return this.pm.fetch(this);
    }

    @Override
    public SienaFuture<List<T>> fetch(int limit) {
        return this.pm.fetch(this, limit);
    }

    @Override
    public SienaFuture<List<T>> fetch(int limit, Object offset) {
        return this.pm.fetch(this, limit, offset);
    }

    @Override
    public SienaFuture<List<T>> fetchKeys() {
        return this.pm.fetchKeys(this);
    }

    @Override
    public SienaFuture<List<T>> fetchKeys(int limit) {
        return this.pm.fetchKeys(this, limit);
    }

    @Override
    public SienaFuture<List<T>> fetchKeys(int limit, Object offset) {
        return this.pm.fetchKeys(this, limit, offset);
    }

    @Override
    public SienaFuture<Iterable<T>> iter() {
        return this.pm.iter(this);
    }

    @Override
    public SienaFuture<Iterable<T>> iter(int limit) {
        return this.pm.iter(this, limit);
    }

    @Override
    public SienaFuture<Iterable<T>> iter(int limit, Object offset) {
        return this.pm.iter(this, limit, offset);
    }

    @Override
    public SienaFuture<Iterable<T>> iterPerPage(int limit) {
        return this.pm.iterPerPage(this, limit);
    }

    @Override
    public SienaFuture<Object> raw(String request) {
        return null;
    }

    @Override
    public QueryAsync<T> limit(int limit) {
        this.optionLimit(limit);
        return this;
    }

    @Override
    public QueryAsync<T> offset(Object offset) {
        this.optionOffset((Integer)offset);
        return this;
    }

    @Override
    public QueryAsync<T> paginate(int pageSize) {
        this.optionPaginate(pageSize);
        this.pm.paginate(this);
        return this;
    }

    @Override
    public QueryAsync<T> nextPage() {
        this.pm.nextPage(this);
        return this;
    }

    @Override
    public QueryAsync<T> previousPage() {
        this.pm.previousPage(this);
        return this;
    }

    @Override
    public QueryAsync<T> customize(QueryOption ... options) {
        this.addOptions(options);
        return this;
    }

    @Override
    public QueryAsync<T> stateful() {
        this.optionStateful();
        return this;
    }

    @Override
    public QueryAsync<T> stateless() {
        this.resetOptions();
        this.optionStateless();
        return this;
    }

    @Override
    public QueryAsync<T> release() {
        this.pm.release(this);
        return this;
    }

    @Override
    public QueryAsync<T> resetData() {
        super.reset();
        this.pm.release(this);
        return this;
    }

    @Override
    public String dump() {
        return null;
    }

    @Override
    public QueryAsync<T> restore(String dump) {
        return null;
    }

    @Override
    public Query<T> sync() {
        return this.pm.sync().createQuery(this);
    }

    @Override
    public QueryAsync<T> clone() {
        return new BaseQueryAsync<T>(this);
    }
}

