/*
 * Decompiled with CFR 0.152.
 */
package siena.core.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import siena.ClassInfo;
import siena.SienaException;
import siena.core.lifecycle.LifeCyclePhase;
import siena.core.lifecycle.PostDelete;
import siena.core.lifecycle.PostFetch;
import siena.core.lifecycle.PostInsert;
import siena.core.lifecycle.PostSave;
import siena.core.lifecycle.PostUpdate;
import siena.core.lifecycle.PreDelete;
import siena.core.lifecycle.PreFetch;
import siena.core.lifecycle.PreInsert;
import siena.core.lifecycle.PreSave;
import siena.core.lifecycle.PreUpdate;

public class LifeCycleUtils {
    private static final Map<Class<? extends Annotation>, LifeCyclePhase> lifeCycleClasses = new ConcurrentHashMap<Class<? extends Annotation>, LifeCyclePhase>(){
        private static final long serialVersionUID = -3454152184796684592L;
        {
            this.put(PreFetch.class, LifeCyclePhase.PRE_FETCH);
            this.put(PreInsert.class, LifeCyclePhase.PRE_INSERT);
            this.put(PreDelete.class, LifeCyclePhase.PRE_DELETE);
            this.put(PreUpdate.class, LifeCyclePhase.PRE_UPDATE);
            this.put(PreSave.class, LifeCyclePhase.PRE_SAVE);
            this.put(PostFetch.class, LifeCyclePhase.POST_FETCH);
            this.put(PostInsert.class, LifeCyclePhase.POST_INSERT);
            this.put(PostDelete.class, LifeCyclePhase.POST_DELETE);
            this.put(PostUpdate.class, LifeCyclePhase.POST_UPDATE);
            this.put(PostSave.class, LifeCyclePhase.POST_SAVE);
        }
    };

    public static List<LifeCyclePhase> getMethodLifeCycles(Method m) {
        ArrayList<LifeCyclePhase> l = new ArrayList<LifeCyclePhase>();
        for (Class<? extends Annotation> cl : lifeCycleClasses.keySet()) {
            if (!m.isAnnotationPresent(cl)) continue;
            l.add(lifeCycleClasses.get(cl));
        }
        return l;
    }

    public static void executeMethods(LifeCyclePhase lcp, ClassInfo ci, Object obj) {
        List<Method> methods = ci.getLifeCycleMethod(lcp);
        if (methods == null) {
            return;
        }
        try {
            for (Method m : methods) {
                Class<?>[] params = m.getParameterTypes();
                boolean wasAccessible = true;
                if (!m.isAccessible()) {
                    wasAccessible = false;
                    m.setAccessible(true);
                }
                if (params != null && params.length != 0) {
                    if (LifeCyclePhase.class.isAssignableFrom(params[0])) {
                        m.invoke(obj, new Object[]{lcp});
                    }
                } else {
                    m.invoke(obj, new Object[0]);
                }
                if (wasAccessible) continue;
                m.setAccessible(false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SienaException(e);
        }
        catch (IllegalAccessException e) {
            throw new SienaException(e);
        }
        catch (InvocationTargetException e) {
            throw new SienaException(e);
        }
    }
}

