/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Entity;
import java.lang.reflect.Field;
import java.util.Iterator;
import siena.ClassInfo;
import siena.core.async.QueryAsync;
import siena.core.options.QueryOptionPage;
import siena.gae.GaePersistenceManagerAsync;
import siena.gae.QueryOptionGaeContext;

public class GaeSienaIterableAsync<Model>
implements Iterable<Model> {
    Iterable<Entity> gaeIterable;
    QueryAsync<Model> query;
    GaePersistenceManagerAsync pm;

    GaeSienaIterableAsync(GaePersistenceManagerAsync pm, Iterable<Entity> gaeIterable, QueryAsync<Model> query) {
        this.gaeIterable = gaeIterable;
        this.query = query;
        this.pm = pm;
    }

    @Override
    public Iterator<Model> iterator() {
        return new SienaGaeIteratorAsync<Model>(this.query, this.gaeIterable);
    }

    public class SienaGaeIteratorAsync<T>
    implements Iterator<T> {
        Field id;
        QueryAsync<T> query;
        Iterator<Entity> gaeIterator;

        SienaGaeIteratorAsync(QueryAsync<T> query, Iterable<Entity> gaeIterable) {
            this.query = query;
            this.id = ClassInfo.getIdField(query.getQueriedClass());
            this.gaeIterator = gaeIterable.iterator();
            QueryOptionPage pag = (QueryOptionPage)query.option(1);
            QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
            if (pag.isPaginating() && !this.gaeIterator.hasNext()) {
                gaeCtx.noMoreDataAfter = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.gaeIterator.hasNext();
        }

        @Override
        public T next() {
            Entity entity = this.gaeIterator.next();
            T obj = GaeSienaIterableAsync.this.pm.map(this.query, entity);
            return obj;
        }

        @Override
        public void remove() {
            this.gaeIterator.remove();
        }
    }
}

