/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import siena.ClassInfo;
import siena.Id;
import siena.Json;
import siena.Query;
import siena.QueryData;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryFilterSimple;
import siena.QueryOrder;
import siena.SienaException;
import siena.SienaRestrictedApiException;
import siena.Util;
import siena.core.Base64;
import siena.core.DecimalPrecision;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.embed.Embedded;
import siena.embed.JavaSerializer;
import siena.embed.JsonSerializer;
import siena.sdb.QueryOptionSdbContext;
import siena.sdb.SdbNativeSerializer;
import siena.sdb.ws.SimpleDB;

public class SdbMappingUtils {
    private static long ioffset = Math.abs(Integer.MIN_VALUE);
    public static final String WHERE = " where ";
    public static final String AND = " and ";
    public static final String OR = " or ";
    public static final String IS_NULL = " is null ";
    public static final String IS_NOT_NULL = " is not null ";
    public static final String ITEM_NAME = "itemName()";
    public static final String ALL_COLS = "*";
    public static final String SELECT = "select ";
    public static final String FROM = " from ";
    public static final String ORDER_BY = " order by ";
    public static final String DESC = " desc";
    public static final String IN_BEGIN = " in(";
    public static final String IN_END = ")";
    public static final String COUNT_BEGIN = " count(";
    public static final String COUNT_END = ")";
    public static final String LIMIT = " limit ";
    public static final String LIKE = " like ";
    public static final String EQ = " = ";

    public static String getDomainName(Class<?> clazz, String prefix) {
        ClassInfo ci = ClassInfo.getClassInfo(clazz);
        if (ClassInfo.isAutoIncrement(ci.getIdField())) {
            throw new SienaRestrictedApiException("DB", "getItemName", "@Id AUTO_INCREMENT not supported by SDB");
        }
        String domain = String.valueOf(prefix) + ci.tableName;
        return domain;
    }

    public static void getDomainName(StringBuffer str, Class<?> clazz, String prefix) {
        str.append(String.valueOf(prefix) + ClassInfo.getClassInfo(clazz).tableName);
    }

    public static String getAttributeName(Field field) {
        return ClassInfo.getColumnNames(field)[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getItemName(Class<?> clazz, Object obj) {
        Field idField = ClassInfo.getIdField(clazz);
        Id id = idField.getAnnotation(Id.class);
        String keyVal = null;
        if (id == null) throw new SienaException("Field " + idField.getName() + " is not an @Id field");
        switch (id.value()) {
            case NONE: {
                Object idVal = Util.readField(obj, idField);
                if (idVal != null) return SdbMappingUtils.toString(idField, idVal);
                throw new SienaException("Id Field " + idField.getName() + " value null");
            }
            case AUTO_INCREMENT: {
                throw new SienaRestrictedApiException("DB", "getItemName", "@Id AUTO_INCREMENT not supported by SDB");
            }
            case UUID: {
                Object idVal = Util.readField(obj, idField);
                if (idVal != null) return SdbMappingUtils.toString(idField, idVal);
                UUID uuid = UUID.randomUUID();
                keyVal = uuid.toString();
                if (idField.getType() == UUID.class) {
                    Util.setField(obj, idField, uuid);
                    return keyVal;
                }
                if (idField.getType() != String.class) throw new SienaRestrictedApiException("DB", "getItemName", "@Id UUID must be of type String or UUID");
                Util.setField(obj, idField, uuid.toString());
                return keyVal;
            }
            default: {
                throw new SienaRestrictedApiException("DB", "createEntityInstance", "Id Generator " + (Object)((Object)id.value()) + " not supported");
            }
        }
    }

    public static String getItemNameFromKey(Class<?> clazz, Object key) {
        String keyVal;
        block6: {
            Field idField;
            block5: {
                idField = ClassInfo.getIdField(clazz);
                Id id = idField.getAnnotation(Id.class);
                keyVal = null;
                if (id == null) break block5;
                switch (id.value()) {
                    case NONE: {
                        keyVal = SdbMappingUtils.toString(idField, key);
                        break block6;
                    }
                    case AUTO_INCREMENT: {
                        throw new SienaRestrictedApiException("DB", "getItemName", "@Id AUTO_INCREMENT not supported by SDB");
                    }
                    case UUID: {
                        keyVal = SdbMappingUtils.toString(idField, key);
                        break block6;
                    }
                    default: {
                        throw new SienaRestrictedApiException("DB", "createEntityInstance", "Id Generator " + (Object)((Object)id.value()) + " not supported");
                    }
                }
            }
            throw new SienaException("Field " + idField.getName() + " is not an @Id field");
        }
        return keyVal;
    }

    public static PutAttributesRequest createPutRequest(String domain, Class<?> clazz, ClassInfo info, Object obj) {
        PutAttributesRequest req = new PutAttributesRequest().withDomainName(domain);
        req.withItemName(SdbMappingUtils.getItemName(clazz, obj));
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            try {
                String value = SdbMappingUtils.objectFieldToString(obj, field);
                if (value != null) {
                    ReplaceableAttribute attr = new ReplaceableAttribute(SdbMappingUtils.getAttributeName(field), value, Boolean.valueOf(true));
                    req.withAttributes(new ReplaceableAttribute[]{attr});
                    continue;
                }
                if (!ClassInfo.isEmbeddedNative(field)) continue;
                SdbNativeSerializer.embed(req, ClassInfo.getSingleColumnName(field), (Object)value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return req;
    }

    public static ReplaceableItem createItem(Object obj) {
        Class<?> clazz = obj.getClass();
        ReplaceableItem item = new ReplaceableItem(SdbMappingUtils.getItemName(clazz, obj));
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            try {
                String value = SdbMappingUtils.objectFieldToString(obj, field);
                if (value != null) {
                    ReplaceableAttribute attr = new ReplaceableAttribute(SdbMappingUtils.getAttributeName(field), value, Boolean.valueOf(true));
                    item.withAttributes(new ReplaceableAttribute[]{attr});
                    continue;
                }
                if (!ClassInfo.isEmbeddedNative(field)) continue;
                SdbNativeSerializer.embed(item, ClassInfo.getSingleColumnName(field), (Object)value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return item;
    }

    public static DeletableItem createDeletableItem(Object obj) {
        Class<?> clazz = obj.getClass();
        return new DeletableItem().withName(SdbMappingUtils.getItemName(clazz, obj));
    }

    public static <T> DeletableItem createDeletableItemFromKey(Class<T> clazz, Object key) {
        return new DeletableItem().withName(SdbMappingUtils.getItemNameFromKey(clazz, key));
    }

    public static GetAttributesRequest createGetRequest(String domain, Class<?> clazz, Object obj) {
        GetAttributesRequest req = new GetAttributesRequest().withDomainName(domain).withItemName(SdbMappingUtils.getItemName(clazz, obj));
        return req;
    }

    public static GetAttributesRequest createGetRequestFromKey(String domain, Class<?> clazz, Object key) {
        GetAttributesRequest req = new GetAttributesRequest().withDomainName(domain).withItemName(key.toString());
        return req;
    }

    public static DeleteAttributesRequest createDeleteRequest(String domain, Class<?> clazz, Object obj) {
        DeleteAttributesRequest req = new DeleteAttributesRequest().withDomainName(domain).withItemName(SdbMappingUtils.getItemName(clazz, obj));
        return req;
    }

    public static String objectFieldToString(Object obj, Field field) {
        Object val = Util.readField(obj, field);
        if (val == null) {
            return null;
        }
        return SdbMappingUtils.toString(field, val);
    }

    public static String toString(Object val) {
        Class<?> type = val.getClass();
        if (type == Integer.class || type == Integer.TYPE) {
            return SdbMappingUtils.toString((Integer)val);
        }
        if (ClassInfo.isModel(type)) {
            try {
                return SdbMappingUtils.objectFieldToString(val, ClassInfo.getIdField(type));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (type == Json.class) {
            return val.toString();
        }
        if (type == byte[].class) {
            return Base64.encodeBytes((byte[])val);
        }
        if (type == BigDecimal.class) {
            return ((BigDecimal)val).toPlainString();
        }
        if (Enum.class.isAssignableFrom(type)) {
            return val.toString();
        }
        return val.toString();
    }

    public static String toString(Field field, Object val) {
        if (val == null) {
            return null;
        }
        Class<?> type = field.getType();
        if (type == Integer.class || type == Integer.TYPE) {
            return SdbMappingUtils.intToString((Integer)val);
        }
        if (ClassInfo.isModel(type) && !ClassInfo.isEmbedded(field)) {
            try {
                return SdbMappingUtils.objectFieldToString(val, ClassInfo.getIdField(type));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (type == Json.class) {
            return val.toString();
        }
        if (type == byte[].class) {
            return Base64.encodeBytes((byte[])val);
        }
        if (ClassInfo.isEmbedded(field)) {
            Embedded embed = field.getAnnotation(Embedded.class);
            switch (embed.mode()) {
                case SERIALIZE_JSON: {
                    return JsonSerializer.serialize(val).toString();
                }
                case SERIALIZE_JAVA: {
                    try {
                        return Base64.encodeBytes(JavaSerializer.serialize(val));
                    }
                    catch (IOException ex) {
                        throw new SienaException(ex);
                    }
                }
                case NATIVE: {
                    return null;
                }
            }
        } else if (type == BigDecimal.class) {
            DecimalPrecision ann = field.getAnnotation(DecimalPrecision.class);
            if (ann == null) {
                return ((BigDecimal)val).toPlainString();
            }
            switch (ann.storageType()) {
                case DOUBLE: {
                    return Double.valueOf(((BigDecimal)val).doubleValue()).toString();
                }
                case NATIVE: 
                case STRING: {
                    return ((BigDecimal)val).toPlainString();
                }
            }
        } else if (Enum.class.isAssignableFrom(field.getType())) {
            return val.toString();
        }
        return Util.toString(field, val);
    }

    public static String intToString(int i) {
        return String.format("%010d", (long)i + ioffset);
    }

    public static int intFromString(String s) {
        long l = Long.parseLong(s);
        return (int)(l - ioffset);
    }

    public static void setFromString(Object obj, Field field, String val) {
        if (val == null) {
            return;
        }
        Class<?> fieldClass = field.getType();
        if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
            Util.setField(obj, field, SdbMappingUtils.intFromString(val));
            return;
        }
        if (ClassInfo.isModel(fieldClass) && !ClassInfo.isEmbedded(field)) {
            try {
                Object relObj = Util.createObjectInstance(fieldClass);
                Field relIdField = ClassInfo.getIdField(fieldClass);
                SdbMappingUtils.setFromString(relObj, relIdField, val);
                Util.setField(obj, field, relObj);
                return;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        if (fieldClass == byte[].class) {
            try {
                Util.setField(obj, field, Base64.decode(val));
                return;
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
        }
        if (ClassInfo.isEmbeddedNative(field)) {
            return;
        }
        if (fieldClass == BigDecimal.class) {
            DecimalPrecision ann = field.getAnnotation(DecimalPrecision.class);
            if (ann == null) {
                Util.setField(obj, field, new BigDecimal(val));
                return;
            }
            switch (ann.storageType()) {
                case DOUBLE: {
                    Util.setField(obj, field, new BigDecimal(val));
                    return;
                }
                case NATIVE: 
                case STRING: {
                    Util.setField(obj, field, new BigDecimal(val));
                    return;
                }
            }
        }
        Util.setFromObject(obj, field, val);
    }

    public static void fillModelKeysOnly(String itemName, Class<?> clazz, Object obj) {
        Field idField = ClassInfo.getIdField(clazz);
        SdbMappingUtils.setFromString(obj, idField, itemName);
    }

    public static void fillModel(String itemName, List<Attribute> attrs, Class<?> clazz, Object obj) {
        SdbMappingUtils.fillModelKeysOnly(itemName, clazz, obj);
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            if (!ClassInfo.isEmbeddedNative(field)) {
                Attribute theAttr = null;
                String attrName = SdbMappingUtils.getAttributeName(field);
                for (Attribute attr : attrs) {
                    if (!attrName.equals(attr.getName())) continue;
                    theAttr = attr;
                    attrs.remove(attr);
                    break;
                }
                if (theAttr == null) continue;
                SdbMappingUtils.setFromString(obj, field, theAttr.getValue());
                continue;
            }
            Object value = SdbNativeSerializer.unembed(field.getType(), ClassInfo.getSingleColumnName(field), attrs);
            Util.setField(obj, field, value);
        }
    }

    public static void fillModel(String itemName, GetAttributesResult res, Class<?> clazz, Object obj) {
        SdbMappingUtils.fillModel(itemName, res.getAttributes(), clazz, obj);
    }

    public static void fillModel(Item item, Class<?> clazz, ClassInfo info, Object obj) {
        SdbMappingUtils.fillModel(item.getName(), item.getAttributes(), clazz, obj);
    }

    public static void fillModelKeysOnly(Item item, Class<?> clazz, ClassInfo info, Object obj) {
        SdbMappingUtils.fillModelKeysOnly(item.getName(), clazz, obj);
    }

    public static <T> int mapSelectResult(SelectResult res, Iterable<T> objects) {
        List items = res.getItems();
        Class<?> clazz = null;
        ClassInfo info = null;
        int nb = 0;
        for (T obj : objects) {
            if (clazz == null) {
                clazz = obj.getClass();
                info = ClassInfo.getClassInfo(clazz);
            }
            String itemName = SdbMappingUtils.getItemName(clazz, obj);
            Item theItem = null;
            for (Item item : items) {
                if (!item.getName().equals(itemName)) continue;
                theItem = item;
                items.remove(item);
                break;
            }
            if (theItem == null) continue;
            SdbMappingUtils.fillModel(theItem, clazz, info, obj);
            ++nb;
        }
        return nb;
    }

    public static <T> void mapSelectResultToList(SelectResult res, List<T> resList, Class<T> clazz) {
        List items = res.getItems();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Item item : items) {
            T obj = Util.createObjectInstance(clazz);
            SdbMappingUtils.fillModel(item, clazz, info, obj);
            resList.add(obj);
        }
    }

    public static <T> void mapSelectResultToList(SelectResult res, List<T> resList, Class<T> clazz, int offset) {
        List items = res.getItems();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        int i = offset;
        while (i < items.size()) {
            Item item = (Item)items.get(i);
            T obj = Util.createObjectInstance(clazz);
            SdbMappingUtils.fillModel(item, clazz, info, obj);
            resList.add(obj);
            ++i;
        }
    }

    public static <T> void mapSelectResultToListKeysOnly(SelectResult res, List<T> resList, Class<T> clazz) {
        List items = res.getItems();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Item item : items) {
            T obj = Util.createObjectInstance(clazz);
            SdbMappingUtils.fillModelKeysOnly(item, clazz, info, obj);
            resList.add(obj);
        }
    }

    public static <T> void mapSelectResultToListKeysOnly(SelectResult res, List<T> resList, Class<T> clazz, int offset) {
        List items = res.getItems();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        int i = offset;
        while (i < items.size()) {
            Item item = (Item)items.get(i);
            T obj = Util.createObjectInstance(clazz);
            SdbMappingUtils.fillModelKeysOnly(item, clazz, info, obj);
            resList.add(obj);
            ++i;
        }
    }

    public static <T> void mapSelectResultToListOrderedFromKeys(SelectResult res, List<T> resList, Class<T> clazz, Iterable<?> keys) {
        List items = res.getItems();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Object key : keys) {
            boolean found = false;
            for (Item item : items) {
                if (!item.getName().equals(SdbMappingUtils.getItemNameFromKey(clazz, key))) continue;
                T obj = Util.createObjectInstance(clazz);
                SdbMappingUtils.fillModel(item, clazz, info, obj);
                resList.add(obj);
                items.remove(item);
                found = true;
                break;
            }
            if (found) continue;
            resList.add(null);
        }
    }

    public static int mapSelectResultToCount(SelectResult res) {
        Attribute attr;
        Item item = (Item)res.getItems().get(0);
        if (item != null && "Count".equals((attr = (Attribute)item.getAttributes().get(0)).getName())) {
            return Integer.parseInt(attr.getValue());
        }
        return -1;
    }

    public static String quote(String s) {
        return "\"" + s.replace("'", "''") + "\"";
    }

    public static <T> SelectRequest buildBatchGetQuery(Iterable<T> objects, String prefix, StringBuffer domainBuf) {
        Class<?> clazz = null;
        StringBuilder q = new StringBuilder();
        String domain = null;
        boolean first = true;
        for (T obj : objects) {
            if (clazz == null) {
                clazz = obj.getClass();
                domain = SdbMappingUtils.getDomainName(clazz, prefix);
                domainBuf.append(domain);
                q.append("select * from " + domain + WHERE + ITEM_NAME + IN_BEGIN);
            }
            String itemName = SdbMappingUtils.getItemName(clazz, obj);
            if (!first) {
                q.append(",");
            } else {
                first = false;
            }
            q.append(SdbMappingUtils.quote(itemName));
        }
        q.append(")");
        return new SelectRequest(q.toString());
    }

    public static <T> SelectRequest buildBatchGetQueryByKeys(Class<T> clazz, Iterable<?> keys, String prefix, StringBuffer domainBuf) {
        String domain = SdbMappingUtils.getDomainName(clazz, prefix);
        domainBuf.append(domain);
        StringBuilder q = new StringBuilder();
        q.append("select * from " + domain + WHERE + ITEM_NAME + IN_BEGIN);
        boolean first = true;
        for (Object key : keys) {
            String itemName = SdbMappingUtils.toString(key);
            if (!first) {
                q.append(",");
            } else {
                first = false;
            }
            q.append(SdbMappingUtils.quote(itemName));
        }
        q.append(")");
        return new SelectRequest(q.toString());
    }

    public static <T> SelectRequest buildCountQuery(Query<T> query, String prefix, StringBuffer domainBuf) {
        String domain = SdbMappingUtils.getDomainName(query.getQueriedClass(), prefix);
        domainBuf.append(domain);
        StringBuilder q = new StringBuilder();
        q.append("select  count(*) from " + domain);
        return new SelectRequest(SdbMappingUtils.buildFilterOrder(query, q).toString());
    }

    public static <T> SelectRequest buildQuery(Query<T> query, String prefix, StringBuffer domainBuf) {
        Class clazz = query.getQueriedClass();
        String domain = SdbMappingUtils.getDomainName(clazz, prefix);
        domainBuf.append(domain);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        StringBuilder q = new StringBuilder();
        switch (fetchType.fetchType) {
            case KEYS_ONLY: {
                q.append("select itemName() from " + domain);
                break;
            }
            default: {
                q.append("select * from " + domain);
            }
        }
        return new SelectRequest(SdbMappingUtils.buildFilterOrder(query, q).toString());
    }

    public static <T> StringBuilder buildFilterOrder(Query<T> query, StringBuilder q) {
        List<QueryOrder> orders;
        List<QueryFilter> filters = query.getFilters();
        HashSet<Field> filteredFields = new HashSet<Field>();
        boolean first = true;
        if (!filters.isEmpty()) {
            q.append(WHERE);
            for (QueryFilter filter : filters) {
                if (QueryFilterSimple.class.isAssignableFrom(filter.getClass())) {
                    QueryFilterSimple qf = (QueryFilterSimple)filter;
                    Field f = qf.field;
                    Object value = qf.value;
                    String op = qf.operator;
                    filteredFields.add(f);
                    if (!first) {
                        q.append(AND);
                    }
                    first = false;
                    String[] columns = ClassInfo.getColumnNames(f);
                    if ("IN".equals(op)) {
                        if (!Collection.class.isAssignableFrom(value.getClass())) {
                            throw new SienaException("Collection needed when using IN operator in filter() query");
                        }
                        StringBuilder s = new StringBuilder();
                        Collection col = (Collection)value;
                        for (Object object : col) {
                            if (object != null) {
                                s.append("," + SimpleDB.quote(SdbMappingUtils.toString(f, object)));
                                continue;
                            }
                            throw new SienaException("Can't use NULL in collection for IN operator");
                        }
                        String column = null;
                        column = ClassInfo.isId(f) ? ITEM_NAME : ClassInfo.getColumnNames(f)[0];
                        q.append(String.valueOf(column) + IN_BEGIN + s.toString().substring(1) + ")");
                        continue;
                    }
                    if (ClassInfo.isModel(f.getType())) {
                        if (!op.equals("=")) {
                            throw new SienaException("Unsupported operator for relationship: " + op);
                        }
                        ClassInfo relInfo = ClassInfo.getClassInfo(f.getType());
                        int i = 0;
                        for (Field key : relInfo.keys) {
                            if (value == null) {
                                q.append(String.valueOf(columns[i++]) + IS_NULL);
                                continue;
                            }
                            q.append(String.valueOf(columns[i++]) + op + SimpleDB.quote(SdbMappingUtils.objectFieldToString(value, key)));
                        }
                        continue;
                    }
                    String column = null;
                    if (ClassInfo.isId(f)) {
                        column = ITEM_NAME;
                        if (value == null && op.equals("=")) {
                            throw new SienaException("SDB filter on @Id field with 'IS NULL' is not possible");
                        }
                    } else {
                        column = ClassInfo.getColumnNames(f)[0];
                    }
                    if (value == null && op.equals("=")) {
                        q.append(String.valueOf(column) + IS_NULL);
                        continue;
                    }
                    if (value == null && op.equals("!=")) {
                        q.append(String.valueOf(column) + IS_NOT_NULL);
                        continue;
                    }
                    q.append(String.valueOf(column) + op + SimpleDB.quote(SdbMappingUtils.toString(f, value)));
                    continue;
                }
                if (!QueryFilterSearch.class.isAssignableFrom(filter.getClass())) continue;
                Class clazz = query.getQueriedClass();
                QueryFilterSearch qf = (QueryFilterSearch)filter;
                try {
                    String[] words = qf.match.split("\\s");
                    Pattern pNormal = Pattern.compile("[\\%]*(\\w+)[\\%]*");
                    if (!first) {
                        q.append(AND);
                    }
                    first = true;
                    q.append(" ( ");
                    String[] stringArray = qf.fields;
                    int n = qf.fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        Field field = Util.getField(clazz, f);
                        if (!first) {
                            q.append(OR);
                        }
                        first = false;
                        q.append(" ( ");
                        String column = null;
                        column = ClassInfo.isId(field) ? ITEM_NAME : ClassInfo.getColumnNames(field)[0];
                        first = true;
                        String[] stringArray2 = words;
                        int n3 = words.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String word = stringArray2[n4];
                            if (!first) {
                                q.append(OR);
                            }
                            first = false;
                            if (!pNormal.matcher(word).matches()) {
                                throw new SienaException("'" + word + "' doesn't match pattern [\\%]*(\\w+)[\\%]*");
                            }
                            if (word.contains("%")) {
                                q.append(String.valueOf(column) + LIKE + SimpleDB.quote(word));
                            } else {
                                q.append(String.valueOf(column) + EQ + SimpleDB.quote(word));
                            }
                            ++n4;
                        }
                        q.append(" ) ");
                        ++n2;
                    }
                    q.append(" ) ");
                }
                catch (Exception e) {
                    throw new SienaException(e);
                }
            }
        }
        if (!(orders = query.getOrders()).isEmpty()) {
            QueryOrder last = orders.get(orders.size() - 1);
            Field field = last.field;
            if (ClassInfo.isId(field)) {
                if (!filteredFields.contains(field)) {
                    if (filters.isEmpty()) {
                        q.append(WHERE);
                    } else {
                        q.append(AND);
                    }
                    q.append("itemName() is not null ");
                }
                q.append(" order by itemName()");
            } else {
                String column = ClassInfo.getColumnNames(field)[0];
                if (!filteredFields.contains(field)) {
                    if (filters.isEmpty()) {
                        q.append(WHERE);
                    } else {
                        q.append(AND);
                    }
                    q.append(String.valueOf(column) + IS_NOT_NULL);
                }
                q.append(ORDER_BY + column);
            }
            if (!last.ascending) {
                q.append(DESC);
            }
        }
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (sdbCtx != null && sdbCtx.realPageSize != 0) {
            if (off != null && off.isActive()) {
                q.append(LIMIT + (sdbCtx.realPageSize + off.offset));
            } else {
                q.append(LIMIT + sdbCtx.realPageSize);
            }
        }
        return q;
    }

    public static <T> void nextPage(QueryData<T> query) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (sdbCtx == null) {
            sdbCtx = new QueryOptionSdbContext();
            query.options().put(sdbCtx.type, sdbCtx);
        }
        if (sdbCtx.noMoreDataAfter) {
            return;
        }
        if (sdbCtx.noMoreDataBefore) {
            sdbCtx.noMoreDataBefore = false;
            return;
        }
        if (pag.isPaginating()) {
            if (sdbCtx.hasToken()) {
                if (sdbCtx.nextToken() == null) {
                    sdbCtx.noMoreDataAfter = true;
                } else {
                    sdbCtx.realOffset = off.isActive() ? (sdbCtx.realOffset += pag.pageSize + off.offset) : (sdbCtx.realOffset += pag.pageSize);
                    if (sdbCtx.currentTokenOffset() <= sdbCtx.realOffset) {
                        off.activate();
                        off.offset = sdbCtx.realOffset - sdbCtx.currentTokenOffset();
                    } else {
                        SdbMappingUtils.nextPage(query);
                    }
                }
            } else {
                QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                offset.activate();
                offset.offset += pag.pageSize;
                sdbCtx.realOffset += pag.pageSize;
            }
        } else {
            throw new SienaException("Can't use nextPage after pagination has been interrupted...");
        }
    }

    public static <T> void previousPage(QueryData<T> query) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        if (sdbCtx == null) {
            sdbCtx = new QueryOptionSdbContext();
            query.options().put(sdbCtx.type, sdbCtx);
        }
        if (sdbCtx.noMoreDataBefore) {
            return;
        }
        if (sdbCtx.noMoreDataAfter) {
            sdbCtx.realOffset += pag.pageSize;
            sdbCtx.noMoreDataAfter = false;
        }
        if (pag.isPaginating()) {
            if (sdbCtx.hasToken()) {
                if (sdbCtx.tokenIdx == 0) {
                    sdbCtx.previousToken();
                    sdbCtx.realOffset -= pag.pageSize;
                    if (sdbCtx.currentTokenOffset() <= sdbCtx.realOffset) {
                        QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                        offset.activate();
                        offset.offset = sdbCtx.realOffset - sdbCtx.currentTokenOffset();
                    } else {
                        SdbMappingUtils.previousPage(query);
                    }
                } else if (sdbCtx.previousToken() == null) {
                    sdbCtx.realOffset -= pag.pageSize;
                    if (sdbCtx.realOffset >= 0) {
                        QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                        offset.activate();
                        offset.offset = sdbCtx.realOffset;
                    } else {
                        sdbCtx.realOffset = 0;
                        sdbCtx.noMoreDataBefore = true;
                    }
                } else {
                    sdbCtx.realOffset -= pag.pageSize;
                    if (sdbCtx.currentTokenOffset() <= sdbCtx.realOffset) {
                        QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                        offset.activate();
                        offset.offset = sdbCtx.realOffset - sdbCtx.currentTokenOffset();
                    } else {
                        SdbMappingUtils.previousPage(query);
                    }
                }
            } else {
                QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                if (sdbCtx.realOffset != 0) {
                    sdbCtx.realOffset -= pag.pageSize;
                    offset.activate();
                    offset.offset = sdbCtx.realOffset;
                } else {
                    sdbCtx.noMoreDataBefore = true;
                }
            }
        } else {
            throw new SienaException("Can't use nextPage after pagination has been interrupted...");
        }
    }
}

