/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import com.amazonaws.services.simpledb.model.Item;
import java.lang.reflect.Field;
import java.util.Iterator;
import siena.ClassInfo;
import siena.Query;
import siena.Util;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.sdb.QueryOptionSdbContext;
import siena.sdb.SdbMappingUtils;
import siena.sdb.SdbPersistenceManager;

public class SdbSienaIterable<Model>
implements Iterable<Model> {
    protected Iterable<Item> items;
    protected Query<Model> query;
    protected SdbPersistenceManager pm;

    SdbSienaIterable(SdbPersistenceManager pm, Iterable<Item> items, Query<Model> query) {
        this.pm = pm;
        this.items = items;
        this.query = query;
    }

    @Override
    public Iterator<Model> iterator() {
        return new SdbSienaIterator<Model>(this.query, this.items);
    }

    public class SdbSienaIterator<T>
    implements Iterator<T> {
        Field id;
        Query<T> query;
        Iterator<Item> it;
        int idx = 0;
        QueryOptionPage pag;
        QueryOptionSdbContext sdbCtx;
        QueryOptionState state;
        QueryOptionOffset off;

        SdbSienaIterator(Query<T> query, Iterable<Item> items) {
            this.query = query;
            this.id = ClassInfo.getIdField(query.getQueriedClass());
            this.it = items.iterator();
            this.pag = (QueryOptionPage)query.option(1);
            this.sdbCtx = (QueryOptionSdbContext)query.option(12289);
            this.state = (QueryOptionState)query.option(3);
            this.off = (QueryOptionOffset)query.option(2);
            if (this.off != null && this.off.offset != 0) {
                int i = 0;
                while (i < this.off.offset) {
                    if (this.it.hasNext()) {
                        this.it.next();
                    }
                    ++i;
                }
            }
            if (this.pag.isPaginating()) {
                this.sdbCtx.noMoreDataAfter = !this.it.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            boolean n = this.it.hasNext();
            if (!n) {
                int pageSize = this.sdbCtx.realPageSize - this.idx;
                if (!this.pag.isPaginating()) {
                    String token = null;
                    if (this.state.isStateful()) {
                        token = this.sdbCtx.currentToken();
                        if (!this.pag.isActive()) {
                            pageSize = Integer.MAX_VALUE;
                        }
                    } else {
                        token = this.sdbCtx.nextToken();
                        if (this.pag.isActive()) {
                            this.pag.passivate();
                            this.pag.pageSize = 0;
                        } else {
                            pageSize = Integer.MAX_VALUE;
                        }
                        if (this.off.isActive()) {
                            this.off.passivate();
                            this.off.offset = 0;
                        }
                    }
                    if (token != null && pageSize > 0) {
                        SdbSienaIterable iter = (SdbSienaIterable)SdbSienaIterable.this.pm.doFetchIterable(this.query, pageSize, 0, true);
                        SdbSienaIterable.this.items = iter.items;
                        this.it = SdbSienaIterable.this.items.iterator();
                        this.idx = 0;
                        return this.it.hasNext();
                    }
                    if (token == null) {
                        this.sdbCtx.noMoreDataAfter = true;
                    }
                } else {
                    boolean b = this.sdbCtx.hasNextToken();
                    if (b && pageSize > 0) {
                        this.sdbCtx.nextToken();
                        SdbSienaIterable iter = (SdbSienaIterable)SdbSienaIterable.this.pm.doFetchIterable(this.query, pageSize, 0, true);
                        SdbSienaIterable.this.items = iter.items;
                        this.it = SdbSienaIterable.this.items.iterator();
                        this.idx = 0;
                        return this.it.hasNext();
                    }
                    if (!b) {
                        this.sdbCtx.noMoreDataAfter = true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            Item item = this.it.next();
            ++this.idx;
            Class clazz = this.query.getQueriedClass();
            QueryOptionFetchType fetchType = (QueryOptionFetchType)this.query.option(4);
            Object obj = Util.createObjectInstance(clazz);
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    SdbMappingUtils.fillModelKeysOnly(item, clazz, ClassInfo.getClassInfo(clazz), obj);
                }
            }
            SdbMappingUtils.fillModel(item, clazz, ClassInfo.getClassInfo(clazz), obj);
            if (!this.query.getJoins().isEmpty() || !ClassInfo.getClassInfo(this.query.getQueriedClass()).joinFields.isEmpty()) {
                SdbSienaIterable.this.pm.mapJoins(this.query, obj);
            }
            return obj;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

