/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import java.lang.reflect.Field;
import java.util.Iterator;
import siena.ClassInfo;
import siena.core.async.QueryAsync;
import siena.core.options.QueryOptionPage;
import siena.gae.GaePersistenceManagerAsync;
import siena.gae.QueryOptionGaeContext;

public class GaeSienaIterableAsyncWithCursor<Model>
implements Iterable<Model> {
    QueryResultIterable<Entity> gaeIterable;
    QueryAsync<Model> query;
    GaePersistenceManagerAsync pm;

    GaeSienaIterableAsyncWithCursor(GaePersistenceManagerAsync pm, QueryResultIterable<Entity> gaeIterable, QueryAsync<Model> query) {
        this.gaeIterable = gaeIterable;
        this.query = query;
        this.pm = pm;
    }

    @Override
    public Iterator<Model> iterator() {
        return new SienaGaeIteratorAsyncWithCursor<Model>(this.query, this.gaeIterable);
    }

    public class SienaGaeIteratorAsyncWithCursor<T>
    implements Iterator<T> {
        Field id;
        QueryAsync<T> query;
        QueryResultIterator<Entity> gaeIterator;

        SienaGaeIteratorAsyncWithCursor(QueryAsync<T> query, QueryResultIterable<Entity> gaeIterable) {
            this.query = query;
            this.id = ClassInfo.getIdField(query.getQueriedClass());
            this.gaeIterator = gaeIterable.iterator();
            QueryOptionPage pag = (QueryOptionPage)query.option(1);
            QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
            if (pag.isPaginating()) {
                gaeCtx.noMoreDataAfter = !this.gaeIterator.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.gaeIterator.hasNext();
        }

        @Override
        public T next() {
            Entity entity = (Entity)this.gaeIterator.next();
            QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)this.query.option(8193);
            Cursor cursor = this.gaeIterator.getCursor();
            if (cursor != null) {
                gaeCtx.setCurrentCursor(cursor.toWebSafeString());
            }
            ++gaeCtx.realOffset;
            T obj = GaeSienaIterableAsyncWithCursor.this.pm.map(this.query, entity);
            return obj;
        }

        @Override
        public void remove() {
            this.gaeIterator.remove();
        }
    }
}

