/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import siena.ClassInfo;
import siena.SienaException;
import siena.Util;
import siena.sdb.SdbMappingUtils;

public class SdbNativeSerializer {
    private static final String SEPARATOR = ".";

    public static String getEmbeddedAttributeName(String embeddingColumnName, Field field) {
        return String.valueOf(embeddingColumnName) + SEPARATOR + ClassInfo.getSingleColumnName(field);
    }

    public static void embed(PutAttributesRequest req, String embeddingColumnName, Object embeddedObj) {
        Class<?> clazz = embeddedObj.getClass();
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        for (Field f : ClassInfo.getClassInfo(clazz).updateFields) {
            String propValue = SdbMappingUtils.objectFieldToString(embeddedObj, f);
            if (propValue != null) {
                ReplaceableAttribute attr = new ReplaceableAttribute(SdbNativeSerializer.getEmbeddedAttributeName(embeddingColumnName, f), propValue, Boolean.valueOf(true));
                req.withAttributes(new ReplaceableAttribute[]{attr});
                continue;
            }
            if (!ClassInfo.isEmbeddedNative(f)) continue;
            SdbNativeSerializer.embed(req, SdbNativeSerializer.getEmbeddedAttributeName(embeddingColumnName, f), Util.readField(embeddedObj, f));
        }
    }

    public static void embed(ReplaceableItem item, String embeddingColumnName, Object embeddedObj) {
        Class<?> clazz = embeddedObj.getClass();
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        for (Field f : ClassInfo.getClassInfo(clazz).updateFields) {
            String propValue = SdbMappingUtils.objectFieldToString(embeddedObj, f);
            if (propValue != null) {
                ReplaceableAttribute attr = new ReplaceableAttribute(SdbNativeSerializer.getEmbeddedAttributeName(embeddingColumnName, f), propValue, Boolean.valueOf(true));
                item.withAttributes(new ReplaceableAttribute[]{attr});
                continue;
            }
            if (!ClassInfo.isEmbeddedNative(f)) continue;
            SdbNativeSerializer.embed(item, SdbNativeSerializer.getEmbeddedAttributeName(embeddingColumnName, f), Util.readField(embeddedObj, f));
        }
    }

    public static <T> T unembed(Class<T> clazz, String embeddingFieldName, List<Attribute> attrs) {
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        T obj = Util.createObjectInstance(clazz);
        try {
            for (Field f : ClassInfo.getClassInfo(clazz).updateFields) {
                if (!ClassInfo.isEmbeddedNative(f)) {
                    String attrName = SdbNativeSerializer.getEmbeddedAttributeName(embeddingFieldName, f);
                    Attribute theAttr = null;
                    for (Attribute attr : attrs) {
                        if (!attrName.equals(attr.getName())) continue;
                        theAttr = attr;
                        attrs.remove(attr);
                        break;
                    }
                    if (theAttr == null) continue;
                    SdbMappingUtils.setFromString(obj, f, theAttr.getValue());
                    continue;
                }
                Object value = SdbNativeSerializer.unembed(f.getType(), SdbNativeSerializer.getEmbeddedAttributeName(embeddingFieldName, f), attrs);
                Util.setField(obj, f, value);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }
}

