/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.Transaction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Query;
import siena.QueryAggregated;
import siena.SienaException;
import siena.Util;
import siena.core.Many;
import siena.core.Many4PM;
import siena.core.One;
import siena.core.One4PM;
import siena.core.Relation;
import siena.core.RelationMode;
import siena.core.async.PersistenceManagerAsync;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.gae.GaeMappingUtils;
import siena.gae.GaePersistenceManagerAsync;
import siena.gae.GaeQueryUtils;
import siena.gae.GaeSienaIterable;
import siena.gae.GaeSienaIterableWithCursor;
import siena.gae.QueryOptionGaeContext;

public class GaePersistenceManager
extends AbstractPersistenceManager {
    private DatastoreService ds;
    private PersistenceManagerAsync asyncPm;
    private Properties props;
    public static final String DB = "GAE";
    private static String[] supportedOperators = GaeQueryUtils.operators.keySet().toArray(new String[0]);

    @Override
    public void init(Properties p) {
        this.ds = DatastoreServiceFactory.getDatastoreService();
        this.props = p;
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        if (this.asyncPm == null) {
            this.asyncPm = new GaePersistenceManagerAsync();
            this.asyncPm.init(this.props);
        }
        return this.asyncPm;
    }

    @Override
    public void beginTransaction(int isolationLevel) {
        this.ds.beginTransaction();
    }

    @Override
    public void beginTransaction() {
        this.ds.beginTransaction();
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
        Transaction txn = this.ds.getCurrentTransaction();
        txn.commit();
    }

    @Override
    public void rollbackTransaction() {
        Transaction txn = this.ds.getCurrentTransaction();
        txn.rollback();
    }

    @Override
    public void delete(Object obj) {
        ArrayList<Key> keys = new ArrayList<Key>();
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        if (info.hasAggregator) {
            Relation rel = (Relation)Util.readField(obj, info.aggregator);
            if (rel != null && rel.mode == RelationMode.AGGREGATION) {
                ClassInfo parentInfo = ClassInfo.getClassInfo(rel.target.getClass());
                Key parentKey = GaeMappingUtils.makeKey(parentInfo, rel.target);
                this._deleteSingle(obj, keys, parentKey, parentInfo, (Field)rel.discriminator);
            } else {
                this._deleteSingle(obj, keys, null, null, null);
            }
        } else {
            this._deleteSingle(obj, keys, null, null, null);
        }
        this.ds.delete(keys);
    }

    private void _deleteSingle(Object obj, List<Key> keys, Key parentKey, ClassInfo parentInfo, Field parentField) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Key key = parentKey == null ? GaeMappingUtils.getKey(obj) : GaeMappingUtils.getKeyFromParent(obj, parentKey, parentInfo, parentField);
        if (!info.aggregatedFields.isEmpty()) {
            for (Field f : info.aggregatedFields) {
                Many lq;
                if (ClassInfo.isModel(f.getType())) {
                    Object aggObj = Util.readField(obj, f);
                    this._deleteSingle(aggObj, keys, key, info, f);
                    continue;
                }
                if (!ClassInfo.isMany(f) || (lq = (Many)Util.readField(obj, f)).asList().isEmpty()) continue;
                this._deleteMultiple(lq.asQuery().fetchKeys(), keys, key, info, f);
            }
        }
        keys.add(key);
    }

    private void _deleteMultiple(Iterable<?> objects, List<Key> keys, Key parentKey, ClassInfo parentInfo, Field parentField) {
        for (Object obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Key key = parentKey == null ? GaeMappingUtils.getKey(obj) : GaeMappingUtils.getKeyFromParent(obj, parentKey, parentInfo, parentField);
            if (!info.aggregatedFields.isEmpty()) {
                for (Field f : info.aggregatedFields) {
                    Many lq;
                    if (ClassInfo.isModel(f.getType())) {
                        Object aggObj = Util.readField(obj, f);
                        this._deleteSingle(aggObj, keys, key, info, f);
                        continue;
                    }
                    if (ClassInfo.isOne(f)) {
                        One one = (One)Util.readField(obj, f);
                        Object target = one.get();
                        if (target == null) continue;
                        this._deleteSingle(target, keys, key, info, f);
                        continue;
                    }
                    if (!ClassInfo.isMany(f) || (lq = (Many)Util.readField(obj, f)).asList().isEmpty()) continue;
                    this._deleteMultiple(lq.asQuery().fetchKeys(), keys, key, info, f);
                }
            }
            keys.add(key);
        }
    }

    @Override
    public void get(Object obj) {
        Key key = GaeMappingUtils.getKey(obj);
        ClassInfo info = ClassInfo.getClassInfo(obj.getClass());
        try {
            Entity entity = this.ds.get(key);
            if (entity != null) {
                GaeMappingUtils.fillModel(obj, entity);
                if (!info.ownedFields.isEmpty()) {
                    this.mapOwned(obj);
                }
                if (!info.aggregatedFields.isEmpty()) {
                    this.mapAggregated(obj);
                }
                if (!info.joinFields.isEmpty()) {
                    this.mapJoins(obj);
                }
            }
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        Key gKey = GaeMappingUtils.makeKeyFromId(clazz, key);
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        try {
            Entity entity = this.ds.get(gKey);
            T obj = null;
            if (entity != null) {
                obj = Util.createObjectInstance(clazz);
                GaeMappingUtils.fillModelAndKey(obj, entity);
                if (!info.ownedFields.isEmpty()) {
                    this.mapOwned(obj);
                }
                if (!info.aggregatedFields.isEmpty()) {
                    this.mapAggregated(obj);
                }
                if (!info.joinFields.isEmpty()) {
                    this.mapJoins(obj);
                }
            }
            return obj;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void insert(Object obj) {
        this._insertSingle(obj);
    }

    private <T> void _insertSingle(T obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        if (info.hasAggregator) {
            Relation rel = (Relation)Util.readField(obj, info.aggregator);
            if (rel != null && rel.mode == RelationMode.AGGREGATION) {
                ClassInfo parentInfo = ClassInfo.getClassInfo(rel.target.getClass());
                Key parentKey = GaeMappingUtils.makeKey(parentInfo, rel.target);
                this._insertSingle(obj, parentKey, rel.target, parentInfo, (Field)rel.discriminator);
            } else {
                this._insertSingle(obj, null, null, null, null);
            }
        } else {
            this._insertSingle(obj, null, null, null, null);
        }
    }

    private <T> void _insertSingle(T obj, Key parentEntityKey, Object parentObj, ClassInfo parentInfo, Field field) {
        Entity entity;
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        if (parentEntityKey == null) {
            entity = GaeMappingUtils.createEntityInstance(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            this.ds.put(entity);
            GaeMappingUtils.setIdFromKey(idField, obj, entity.getKey());
        } else {
            entity = GaeMappingUtils.createEntityInstanceFromParent(idField, info, obj, parentEntityKey, parentInfo, field);
            GaeMappingUtils.fillEntity(obj, entity);
            this.ds.put(entity);
            GaeMappingUtils.setIdFromKey(idField, obj, entity.getKey());
        }
        if (info.hasAggregatedFields) {
            HashMap<Key, Map<Field, List<Object>>> keyMap = new HashMap<Key, Map<Field, List<Object>>>();
            HashMap<Field, List<Object>> objectMap = new HashMap<Field, List<Object>>();
            keyMap.put(entity.getKey(), objectMap);
            this._populateAggregateFieldMap(objectMap, info, obj);
            this._insertMultipleMapFromParent(keyMap, Arrays.asList(info));
        }
        if (info.hasOwnedFields) {
            ArrayList<Object> relObjects = new ArrayList<Object>();
            this._populateOwnedList(relObjects, info, obj);
            this.save(relObjects);
        }
    }

    private <T> int _insertMultiple(Iterable<T> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (T obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            if (info.hasAggregator) {
                Relation rel = (Relation)Util.readField(obj, info.aggregator);
                if (rel != null && rel.mode == RelationMode.AGGREGATION) {
                    ClassInfo parentInfo = ClassInfo.getClassInfo(rel.target.getClass());
                    Key parentKey = GaeMappingUtils.makeKey(parentInfo, rel.target);
                    this._insertAddEntity(entities, obj, info, parentKey, parentInfo, (Field)rel.discriminator);
                    continue;
                }
                this._insertAddEntity(entities, obj, info, null, null, null);
                continue;
            }
            this._insertAddEntity(entities, obj, info, null, null, null);
        }
        return this._insertPutEntities(entities, objects);
    }

    private <T> void _insertAddEntity(List<Entity> entities, T obj, ClassInfo info, Key parentEntityKey, ClassInfo parentInfo, Field field) {
        if (parentEntityKey == null) {
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstance(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        } else {
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstanceFromParent(idField, info, obj, parentEntityKey, parentInfo, field);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
    }

    private <T> int _insertPutEntities(Iterable<Entity> entities, Iterable<T> objects) {
        List generatedKeys = this.ds.put(entities);
        int i = 0;
        HashMap<Key, Map<Field, List<Object>>> keyMap = new HashMap<Key, Map<Field, List<Object>>>();
        ArrayList<ClassInfo> infos = new ArrayList<ClassInfo>();
        ArrayList<Object> relObjects = new ArrayList<Object>();
        for (T obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            GaeMappingUtils.setIdFromKey(idField, obj, (Key)generatedKeys.get(i));
            if (info.hasAggregatedFields) {
                infos.add(info);
                HashMap<Field, List<Object>> objectMap = new HashMap<Field, List<Object>>();
                keyMap.put((Key)generatedKeys.get(i), objectMap);
                this._populateAggregateFieldMap(objectMap, info, obj);
            }
            if (info.hasOwnedFields) {
                this._populateOwnedList(relObjects, info, obj);
            }
            ++i;
        }
        if (!keyMap.isEmpty()) {
            this._insertMultipleMapFromParent(keyMap, infos);
        }
        if (!relObjects.isEmpty()) {
            this.save(relObjects);
        }
        return generatedKeys.size();
    }

    private int _insertMultipleMapFromParent(Map<Key, Map<Field, List<Object>>> keyMap, List<ClassInfo> parentInfos) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int i = 0;
        for (Key key : keyMap.keySet()) {
            Map<Field, List<Object>> objectMap = keyMap.get(key);
            for (Field field : objectMap.keySet()) {
                for (Object obj : objectMap.get(field)) {
                    Class<?> clazz = obj.getClass();
                    ClassInfo info = ClassInfo.getClassInfo(clazz);
                    Field idField = info.getIdField();
                    Entity entity = GaeMappingUtils.createEntityInstanceFromParent(idField, info, obj, key, parentInfos.get(i), field);
                    GaeMappingUtils.fillEntity(obj, entity);
                    entities.add(entity);
                }
            }
            ++i;
        }
        List generatedKeys = this.ds.put(entities);
        i = 0;
        HashMap<Key, Map<Field, List<Object>>> recKeyMap = new HashMap<Key, Map<Field, List<Object>>>();
        ArrayList<ClassInfo> recInfos = new ArrayList<ClassInfo>();
        for (Key key : keyMap.keySet()) {
            Map<Field, List<Object>> objectMap = keyMap.get(key);
            for (Field field : objectMap.keySet()) {
                for (Object obj : objectMap.get(field)) {
                    Class<?> clazz = obj.getClass();
                    ClassInfo info = ClassInfo.getClassInfo(clazz);
                    Field idField = info.getIdField();
                    GaeMappingUtils.setIdFromKey(idField, obj, (Key)generatedKeys.get(i));
                    if (info.hasAggregatedFields) {
                        recInfos.add(info);
                        HashMap<Field, List<Object>> recObjectMap = new HashMap<Field, List<Object>>();
                        recKeyMap.put((Key)generatedKeys.get(i), recObjectMap);
                        this._populateAggregateFieldMap(recObjectMap, info, obj);
                    }
                    ++i;
                }
            }
        }
        if (!recKeyMap.isEmpty()) {
            this._insertMultipleMapFromParent(recKeyMap, recInfos);
        }
        return generatedKeys.size();
    }

    public void _populateAggregateFieldMap(Map<Field, List<Object>> map, ClassInfo info, Object obj) {
        for (Field f : info.aggregatedFields) {
            Many4PM lq;
            if (ClassInfo.isOne(f)) {
                One4PM one = (One4PM)Util.readField(obj, f);
                Object oneObj = one.get();
                if (oneObj != null) {
                    map.put(f, Arrays.asList(oneObj));
                }
                one.setModified(false);
                continue;
            }
            if (!ClassInfo.isMany(f) || (lq = (Many4PM)Util.readField(obj, f)).asList().isEmpty()) continue;
            map.put(f, new ArrayList(lq.asList2Add()));
            lq.asList2Add().clear();
        }
    }

    public void _populateOwnedList(List<Object> relObjects, ClassInfo info, Object obj) {
        for (Field f : info.ownedFields) {
            Many4PM lq;
            if (ClassInfo.isOne(f)) {
                One relObj = (One)Util.readField(obj, f);
                Map<ClassInfo.FieldMapKeys, Object> m = info.oneFieldMap.get(f);
                if (m == null) continue;
                Field asField = (Field)m.get((Object)ClassInfo.FieldMapKeys.FIELD);
                Object oneObj = relObj.get();
                if (oneObj == null) continue;
                Util.setField(oneObj, asField, obj);
                relObjects.add(oneObj);
                continue;
            }
            if (!ClassInfo.isMany(f) || (lq = (Many4PM)Util.readField(obj, f)).asList().isEmpty()) continue;
            Field asField = (Field)info.manyFieldMap.get(f).get((Object)ClassInfo.FieldMapKeys.FIELD);
            for (Object relObj : lq.asList2Add()) {
                Util.setField(relObj, asField, obj);
                relObjects.add(relObj);
            }
            lq.asList2Add().clear();
        }
    }

    @Override
    public void update(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        if (info.hasAggregator) {
            Relation rel = (Relation)Util.readField(obj, info.aggregator);
            if (rel != null && rel.mode == RelationMode.AGGREGATION) {
                ClassInfo parentInfo = ClassInfo.getClassInfo(rel.target.getClass());
                Key parentKey = GaeMappingUtils.makeKey(parentInfo, rel.target);
                if (!info.hasAggregatedFields && !info.hasOwnedFields) {
                    this._updateSimple(obj, info, parentKey, parentInfo, (Field)rel.discriminator);
                } else {
                    this._updateComplex(obj, parentKey, parentInfo, (Field)rel.discriminator);
                }
            } else if (!info.hasAggregatedFields && !info.hasOwnedFields) {
                this._updateSimple(obj, info, null, null, null);
            } else {
                this._updateComplex(obj, null, null, null);
            }
        } else if (!info.hasAggregatedFields && !info.hasOwnedFields) {
            this._updateSimple(obj, info, null, null, null);
        } else {
            this._updateComplex(obj, null, null, null);
        }
    }

    private <T> void _updateSimple(T obj, ClassInfo info, Key parentKey, ClassInfo parentInfo, Field parentField) {
        Entity entity;
        Field idField = info.getIdField();
        Object idVal = Util.readField(obj, idField);
        if (idVal == null) {
            entity = parentKey == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceFromParent(idField, info, obj, parentKey, parentInfo, parentField);
            GaeMappingUtils.fillEntity(obj, entity);
        } else {
            entity = parentKey == null ? GaeMappingUtils.createEntityInstanceForUpdate(info, obj) : GaeMappingUtils.createEntityInstanceForUpdateFromParent(info, obj, parentKey, parentInfo, parentField);
            GaeMappingUtils.fillEntity(obj, entity);
        }
        if (entity != null) {
            this.ds.put(entity);
        }
    }

    private <T> void _updateSimpleMultiple(Iterable<T> objs, Key parentKey, ClassInfo parentInfo, Field parentField) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ClassInfo info = null;
        Field idField = null;
        for (T obj : objs) {
            Entity entity;
            Object idVal;
            if (info == null) {
                info = ClassInfo.getClassInfo(obj.getClass());
                idField = info.getIdField();
            }
            if ((idVal = Util.readField(obj, idField)) == null) {
                entity = parentKey == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceFromParent(idField, info, obj, parentKey, parentInfo, parentField);
                GaeMappingUtils.fillEntity(obj, entity);
            } else {
                entity = parentKey == null ? GaeMappingUtils.createEntityInstanceForUpdate(info, obj) : GaeMappingUtils.createEntityInstanceForUpdateFromParent(info, obj, parentKey, parentInfo, parentField);
                GaeMappingUtils.fillEntity(obj, entity);
            }
            entities.add(entity);
        }
        if (!entities.isEmpty()) {
            this.ds.put(entities);
        }
    }

    private <T> int _updateComplex(T obj, Key parentKey, ClassInfo parentInfo, Field parentField) {
        HashMap<PersistenceType, List<Entity>> entitiesMap = new HashMap<PersistenceType, List<Entity>>();
        HashMap<PersistenceType, List<Object>> objectsMap = new HashMap<PersistenceType, List<Object>>();
        HashMap<PersistenceType, List<Key>> keysMap = new HashMap<PersistenceType, List<Key>>();
        GaePersistenceManager._updateBuildMaps(entitiesMap, objectsMap, keysMap, obj, null, null, null);
        return this._updateManageMaps(entitiesMap, objectsMap, keysMap);
    }

    private <T> int _updateMultiple(Iterable<T> objects) {
        HashMap<PersistenceType, List<Entity>> entitiesMap = new HashMap<PersistenceType, List<Entity>>();
        HashMap<PersistenceType, List<Object>> objectsMap = new HashMap<PersistenceType, List<Object>>();
        HashMap<PersistenceType, List<Key>> keysMap = new HashMap<PersistenceType, List<Key>>();
        for (T obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            if (info.hasAggregator) {
                Relation rel = (Relation)Util.readField(obj, info.aggregator);
                if (rel != null && rel.mode == RelationMode.AGGREGATION) {
                    ClassInfo parentInfo = ClassInfo.getClassInfo(rel.target.getClass());
                    Key parentKey = GaeMappingUtils.makeKey(parentInfo, rel.target);
                    GaePersistenceManager._updateBuildMaps(entitiesMap, objectsMap, keysMap, obj, parentKey, parentInfo, (Field)rel.discriminator);
                    continue;
                }
                GaePersistenceManager._updateBuildMaps(entitiesMap, objectsMap, keysMap, obj, null, null, null);
                continue;
            }
            GaePersistenceManager._updateBuildMaps(entitiesMap, objectsMap, keysMap, obj, null, null, null);
        }
        return this._updateManageMaps(entitiesMap, objectsMap, keysMap);
    }

    private static void _updateBuildMaps(HashMap<PersistenceType, List<Entity>> entitiesMap, HashMap<PersistenceType, List<Object>> objectsMap, HashMap<PersistenceType, List<Key>> keysMap, Object obj, Key parentKey, ClassInfo parentInfo, Field parentField) {
        Many4PM lq;
        Entity entity;
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        Object idVal = Util.readField(obj, idField);
        if (idVal == null) {
            entity = parentKey == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceFromParent(idField, info, obj, parentKey, parentInfo, parentField);
            GaeMappingUtils.fillEntity(obj, entity);
            List<Entity> entities2Insert = entitiesMap.get((Object)PersistenceType.INSERT);
            if (entities2Insert == null) {
                entities2Insert = new ArrayList<Entity>();
                entitiesMap.put(PersistenceType.INSERT, entities2Insert);
            }
            entities2Insert.add(entity);
            List<Object> objects2Insert = objectsMap.get((Object)PersistenceType.INSERT);
            if (objects2Insert == null) {
                objects2Insert = new ArrayList<Object>();
                objectsMap.put(PersistenceType.INSERT, objects2Insert);
            }
            objects2Insert.add(obj);
        } else {
            entity = parentKey == null ? GaeMappingUtils.createEntityInstanceForUpdate(info, obj) : GaeMappingUtils.createEntityInstanceForUpdateFromParent(info, obj, parentKey, parentInfo, parentField);
            GaeMappingUtils.fillEntity(obj, entity);
            List<Entity> entities2Update = entitiesMap.get((Object)PersistenceType.UPDATE);
            if (entities2Update == null) {
                entities2Update = new ArrayList<Entity>();
                entitiesMap.put(PersistenceType.UPDATE, entities2Update);
            }
            entities2Update.add(entity);
        }
        for (Field f : info.ownedFields) {
            Field asField;
            List<Object> objects2Save;
            if (ClassInfo.isOne(f)) {
                One4PM relObj = (One4PM)Util.readField(obj, f);
                Map<ClassInfo.FieldMapKeys, Object> m = info.oneFieldMap.get(f);
                if (m == null) continue;
                Field asField2 = (Field)m.get((Object)ClassInfo.FieldMapKeys.FIELD);
                if (!relObj.isModified()) continue;
                Object prevObj = relObj.getPrev();
                if (prevObj != null) {
                    Util.setField(prevObj, asField2, null);
                }
                relObj.setModified(false);
                objects2Save = objectsMap.get((Object)PersistenceType.SAVE);
                if (objects2Save == null) {
                    objects2Save = new ArrayList<Object>();
                    objectsMap.put(PersistenceType.SAVE, objects2Save);
                }
                objects2Save.add(prevObj);
                Object oneObj = relObj.get();
                if (oneObj == null) continue;
                Util.setField(oneObj, asField2, obj);
                objects2Save.add(oneObj);
                continue;
            }
            if (!ClassInfo.isMany(f)) continue;
            lq = (Many4PM)Util.readField(obj, f);
            if (!lq.asList2Remove().isEmpty()) {
                asField = (Field)info.manyFieldMap.get(f).get((Object)ClassInfo.FieldMapKeys.FIELD);
                for (Object elt : lq.asList2Remove()) {
                    Util.setField(elt, asField, null);
                    objects2Save = objectsMap.get((Object)PersistenceType.SAVE);
                    if (objects2Save == null) {
                        objects2Save = new ArrayList<Object>();
                        objectsMap.put(PersistenceType.SAVE, objects2Save);
                    }
                    objects2Save.add(elt);
                }
                lq.asList2Remove().clear();
            }
            if (lq.asList2Add().isEmpty()) continue;
            asField = (Field)info.manyFieldMap.get(f).get((Object)ClassInfo.FieldMapKeys.FIELD);
            for (Object elt : lq.asList2Add()) {
                Util.setField(elt, asField, obj);
                objects2Save = objectsMap.get((Object)PersistenceType.SAVE);
                if (objects2Save == null) {
                    objects2Save = new ArrayList<Object>();
                    objectsMap.put(PersistenceType.SAVE, objects2Save);
                }
                objects2Save.add(elt);
            }
            lq.asList2Add().clear();
        }
        for (Field f : info.aggregatedFields) {
            if (ClassInfo.isOne(f)) {
                One4PM one = (One4PM)Util.readField(obj, f);
                if (!one.isModified()) continue;
                Object prevObj = one.getPrev();
                if (prevObj != null) {
                    Class<?> delClazz = prevObj.getClass();
                    ClassInfo delInfo = ClassInfo.getClassInfo(delClazz);
                    Key delKey = GaeMappingUtils.makeKeyFromParent(delInfo, prevObj, entity.getKey(), info, f);
                    List<Key> key2Remove = keysMap.get((Object)PersistenceType.DELETE);
                    if (key2Remove == null) {
                        key2Remove = new ArrayList<Key>();
                        keysMap.put(PersistenceType.DELETE, key2Remove);
                    }
                    key2Remove.add(delKey);
                }
                one.setModified(false);
                Object oneObj = one.get();
                if (oneObj == null) continue;
                GaePersistenceManager._updateBuildMaps(entitiesMap, objectsMap, keysMap, oneObj, entity.getKey(), info, f);
                continue;
            }
            if (!ClassInfo.isMany(f)) continue;
            lq = (Many4PM)Util.readField(obj, f);
            if (!lq.asList2Remove().isEmpty()) {
                for (Object elt : lq.asList2Remove()) {
                    Class<?> delClazz = elt.getClass();
                    ClassInfo delInfo = ClassInfo.getClassInfo(delClazz);
                    Key delKey = GaeMappingUtils.makeKeyFromParent(delInfo, elt, entity.getKey(), info, f);
                    List<Key> key2Remove = keysMap.get((Object)PersistenceType.DELETE);
                    if (key2Remove == null) {
                        key2Remove = new ArrayList<Key>();
                        keysMap.put(PersistenceType.DELETE, key2Remove);
                    }
                    key2Remove.add(delKey);
                }
                lq.asList2Remove().clear();
            }
            if (lq.asList2Add().isEmpty()) continue;
            for (Object elt : lq.asList2Add()) {
                GaePersistenceManager._updateBuildMaps(entitiesMap, objectsMap, keysMap, elt, entity.getKey(), info, f);
            }
            lq.asList2Add().clear();
        }
    }

    private int _updateManageMaps(HashMap<PersistenceType, List<Entity>> entitiesMap, HashMap<PersistenceType, List<Object>> objectsMap, HashMap<PersistenceType, List<Key>> keysMap) {
        List<Key> keys;
        List<Entity> entities;
        int nb = 0;
        List<Object> objs = objectsMap.get((Object)PersistenceType.SAVE);
        if (objs != null && !objs.isEmpty()) {
            nb += this.save(objs);
        }
        if ((entities = entitiesMap.get((Object)PersistenceType.INSERT)) != null && !entities.isEmpty()) {
            List generatedKeys = this.ds.put(entities);
            int i = 0;
            for (Object elt : objectsMap.get((Object)PersistenceType.INSERT)) {
                Class<?> clazz = elt.getClass();
                ClassInfo info = ClassInfo.getClassInfo(clazz);
                Field idField = info.getIdField();
                GaeMappingUtils.setIdFromKey(idField, elt, (Key)generatedKeys.get(i));
            }
            nb += generatedKeys.size();
        }
        if ((entities = entitiesMap.get((Object)PersistenceType.UPDATE)) != null && !entities.isEmpty()) {
            this.ds.put((Iterable)entitiesMap.get((Object)PersistenceType.UPDATE));
            nb += entities.size();
        }
        if ((keys = keysMap.get((Object)PersistenceType.DELETE)) != null && !keys.isEmpty()) {
            this.ds.delete(keys);
            nb += keys.size();
        }
        return nb;
    }

    @Override
    public void save(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        Object idVal = Util.readField(obj, idField);
        if (idVal == null) {
            this.insert(obj);
        } else {
            this.update(obj);
        }
    }

    protected DatastoreService getDatastoreService() {
        return this.ds;
    }

    private <T> PreparedQuery prepare(Query<T> query) {
        Class clazz = query.getQueriedClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        List<QueryAggregated> aggregs = query.getAggregatees();
        if (aggregs.isEmpty()) {
            com.google.appengine.api.datastore.Query q = new com.google.appengine.api.datastore.Query(info.tableName);
            return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q));
        }
        if (aggregs.size() == 1) {
            QueryAggregated aggreg = aggregs.get(0);
            Key ancestorKey = GaeMappingUtils.getKey(aggreg.aggregator);
            com.google.appengine.api.datastore.Query q = new com.google.appengine.api.datastore.Query(GaeMappingUtils.getKindWithAncestorField(info, ClassInfo.getClassInfo(aggreg.aggregator.getClass()), aggreg.field));
            q.setAncestor(ancestorKey);
            return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q, ancestorKey));
        }
        throw new SienaException("Only one aggregation per query allowed");
    }

    private <T> PreparedQuery prepareKeysOnly(Query<T> query) {
        com.google.appengine.api.datastore.Query q;
        Class clazz = query.getQueriedClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        List<QueryAggregated> aggregs = query.getAggregatees();
        if (aggregs.isEmpty()) {
            q = new com.google.appengine.api.datastore.Query(ClassInfo.getClassInfo(clazz).tableName);
        } else if (aggregs.size() == 1) {
            QueryAggregated aggreg = aggregs.get(0);
            q = new com.google.appengine.api.datastore.Query(GaeMappingUtils.getKindWithAncestorField(info, ClassInfo.getClassInfo(aggreg.aggregator.getClass()), aggreg.field));
            q.setAncestor(GaeMappingUtils.getKey(aggreg.aggregator));
        } else {
            throw new SienaException("Only one aggregation per query allowed");
        }
        return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q).setKeysOnly());
    }

    protected <T> T mapJoins(Query<T> query, T model) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(query);
            for (Field field : fieldMap.keySet()) {
                Key key = GaeMappingUtils.getKey(field.get(model));
                List keys = fieldMap.get(field);
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Map entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, entities);
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap linkedModels = new HashMap();
            for (Field field : fieldMap.keySet()) {
                Object objVal = field.get(model);
                Key key = GaeMappingUtils.getKey(objVal);
                Object linkedObj = linkedModels.get(key);
                if (linkedObj == null) {
                    Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                    linkedObj = objVal;
                    GaeMappingUtils.fillModel(linkedObj, entity);
                    linkedModels.put(key, linkedObj);
                }
                field.set(model, linkedObj);
            }
            return model;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    protected <T> T mapJoins(T model) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(model);
            for (Field field : fieldMap.keySet()) {
                Key key = GaeMappingUtils.getKey(field.get(model));
                List keys = fieldMap.get(field);
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Map entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, entities);
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap linkedModels = new HashMap();
            for (Field field : fieldMap.keySet()) {
                Object objVal = field.get(model);
                Key key = GaeMappingUtils.getKey(objVal);
                Object linkedObj = linkedModels.get(key);
                if (linkedObj == null) {
                    Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                    linkedObj = objVal;
                    GaeMappingUtils.fillModel(linkedObj, entity);
                    linkedModels.put(key, linkedObj);
                }
                field.set(model, linkedObj);
            }
            return model;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected <T> List<T> mapJoins(Query<T> query, List<T> models) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(query);
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    List keys = fieldMap.get(field);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Map entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, entities);
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap<Key, Object> linkedModels = new HashMap<Key, Object>();
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    void var6_13;
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    Object v = linkedModels.get(key);
                    if (v == null) {
                        Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                        Object object = objVal;
                        GaeMappingUtils.fillModel(object, entity);
                        linkedModels.put(key, object);
                    }
                    field.set(model, var6_13);
                }
            }
            return models;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    protected <T> List<T> mapJoins(List<T> models) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = null;
            for (T model : models) {
                if (fieldMap == null) {
                    fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(model);
                }
                for (Object field : fieldMap.keySet()) {
                    Object objVal = Util.readField(model, (Field)field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    List keys = fieldMap.get(field);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Map entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, entities);
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap linkedModels = new HashMap();
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    Object linkedObj = linkedModels.get(key);
                    if (linkedObj == null) {
                        Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                        linkedObj = objVal;
                        GaeMappingUtils.fillModel(linkedObj, entity);
                        linkedModels.put(key, linkedObj);
                    }
                    field.set(model, linkedObj);
                }
            }
            return models;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    protected <T> void fillAggregated(ClassInfo info, T ancestor, Key ancestorKey) {
        for (Field f : info.aggregatedFields) {
            Class<?> cClazz = f.getType();
            ClassInfo cInfo = ClassInfo.getClassInfo(cClazz);
            if (ClassInfo.isModel(cClazz)) {
                com.google.appengine.api.datastore.Query q = new com.google.appengine.api.datastore.Query(GaeMappingUtils.getKindWithAncestorField(cInfo, info, f));
                PreparedQuery pq = this.ds.prepare(q.setAncestor(ancestorKey));
                Entity cEntity = pq.asSingleEntity();
                Object cObj = Util.createObjectInstance(cClazz);
                GaeMappingUtils.fillModelAndKey(cObj, cEntity);
                Util.setField(ancestor, f, cObj);
                continue;
            }
            if (!ClassInfo.isMany(f)) continue;
            Many4PM lq = (Many4PM)Util.readField(ancestor, f);
            lq.setSync(false);
        }
    }

    protected <T> T mapOwned(T model) {
        Class<?> clazz = model.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Field f : info.ownedFields) {
            Object lq;
            if (ClassInfo.isOne(f)) {
                lq = (One4PM)Util.readField(model, f);
                lq.setSync(false);
                continue;
            }
            if (!ClassInfo.isMany(f)) continue;
            lq = (Many4PM)Util.readField(model, f);
            lq.setSync(false);
        }
        return model;
    }

    protected <T> List<T> mapOwned(List<T> models) {
        for (T model : models) {
            this.mapOwned(model);
        }
        return models;
    }

    protected <T> T mapAggregated(T model) {
        Class<?> clazz = model.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Field f : info.aggregatedFields) {
            if (ClassInfo.isOne(f)) {
                One4PM one = (One4PM)Util.readField(model, f);
                one.setSync(false);
                continue;
            }
            if (!ClassInfo.isMany(f)) continue;
            Many4PM lq = (Many4PM)Util.readField(model, f);
            lq.setSync(false);
        }
        return model;
    }

    protected <T> List<T> mapAggregated(List<T> models) {
        for (T model : models) {
            this.mapAggregated(model);
        }
        return models;
    }

    protected <T> T map(Query<T> query, Entity entity) {
        Class clazz = query.getQueriedClass();
        Object result = GaeMappingUtils.mapEntity(entity, clazz);
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        GaeMappingUtils.mapRelation(query, result, info);
        if (!info.ownedFields.isEmpty()) {
            this.mapOwned(result);
        }
        if (!ClassInfo.getClassInfo(clazz).aggregatedFields.isEmpty()) {
            this.mapAggregated(result);
        }
        if (!query.getJoins().isEmpty() || !ClassInfo.getClassInfo(clazz).joinFields.isEmpty()) {
            this.mapJoins(query, result);
        }
        return result;
    }

    protected <T> List<T> map(Query<T> query, List<Entity> entities) {
        Class clazz = query.getQueriedClass();
        List results = GaeMappingUtils.mapEntities(entities, clazz);
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        GaeMappingUtils.mapRelations(query, results, info);
        if (!info.ownedFields.isEmpty()) {
            this.mapOwned(results);
        }
        if (!info.aggregatedFields.isEmpty()) {
            this.mapAggregated(results);
        }
        if (!query.getJoins().isEmpty() || !info.joinFields.isEmpty()) {
            this.mapJoins(query, results);
        }
        return results;
    }

    protected <T> List<T> mapKeysOnly(Query<T> query, List<Entity> entities) {
        Class clazz = query.getQueriedClass();
        List results = GaeMappingUtils.mapEntitiesKeysOnly(entities, clazz);
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        GaeMappingUtils.mapRelations(query, results, info);
        return results;
    }

    private <T> List<T> doFetchList(Query<T> query, int limit, int offset) {
        String cursor;
        QueryResultList entities;
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.customize(gaeCtx);
        }
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (!pag.isPaginating()) {
            if (pag.isActive()) {
                if (limit != Integer.MAX_VALUE) {
                    gaeCtx.realPageSize = limit;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    pag.passivate();
                } else {
                    gaeCtx.realPageSize = pag.pageSize;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    if (state.isStateless()) {
                        pag.passivate();
                    }
                }
            } else if (limit != Integer.MAX_VALUE) {
                gaeCtx.realPageSize = limit;
                fetchOptions.limit(gaeCtx.realPageSize);
            }
        } else {
            gaeCtx.realPageSize = pag.pageSize;
            fetchOptions.limit(gaeCtx.realPageSize);
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
        if (gaeCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless()) {
            if (pag.isPaginating()) {
                if (off.isActive()) {
                    gaeCtx.realOffset += off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                } else {
                    fetchOptions.offset(gaeCtx.realOffset);
                }
            } else {
                gaeCtx.realOffset = 0;
                if (off.isActive()) {
                    gaeCtx.realOffset = off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                }
            }
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    List entities2 = this.prepareKeysOnly(query).asList(fetchOptions);
                    if (pag.isPaginating()) {
                        gaeCtx.noMoreDataAfter = entities2.size() == 0;
                    }
                    return this.mapKeysOnly(query, entities2);
                }
            }
            List entities3 = this.prepare(query).asList(fetchOptions);
            if (pag.isPaginating()) {
                gaeCtx.noMoreDataAfter = entities3.size() == 0;
            }
            return this.map(query, entities3);
        }
        if (off.isActive()) {
            fetchOptions.offset(off.offset);
            gaeCtx.realOffset += off.offset;
            off.passivate();
        }
        if (!gaeCtx.isActive()) {
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    PreparedQuery pq = this.prepareKeysOnly(query);
                    if (!gaeCtx.useCursor) {
                        fetchOptions.offset(gaeCtx.realOffset);
                    }
                    QueryResultList entities4 = pq.asQueryResultList(fetchOptions);
                    gaeCtx.activate();
                    if (pag.isPaginating()) {
                        Cursor cursor2 = entities4.getCursor();
                        if (cursor2 != null) {
                            gaeCtx.addCursor(cursor2.toWebSafeString());
                        }
                        gaeCtx.noMoreDataAfter = entities4.size() == 0;
                    } else {
                        Cursor cursor3 = entities4.getCursor();
                        if (cursor3 != null) {
                            gaeCtx.addAndMoveCursor(entities4.getCursor().toWebSafeString());
                        }
                        gaeCtx.realOffset += entities4.size();
                    }
                    return this.mapKeysOnly(query, (List<Entity>)entities4);
                }
            }
            PreparedQuery pq = this.prepare(query);
            if (!gaeCtx.useCursor) {
                fetchOptions.offset(gaeCtx.realOffset);
            }
            QueryResultList entities5 = pq.asQueryResultList(fetchOptions);
            gaeCtx.activate();
            if (pag.isPaginating()) {
                Cursor cursor4 = entities5.getCursor();
                if (cursor4 != null) {
                    gaeCtx.addCursor(cursor4.toWebSafeString());
                }
                gaeCtx.noMoreDataAfter = entities5.size() == 0;
            } else {
                Cursor cursor5 = entities5.getCursor();
                if (cursor5 != null) {
                    gaeCtx.addAndMoveCursor(entities5.getCursor().toWebSafeString());
                }
                gaeCtx.realOffset += entities5.size();
            }
            return this.map(query, (List<Entity>)entities5);
        }
        switch (fetchType.fetchType) {
            case KEYS_ONLY: {
                String cursor6;
                QueryResultList entities6;
                PreparedQuery pq = this.prepareKeysOnly(query);
                if (!gaeCtx.useCursor) {
                    fetchOptions.offset(gaeCtx.realOffset);
                    entities6 = pq.asQueryResultList(fetchOptions);
                } else {
                    cursor6 = gaeCtx.currentCursor();
                    entities6 = cursor6 != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor6))) : pq.asQueryResultList(fetchOptions);
                }
                if (pag.isPaginating()) {
                    cursor6 = entities6.getCursor();
                    if (cursor6 != null) {
                        gaeCtx.addCursor(cursor6.toWebSafeString());
                    }
                    gaeCtx.noMoreDataAfter = entities6.size() == 0;
                } else {
                    cursor6 = entities6.getCursor();
                    if (cursor6 != null) {
                        gaeCtx.addAndMoveCursor(entities6.getCursor().toWebSafeString());
                    }
                    gaeCtx.realOffset += entities6.size();
                }
                return this.mapKeysOnly(query, (List<Entity>)entities6);
            }
        }
        PreparedQuery pq = this.prepare(query);
        if (!gaeCtx.useCursor) {
            fetchOptions.offset(gaeCtx.realOffset);
            entities = pq.asQueryResultList(fetchOptions);
        } else {
            cursor = gaeCtx.currentCursor();
            entities = cursor != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)gaeCtx.currentCursor()))) : pq.asQueryResultList(fetchOptions);
        }
        if (pag.isPaginating()) {
            cursor = entities.getCursor();
            if (cursor != null) {
                gaeCtx.addCursor(cursor.toWebSafeString());
            }
            gaeCtx.noMoreDataAfter = entities.size() == 0;
        } else {
            cursor = entities.getCursor();
            if (cursor != null) {
                gaeCtx.addAndMoveCursor(entities.getCursor().toWebSafeString());
            }
            gaeCtx.realOffset += entities.size();
        }
        return this.map(query, (List<Entity>)entities);
    }

    private <T> Iterable<T> doFetchIterable(Query<T> query, int limit, int offset) {
        QueryResultIterable entities;
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.customize(gaeCtx);
        }
        FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (!pag.isPaginating()) {
            if (pag.isActive()) {
                if (limit != Integer.MAX_VALUE) {
                    gaeCtx.realPageSize = limit;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    pag.passivate();
                } else {
                    gaeCtx.realPageSize = pag.pageSize;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    if (state.isStateless()) {
                        pag.passivate();
                    }
                }
            } else if (limit != Integer.MAX_VALUE) {
                gaeCtx.realPageSize = limit;
                fetchOptions.limit(gaeCtx.realPageSize);
            }
        } else {
            gaeCtx.realPageSize = pag.pageSize;
            fetchOptions.limit(gaeCtx.realPageSize);
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
        if (gaeCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless()) {
            if (pag.isPaginating()) {
                if (off.isActive()) {
                    gaeCtx.realOffset += off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                } else {
                    fetchOptions.offset(gaeCtx.realOffset);
                }
            } else {
                gaeCtx.realOffset = off.offset;
                if (off.isActive()) {
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                }
            }
            switch (fetchType.fetchType) {
                default: 
            }
            Iterable entities2 = this.prepare(query).asIterable(fetchOptions);
            return new GaeSienaIterable<T>(this, entities2, query);
        }
        if (off.isActive()) {
            fetchOptions.offset(off.offset);
            gaeCtx.realOffset += off.offset;
            off.passivate();
        }
        if (!gaeCtx.isActive()) {
            switch (fetchType.fetchType) {
                default: 
            }
            PreparedQuery pq = this.prepare(query);
            if (pag.isPaginating()) {
                QueryResultList entities3 = pq.asQueryResultList(fetchOptions);
                gaeCtx.activate();
                Cursor cursor = entities3.getCursor();
                if (cursor != null) {
                    gaeCtx.addCursor(cursor.toWebSafeString());
                }
                return new GaeSienaIterable<T>(this, (Iterable<Entity>)entities3, query);
            }
            QueryResultIterable entities4 = pq.asQueryResultIterable(fetchOptions);
            gaeCtx.activate();
            return new GaeSienaIterableWithCursor<T>(this, (QueryResultIterable<Entity>)entities4, query);
        }
        switch (fetchType.fetchType) {
            default: 
        }
        PreparedQuery pq = this.prepare(query);
        if (pag.isPaginating()) {
            QueryResultList entities5;
            if (!gaeCtx.useCursor) {
                fetchOptions.offset(gaeCtx.realOffset);
                entities5 = pq.asQueryResultList(fetchOptions);
            } else {
                String cursor = gaeCtx.currentCursor();
                entities5 = cursor != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor))) : pq.asQueryResultList(fetchOptions);
                gaeCtx.addCursor(entities5.getCursor().toWebSafeString());
            }
            return new GaeSienaIterable<T>(this, (Iterable<Entity>)entities5, query);
        }
        if (!gaeCtx.useCursor) {
            fetchOptions.offset(gaeCtx.realOffset);
            entities = pq.asQueryResultIterable(fetchOptions);
        } else {
            String cursor = gaeCtx.currentCursor();
            entities = cursor != null ? pq.asQueryResultIterable(fetchOptions.startCursor(Cursor.fromWebSafeString((String)gaeCtx.currentCursor()))) : pq.asQueryResultIterable(fetchOptions);
        }
        return new GaeSienaIterableWithCursor<T>(this, (QueryResultIterable<Entity>)entities, query);
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, limit, 0);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, limit, (Integer)offset);
    }

    @Override
    public <T> int count(Query<T> query) {
        return this.prepare(query).countEntities(FetchOptions.Builder.withDefaults());
    }

    @Override
    public <T> int delete(Query<T> query) {
        ArrayList<Key> keys = new ArrayList<Key>();
        Class clazz = query.getQueriedClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        if (!info.hasAggregatedFields) {
            for (Entity entity : this.prepareKeysOnly(query).asIterable(FetchOptions.Builder.withDefaults())) {
                keys.add(entity.getKey());
            }
        } else {
            List<T> models = query.fetch();
            this._deleteMultiple(models, keys, null, null, null);
        }
        this.ds.delete(keys);
        return keys.size();
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, limit, 0);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, limit, (Integer)offset);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, 0);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, (Integer)offset);
    }

    @Override
    public <T> void release(Query<T> query) {
        super.release(query);
        GaeQueryUtils.release(query);
    }

    @Override
    public <T> void paginate(Query<T> query) {
        GaeQueryUtils.paginate(query);
    }

    @Override
    public <T> void nextPage(Query<T> query) {
        GaeQueryUtils.nextPage(query);
    }

    @Override
    public <T> void previousPage(Query<T> query) {
        GaeQueryUtils.previousPage(query);
    }

    @Override
    public int insert(Object ... objects) {
        return this._insertMultiple(Arrays.asList(objects));
    }

    @Override
    public int insert(Iterable<?> objects) {
        return this._insertMultiple(objects);
    }

    @Override
    public int delete(Object ... models) {
        return this.delete(Arrays.asList(models));
    }

    @Override
    public int delete(Iterable<?> models) {
        ArrayList<Key> keys = new ArrayList<Key>();
        this._deleteMultiple(models, keys, null, null, null);
        this.ds.delete(keys);
        return keys.size();
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        return this.deleteByKeys(clazz, Arrays.asList(keys));
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        for (Object key : keys) {
            gaeKeys.add(GaeMappingUtils.makeKeyFromId(clazz, key));
        }
        this.ds.delete(gaeKeys);
        return gaeKeys.size();
    }

    @Override
    public int get(Object ... objects) {
        return this.get(Arrays.asList(objects));
    }

    @Override
    public <T> int get(Iterable<T> objects) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (T obj : objects) {
            keys.add(GaeMappingUtils.getKey(obj));
        }
        Map entityMap = this.ds.get(keys);
        for (T obj : objects) {
            Entity e = (Entity)entityMap.get(GaeMappingUtils.getKey(obj));
            if (e == null) continue;
            GaeMappingUtils.fillModel(obj, e);
        }
        return entityMap.size();
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        return this.getByKeys(clazz, Arrays.asList(keys));
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        for (Object key : keys) {
            gaeKeys.add(GaeMappingUtils.makeKeyFromId(clazz, key));
        }
        Map entityMap = this.ds.get(gaeKeys);
        ArrayList<T> models = new ArrayList<T>(entityMap.size());
        for (Object key : keys) {
            Entity entity = (Entity)entityMap.get(GaeMappingUtils.makeKeyFromId(clazz, key));
            T obj = null;
            if (entity != null && (obj = (T)GaeMappingUtils.mapEntity(entity, clazz)) != null) {
                if (!info.ownedFields.isEmpty()) {
                    this.mapOwned(obj);
                }
                if (!info.aggregatedFields.isEmpty()) {
                    this.mapAggregated(obj);
                }
                if (!info.joinFields.isEmpty()) {
                    this.mapJoins(obj);
                }
            }
            models.add(obj);
        }
        return models;
    }

    @Override
    public <T> int update(Object ... objects) {
        return this.update(Arrays.asList(objects));
    }

    @Override
    public <T> int update(Iterable<T> objects) {
        return this._updateMultiple(objects);
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        throw new SienaException("update not implemented for GAE yet");
    }

    @Override
    public int save(Object ... objects) {
        return this.save(Arrays.asList(objects));
    }

    @Override
    public int save(Iterable<?> objects) {
        ArrayList entities2Insert = new ArrayList();
        ArrayList entities2Update = new ArrayList();
        for (Object obj : objects) {
            Class<?> clazz;
            ClassInfo info;
            Field idField;
            Object idVal = Util.readField(obj, idField = (info = ClassInfo.getClassInfo(clazz = obj.getClass())).getIdField());
            if (idVal == null) {
                entities2Insert.add(obj);
                continue;
            }
            entities2Update.add(obj);
        }
        return this.insert(entities2Insert) + this.update(entities2Update);
    }

    @Override
    public String[] supportedOperators() {
        return supportedOperators;
    }

    public static enum PersistenceType {
        INSERT,
        UPDATE,
        SAVE,
        DELETE;

    }
}

