/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import siena.ClassInfo;
import siena.Json;
import siena.SienaException;
import siena.Util;
import siena.core.DecimalPrecision;
import siena.core.Polymorphic;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.jdbc.ConnectionManager;
import siena.jdbc.JdbcDBUtils;
import siena.jdbc.JdbcPersistenceManager;

public class GoogleSqlPersistenceManager
extends JdbcPersistenceManager {
    private static final String DB = "GOOGLESQL";

    public GoogleSqlPersistenceManager() {
    }

    public GoogleSqlPersistenceManager(ConnectionManager connectionManager, Class<?> listener) {
        super(connectionManager, listener);
    }

    @Override
    protected int addParameters(Object obj, List<Field> fields, PreparedStatement ps, int i) throws SQLException {
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (ClassInfo.isModel(type) && !ClassInfo.isEmbedded(field)) {
                JdbcPersistenceManager.JdbcClassInfo ci = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(type);
                Object rel = Util.readField(obj, field);
                for (Field f : ci.keys) {
                    if (rel != null) {
                        Object value = Util.readField(rel, f);
                        if (value instanceof Json) {
                            value = ((Json)value).toString();
                        }
                        this.setParameter(ps, i++, value, f);
                        continue;
                    }
                    this.setParameter(ps, i++, null, f);
                }
                continue;
            }
            Object value = Util.readField(obj, field);
            if (value != null) {
                if (Json.class.isAssignableFrom(type)) {
                    value = ((Json)value).toString();
                } else if (field.getAnnotation(Embedded.class) != null) {
                    value = JsonSerializer.serialize(value).toString();
                } else if (field.getAnnotation(Polymorphic.class) != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream out = new ObjectOutputStream(bos);
                        out.writeObject(value);
                        out.close();
                    }
                    catch (IOException e) {
                        throw new SienaException(e);
                    }
                    value = bos.toByteArray();
                } else if (Enum.class.isAssignableFrom(type)) {
                    value = value.toString();
                } else if (BigDecimal.class == type) {
                    DecimalPrecision ann = field.getAnnotation(DecimalPrecision.class);
                    if (ann == null) {
                        value = (BigDecimal)value;
                    } else {
                        switch (ann.storageType()) {
                            case DOUBLE: {
                                value = ((BigDecimal)value).doubleValue();
                                break;
                            }
                            case STRING: {
                                value = ((BigDecimal)value).toPlainString();
                                break;
                            }
                            case NATIVE: {
                                value = (BigDecimal)value;
                            }
                        }
                    }
                }
            }
            this.setParameter(ps, i++, value, field);
        }
        return i;
    }

    protected void setParameter(PreparedStatement ps, int index, Object value, Field field) throws SQLException {
        JdbcDBUtils.setObject(ps, index, value, field, DB);
    }
}

