/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import siena.ClassInfo;
import siena.Generator;
import siena.Id;
import siena.QueryFilterSearch;
import siena.SienaException;
import siena.Util;
import siena.core.options.QueryOption;
import siena.jdbc.ConnectionManager;
import siena.jdbc.JdbcDBUtils;
import siena.jdbc.JdbcPersistenceManager;
import siena.jdbc.QueryOptionPostgresqlSearch;

public class PostgresqlPersistenceManager
extends JdbcPersistenceManager {
    private static final String DB = "POSTGRES";

    public PostgresqlPersistenceManager() {
    }

    public PostgresqlPersistenceManager(ConnectionManager connectionManager, Class<?> listener) {
        super(connectionManager, listener);
    }

    @Override
    protected void setParameter(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value != null && value instanceof Date) {
            Date date = (Date)value;
            ps.setTimestamp(index, new Timestamp(date.getTime()));
        } else {
            ps.setObject(index, value);
        }
    }

    @Override
    protected void insertWithAutoIncrementKey(JdbcPersistenceManager.JdbcClassInfo classInfo, Object obj) throws SQLException, IllegalAccessException {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.generatedKeys) {
            keyNames.add(field.getName());
        }
        ResultSet gk = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(String.valueOf(classInfo.insertSQL) + " RETURNING " + Util.join(keyNames, ","));
            this.addParameters(obj, classInfo.insertFields, ps, 1);
            gk = ps.executeQuery();
            if (!gk.next()) {
                throw new SienaException("No such generated keys");
            }
            int i = 1;
            for (Field field : classInfo.generatedKeys) {
                Util.setFromObject(obj, field, gk.getObject(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeResultSet(gk);
            JdbcDBUtils.closeStatementAndConnection(this, ps);
            throw throwable;
        }
        JdbcDBUtils.closeResultSet(gk);
        JdbcDBUtils.closeStatementAndConnection(this, ps);
    }

    @Override
    protected int insertBatchWithAutoIncrementKey(JdbcPersistenceManager.JdbcClassInfo classInfo, Map<JdbcPersistenceManager.JdbcClassInfo, List<Object>> objMap) throws SQLException, IllegalAccessException {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.generatedKeys) {
            keyNames.add(field.getName());
        }
        PreparedStatement ps = null;
        ResultSet gk = null;
        int res = 0;
        try {
            ps = this.getConnection().prepareStatement(String.valueOf(classInfo.insertSQL) + " RETURNING " + Util.join(keyNames, ","));
            for (Object obj : objMap.get(classInfo)) {
                for (Field field : classInfo.keys) {
                    Id id = field.getAnnotation(Id.class);
                    if (id.value() != Generator.UUID) continue;
                    field.set(obj, UUID.randomUUID().toString());
                }
                this.addParameters(obj, classInfo.insertFields, ps, 1);
                gk = ps.executeQuery();
                if (!gk.next()) {
                    throw new SienaException("No such generated keys");
                }
                int i = 1;
                for (Field field : classInfo.generatedKeys) {
                    Util.setFromObject(obj, field, gk.getObject(i));
                    ++i;
                }
                JdbcDBUtils.closeResultSet(gk);
                ++res;
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeStatementAndConnection(this, ps);
            throw throwable;
        }
        JdbcDBUtils.closeStatementAndConnection(this, ps);
        return res;
    }

    @Override
    public <T> void appendSqlSearch(QueryFilterSearch qf, Class<?> clazz, JdbcPersistenceManager.JdbcClassInfo info, StringBuilder sql, List<Object> parameters) {
        ArrayList<String> cols = new ArrayList<String>();
        try {
            String[] stringArray = qf.fields;
            int n = qf.fields.length;
            int n2 = 0;
            while (n2 < n) {
                String col;
                int n3;
                String[] stringArray2;
                String[] columns;
                String field = stringArray[n2];
                Field f = Util.getField(clazz, field);
                Class<?> cl = f.getType();
                if (Number.class.isAssignableFrom(cl) || Date.class.isAssignableFrom(cl)) {
                    stringArray2 = columns = ClassInfo.getColumnNames(f, info.tableName);
                    n3 = columns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        col = stringArray2[n4];
                        cols.add(col);
                        ++n4;
                    }
                } else if (ClassInfo.isModel(cl)) {
                    ClassInfo ci = ClassInfo.getClassInfo(cl);
                    if (ci.keys.size() == 1) {
                        Field key = ci.keys.get(0);
                        if (Number.class.isAssignableFrom(key.getType()) || Date.class.isAssignableFrom(key.getType())) {
                            cols.add(f.getName());
                        } else {
                            cols.add("coalesce(" + f.getName() + ", '')");
                        }
                    } else {
                        for (Field key : ci.keys) {
                            String col2;
                            int n5;
                            int n6;
                            String[] stringArray3;
                            String[] columns2 = ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(f.getName()) + "_");
                            if (Number.class.isAssignableFrom(key.getType()) || Date.class.isAssignableFrom(key.getType())) {
                                stringArray3 = columns2;
                                n6 = columns2.length;
                                n5 = 0;
                                while (n5 < n6) {
                                    col2 = stringArray3[n5];
                                    cols.add(col2);
                                    ++n5;
                                }
                                continue;
                            }
                            stringArray3 = columns2;
                            n6 = columns2.length;
                            n5 = 0;
                            while (n5 < n6) {
                                col2 = stringArray3[n5];
                                cols.add("coalesce(" + col2 + ", '')");
                                ++n5;
                            }
                        }
                    }
                } else {
                    stringArray2 = columns = ClassInfo.getColumnNames(f, info.tableName);
                    n3 = columns.length;
                    int n7 = 0;
                    while (n7 < n3) {
                        col = stringArray2[n7];
                        cols.add("coalesce(" + col + ", '')");
                        ++n7;
                    }
                }
                ++n2;
            }
            QueryOption opt = qf.option;
            if (opt != null) {
                if (QueryOptionPostgresqlSearch.class.isAssignableFrom(opt.getClass())) {
                    String lang = ((QueryOptionPostgresqlSearch)opt).language;
                    if (lang != null && !"".equals(lang)) {
                        sql.append("to_tsvector('" + lang + "', " + Util.join(cols, " || ' ' || ") + ") @@ to_tsquery(?)");
                    } else {
                        sql.append("to_tsvector('english', " + Util.join(cols, " || ' ' || ") + ") @@ to_tsquery(?)");
                    }
                }
            } else {
                sql.append("to_tsvector('english', " + Util.join(cols, " || ' ' || ") + ") @@ to_tsquery(?)");
            }
            parameters.add(qf.match);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void save(Object obj) {
        JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.keys) {
            keyNames.add(field.getName());
        }
        PreparedStatement ps = null;
        try {
            try {
                Field idField = classInfo.info.getIdField();
                Object idVal = Util.readField(obj, idField);
                if (idVal == null) {
                    this.insert(obj);
                } else {
                    ps = this.getConnection().prepareStatement("INSERT INTO " + classInfo.tableName + " (" + Util.join(keyNames, ",") + ") " + "SELECT ? WHERE ? NOT IN (SELECT " + Util.join(keyNames, ",") + " FROM " + classInfo.tableName + ");" + classInfo.updateSQL);
                    int i = 1;
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.updateFields, ps, i);
                    this.addParameters(obj, classInfo.keys, ps, i);
                    ps.executeUpdate();
                }
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        finally {
            JdbcDBUtils.closeStatementAndConnection(this, ps);
        }
    }

    @Override
    public int save(Object ... objects) {
        return this.save(Arrays.asList(objects));
    }

    @Override
    public int save(Iterable<?> objects) {
        HashMap generatedObjMap = new HashMap();
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            ArrayList l;
            JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
            Field idField = classInfo.info.getIdField();
            Object idVal = Util.readField(obj, idField);
            if (idVal == null && !classInfo.generatedKeys.isEmpty()) {
                if (!generatedObjMap.containsKey(classInfo)) {
                    l = new ArrayList();
                    l.add(obj);
                    generatedObjMap.put(classInfo, l);
                    continue;
                }
                ((List)generatedObjMap.get(classInfo)).add(obj);
                continue;
            }
            if (!objMap.containsKey(classInfo)) {
                l = new ArrayList();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : generatedObjMap.keySet()) {
                total += this.insert((Iterable)generatedObjMap.get(classInfo));
            }
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : objMap.keySet()) {
                ArrayList<String> keyNames = new ArrayList<String>();
                for (Field field : classInfo.keys) {
                    keyNames.add(field.getName());
                }
                ps = this.getConnection().prepareStatement("INSERT INTO " + classInfo.tableName + " (" + Util.join(keyNames, ",") + ") " + "SELECT ? WHERE ? NOT IN (SELECT " + Util.join(keyNames, ",") + " FROM " + classInfo.tableName + ");" + classInfo.updateSQL);
                for (Field obj : (List)objMap.get(classInfo)) {
                    int i = 1;
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.updateFields, ps, i);
                    this.addParameters(obj, classInfo.keys, ps, i);
                    ps.executeUpdate();
                    ++total;
                }
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatementAndConnection(this, ps);
        }
    }
}

