/*
 * Decompiled with CFR 0.152.
 */
package siena.remote;

import java.lang.reflect.Field;
import java.util.List;
import org.dom4j.Element;
import siena.ClassInfo;
import siena.Model;
import siena.SienaException;
import siena.Util;

public class Common {
    public static void fillRequestElement(Object obj, Element element, boolean ids) {
        Field[] fields;
        Class<?> clazz = obj.getClass();
        element.addAttribute("class", clazz.getName());
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() != Class.class && (!ids || ClassInfo.isId(field))) {
                Element f;
                Object value;
                field.setAccessible(true);
                try {
                    value = field.get(obj);
                }
                catch (Exception e) {
                    throw new SienaException(e);
                }
                Class<?> type = field.getType();
                if (ClassInfo.isModel(type)) {
                    f = element.addElement("object");
                    f.addAttribute("name", field.getName());
                    if (value != null) {
                        Common.fillRequestElement((Model)value, f, true);
                    }
                } else {
                    f = element.addElement("field");
                    f.addAttribute("name", field.getName());
                    if (value != null) {
                        f.setText(Util.toString(field, value));
                    }
                }
            }
            ++n2;
        }
    }

    public static Model parseEntity(Element element, ClassLoader classLoader) {
        String clazzName = element.attributeValue("class");
        Model obj = null;
        try {
            Class<?> clazz = Common.classForName(clazzName, classLoader);
            obj = (Model)clazz.newInstance();
        }
        catch (Exception e) {
            throw new SienaException("Error while trying to create an instance of " + clazzName + ". " + e.getMessage());
        }
        Common.parseEntity(obj, element, classLoader);
        return obj;
    }

    public static void parseEntity(Object obj, Element element, ClassLoader classLoader) {
        Class<?> clazz = obj.getClass();
        Field field = null;
        Object value = null;
        try {
            List list = element.elements();
            for (Element el : list) {
                String name = el.attributeValue("name");
                field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                value = el.hasContent() ? ("object".equals(el.getName()) ? Common.parseEntity(el, classLoader) : Util.fromString(field.getType(), el.getText())) : null;
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            String message = "Error while setting field values (class: " + clazz.getName();
            message = field != null ? String.valueOf(message) + ", field: " + field.getName() : String.valueOf(message) + ", field: null";
            message = value != null ? String.valueOf(message) + ", value: " + value + " [" + value.getClass().getName() + "]" : String.valueOf(message) + ", value: null";
            message = String.valueOf(message) + ")";
            throw new SienaException(message, e);
        }
    }

    public static Class<?> classForName(String clazzName, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(clazzName);
        }
        return Class.forName(clazzName, true, classLoader);
    }
}

