/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Query;
import siena.QueryJoin;
import siena.SienaException;
import siena.Util;
import siena.core.async.PersistenceManagerAsync;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.sdb.PmOptionSdbReadConsistency;
import siena.sdb.QueryOptionSdbContext;
import siena.sdb.SdbMappingUtils;
import siena.sdb.SdbSienaIterable;

public class SdbPersistenceManager
extends AbstractPersistenceManager {
    public static final String DB = "SDB";
    private static final String[] supportedOperators = new String[]{"<", ">", ">=", "<=", "!=", "=", "LIKE", "NOT LIKE", "IN"};
    public static final PmOptionSdbReadConsistency CONSISTENT_READ = new PmOptionSdbReadConsistency(true);
    public static final PmOptionSdbReadConsistency NOT_CONSISTENT_READ = new PmOptionSdbReadConsistency(false);
    public static final int MAX_ITEMS_PER_CALL = 25;
    public static final int MAX_ATTR_PER_SELECT = 20;
    private AmazonSimpleDB sdb;
    private String prefix;
    private List<String> domains;
    protected final int MAX_DEPTH = 25;

    @Override
    public void init(Properties p) {
        String awsAccessKeyId = p.getProperty("awsAccessKeyId");
        String awsSecretAccessKey = p.getProperty("awsSecretAccessKey");
        if (awsAccessKeyId == null || awsSecretAccessKey == null) {
            throw new SienaException("Both awsAccessKeyId and awsSecretAccessKey properties must be set");
        }
        this.prefix = p.getProperty("prefix");
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.sdb = new AmazonSimpleDBClient((AWSCredentials)new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey));
    }

    public void checkDomain(String domainName) {
        if (this.domains == null) {
            this.domains = this.sdb.listDomains().getDomainNames();
        }
        if (!this.domains.contains(domainName)) {
            this.sdb.createDomain(new CreateDomainRequest(domainName));
            this.domains.add(domainName);
        }
    }

    public boolean isReadConsistent() {
        PmOptionSdbReadConsistency opt = (PmOptionSdbReadConsistency)this.option(SdbPersistenceManager.CONSISTENT_READ.type);
        if (opt != null) {
            return opt.isConsistentRead;
        }
        return false;
    }

    @Override
    public void insert(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
        try {
            this.checkDomain(domain);
            this.sdb.putAttributes(SdbMappingUtils.createPutRequest(domain, clazz, info, obj));
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public int insert(Object ... objects) {
        return this.insert(Arrays.asList(objects));
    }

    @Override
    public int insert(Iterable<?> objects) {
        HashMap<String, ArrayList<ReplaceableItem>> doMap = new HashMap<String, ArrayList<ReplaceableItem>>();
        int nb = 0;
        for (Object obj : objects) {
            Class<?> clazz = obj.getClass();
            String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
            ArrayList<ReplaceableItem> doList = (ArrayList<ReplaceableItem>)doMap.get(domain);
            if (doList == null) {
                doList = new ArrayList<ReplaceableItem>();
                doMap.put(domain, doList);
            }
            doList.add(SdbMappingUtils.createItem(obj));
            ++nb;
        }
        try {
            for (String domain : doMap.keySet()) {
                this.checkDomain(domain);
                List doList = (List)doMap.get(domain);
                int len = doList.size() > 25 ? 25 : doList.size();
                int i = 0;
                while (i < doList.size()) {
                    int sz = i + len;
                    if (sz > doList.size()) {
                        sz = doList.size();
                    }
                    this.sdb.batchPutAttributes(new BatchPutAttributesRequest(domain, doList.subList(i, sz)));
                    i += len;
                }
            }
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
        return nb;
    }

    @Override
    public void get(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(obj.getClass());
        String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
        try {
            this.checkDomain(domain);
            GetAttributesRequest req = SdbMappingUtils.createGetRequest(domain, clazz, obj);
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            GetAttributesResult res = this.sdb.getAttributes(req);
            if (res.getAttributes().size() == 0) {
                throw new SienaException(String.valueOf(req.getItemName()) + " not found in domain " + req.getDomainName());
            }
            SdbMappingUtils.fillModel(req.getItemName(), res, clazz, obj);
            if (!info.joinFields.isEmpty()) {
                this.mapJoins(obj);
            }
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public int get(Object ... models) {
        return this.get(Arrays.asList(models));
    }

    protected <T> int rawGet(Iterable<T> models) {
        StringBuffer domainBuf = new StringBuffer();
        SelectRequest req = SdbMappingUtils.buildBatchGetQuery(models, this.prefix, domainBuf);
        req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
        try {
            this.checkDomain(domainBuf.toString());
            SelectResult res = this.sdb.select(req);
            int nb = SdbMappingUtils.mapSelectResult(res, models);
            Class<?> clazz = null;
            for (T obj : models) {
                if (clazz != null) continue;
                clazz = obj.getClass();
                break;
            }
            if (!ClassInfo.getClassInfo(clazz).joinFields.isEmpty()) {
                this.mapJoins(models);
            }
            return nb;
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> int get(Iterable<T> models) {
        Iterator<T> it = models.iterator();
        int total = 0;
        while (it.hasNext()) {
            ArrayList<T> subList = new ArrayList<T>();
            int i = 0;
            while (i < 20 && it.hasNext()) {
                subList.add(it.next());
                ++i;
            }
            if (subList.isEmpty()) continue;
            total += this.rawGet(subList);
        }
        return total;
    }

    @Override
    public void update(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
        try {
            this.checkDomain(domain);
            this.sdb.putAttributes(SdbMappingUtils.createPutRequest(domain, clazz, info, obj));
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> int update(Object ... models) {
        return this.update(Arrays.asList(models));
    }

    @Override
    public <T> int update(Iterable<T> models) {
        HashMap<String, ArrayList<ReplaceableItem>> doMap = new HashMap<String, ArrayList<ReplaceableItem>>();
        int nb = 0;
        for (T obj : models) {
            Class<?> clazz = obj.getClass();
            String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
            ArrayList<ReplaceableItem> doList = (ArrayList<ReplaceableItem>)doMap.get(domain);
            if (doList == null) {
                doList = new ArrayList<ReplaceableItem>();
                doMap.put(domain, doList);
            }
            doList.add(SdbMappingUtils.createItem(obj));
            ++nb;
        }
        try {
            for (String domain : doMap.keySet()) {
                this.checkDomain(domain);
                List doList = (List)doMap.get(domain);
                int len = doList.size() > 25 ? 25 : doList.size();
                int i = 0;
                while (i < doList.size()) {
                    int sz = i + len;
                    if (sz > doList.size()) {
                        sz = doList.size();
                    }
                    this.sdb.batchPutAttributes(new BatchPutAttributesRequest(domain, doList.subList(i, sz)));
                    i += len;
                }
            }
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
        return nb;
    }

    @Override
    public void delete(Object obj) {
        Class<?> clazz = obj.getClass();
        String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
        try {
            this.checkDomain(domain);
            this.sdb.deleteAttributes(SdbMappingUtils.createDeleteRequest(domain, clazz, obj));
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public int delete(Object ... models) {
        return this.delete(Arrays.asList(models));
    }

    @Override
    public int delete(Iterable<?> models) {
        HashMap<String, ArrayList<DeletableItem>> doMap = new HashMap<String, ArrayList<DeletableItem>>();
        int nb = 0;
        for (Object obj : models) {
            Class<?> clazz = obj.getClass();
            String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
            ArrayList<DeletableItem> doList = (ArrayList<DeletableItem>)doMap.get(domain);
            if (doList == null) {
                doList = new ArrayList<DeletableItem>();
                doMap.put(domain, doList);
            }
            doList.add(SdbMappingUtils.createDeletableItem(obj));
            ++nb;
        }
        try {
            for (String domain : doMap.keySet()) {
                this.checkDomain(domain);
                List doList = (List)doMap.get(domain);
                int len = doList.size() > 25 ? 25 : doList.size();
                int i = 0;
                while (i < doList.size()) {
                    int sz = i + len;
                    if (sz > doList.size()) {
                        sz = doList.size();
                    }
                    this.sdb.batchDeleteAttributes(new BatchDeleteAttributesRequest(domain, doList.subList(i, sz)));
                    i += len;
                }
            }
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
        return nb;
    }

    @Override
    public void save(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        Object idVal = Util.readField(obj, idField);
        if (idVal == null) {
            this.insert(obj);
        } else {
            this.update(obj);
        }
    }

    @Override
    public int save(Object ... objects) {
        return this.save(Arrays.asList(objects));
    }

    @Override
    public int save(Iterable<?> objects) {
        ArrayList entities2Insert = new ArrayList();
        ArrayList entities2Update = new ArrayList();
        for (Object obj : objects) {
            Class<?> clazz;
            ClassInfo info;
            Field idField;
            Object idVal = Util.readField(obj, idField = (info = ClassInfo.getClassInfo(clazz = obj.getClass())).getIdField());
            if (idVal == null) {
                entities2Insert.add(obj);
                continue;
            }
            entities2Update.add(obj);
        }
        return this.insert(entities2Insert) + this.update(entities2Update);
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
        try {
            this.checkDomain(domain);
            GetAttributesRequest req = SdbMappingUtils.createGetRequestFromKey(domain, clazz, key);
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            GetAttributesResult res = this.sdb.getAttributes(req);
            if (res.getAttributes().size() == 0) {
                throw new SienaException(String.valueOf(req.getItemName()) + " not found in domain " + req.getDomainName());
            }
            T obj = Util.createObjectInstance(clazz);
            SdbMappingUtils.fillModel(req.getItemName(), res, clazz, obj);
            if (!ClassInfo.getClassInfo(clazz).joinFields.isEmpty()) {
                this.mapJoins(obj);
            }
            return obj;
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        return this.getByKeys(clazz, Arrays.asList(keys));
    }

    protected <T> List<T> rawGetByKeys(Class<T> clazz, Iterable<?> keys) {
        try {
            StringBuffer domainBuf = new StringBuffer();
            SelectRequest req = SdbMappingUtils.buildBatchGetQueryByKeys(clazz, keys, this.prefix, domainBuf);
            this.checkDomain(domainBuf.toString());
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            SelectResult res = this.sdb.select(req);
            ArrayList models = new ArrayList();
            SdbMappingUtils.mapSelectResultToListOrderedFromKeys(res, models, clazz, keys);
            if (!ClassInfo.getClassInfo(clazz).joinFields.isEmpty()) {
                this.mapJoins(models);
            }
            return models;
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        Iterator<?> it = keys.iterator();
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            ArrayList subList = new ArrayList();
            int i = 0;
            while (i < 20 && it.hasNext()) {
                subList.add(it.next());
                ++i;
            }
            if (subList.isEmpty()) continue;
            list.addAll(this.rawGetByKeys(clazz, subList));
        }
        return list;
    }

    @Override
    public <T> int count(Query<T> query) {
        StringBuffer domainBuf = new StringBuffer();
        SelectRequest req = SdbMappingUtils.buildCountQuery(query, this.prefix, domainBuf);
        try {
            this.checkDomain(domainBuf.toString());
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            SelectResult res = this.sdb.select(req);
            return SdbMappingUtils.mapSelectResultToCount(res);
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        ArrayList models = new ArrayList();
        this.doFetchList(query, Integer.MAX_VALUE, 0, models, 0);
        return models;
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        ArrayList models = new ArrayList();
        this.doFetchList(query, limit, 0, models, 0);
        return models;
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        ArrayList models = new ArrayList();
        this.doFetchList(query, limit, (Integer)offset, models, 0);
        return models;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        ArrayList models = new ArrayList();
        this.doFetchList(query, Integer.MAX_VALUE, 0, models, 0);
        return models;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        ArrayList models = new ArrayList();
        this.doFetchList(query, limit, 0, models, 0);
        return models;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        ArrayList models = new ArrayList();
        this.doFetchList(query, limit, (Integer)offset, models, 0);
        return models;
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, Integer.MAX_VALUE, 0, false);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, 0, false);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, (Integer)offset, false);
    }

    @Override
    public <T> int delete(Query<T> query) {
        List<T> l = this.fetchKeys(query);
        return this.delete(l);
    }

    protected <T> void postMapping(Query<T> query) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (state.isStateless() && !pag.isPaginating()) {
            pag.passivate();
            pag.pageSize = 0;
            sdbCtx.resetAll();
        }
        off.passivate();
        off.offset = 0;
    }

    protected <T> void continueFetchNextToken(Query<T> query, List<T> results, int depth) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (state.isStateless()) {
            off.passivate();
        }
        if (!pag.isActive()) {
            if (state.isStateless()) {
                if (sdbCtx.nextToken() != null) {
                    this.doFetchList(query, Integer.MAX_VALUE, 0, results, depth + 1);
                }
            } else if (sdbCtx.currentToken() != null) {
                boolean b = off.isActive();
                off.passivate();
                this.doFetchList(query, Integer.MAX_VALUE, 0, results, depth + 1);
                if (b) {
                    off.activate();
                }
            }
        }
    }

    protected <T> void postFetch(Query<T> query, SelectResult res) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (sdbCtx.realPageSize == 0) {
            sdbCtx.realPageSize = res.getItems().size();
        }
        String token = null;
        if (pag.isPaginating()) {
            token = res.getNextToken();
            if (token != null) {
                sdbCtx.addToken(token, sdbCtx.realOffset + sdbCtx.realPageSize + off.offset);
            }
            sdbCtx.noMoreDataAfter = res.getItems().size() == 0;
        } else if (state.isStateless()) {
            sdbCtx.realOffset = off.offset;
            token = res.getNextToken();
            if (token != null) {
                sdbCtx.addToken(token, sdbCtx.realPageSize);
            }
        } else {
            sdbCtx.realOffset += sdbCtx.realPageSize;
            token = res.getNextToken();
            if (token != null) {
                sdbCtx.addAndMoveToken(token, sdbCtx.realOffset);
            } else {
                sdbCtx.nextToken();
            }
        }
    }

    protected <T> void preFetch(Query<T> query, int limit, int offset, boolean recursing) {
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (sdbCtx == null) {
            sdbCtx = new QueryOptionSdbContext();
            query.customize(sdbCtx);
        }
        if (!pag.isPaginating()) {
            if (state.isStateless()) {
                sdbCtx.reset(recursing);
            }
            if (pag.isActive()) {
                sdbCtx.realPageSize = limit != Integer.MAX_VALUE ? limit : pag.pageSize;
            } else if (limit != Integer.MAX_VALUE) {
                sdbCtx.realPageSize = limit;
                pag.activate();
            } else {
                sdbCtx.realPageSize = 0;
            }
        } else {
            sdbCtx.realPageSize = pag.pageSize;
        }
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
    }

    protected <T> void doFetchList(Query<T> query, int limit, int offset, List<T> resList, int depth) {
        if (depth >= 25) {
            throw new SienaException("Reached maximum depth of recursion when retrieving more data (25)");
        }
        this.preFetch(query, limit, offset, !resList.isEmpty());
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (sdbCtx.noMoreDataBefore || sdbCtx.noMoreDataAfter) {
            return;
        }
        if (!sdbCtx.isActive()) {
            StringBuffer domainBuf = new StringBuffer();
            SelectRequest req = SdbMappingUtils.buildQuery(query, this.prefix, domainBuf);
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            this.checkDomain(domainBuf.toString());
            SelectResult res = this.sdb.select(req);
            sdbCtx.activate();
            this.postFetch(query, res);
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    if (off.isActive()) {
                        SdbMappingUtils.mapSelectResultToListKeysOnly(res, resList, query.getQueriedClass(), off.offset);
                        break;
                    }
                    SdbMappingUtils.mapSelectResultToListKeysOnly(res, resList, query.getQueriedClass());
                    break;
                }
                default: {
                    if (off.isActive()) {
                        SdbMappingUtils.mapSelectResultToList(res, resList, query.getQueriedClass(), off.offset);
                    } else {
                        SdbMappingUtils.mapSelectResultToList(res, resList, query.getQueriedClass());
                    }
                    if (query.getJoins().isEmpty() && ClassInfo.getClassInfo(query.getQueriedClass()).joinFields.isEmpty()) break;
                    this.mapJoins(query, resList);
                }
            }
            this.continueFetchNextToken(query, resList, depth);
            this.postMapping(query);
        } else {
            StringBuffer domainBuf = new StringBuffer();
            SelectRequest req = SdbMappingUtils.buildQuery(query, this.prefix, domainBuf);
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            this.checkDomain(domainBuf.toString());
            String token = sdbCtx.currentToken();
            if (token != null) {
                req.setNextToken(token);
            }
            SelectResult res = this.sdb.select(req);
            this.postFetch(query, res);
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    if (off.isActive()) {
                        SdbMappingUtils.mapSelectResultToListKeysOnly(res, resList, query.getQueriedClass(), off.offset);
                        break;
                    }
                    SdbMappingUtils.mapSelectResultToListKeysOnly(res, resList, query.getQueriedClass());
                    break;
                }
                default: {
                    if (off.isActive()) {
                        SdbMappingUtils.mapSelectResultToList(res, resList, query.getQueriedClass(), off.offset);
                    } else {
                        SdbMappingUtils.mapSelectResultToList(res, resList, query.getQueriedClass());
                    }
                    if (query.getJoins().isEmpty() && ClassInfo.getClassInfo(query.getQueriedClass()).joinFields.isEmpty()) break;
                    this.mapJoins(query, resList);
                }
            }
            this.continueFetchNextToken(query, resList, depth);
            this.postMapping(query);
        }
    }

    protected <T> Iterable<T> doFetchIterable(Query<T> query, int limit, int offset, boolean recursing) {
        this.preFetch(query, limit, offset, recursing);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        if (sdbCtx.noMoreDataBefore || sdbCtx.noMoreDataAfter) {
            return new ArrayList();
        }
        if (!sdbCtx.isActive()) {
            StringBuffer domainBuf = new StringBuffer();
            SelectRequest req = SdbMappingUtils.buildQuery(query, this.prefix, domainBuf);
            req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
            this.checkDomain(domainBuf.toString());
            SelectResult res = this.sdb.select(req);
            sdbCtx.activate();
            this.postFetch(query, res);
            return new SdbSienaIterable<T>(this, res.getItems(), query);
        }
        StringBuffer domainBuf = new StringBuffer();
        SelectRequest req = SdbMappingUtils.buildQuery(query, this.prefix, domainBuf);
        req.setConsistentRead(Boolean.valueOf(this.isReadConsistent()));
        this.checkDomain(domainBuf.toString());
        String token = sdbCtx.currentToken();
        if (token != null) {
            req.setNextToken(token);
        }
        SelectResult res = this.sdb.select(req);
        this.postFetch(query, res);
        return new SdbSienaIterable<T>(this, res.getItems(), query);
    }

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public <T> void release(Query<T> query) {
        super.release(query);
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        if (sdbCtx != null) {
            sdbCtx.resetAll();
        }
    }

    @Override
    public String[] supportedOperators() {
        return supportedOperators;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        return this.deleteByKeys(clazz, Arrays.asList(keys));
    }

    @Override
    public <T> void nextPage(Query<T> query) {
        SdbMappingUtils.nextPage(query);
    }

    @Override
    public <T> void previousPage(Query<T> query) {
        SdbMappingUtils.previousPage(query);
    }

    @Override
    public <T> void paginate(Query<T> query) {
        QueryOptionSdbContext sdbCtx = (QueryOptionSdbContext)query.option(12289);
        QueryOptionState state = (QueryOptionState)query.option(3);
        if (sdbCtx == null) {
            sdbCtx = new QueryOptionSdbContext();
            query.customize(sdbCtx);
        }
        if (state.isStateless()) {
            sdbCtx.resetAll();
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        off.passivate();
        off.offset = 0;
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        return null;
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        return 0;
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        ArrayList<DeletableItem> doList = new ArrayList<DeletableItem>();
        int nb = 0;
        String domain = SdbMappingUtils.getDomainName(clazz, this.prefix);
        for (Object key : keys) {
            doList.add(SdbMappingUtils.createDeletableItemFromKey(clazz, key));
            ++nb;
        }
        try {
            this.checkDomain(domain);
            int len = doList.size() > 25 ? 25 : doList.size();
            int i = 0;
            while (i < doList.size()) {
                int sz = i + len;
                if (sz > doList.size()) {
                    sz = doList.size();
                }
                this.sdb.batchDeleteAttributes(new BatchDeleteAttributesRequest(domain, doList.subList(i, sz)));
                i += len;
            }
        }
        catch (AmazonClientException ex) {
            throw new SienaException(ex);
        }
        return nb;
    }

    protected <T> T mapJoins(T model) {
        HashMap classMap = new HashMap();
        for (Field field : ClassInfo.getClassInfo(model.getClass()).joinFields) {
            HashMap<String, Object> strMap = (HashMap<String, Object>)classMap.get(field.getType());
            if (strMap == null) {
                strMap = new HashMap<String, Object>();
                classMap.put(field.getType(), strMap);
            }
            String itemName = SdbMappingUtils.toString(Util.readField(model, field));
            strMap.put(itemName, null);
        }
        for (Class clazz : classMap.keySet()) {
            List<T> objs = this.getByKeys(clazz, ((Map)classMap.get(clazz)).keySet());
            Map strMap = (Map)classMap.get(clazz);
            for (T obj : objs) {
                String itemName = SdbMappingUtils.getItemName(clazz, obj);
                strMap.put(itemName, obj);
            }
        }
        for (Field field : ClassInfo.getClassInfo(model.getClass()).joinFields) {
            String itemName = SdbMappingUtils.toString(Util.readField(model, field));
            Util.setField(model, field, ((Map)classMap.get(field.getType())).get(itemName));
        }
        return model;
    }

    protected <T> void mapJoins(Iterable<T> models) {
        HashMap classMap = new HashMap();
        for (Object model : models) {
            for (Field field : ClassInfo.getClassInfo(model.getClass()).joinFields) {
                HashMap<String, Object> strMap = (HashMap<String, Object>)classMap.get(field.getType());
                if (strMap == null) {
                    strMap = new HashMap<String, Object>();
                    classMap.put(field.getType(), strMap);
                }
                String itemName = SdbMappingUtils.toString(Util.readField(model, field));
                strMap.put(itemName, null);
            }
        }
        for (Class clazz : classMap.keySet()) {
            List<T> objs = this.getByKeys(clazz, ((Map)classMap.get(clazz)).keySet());
            Map strMap = (Map)classMap.get(clazz);
            for (T obj : objs) {
                String itemName = SdbMappingUtils.getItemName(clazz, obj);
                strMap.put(itemName, obj);
            }
        }
        for (Object model : models) {
            for (Field field : ClassInfo.getClassInfo(model.getClass()).joinFields) {
                String itemName = SdbMappingUtils.toString(Util.readField(model, field));
                Util.setField(model, field, ((Map)classMap.get(field.getType())).get(itemName));
            }
        }
    }

    protected <T> T mapJoins(Query<T> query, T model) {
        Map<String, T> strMap;
        List<QueryJoin> joins = query.getJoins();
        HashMap classMap = new HashMap();
        for (QueryJoin join : joins) {
            Field field = join.field;
            strMap = (HashMap<String, Object>)classMap.get(field.getType());
            if (strMap == null) {
                strMap = new HashMap<String, Object>();
                classMap.put(field.getType(), strMap);
            }
            String itemName = SdbMappingUtils.toString(Util.readField(model, field));
            strMap.put(itemName, null);
        }
        for (Field field : ClassInfo.getClassInfo(query.getQueriedClass()).joinFields) {
            HashMap<String, Object> strMap2 = (HashMap<String, Object>)classMap.get(field.getType());
            if (strMap2 == null) {
                strMap2 = new HashMap<String, Object>();
                classMap.put(field.getType(), strMap2);
            }
            String itemName = SdbMappingUtils.toString(Util.readField(model, field));
            strMap2.put(itemName, null);
        }
        for (Class clazz : classMap.keySet()) {
            List<T> objs = this.getByKeys(clazz, ((Map)classMap.get(clazz)).keySet());
            strMap = (Map)classMap.get(clazz);
            for (T obj : objs) {
                String itemName = SdbMappingUtils.getItemName(clazz, obj);
                strMap.put(itemName, obj);
            }
        }
        for (Field field : ClassInfo.getClassInfo(model.getClass()).joinFields) {
            String itemName = SdbMappingUtils.toString(Util.readField(model, field));
            Util.setField(model, field, ((Map)classMap.get(field.getType())).get(itemName));
        }
        return model;
    }

    protected <T> List<T> mapJoins(Query<T> query, List<T> models) {
        Object itemName;
        String itemName2;
        Field field;
        List<QueryJoin> joins = query.getJoins();
        HashMap classMap = new HashMap();
        for (Object model : models) {
            for (QueryJoin join : joins) {
                field = join.field;
                HashMap<String, Object> strMap = (HashMap<String, Object>)classMap.get(field.getType());
                if (strMap == null) {
                    strMap = new HashMap<String, Object>();
                    classMap.put(field.getType(), strMap);
                }
                itemName2 = SdbMappingUtils.toString(Util.readField(model, field));
                strMap.put(itemName2, null);
            }
            for (Field field2 : ClassInfo.getClassInfo(query.getQueriedClass()).joinFields) {
                HashMap<Object, Object> strMap = (HashMap<Object, Object>)classMap.get(field2.getType());
                if (strMap == null) {
                    strMap = new HashMap<Object, Object>();
                    classMap.put(field2.getType(), strMap);
                }
                itemName = SdbMappingUtils.toString(Util.readField(model, field2));
                strMap.put(itemName, null);
            }
        }
        for (Class clazz : classMap.keySet()) {
            List<T> objs = this.getByKeys(clazz, ((Map)classMap.get(clazz)).keySet());
            Map strMap = (Map)classMap.get(clazz);
            for (T obj : objs) {
                itemName2 = SdbMappingUtils.getItemName(clazz, obj);
                strMap.put(itemName2, obj);
            }
        }
        for (Object model : models) {
            for (QueryJoin join : joins) {
                field = join.field;
                itemName = SdbMappingUtils.toString(Util.readField(model, field));
                Util.setField(model, field, ((Map)classMap.get(field.getType())).get(itemName));
            }
            for (Field field2 : ClassInfo.getClassInfo(model.getClass()).joinFields) {
                String itemName3 = SdbMappingUtils.toString(Util.readField(model, field2));
                Util.setField(model, field2, ((Map)classMap.get(field2.getType())).get(itemName3));
            }
        }
        return models;
    }
}

