/*
 * Decompiled with CFR 0.152.
 */
package play.modules.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayClassPathBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    public PlayClassPathBeanDefinitionScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public Set<BeanDefinition> findCandidateComponents(String basePackage) {
        Logger.debug((String)("Finding candidate components with base package: " + basePackage), (Object[])new Object[0]);
        LinkedHashSet<BeanDefinition> candidates = new LinkedHashSet<BeanDefinition>();
        try {
            for (ApplicationClasses.ApplicationClass appClass : Play.classes.all()) {
                if (appClass.name.startsWith(basePackage)) {
                    MetadataReader metadataReader;
                    Logger.debug((String)("Scanning class: " + appClass.name), (Object[])new Object[0]);
                    ByteArrayResource res = null;
                    if (System.clearProperty("precompile") == null) {
                        File f = Play.getFile((String)("precompiled/java/" + appClass.name.replace(".", "/") + ".class"));
                        res = new InputStreamResource((InputStream)new FileInputStream(f));
                    } else {
                        res = new ByteArrayResource(appClass.enhance());
                    }
                    if (!this.isCandidateComponent(metadataReader = this.metadataReaderFactory.getMetadataReader((Resource)res))) continue;
                    ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                    sbd.setSource((Object)res);
                    if (!this.isCandidateComponent((AnnotatedBeanDefinition)sbd)) continue;
                    candidates.add((BeanDefinition)sbd);
                    continue;
                }
                Logger.trace((String)("Skipped class: " + appClass.name + " -- wrong base package"), (Object[])new Object[0]);
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
        return candidates;
    }
}

