/*
 * Decompiled with CFR 0.152.
 */
package play.modules.springtester;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;
import play.modules.spring.Spring;
import play.modules.spring.SpringPlugin;
import play.modules.springtester.DatabaseUnitTestCase;
import play.modules.springtester.MockitoFactory;
import play.modules.springtester.Subject;

public abstract class SpringMockitoUnitTestCase
extends DatabaseUnitTestCase {
    private final Map<String, BeanDefinition> definitions = new HashMap<String, BeanDefinition>();

    @Before
    public void injectMocksIntoSubject() throws IllegalAccessException {
        this.injectMocks();
        this.registerMocksInSpringContext();
        this.injectSubject();
    }

    @After
    public void revertMocksFromApplicationContext() {
        Set<String> beanNames = this.definitions.keySet();
        for (String name : beanNames) {
            BeanDefinition definition = this.definitions.get(name);
            SpringPlugin.applicationContext.removeBeanDefinition(name);
            SpringPlugin.applicationContext.registerBeanDefinition(name, definition);
        }
        this.definitions.clear();
    }

    private void injectSubject() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Subject.class)) continue;
            this.injectSubject(field);
        }
    }

    private void injectSubject(Field field) throws IllegalAccessException {
        Class<?> cls = field.getType();
        field.setAccessible(true);
        Object value = Spring.getBeanOfType(cls);
        field.set((Object)this, value);
    }

    private void injectMocks() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    private void registerMocksInSpringContext() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Mock.class)) continue;
            this.registerMockInSpringContext(field);
        }
    }

    private void registerMockInSpringContext(Field field) throws IllegalAccessException {
        Object object = this.getValue(field);
        String name = this.getMockName(field);
        if ("".equals(name)) {
            this.registerBeanDefinitionWithFieldName(field, object);
        } else {
            this.registerBeanDefinition(name, object);
        }
    }

    private String getMockName(Field field) {
        Mock mock = field.getAnnotation(Mock.class);
        return mock.name();
    }

    private Object getValue(Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get((Object)this);
    }

    private void registerBeanDefinitionWithFieldName(Field field, Object object) {
        String fieldName = field.getName();
        this.registerBeanDefinition(fieldName, object);
    }

    private void registerBeanDefinition(String name, Object object) {
        GenericApplicationContext context = SpringPlugin.applicationContext;
        if (context.containsBeanDefinition(name)) {
            BeanDefinition beanDefinition = context.getBeanDefinition(name);
            this.definitions.put(name, beanDefinition);
            context.removeBeanDefinition(name);
        }
        GenericBeanDefinition definition = this.createMockitoFactoryBeanDefinition(object);
        context.registerBeanDefinition(name, (BeanDefinition)definition);
    }

    private GenericBeanDefinition createMockitoFactoryBeanDefinition(Object object) {
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.setBeanClass(MockitoFactory.class);
        definition.setFactoryMethodName("create");
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        Mockito.reset((Object[])new Object[]{object});
        values.addGenericArgumentValue(object);
        definition.setConstructorArgumentValues(values);
        return definition;
    }
}

