/*
 * Decompiled with CFR 0.152.
 */
package play.modules.spring;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.xml.sax.InputSource;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.exceptions.PlayException;
import play.inject.BeanSource;
import play.inject.Injector;
import play.modules.spring.PlayClassPathBeanDefinitionScanner;
import play.modules.spring.SpringEnhancer;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringPlugin
extends PlayPlugin
implements BeanSource {
    private static final String PLAY_SPRING_COMPONENT_SCAN_FLAG = "play.spring.component-scan";
    private static final String PLAY_SPRING_COMPONENT_SCAN_BASE_PACKAGES = "play.spring.component-scan.base-packages";
    private static final String PLAY_SPRING_ADD_PLAY_PROPERTIES = "play.spring.add-play-properties";
    private static final String PLAY_SPRING_NAMESPACE_AWARE = "play.spring.namespace-aware";
    public static GenericApplicationContext applicationContext;
    private long startDate = 0L;

    public void detectChange() {
        VirtualFile appRoot;
        long mod;
        if (Play.mode == Play.Mode.DEV && (mod = (appRoot = VirtualFile.open((File)Play.applicationPath)).child("conf/application-context.xml").lastModified().longValue()) > this.startDate) {
            throw new RuntimeException("conf/application-context.xml has changed");
        }
    }

    public void onApplicationStop() {
        if (applicationContext != null) {
            Logger.debug((String)"Closing Spring application context", (Object[])new Object[0]);
            applicationContext.close();
        }
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        new SpringEnhancer().enhanceThisClass(applicationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationStart() {
        URL url = Play.classloader.getResource(Play.id + ".application-context.xml");
        if (url == null) {
            url = Play.classloader.getResource("application-context.xml");
        }
        if (url != null) {
            InputStream is = null;
            try {
                Logger.debug((String)"Starting Spring application context", (Object[])new Object[0]);
                applicationContext = new GenericApplicationContext();
                applicationContext.setClassLoader((ClassLoader)Play.classloader);
                XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)applicationContext);
                if (Play.configuration.getProperty(PLAY_SPRING_NAMESPACE_AWARE, "false").equals("true")) {
                    xmlReader.setNamespaceAware(true);
                }
                xmlReader.setValidationMode(0);
                if (Play.configuration.getProperty(PLAY_SPRING_ADD_PLAY_PROPERTIES, "true").equals("true")) {
                    Logger.debug((String)"Adding PropertyPlaceholderConfigurer with Play properties", (Object[])new Object[0]);
                    PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
                    configurer.setProperties(Play.configuration);
                    applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
                } else {
                    Logger.debug((String)"PropertyPlaceholderConfigurer with Play properties NOT added", (Object[])new Object[0]);
                }
                boolean doComponentScan = Play.configuration.getProperty(PLAY_SPRING_COMPONENT_SCAN_FLAG, "false").equals("true");
                Logger.debug((String)("Spring configuration do component scan: " + doComponentScan), (Object[])new Object[0]);
                if (doComponentScan) {
                    PlayClassPathBeanDefinitionScanner scanner = new PlayClassPathBeanDefinitionScanner((BeanDefinitionRegistry)applicationContext);
                    String scanBasePackage = Play.configuration.getProperty(PLAY_SPRING_COMPONENT_SCAN_BASE_PACKAGES, "");
                    Logger.debug((String)("Base package for scan: " + scanBasePackage), (Object[])new Object[0]);
                    Logger.debug((String)"Scanning...", (Object[])new Object[0]);
                    scanner.scan(scanBasePackage.split(","));
                    Logger.debug((String)"... component scanning complete", (Object[])new Object[0]);
                }
                is = url.openStream();
                xmlReader.loadBeanDefinitions(new InputSource(is));
                ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
                try {
                    applicationContext.refresh();
                    this.startDate = System.currentTimeMillis();
                }
                catch (BeanCreationException e) {
                    Throwable ex = e.getCause();
                    if (ex instanceof PlayException) {
                        throw (PlayException)ex;
                    }
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
            catch (IOException e) {
                Logger.error((Throwable)e, (String)"Can't load spring config file", (Object[])new Object[0]);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Logger.error((Throwable)e, (String)"Can't close spring config file stream", (Object[])new Object[0]);
                    }
                }
            }
        }
        Injector.inject((BeanSource)this);
    }

    public <T> T getBeanOfType(Class<T> clazz) {
        Map beans = applicationContext.getBeansOfType(clazz);
        if (beans.size() == 0) {
            return null;
        }
        return (T)beans.values().iterator().next();
    }
}

