package play.modules.springtester;

import java.util.HashMap;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.config.BeanDefinition;
import play.test.FunctionalTest;

public abstract class SpringMockitoFunctionalTestCase extends FunctionalTest {
    private final Map<String, BeanDefinition> definitions = new HashMap<String, BeanDefinition>();
    private final SpringMockitoMaster master = new SpringMockitoMaster();

    @Before
    public void injectMocksIntoSubject() throws IllegalAccessException {
        master.before(this, definitions);
    }

    @After
    public void revertMocksFromApplicationContext() {
        master.after(definitions);
    }

    /**
     * Register an object for the test.  This method is particularly useful to register a mock for just the one test but not for any of the others
     * in the test class.
     * @param name The name of the bean to be registered in spring's application context.
     * @param object The object to register against the name.
     */
    public void registerObject(String name, Object object) {
        master.registerBeanDefinition(name, object, definitions);
    }
}
