package springtester;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

@Component
public class Person {
    // Here we are injecting the AgeCalculator and FavouriteThings into the Person class
    @Resource private AgeCalculator ageCalculator;
    @Resource private FavouriteThings favouriteThings;

    public boolean canVote() {
        int age = ageCalculator.calculate("1-January-1980");
        return age >= 18;
    }

    public String sayFavouriteSport() {
        return "My favourite sport is " + favouriteThings.sport();
    }

    public String sayFavouriteNumber() {
        return "My favourite number is " + favouriteThings.number();
    }
}
